/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.JOptionPane;
import se.ericsson.cello.emt.sshsftpservice.EmSftp;
import se.ericsson.cello.emt.sshsftpservice.FileAttributes;
import se.ericsson.cello.emt.sshsftpservice.FileTransferProgress;
import se.ericsson.cello.emt.sshsftpservice.FileType;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.application.applications.integraterbs.control.IntegrateRbsController;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterExtended;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterExtendedLogImpl;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterLogImpl;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.RbsNclImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.InformativeText;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.config.resource.util.RollbackConfigurationVersionRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntennaBranch;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAtmLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpHostLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpRoutingTable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsConfiguration;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.util.SshSftpServiceLauncher;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;

public class IntegrateRbsUtil
implements Observer {
    private Rbs rbs = null;
    private MoHandler moHandler = null;
    private BemMo rbsConfigurationMo = null;
    private final ProgressReporter progressReporter;
    private int stepProgressCounter = 0;
    private boolean executeOnClient = !Boolean.getBoolean("execute.integrate.rbs.on.node");
    private IntegrateRbsController controller = null;
    private ProgressReporterExtended progressReporterExtended = new ProgressReporterExtendedLogImpl("IntegrateRbs-Default", null);
    private int totalProgressCounter = 0;
    private RollbackConfigurationVersionRI rollbackCvRI;
    private static final String VALUE_STRING_IS_DIRECTORY = "{0} is a directory, specify a valid filename.";
    private static final String VALUE_STRING_CONFIRM_OVERWRITE = "File {0} already exists on Client. Do you want to overwrite?";
    private static final String VALUE_STRING_INVALID_FILENAME = "File can not be created. Check permissions and/or that file name is valid {0}";
    private static final String RESTART_INFORMATION = "IntegrateRbs configuration: rollback to previous configuration";
    private static final long WAIT_FOR_OSS_TIMEOUT = 600000L;
    private String progressMessage = "";
    private boolean test = false;
    private String OssRcConfigurationMessage = "";
    private String accumulatedConfigreports = "";
    private static SshSftpServiceLauncher sshSftpServiceLauncher;
    private static final String TMF_DATA_PATH = "/c/systemfiles/rbs/antenna_system_config/";
    private static final String FILE_SEPARATOR = "file.separator";
    private String[] tmfFileList = null;

    public IntegrateRbsUtil(ProgressReporter progressReporter) throws BemException, MoHandlerException {
        this.progressReporter = new ProgressReporterLogImpl("IntegrateRbs", progressReporter);
        this.checkPreconditions();
        this.moHandler = new MoHandlerImpl();
        this.rbs = RbsFactory.getRbs(this.moHandler, "STEP_INT_RBS_ALL", DuwUtil.isPantherHybridRbs());
        MoInstance moInstance = this.rbs.getNodeBFunctionMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimRbsConfiguration.MOTYPENAME, "1");
        this.rbsConfigurationMo = this.moHandler.getMo(singleChildMoi.getLdn());
    }

    public void openBasicIntegrateRbsCIs() throws BemException {
        this.rbs.addObserver(this);
        this.stepProgressCounter = 0;
        OpenCIs.openIntegrateRbsBasicCIs(this.rbs);
    }

    public void removeFromObserverList() {
        this.rbs.deleteObserver(this);
    }

    public void startBemCliIntegration(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws BemException {
        this.executeOnClient = bl;
        this.openBasicIntegrateRbsCIs();
        this.rbs.setCustomerParameter("AI_logicalName", string2);
        this.rbs.setCustomerParameter("AI_user_name", string3);
        this.rbs.setCustomerParameter("AI_password", string4);
        this.rbs.setCustomerParameter("AI_vlan", string6);
        this.rbs.setCustomerParameter("AI_vid", string7);
        if (string5 != null && !string5.equals("null")) {
            this.rbs.setCustomerParameter("AI_gigabitEthernetPort", string5);
        }
        this.rbs.setCustomerParameter("AI_waitForOss", "NO");
        try {
            this.startIntegration(null, null, false);
        }
        catch (InterruptedException interruptedException) {
            throw new BemException("startIntegration was canceled.", (Throwable)interruptedException);
        }
    }

    public void startIntegration(ProgressReporterExtended progressReporterExtended, IntegrateRbsController integrateRbsController, boolean bl) throws BemException, InterruptedException {
        long l = System.currentTimeMillis();
        this.controller = integrateRbsController;
        this.progressReporterExtended = new ProgressReporterExtendedLogImpl("IntegrateRbs-High", progressReporterExtended);
        this.totalProgressCounter = 0;
        this.reportTotalProgress(this.totalProgressCounter, "Preparing configuration");
        this.update(null, "Checking preconditions");
        this.checkOamPreconditions();
        if (bl) {
            this.update(null, "Creating rollback CV");
            this.createRollbackCV();
        }
        this.checkIfCanceled();
        this.update(null, "Setting CustomerParameters");
        String string = this.rbs.getCustomerParameter("AI_autoIntegrate");
        String string2 = this.rbs.getCustomerParameter("AI_user_name");
        String string3 = this.rbs.getCustomerParameter("AI_password");
        this.update(null, "Saving Configuration Report");
        InformativeText informativeText = new InformativeText(this.rbs);
        this.accumulatedConfigreports = this.accumulatedConfigreports + informativeText.getAiInformativeText();
        this.totalProgressCounter = 25;
        this.reportTotalProgress(this.totalProgressCounter, "Loading Configuration Files");
        if (string.equalsIgnoreCase("Obtain configuration data automatically")) {
            this.handleAutomaticInstallation(string2, string3);
            this.setStoredReportParams(string, string2, string3);
        } else {
            this.handleManualIntegration();
        }
        this.totalProgressCounter = 50;
        this.reportTotalProgress(this.totalProgressCounter, "Activating OAM configuration");
        this.activateOamConfiguration();
        this.restartAfterOamIfNeeded();
        this.totalProgressCounter = 60;
        this.reportTotalProgress(this.totalProgressCounter, "Activating Site configuration");
        this.activateSiteConfiguration();
        this.restartAfterSiteIfNeeded();
        this.update(null, "Saving Configuration Report");
        this.accumulatedConfigreports = this.accumulatedConfigreports + this.getConfigReportFromNode();
        this.checkIfCanceled();
        String string4 = this.rbs.getCustomerParameter("AI_waitForOss");
        if (string4.equals("YES")) {
            String string5;
            int n = 0;
            try {
                this.totalProgressCounter = 80;
                this.reportTotalProgress(this.totalProgressCounter, "Waiting for OSS to detect RBS.");
                n = this.waitForConfigLevelToChange(4);
                this.totalProgressCounter = 90;
                this.reportTotalProgress(this.totalProgressCounter, "Waiting for OSS activate site specific configuration.");
                n = this.waitForConfigLevelToChange(n);
                if (n == 7) {
                    string5 = this.getFaultReason();
                    String string6 = "OSS failed to activate site specific configuration.";
                    if (string5 != null && !string5.equals("")) {
                        string6 = string6 + "\nReason: " + string5;
                    }
                    this.setOssRcConfigurationMessage(string6 + "\n\n");
                    this.controller.setFailedDuringWaitForOss(true);
                } else if (n == 6) {
                    this.setOssRcConfigurationMessage("OSS integration successful!");
                } else {
                    this.setOssRcConfigurationMessage("OSS integration unknown configuration level");
                }
            }
            catch (InterruptedException interruptedException) {
                this.controller.setCancelledDuringWaitForOss(true);
                this.setOssRcConfigurationMessage("OSS integration was canceled or timed out!");
            }
            string5 = "Node integration status\n";
            string5 = string5 + "=======================\n";
            string5 = string5 + this.getOssRcConfigurationMessage() + "\n";
            this.accumulatedConfigreports = string5 + this.accumulatedConfigreports;
        }
        long l2 = System.currentTimeMillis();
        Nal.getFactory().getLog().nalTrace(5, this.getClass(), "startIntegration duration = " + (l2 - l) / 1000L + " sec");
    }

    private void restartAfterOamIfNeeded() throws BemException, InterruptedException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        Rbs rbs = RbsFactory.getRbs((MoHandler)moHandlerImpl, "STEP_INT_OAM", DuwUtil.isPantherHybridRbs());
        OpenCIs.openOamCIs(rbs);
    }

    private void restartAfterSiteIfNeeded() throws BemException, InterruptedException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        Rbs rbs = RbsFactory.getRbs((MoHandler)moHandlerImpl, "STEP_INT_SITE", DuwUtil.isPantherHybridRbs());
        OpenCIs.openSiteCIs(rbs);
    }

    private void setOssRcConfigurationMessage(String string) {
        this.OssRcConfigurationMessage = string;
    }

    public boolean isSiteWizardRun() {
        try {
            BemMo bemMo = this.moHandler.getMo(WizardCommon.WIZARD_LDN_EQUIPMENT);
            BemMo[] bemMoArray = this.moHandler.getChildren(bemMo, 1, MimSectorAntenna.MOTYPENAME, "");
            if (bemMoArray == null || bemMoArray.length == 0) {
                return false;
            }
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                BemMo[] bemMoArray2 = this.moHandler.getChildren(bemMo2, 1, MimAntennaBranch.MOTYPENAME, "");
                if (bemMoArray2 == null || bemMoArray2.length <= 0) continue;
                return true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            // empty catch block
        }
        return false;
    }

    private void createRollbackCV() throws BemException {
        this.rollbackCvRI = new RollbackConfigurationVersionRI(this.rbs);
        this.rollbackCvRI.install("RollbackCVCreationPhase");
    }

    public void setRollbackCVAsStartable() throws BemException {
        if (this.rollbackCvRI != null) {
            this.rollbackCvRI.install("RollbackCVSettingPhase");
        }
    }

    public boolean isRollbackCVExisting() throws BemException {
        boolean bl = this.rollbackCvRI.isRollbackCVsExisting();
        return bl;
    }

    private void handleAutomaticInstallation(String string, String string2) throws BemException, InterruptedException {
        this.update(null, "Setting parameters for DHCP");
        OpenCIs.openIntegrateRbsAutomaticCIs(this.rbs);
        this.rbs.setCustomerParameter("OamIpHost_oamIpAddress", "0.0.0.0");
        this.rbs.setCustomerParameter("OamIpHost_oamDefaultRouter0", "1.2.3.4");
        this.rbs.setCustomerParameter("OamIpHost_oamSubnetMask", "255.255.255.128");
        this.rbs.setCustomerParameter("IPoverGigabitEthernet_transportOption", "atm");
        this.checkIfCanceled();
        this.rbs.getMoHandler().setUseLargeTransactions(true);
        this.checkIfCanceled();
        this.rbs.installAllCIs(false, this);
        this.checkIfCanceled();
        this.rbs.getMoHandler().setUseLargeTransactions(false);
        this.checkIfCanceled();
        this.update(null, "Fetching configuration from DHCP server");
        this.fetchDhcpConfiguration();
        this.checkIfCanceled();
        this.update(null, "Activating DHCP configuration");
        this.activateDhcpConfiguration();
        this.accumulatedConfigreports = this.accumulatedConfigreports + this.getConfigReportFromNode();
        this.checkIfCanceled();
        this.update(null, "Fetching configuration files");
        this.fetchRbsConfigurationFiles(string, string2);
        this.checkIfCanceled();
        this.update(null, "Fetching TMF files");
        this.fetchAntennaSystemConfigurationFiles(string, string2);
        this.checkIfCanceled();
        this.update(null, "Removing static route");
        this.removeStaticRoute();
        this.checkIfCanceled();
    }

    private void handleManualIntegration() throws BemException, InterruptedException {
        this.update(null, "Loading config files");
        String string = this.rbs.getCustomerParameter("AI_oamFilePath");
        String string2 = this.rbs.getCustomerParameter("AI_siteFilePath");
        this.setConfigurationFileAttributes(string, string2);
        this.checkIfCanceled();
        this.setTmfFilesConfiguration();
        this.checkIfCanceled();
    }

    private void setStoredReportParams(String string, String string2, String string3) throws BemException {
        this.rbs.setCustomerParameter("AI_ftpStoreReport", string);
        this.rbs.setCustomerParameter("AI_ftpStoreReportUserName", string2);
        this.rbs.setCustomerParameter("AI_ftpStoreReportPassword", string3);
        if (string.equalsIgnoreCase("Obtain configuration data automatically")) {
            this.rbs.setCustomerParameter("AI_clientStoreReport", "NO");
        } else {
            this.rbs.setCustomerParameter("AI_clientStoreReport", "YES");
        }
    }

    private void fetchDhcpConfiguration() throws BemException {
        String string = this.rbs.getCustomerParameter("AI_logicalName");
        try {
            this.moHandler.setAttribute(this.rbsConfigurationMo, "rbsLogicalName", string);
            this.moHandler.action(this.rbsConfigurationMo, "fetchDhcpConfiguration", new NalNameValue[0], 30000, false);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(".fetchDhcpConfiguration() logicalName=" + string, (Throwable)moHandlerException);
        }
    }

    private void fetchRbsConfigurationFiles(String string, String string2) throws BemException {
        this.update(null, "Calling action fetchConfigurationFiles");
        try {
            if (this.test) {
                this.setAttributesForFtpTest();
            }
            NalNameValue[] nalNameValueArray = new NalNameValue[2];
            NalFactory nalFactory = Nal.getFactory();
            nalNameValueArray[0] = nalFactory.getNameValue("userId", string);
            nalNameValueArray[1] = nalFactory.getNameValue("password", string2);
            this.stepProgressCounter = 20;
            this.update(null, "Calling action fetchConfigurationFiles");
            this.moHandler.action(this.rbsConfigurationMo, "fetchRbsConfigurationFiles", nalNameValueArray, 60000, false);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("fetchRbsConfigurationFiles()", (Throwable)moHandlerException);
        }
    }

    private void activateDhcpConfiguration() throws BemException {
        long l = System.currentTimeMillis();
        if (this.executeOnClient) {
            this.activateDhcpConfigurationClient();
        } else {
            this.activateDhcpConfigurationHost();
        }
        long l2 = System.currentTimeMillis();
        Nal.getFactory().getLog().nalTrace(5, this.getClass(), "activateDhcpConfiguration duration = " + (l2 - l) / 1000L + " sec");
    }

    private void activateOamConfiguration() throws BemException {
        long l = System.currentTimeMillis();
        if (this.executeOnClient) {
            this.activateOamConfigurationClient();
        } else {
            this.activateConfigurationHost("activateOaMConfiguration");
        }
        long l2 = System.currentTimeMillis();
        Nal.getFactory().getLog().nalTrace(5, this.getClass(), "activateOamAndSiteConfiguration duration = " + (l2 - l) / 1000L + " sec");
    }

    private void setConfigurationFileAttributes(String string, String string2) throws BemException {
        this.setConfigFileAttribute(string, "oamConfigFile");
        this.setConfigFileAttribute(string2, "siteConfigFile");
    }

    private void activateDhcpConfigurationClient() throws BemException {
        try {
            String string = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "ethernetIpAddress");
            String string2 = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "ethernetSubnetMask");
            String string3 = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "dhcpIpAddress");
            String string4 = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "dnsIpAddress");
            String string5 = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "defaultGateway");
            if (this.test) {
                string = "137.58.202.123";
                string2 = "255.255.255.0";
            }
            RbsNclImpl rbsNclImpl = new RbsNclImpl(this.progressReporter);
            rbsNclImpl.performDhcpConfiguration(string, string2, string3, string4, string5);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("activateDhcpConfigurationClient()", (Throwable)moHandlerException);
        }
    }

    private void activateDhcpConfigurationHost() throws BemException {
        String string = "activateDhcpConfiguration";
        try {
            Nal.getLog().nalTraceEnter(this.getClass(), "activateDhcpConfigurationHost() - action=" + string);
            ActionResult actionResult = this.startActionOnHost(this.rbsConfigurationMo, string);
            String string2 = "";
            boolean bl = actionResult.isAlive();
            while (bl) {
                String string3 = this.getProgressInformationFromNode();
                if (!string3.equals(string2)) {
                    this.update(null, string3);
                    string2 = string3;
                }
                this.delay_ms(1000);
                Throwable throwable = actionResult.getError();
                if (throwable != null) {
                    throw new Exception(throwable);
                }
                bl = actionResult.isAlive();
            }
        }
        catch (Exception exception) {
            throw new BemException("Failed activating DHCP!", (Throwable)exception);
        }
    }

    private void activateOamConfigurationClient() throws BemException {
        try {
            String string = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "oamConfigFile");
            RbsNclImpl rbsNclImpl = new RbsNclImpl(this.progressReporter);
            rbsNclImpl.performOamConfiguration(string);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("activateOamAndSiteConfigurationClient()", (Throwable)moHandlerException);
        }
    }

    private void activateSiteConfigurationClient() throws BemException {
        try {
            String string = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "siteConfigFile");
            RbsNclImpl rbsNclImpl = new RbsNclImpl(this.progressReporter);
            rbsNclImpl.performSiteConfiguration(string);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("activateSiteConfigurationClient()", (Throwable)moHandlerException);
        }
    }

    private void activateSiteConfiguration() throws BemException {
        long l = System.currentTimeMillis();
        if (this.executeOnClient) {
            this.activateSiteConfigurationClient();
        } else {
            this.activateConfigurationHost("activateSiteConfiguration");
        }
        long l2 = System.currentTimeMillis();
        Nal.getFactory().getLog().nalTrace(5, this.getClass(), "activateSiteConfiguration duration = " + (l2 - l) / 1000L + " sec");
    }

    private void activateConfigurationHost(String string) throws BemException {
        try {
            Nal.getLog().nalTraceEnter(this.getClass(), "activateOamAndSiteConfigurationHost() - action=" + string);
            ActionResult actionResult = this.startActionOnHost(this.rbsConfigurationMo, string);
            String string2 = "";
            boolean bl = actionResult.isAlive();
            while (bl) {
                String string3 = this.getProgressInformationFromNode();
                if (!string3.equals(string2)) {
                    this.update(null, string3);
                    string2 = string3;
                }
                this.delay_ms(1000);
                Throwable throwable = actionResult.getError();
                if (throwable != null) {
                    throw new Exception(throwable);
                }
                bl = actionResult.isAlive();
            }
        }
        catch (Exception exception) {
            throw new BemException("Failed activating OAM and SITE!", (Throwable)exception);
        }
    }

    private ActionResult startActionOnHost(final BemMo bemMo, final String string) {
        Nal.getLog().nalTraceEnter(this.getClass(), "startActionOnHost(mo=" + bemMo + ", actionName=" + string + ")");
        final ActionResult actionResult = new ActionResult();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Throwable throwable;
                NalTransaction nalTransaction = Nal.getFactory().createNullTransaction();
                try {
                    Nal.getLog().nalTraceEnter(this.getClass(), "Thread " + Thread.currentThread().getName() + " started");
                    bemMo.action(string, new NalNameValue[0], nalTransaction);
                    nalTransaction.commit();
                    nalTransaction = null;
                    throwable = actionResult.getError();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3;
                    try {
                        actionResult.reportError(throwable2);
                        String string2 = "Failed calling action " + string + "!";
                        if ("activateDhcpConfiguration".equals(string)) {
                            string2 = "Expected exception when calling " + string;
                        }
                        nalTransaction.rollback(string2, throwable2);
                        nalTransaction = null;
                        throwable3 = actionResult.getError();
                    }
                    catch (Throwable throwable4) {
                        nalTransaction = null;
                        Throwable throwable5 = actionResult.getError();
                        Nal.getLog().nalTraceReturn(this.getClass(), "Thread " + Thread.currentThread().getName() + " terminated " + (throwable5 == null ? " OK without exception" : " after exception"));
                        throw throwable4;
                    }
                    Nal.getLog().nalTraceReturn(this.getClass(), "Thread " + Thread.currentThread().getName() + " terminated " + (throwable3 == null ? " OK without exception" : " after exception"));
                }
                Nal.getLog().nalTraceReturn(this.getClass(), "Thread " + Thread.currentThread().getName() + " terminated " + (throwable == null ? " OK without exception" : " after exception"));
            }
        };
        Thread thread = new Thread(runnable, "IntegrateRbsUtil - " + string);
        actionResult.setActionThread(thread);
        thread.setUncaughtExceptionHandler(actionResult);
        thread.start();
        return actionResult;
    }

    private void reportTotalProgress(int n, String string) {
        this.progressReporterExtended.reportTotalProgress(n, string);
        this.stepProgressCounter = 0;
        this.update(null, "");
    }

    public void update(Observable observable, Object object) {
        String string;
        this.progressMessage = string = (String)object;
        this.progressReporter.reportProgress(this.stepProgressCounter++, this.progressMessage);
    }

    private void setConfigFileAttribute(String string, String string2) throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Input File", string);
        exceptionProperties.setProperty("Failing Method", "setConfigFileAttribute()");
        exceptionProperties.setProperty("Failing Method  - Params", "attributeName=" + string2);
        FileInputStream fileInputStream = null;
        try {
            String string3;
            String string4;
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[((InputStream)fileInputStream).available()];
            StringBuffer stringBuffer = new StringBuffer();
            int n = ((InputStream)fileInputStream).read(byArray);
            while (n > -1) {
                string4 = new String(byArray);
                string4 = string4.trim();
                stringBuffer.append(string4);
                n = ((InputStream)fileInputStream).read(byArray);
            }
            string4 = stringBuffer.toString();
            if (!string4.equals(string3 = string4.replaceAll("'", "\""))) {
                Nal.getFactory().getLog().nalTrace(3, this.getClass(), "Single quotes are translated to double quotes when setting the attribute: " + string2);
            }
            this.moHandler.setAttribute(this.rbsConfigurationMo, string2, string3);
        }
        catch (MoHandlerException moHandlerException) {
            exceptionProperties.setProperty("Problem", "Failed storing input file MO attribute \"" + string2 + "\" on the RBS.");
            throw new BemException(exceptionProperties, (Throwable)moHandlerException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            exceptionProperties.setProperty("Problem", "Could not find input file for reading!");
            exceptionProperties.setProperty("Additional Info", fileNotFoundException.getMessage());
            throw new BemException(exceptionProperties, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            exceptionProperties.setProperty("Problem", "Failed reading input file!");
            exceptionProperties.setProperty("Additional Info", iOException.getMessage());
            throw new BemException(exceptionProperties, (Throwable)iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void delay_ms(int n) throws InterruptedException {
        NalFactory nalFactory = Nal.getFactory();
        nalFactory.sleep(n);
    }

    public Rbs getRbs() {
        return this.rbs;
    }

    private int waitForConfigLevelToChange(int n) throws InterruptedException, BemException {
        int n2 = -1;
        long l = System.currentTimeMillis();
        int n3 = 0;
        this.update(null, "Waiting for " + n3 * 10 + " sec");
        try {
            Integer n4 = (Integer)this.moHandler.getAttribute(this.rbsConfigurationMo, "rbsConfigLevel");
            n2 = n4;
            while (n == n2) {
                long l2 = System.currentTimeMillis() - l;
                if (l2 >= 600000L) {
                    String string = "Wait for OSS timed out!";
                    this.setOssRcConfigurationMessage(string);
                    throw new InterruptedException(string);
                }
                this.checkIfCanceled();
                this.delay_ms(10000);
                this.stepProgressCounter = 0;
                this.update(null, "Waiting for " + ++n3 * 10 + " sec");
                n4 = (Integer)this.moHandler.getAttribute(this.rbsConfigurationMo, "rbsConfigLevel");
                n2 = n4;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("waitForConfigLevelToChange() configlevel=" + n, (Throwable)moHandlerException);
        }
        return n2;
    }

    private String getFaultReason() throws BemException {
        String string = "";
        try {
            string = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "configFaultReason");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("getFaultReason()", (Throwable)moHandlerException);
        }
        return string;
    }

    public void storeConfigurationReportInRbsConfigurationMO(String string) throws BemException {
        try {
            this.moHandler.setAttribute(this.rbsConfigurationMo, "configurationReport", string);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("storeConfigurationReportInRbsConfigurationMO()", (Throwable)moHandlerException);
        }
    }

    public void storeConfigurationReportOnServer(String string, String string2, String string3, String string4, String string5) throws BemException {
        try {
            NalFactory nalFactory = Nal.getFactory();
            NalNameValue[] nalNameValueArray = new NalNameValue[]{nalFactory.getNameValue("ipAddress", string), nalFactory.getNameValue("filePath", string2), nalFactory.getNameValue("userId", string3), nalFactory.getNameValue("password", string4)};
            this.moHandler.action(this.rbsConfigurationMo, "storeConfigurationReport", nalNameValueArray);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("storeConfigurationReportOnServer", (Throwable)moHandlerException);
        }
    }

    public boolean checkFileOnServer(String string, String string2, String string3, String string4) throws BemException {
        try {
            NalFactory nalFactory = Nal.getFactory();
            NalNameValue[] nalNameValueArray = new NalNameValue[]{nalFactory.getNameValue("ipAddress", string), nalFactory.getNameValue("filePath", string2), nalFactory.getNameValue("userId", string3), nalFactory.getNameValue("password", string4)};
            Boolean bl = (Boolean)this.moHandler.action(this.rbsConfigurationMo, "fileExistsOnSmrs", nalNameValueArray);
            return bl;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("storeConfigurationReportOnServer", (Throwable)moHandlerException);
        }
    }

    public boolean storeConfigurationReportOnClient(String string, String string2) throws BemException {
        boolean bl = true;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8"));
            bufferedWriter.write(string2);
            bufferedWriter.flush();
            bufferedWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            throw new BemException("storeConfigurationReportOnClient()", (Throwable)exception);
        }
        return bl;
    }

    public boolean checkFileName(String string) {
        String string2;
        File file = new File(string);
        String[] stringArray = new String[]{string};
        if (file.exists() && !file.isDirectory()) {
            string2 = MessageFormat.format(VALUE_STRING_CONFIRM_OVERWRITE, stringArray);
            boolean bl = this.controller.displayConfirmDialog(string2);
            if (!bl) {
                return false;
            }
            file.delete();
        }
        if (file.isDirectory()) {
            string2 = MessageFormat.format(VALUE_STRING_IS_DIRECTORY, stringArray);
            this.controller.displayError(string2);
            return false;
        }
        try {
            string2 = MessageFormat.format(VALUE_STRING_INVALID_FILENAME, stringArray);
            if (string == null || string.length() == 0 || string.trim().equals("")) {
                string2 = "File can not be created. Check permissions and/or that file name is valid {0} .No fileName given.";
            }
            if (!file.createNewFile()) {
                this.controller.displayError(string2);
                return false;
            }
            if (!file.canWrite()) {
                this.controller.displayError(string2);
                return false;
            }
            file.delete();
        }
        catch (IOException iOException) {
            String string3 = MessageFormat.format(VALUE_STRING_INVALID_FILENAME, stringArray);
            this.controller.displayError(string3);
            return false;
        }
        return true;
    }

    private void checkPreconditions() throws BemException {
        try {
            this.moHandler = new MoHandlerImpl();
            BemMo bemMo = this.moHandler.getRoot();
            String string = (String)this.moHandler.getAttribute(bemMo, "productName");
            if (string.equals("")) {
                throw new BemException("Wrong configuration level. \nThe cabinet equipment configuration must be completed before starting Integrate RBS.\n");
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Could not read product name from the RBS", (Throwable)moHandlerException);
        }
    }

    private void checkOamPreconditions() throws BemException {
        Object object;
        BemMo[] bemMoArray = null;
        BemMo[] bemMoArray2 = null;
        BemMo[] bemMoArray3 = null;
        try {
            object = this.moHandler.getRoot();
            bemMoArray = this.moHandler.getChildren((BemMo)object, 10, MimIpAtmLink.MOTYPENAME, "");
            bemMoArray2 = this.moHandler.getChildren((BemMo)object, 10, MimIpAccessHostEt.MOTYPENAME, "");
            bemMoArray3 = this.moHandler.getChildren((BemMo)object, 10, MimIpHostLink.MOTYPENAME, "");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("checkOamPreconditions() Can not read from the RBS.", (Throwable)moHandlerException);
        }
        if (bemMoArray != null && bemMoArray.length != 0 || bemMoArray2 != null && bemMoArray2.length != 0 || bemMoArray3 != null && bemMoArray3.length != 0) {
            object = "Integrate RBS can only be run once.\nUse the add and remove applications to change the configuration.\n";
            throw new BemException((String)object);
        }
    }

    public void restartNode(int n) {
        try {
            BemMo bemMo = this.moHandler.getRoot();
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", 2), Nal.getFactory().getNameValue("restartReason", n), Nal.getFactory().getNameValue("restartInfo", RESTART_INFORMATION)};
            this.moHandler.action(bemMo, "manualRestart", nalNameValueArray);
        }
        catch (MoHandlerException moHandlerException) {
            // empty catch block
        }
    }

    private void setAttributesForFtpTest() throws MoHandlerException {
        this.moHandler.setAttribute(this.rbsConfigurationMo, "smrsIpAddress", "137.58.202.239");
        this.moHandler.setAttribute(this.rbsConfigurationMo, "summaryFileFilePath", "/home/erabemli/autoint/summary.xml");
    }

    private String getProgressInformationFromNode() {
        String string = "";
        NalTransaction nalTransaction = Nal.getFactory().createNullTransaction();
        try {
            string = (String)this.rbsConfigurationMo.getAttribute("progressInformation", nalTransaction);
        }
        catch (Exception exception) {
            nalTransaction.rollback("", exception);
        }
        return string;
    }

    private String getConfigReportFromNode() throws BemException {
        String string;
        try {
            string = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "configurationReport");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("getConfigReport()", (Throwable)moHandlerException);
        }
        return string;
    }

    public String generateConfigurationReport() {
        return this.accumulatedConfigreports;
    }

    public void deleteLogFile() throws BemException {
        try {
            this.moHandler.action(this.rbsConfigurationMo, "deleteLogFile", new NalNameValue[0]);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("deleteLogFile()", (Throwable)moHandlerException);
        }
    }

    private void checkIfCanceled() throws InterruptedException {
        if (this.controller != null) {
            this.controller.checkIfCanceled();
        }
    }

    public String getOssRcConfigurationMessage() {
        String string = this.OssRcConfigurationMessage;
        return string;
    }

    private void removeStaticRoute() throws BemException {
        try {
            String string = "0.0.0.0";
            String string2 = "0.0.0.0";
            String string3 = (String)this.moHandler.getAttribute(this.rbsConfigurationMo, "defaultGateway");
            this.removeRoutingTableEntry(string, string3, string2);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Removal of static route failed!", (Throwable)moHandlerException);
        }
    }

    private void removeRoutingTableEntry(String string, String string2, String string3) throws BemException {
        SingleChildMoi singleChildMoi = new SingleChildMoi(new RootMoi(), MimIpOam.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimIpRoutingTable.MOTYPENAME, "1");
        BemMo bemMo = this.moHandler.getMo(singleChildMoi3.getLdn());
        String string4 = null;
        NalNameValue[] nalNameValueArray = null;
        try {
            string4 = "numberOfRoutes";
            nalNameValueArray = new NalNameValue[]{};
            Integer n = (Integer)this.moHandler.action(bemMo, string4, nalNameValueArray);
            string4 = "getRoutingTableEntry";
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("index", null);
            nalNameValueArray = new NalNameValue[]{nalNameValue};
            for (int i = 0; i < n; ++i) {
                String string5 = nalNameValueArray[0].getName();
                Integer n2 = new Integer(i);
                nalNameValueArray[0] = Nal.getFactory().getNameValue(string5, n2);
                NalStruct nalStruct = (NalStruct)this.moHandler.action(bemMo, string4, nalNameValueArray);
                NalNameValue nalNameValue2 = nalStruct.getMember("routeType");
                NalNameValue nalNameValue3 = nalStruct.getMember("routeMetric");
                NalNameValue nalNameValue4 = nalStruct.getMember("nextHopIpAddr");
                NalNameValue nalNameValue5 = nalStruct.getMember("redistribute");
                Integer n3 = (Integer)nalNameValue2.getValue();
                int n4 = 2;
                if (n3 != n4 || !string2.equals((String)nalNameValue4.getValue())) continue;
                NalNameValue nalNameValue6 = Nal.getFactory().getNameValue("destinationIpAddr", string);
                NalNameValue nalNameValue7 = Nal.getFactory().getNameValue("destinationNetworkMask", string3);
                NalNameValue nalNameValue8 = Nal.getFactory().getNameValue("nextHopIpAddr", string2);
                NalNameValue[] nalNameValueArray2 = new NalNameValue[]{nalNameValue6, nalNameValue7, nalNameValue8, nalNameValue3, nalNameValue5};
                nalStruct = Nal.getFactory().getStruct(nalNameValueArray2);
                NalNameValue[] nalNameValueArray3 = new NalNameValue[]{Nal.getFactory().getNameValue("routingTableEntry", nalStruct)};
                this.moHandler.action(bemMo, "deleteStaticRoute", nalNameValueArray3);
                Nal.getFactory().getLog().nalTrace(7, this.getClass(), "Route: " + ((Object)nalStruct).toString() + " removed!");
                break;
            }
        }
        catch (NalCmException nalCmException) {
            Nal.getFactory().getLog().nalTrace(6, this.getClass(), "Exception caught (and ignored) when trying to remove static route: " + nalCmException.toString());
        }
        catch (MoHandlerException moHandlerException) {
            Nal.getFactory().getLog().nalTrace(6, this.getClass(), "Exception caught (and ignored) when trying to remove static route: " + moHandlerException.toString());
        }
    }

    private void fetchAntennaSystemConfigurationFiles(String string, String string2) throws BemException {
        try {
            NalNameValue[] nalNameValueArray = new NalNameValue[2];
            NalFactory nalFactory = Nal.getFactory();
            nalNameValueArray[0] = nalFactory.getNameValue("userId", string);
            nalNameValueArray[1] = nalFactory.getNameValue("password", string2);
            this.stepProgressCounter = 30;
            this.update(null, "Calling action fetchAntennaSystemConfigurationFiles");
            this.moHandler.action(this.rbsConfigurationMo, "fetchAntennaSystemConfigurationFiles", nalNameValueArray, 60000, false);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("fetchAntennaSystemConfigurationFiles()", (Throwable)moHandlerException);
        }
    }

    public static void initSshSftpServiceLauncher(Launchable launchable, LauncherInterface launcherInterface, LaunchProperties launchProperties, String string) {
        sshSftpServiceLauncher = new SshSftpServiceLauncher(launchable, launcherInterface, launchProperties, string);
    }

    public SshSftpService startSshSftpServiceLauncher() throws LauncherException {
        return sshSftpServiceLauncher.runResource("/cello/emas/sshservcfg.xml");
    }

    public SshSftpServiceLauncher getsshSftpServiceLauncher() {
        return sshSftpServiceLauncher;
    }

    protected void displayWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "warning", 0);
    }

    public void setTmfFilesConfiguration() throws BemException {
        if (this.tmfFileList == null || this.tmfFileList.length == 0) {
            return;
        }
        if (this.getsshSftpServiceLauncher().getLauncher() instanceof Launcher) {
            try {
                this.update(null, "FTP TMF data file");
                SshSftpService sshSftpService = this.startSshSftpServiceLauncher();
                EmSftp emSftp = sshSftpService.getSftp("Element Manager");
                if (this.tmfFileList.length > 0) {
                    if (!this.isDirectoryExist(emSftp, "/c/systemfiles/", "rbs")) {
                        emSftp.mkdir("/c/systemfiles/rbs");
                    }
                    if (!this.isDirectoryExist(emSftp, "/c/systemfiles/rbs", "antenna_system_config")) {
                        emSftp.mkdir("/c/systemfiles/rbs/antenna_system_config");
                    }
                }
                Properties properties = System.getProperties();
                String string = (String)properties.get(FILE_SEPARATOR);
                for (int i = 0; i < this.tmfFileList.length; ++i) {
                    String string2 = TMF_DATA_PATH + this.tmfFileList[i].substring(this.tmfFileList[i].lastIndexOf(string) + 1);
                    FileTransferProgressListener fileTransferProgressListener = new FileTransferProgressListener();
                    emSftp.put(this.tmfFileList[i], string2, (FileTransferProgress)fileTransferProgressListener);
                    if (fileTransferProgressListener.isOK()) continue;
                    this.displayWarningMessage("TMF file" + string2 + "FTP failed!");
                    break;
                }
                emSftp.bye();
            }
            catch (LauncherException launcherException) {
                throw new BemException(launcherException);
            }
        }
    }

    private boolean isDirectoryExist(EmSftp emSftp, String string, String string2) {
        Collection collection = emSftp.ls(string);
        Iterator iterator = collection.iterator();
        FileAttributes fileAttributes = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            fileAttributes = (FileAttributes)iterator.next();
            if (!fileAttributes.getName().equals(string2) || !fileAttributes.getType().equals((Object)FileType.DIRECTORY)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setTmfFileList(String[] stringArray) {
        this.tmfFileList = stringArray;
    }

    private static class FileTransferProgressListener
    implements FileTransferProgress {
        private boolean isOK = false;

        private FileTransferProgressListener() {
        }

        public boolean isOK() {
            return this.isOK;
        }

        public void completed() {
            this.isOK = true;
        }

        public boolean isCancelled() {
            return false;
        }

        public void progressed(long l) {
        }

        public void started(long l, String string) {
        }
    }

    static class ActionResult
    implements Thread.UncaughtExceptionHandler {
        private Thread actionThread;
        private Throwable error;

        ActionResult() {
        }

        public void setActionThread(Thread thread) {
            this.actionThread = thread;
            thread.setUncaughtExceptionHandler(this);
        }

        public Thread getActionThread() {
            return this.actionThread;
        }

        public boolean isAlive() {
            return this.actionThread.isAlive();
        }

        public void reportError(Throwable throwable) {
            this.error = throwable;
        }

        public Throwable getError() {
            return this.error;
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (this.error == null) {
                this.error = throwable;
            }
        }
    }
}

