/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer;

import java.io.IOException;
import java.io.Writer;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.OutputWriter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.SimpleFormatterException;

public class FormattingWriter
extends OutputWriter {
    private static final int SPACES_PER_INDENT = 3;
    private static final String LINE_TERMINATOR = "\n";
    private int elementLevel;

    public void write(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        this.index = 0;
        this.elementLevel = 0;
        while (this.index < cArray.length) {
            this.removeEmptyLines(cArray);
            this.removeSpacesAndTabs(cArray);
            if (cArray[this.index] == '<') {
                this.processTag(writer, cArray);
                continue;
            }
            writer.write(cArray[this.index++]);
        }
    }

    private void removeEmptyLines(char[] cArray) {
        int n;
        if (cArray[this.index] != '\n') {
            return;
        }
        for (n = this.index + 1; n < cArray.length && cArray[n] != '\n'; ++n) {
            if (cArray[n] == ' ' || cArray[n] == '\t') continue;
            return;
        }
        this.index = n;
        if (this.index != cArray.length) {
            this.removeEmptyLines(cArray);
        } else {
            --this.index;
        }
    }

    private void removeSpacesAndTabs(char[] cArray) {
        while (this.index < cArray.length) {
            if (cArray[this.index] != ' ' && cArray[this.index] != '\t') {
                return;
            }
            ++this.index;
        }
    }

    private void processTag(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        if (cArray[this.index + 1] == '!' && cArray[this.index + 2] == '-' && cArray[this.index + 3] == '-') {
            this.processCommentTag(writer, cArray);
        } else if (cArray[this.index + 1] == '!') {
            this.processDocTypeTag(writer, cArray);
        } else if (cArray[this.index + 1] == '?') {
            this.processInstructionTag(writer, cArray);
        } else if (cArray[this.index + 1] == '/') {
            --this.elementLevel;
            this.processElementTag(writer, cArray);
        } else {
            ++this.elementLevel;
            this.processElementTag(writer, cArray);
        }
    }

    private void processElementTag(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        boolean bl = false;
        while (this.index < cArray.length) {
            if (cArray[this.index] == '\"') {
                bl = true;
                writer.write(cArray[this.index++]);
                this.processAttributeValue(writer, cArray);
                continue;
            }
            if (cArray[this.index] == '\'') {
                bl = true;
                writer.write(cArray[this.index++]);
                this.processSingleQuoteAttributeValue(writer, cArray);
                continue;
            }
            if (cArray[this.index] == '/' && cArray[this.index + 1] == '>') {
                --this.elementLevel;
                if (bl) {
                    this.writeNewLineAndIndent(writer, this.elementLevel);
                }
                writer.write(cArray[this.index++]);
                writer.write(cArray[this.index++]);
                return;
            }
            if (cArray[this.index] == '>') {
                writer.write(cArray[this.index++]);
                return;
            }
            if (cArray[this.index] == ' ') {
                this.writeNewLineAndIndent(writer, this.elementLevel);
                ++this.index;
                continue;
            }
            if (cArray[this.index] == '<' && cArray[this.index + 1] == '/') {
                this.writeIndent(writer, this.elementLevel);
                writer.write(cArray[this.index++]);
                continue;
            }
            if (cArray[this.index] == '<') {
                this.writeIndent(writer, this.elementLevel - 1);
                writer.write(cArray[this.index++]);
                continue;
            }
            writer.write(cArray[this.index++]);
        }
        throw new SimpleFormatterException("Unclosed element tag in output xml file.");
    }

    private void processInstructionTag(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        while (this.index < cArray.length) {
            writer.write(cArray[this.index++]);
            if (cArray[this.index - 1] != '>' || cArray[this.index - 2] != '?') continue;
            writer.write(10);
            return;
        }
        throw new SimpleFormatterException("Unclosed processing instruction tags in output xml file. Writing failed.");
    }

    private void processCommentTag(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        while (this.index < cArray.length) {
            writer.write(cArray[this.index++]);
            if (cArray[this.index - 1] != '>' || cArray[this.index - 2] != '-' || cArray[this.index - 3] != '-') continue;
            writer.write(10);
            return;
        }
        throw new SimpleFormatterException("Unclosed comment tags in output xml file.");
    }

    private void processDocTypeTag(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        while (this.index < cArray.length) {
            writer.write(cArray[this.index++]);
            if (cArray[this.index - 1] != '>') continue;
            writer.write(10);
            return;
        }
        throw new SimpleFormatterException("Unclosed quotation marks around attribute value in output xml file.");
    }

    private void processAttributeValue(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        while (this.index < cArray.length) {
            writer.write(cArray[this.index++]);
            if (cArray[this.index - 1] != '\"') continue;
            return;
        }
        throw new SimpleFormatterException("Unclosed quotation marks around attribute value in output xml file.");
    }

    private void processSingleQuoteAttributeValue(Writer writer, char[] cArray) throws IOException, SimpleFormatterException {
        while (this.index < cArray.length) {
            writer.write(cArray[this.index++]);
            if (cArray[this.index - 1] != '\'') continue;
            return;
        }
        throw new SimpleFormatterException("Unclosed quotation marks around attribute value in output xml file.");
    }

    private void writeNewLineAndIndent(Writer writer, int n) throws IOException {
        writer.write(LINE_TERMINATOR);
        this.writeIndent(writer, n);
    }

    private void writeIndent(Writer writer, int n) throws IOException {
        for (int i = 0; i < 3 * n; ++i) {
            writer.write(32);
        }
    }
}

