/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.util.DeleteEtmUtil;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmTrafficDescriptor;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAtmLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIub;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElement;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeBFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrack;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.rbs.bem.common.util.IpAddressHandler;

public class DeleteEtm
extends Observable {
    public static final boolean NOT_DESCENDING = false;
    public static final boolean DESCENDING = true;
    public static final int INITIAL_NO_OF_PROGRESS_REPORTS = 100;
    private static final String ATTRNAME_RESERVEDBY = "reservedBy";
    private static final String VALUE_STRING_PROGRESS_FOR_ETM = "Preparing to Lock and Delete ETM        ";
    private static final String VALUE_STRING_DELETE_FAILED_NO_ROLLBACK = "Manage Transmission Link failed! \nThe configuration has NOT been changed running this application.";
    private static final String VALUE_STRING_ET_BOARD_STILL_IN_USE_INFO = "\n\nThe ET board is still in use. \nIf \"Migration of RBS between ATM and IP\" is initiated, \nthen please check that correct OPI is used. ";
    private final List findIpAtmLinkDeleteMO = new ArrayList();
    private final List ipAtmLinkMOs = new ArrayList();
    private BemMo[] ipInterfaceMOs;
    private int totalNoOfProgressReports = 1;
    private int progressIndicator = 0;
    private BemMo secondEtmMo;
    private final Rbs rbs;

    public DeleteEtm(Rbs rbs) {
        this.rbs = rbs;
        DeleteEtmUtil.clearlistOfDeletedMO();
        DeleteEtmUtil.clearlistOfLockedMO();
        DeleteEtmUtil.clearListOfPerformedActionsOnMOs();
    }

    public String getSlotFor2ndAtmLink(String string) throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        if (bemMo.getType().equals(MimExchangeTerminal.MOTYPENAME)) {
            List list = this.findIpAtmLink(bemMo, null, true);
            if (!list.isEmpty()) {
                this.ipAtmLinkMOs.addAll(list);
                BemMo bemMo2 = DeleteEtmUtil.getParentMoOfType(bemMo, MimSubrack.MOTYPENAME);
                try {
                    BemMo[] bemMoArray = moHandler.getChildren(bemMo2, 4, MimExchangeTerminal.MOTYPENAME, "");
                    for (int i = 0; i < bemMoArray.length; ++i) {
                        List list2;
                        if (((Object)bemMo).equals(bemMoArray[i]) || (list2 = this.findIpAtmLink(bemMoArray[i], null, true)).isEmpty()) continue;
                        this.ipAtmLinkMOs.addAll(list2);
                        this.secondEtmMo = bemMoArray[i];
                        BemMo bemMo3 = DeleteEtmUtil.getParentMoOfType(this.secondEtmMo, MimSlot.MOTYPENAME);
                        return BemUtil.getRdn(bemMo3.getDN());
                    }
                }
                catch (MoHandlerException moHandlerException) {
                    throw new BemException(moHandlerException);
                }
            }
        } else {
            String string2 = this.rbs.getMoiRefs().getHubSubrackMoi().getLdn();
            BemMo bemMo4 = this.rbs.getMoHandler().getMo(string2);
            try {
                this.ipInterfaceMOs = this.rbs.getMoHandler().getChildren(bemMo4, 6, MimIpInterface.MOTYPENAME, "");
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException);
            }
        }
        return null;
    }

    public void prepareDelete(BemMo bemMo, int n) throws BemException {
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, "", "");
            if (bemMoArray != null && bemMoArray.length > 0) {
                for (int i = n; i < bemMoArray.length; ++i) {
                    if (bemMoArray[i].getType().equalsIgnoreCase(MimProgram.MOTYPENAME)) continue;
                    this.prepareDeleteMO(bemMoArray[i], null, true);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
    }

    public void prepareDeleteIpRoutingTable() throws BemException {
        if (this.secondEtmMo != null) {
            this.prepareDelete(this.secondEtmMo, 1);
        }
        IpAddressHandler ipAddressHandler = new IpAddressHandler();
        MoInstance moInstance = this.rbs.getMoiRefs().getIpRoutingTable();
        try {
            NalStruct nalStruct;
            String string;
            int n;
            String string2;
            Object object;
            NalNameValue[] nalNameValueArray3;
            int n2;
            MoHandler moHandler = this.rbs.getMoHandler();
            BemMo bemMo = moHandler.getMo(moInstance.getLdn());
            NalStruct[] nalStructArray = (NalStruct[])moHandler.getAttribute(bemMo, "staticRoutes");
            int n3 = (Integer)moHandler.action(bemMo, "numberOfRoutes", new NalNameValue[0]);
            ArrayList<NalObject> arrayList = new ArrayList<NalObject>();
            ArrayList<NalStruct> arrayList2 = new ArrayList<NalStruct>();
            NalNameValue[] nalNameValueArray2 = new NalNameValue[1];
            for (n2 = 0; n2 < n3; ++n2) {
                nalNameValueArray2[0] = Nal.getFactory().getNameValue("IpRoutingTableId", n2);
                nalNameValueArray3 = (NalStruct)moHandler.action(bemMo, "getRoutingTableEntry", nalNameValueArray2);
                arrayList.add((NalObject)nalNameValueArray3);
            }
            if (this.ipInterfaceMOs != null) {
                for (n2 = 0; n2 < this.ipInterfaceMOs.length; ++n2) {
                    nalNameValueArray3 = (String)this.ipInterfaceMOs[n2].getAttribute("defaultRouter0");
                    object = (Integer)this.ipInterfaceMOs[n2].getAttribute("networkPrefixLength");
                    string2 = this.convertToSubnetMask((Integer)object);
                    for (n = 0; n < nalStructArray.length; ++n) {
                        string = (String)nalStructArray[n].getMemberValue("nextHopIpAddr");
                        if (!ipAddressHandler.checkIfOnSite((String)nalNameValueArray3, string2, string)) continue;
                        nalStruct = this.getRoutingTableEntryOfStaticRoute(arrayList, nalStructArray[n]);
                        arrayList2.add(nalStruct);
                    }
                }
            } else {
                for (NalNameValue[] nalNameValueArray3 : this.ipAtmLinkMOs) {
                    object = (String)nalNameValueArray3.getAttribute("ipAddress");
                    string2 = (String)nalNameValueArray3.getAttribute("subnetMask");
                    for (n = 0; n < nalStructArray.length; ++n) {
                        string = (String)nalStructArray[n].getMemberValue("nextHopIpAddr");
                        if (!ipAddressHandler.checkIfOnSite((String)object, string2, string)) continue;
                        nalStruct = this.getRoutingTableEntryOfStaticRoute(arrayList, nalStructArray[n]);
                        arrayList2.add(nalStruct);
                    }
                }
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                nalNameValueArray3 = new NalNameValue[]{Nal.getFactory().getNameValue("routingTableEntry", arrayList2.get(i))};
                moHandler.orderMoOperation("deleteStaticRoute", bemMo, nalNameValueArray3);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
        catch (NalCmException nalCmException) {
            throw new BemException("prepareDeleteEtm", "", "ipAtmLinkMO", "Getting attributes of ipATmLinkMO fails ", nalCmException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException("prepareDeleteEtm", "", "RoutingTableEntryMO", "Getting attributes of RoutingTableEntry fails ", noSuchFieldException);
        }
    }

    public void prepareDeleteAtmTrafficDescriptor() throws BemException {
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            String string = this.rbs.getMoiRefs().getTransportNetworkMoi().getLdn();
            BemMo bemMo = this.rbs.getMoHandler().getMo(string);
            BemMo[] bemMoArray = this.rbs.getMoHandler().getChildren(bemMo, 1, MimAtmTrafficDescriptor.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                boolean bl = false;
                Object[] objectArray = (Object[])moHandler.getAttribute(bemMoArray[i], ATTRNAME_RESERVEDBY);
                if (objectArray != null) {
                    for (int j = 0; j < objectArray.length; ++j) {
                        if (!(objectArray[j] instanceof BemMo)) continue;
                        if (DeleteEtmUtil.isMoInListOfDeleteMOs((BemMo)objectArray[j])) {
                            bl = true;
                        }
                        if (DeleteEtmUtil.isMoInListOfDeleteMOs((BemMo)objectArray[j])) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                moHandler.orderMoOperation("delete", bemMoArray[i], new NalNameValue[0]);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(this.getClass() + "prepareDeleteAtmTrafficDescriptor()", (Throwable)moHandlerException);
        }
    }

    private void prepareDeleteMO(BemMo bemMo, BemMo bemMo2, boolean bl) throws BemException {
        Object object;
        int n;
        BemMo[] bemMoArray;
        if (bemMo == null || bemMo.getDN() == null) {
            return;
        }
        String string = bemMo.getType();
        if (string.equalsIgnoreCase(MimManagedElement.MOTYPENAME) || string.equalsIgnoreCase(MimNodeBFunction.MOTYPENAME) || string.equalsIgnoreCase(MimIub.MOTYPENAME)) {
            throw new BemException("Manage Transmission Link failed! \nThe configuration has NOT been changed running this application.\n\nThe ET board is still in use. \nIf \"Migration of RBS between ATM and IP\" is initiated, \nthen please check that correct OPI is used. ");
        }
        if (DeleteEtmUtil.actionExistForMO(bemMo)) {
            DeleteEtmUtil.orderActionForMO(bemMo);
        }
        String[] stringArray = DeleteEtmUtil.getAttributeNames(bemMo, ATTRNAME_RESERVEDBY);
        for (int i = 0; i < stringArray.length; ++i) {
            bemMoArray = DeleteEtmUtil.getReservedByMO(bemMo, stringArray[i]);
            if (bemMoArray == null) continue;
            for (n = 0; n < bemMoArray.length; ++n) {
                if (bemMoArray[n] == null || bemMoArray[n].getDN() == null || bemMoArray[n].getDN().equals("null") || bemMoArray[n].getDN().equals("")) continue;
                if (DeleteEtmUtil.actionExistForMO(bemMoArray[n])) {
                    DeleteEtmUtil.orderActionForMO(bemMo, bemMoArray[n]);
                    continue;
                }
                this.prepareDeleteMO(bemMoArray[n], null, false);
            }
        }
        try {
            object = this.rbs.getMoHandler();
            bemMoArray = object.getChildren(bemMo, 1, "", "");
            if (bemMoArray != null) {
                for (n = 1; n < bemMoArray.length; ++n) {
                    if (bemMo2 == null) {
                        this.prepareDeleteMO(bemMoArray[n], null, true);
                        continue;
                    }
                    String string2 = bemMoArray[n].getDN();
                    String string3 = bemMo2.getDN();
                    if (string2 == null || string2.equalsIgnoreCase(string3)) continue;
                    this.prepareDeleteMO(bemMoArray[n], null, true);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
        if (DeleteEtmUtil.isMOLockable(bemMo)) {
            DeleteEtmUtil.orderLockOfMO(bemMo);
        }
        if (DeleteEtmUtil.isMODeletable(bemMo)) {
            boolean bl2 = DeleteEtmUtil.orderDeleteOfMO(bemMo);
            if (bl2) {
                this.progressIndicator = this.checkAndReportProgress(this.totalNoOfProgressReports, this.progressIndicator + 1, this.totalNoOfProgressReports, this.progressIndicator, VALUE_STRING_PROGRESS_FOR_ETM);
            }
        } else if (!bl) {
            object = bemMo.getParent();
            this.prepareDeleteMO((BemMo)object, bemMo, false);
        }
    }

    private List findIpAtmLink(BemMo bemMo, BemMo bemMo2, boolean bl) throws BemException {
        List list;
        int n;
        Object object;
        ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
        if (bemMo == null) {
            return arrayList;
        }
        String string = bemMo.getType();
        if (string.equalsIgnoreCase(MimManagedElement.MOTYPENAME) || string.equalsIgnoreCase(MimNodeBFunction.MOTYPENAME) || string.equalsIgnoreCase(MimIub.MOTYPENAME)) {
            throw new BemException("Manage Transmission Link failed! \nThe configuration has NOT been changed running this application.\n\nThe ET board is still in use. \nIf \"Migration of RBS between ATM and IP\" is initiated, \nthen please check that correct OPI is used. ");
        }
        if (string.equals(MimIpAtmLink.MOTYPENAME)) {
            arrayList.add(bemMo);
        }
        String[] stringArray = DeleteEtmUtil.getAttributeNames(bemMo, ATTRNAME_RESERVEDBY);
        for (int i = 0; i < stringArray.length; ++i) {
            object = DeleteEtmUtil.getReservedByMO(bemMo, stringArray[i]);
            if (object == null) continue;
            for (n = 0; n < ((BemMo[])object).length; ++n) {
                if (object[n] == null || object[n].getDN() == null || object[n].getDN().equals("null") || object[n].getDN().equals("") || DeleteEtmUtil.actionExistForMO((BemMo)object[n]) || (list = this.findIpAtmLink((BemMo)object[n], null, false)).isEmpty()) continue;
                arrayList.addAll(list);
            }
        }
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            object = moHandler.getChildren(bemMo, 1, "", "");
            if (object != null) {
                for (n = 1; n < ((BemMo[])object).length; ++n) {
                    list = null;
                    if (bemMo2 == null) {
                        list = this.findIpAtmLink(object[n], null, true);
                    } else {
                        String string2 = object[n].getDN();
                        String string3 = bemMo2.getDN();
                        if (string2 != null && !string2.equalsIgnoreCase(string3)) {
                            list = this.findIpAtmLink((BemMo)object[n], null, true);
                        }
                    }
                    if (list == null || list.isEmpty()) continue;
                    arrayList.addAll(list);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
        if (DeleteEtmUtil.isMODeletable(bemMo)) {
            if (!this.findIpAtmLinkDeleteMO.contains(bemMo)) {
                this.findIpAtmLinkDeleteMO.add(bemMo);
            }
        } else if (!bl && !(object = this.findIpAtmLink(bemMo.getParent(), bemMo, false)).isEmpty()) {
            arrayList.addAll((Collection<BemMo>)object);
        }
        return arrayList;
    }

    private int checkAndReportProgress(int n, int n2, int n3, int n4, String string) {
        if (n3 < 1) {
            return 0;
        }
        int n5 = n * n2 / n3 - n4;
        int n6 = n4;
        if (n2 > n3) {
            return n6 += n5;
        }
        if (n5 > 0) {
            n6 += n5;
            this.setChanged();
            this.notifyObservers(Nal.getFactory().getNameValue(string, n5));
        }
        return n6;
    }

    public String convertToSubnetMask(int n) {
        int n2 = n;
        String string = "";
        string = n2 <= 8 ? this.getSubnetValue(n2) + ".0.0.0" : (n2 <= 16 ? "255." + this.getSubnetValue(n2 - 8) + ".0.0" : (n2 <= 24 ? "255.255." + this.getSubnetValue(n2 - 16) + ".0" : "255.255.255." + this.getSubnetValue(n2 - 24)));
        return string;
    }

    private String getSubnetValue(int n) {
        if (n == 8) {
            return "255";
        }
        if (n == 7) {
            return "254";
        }
        if (n == 6) {
            return "252";
        }
        if (n == 5) {
            return "248";
        }
        if (n == 4) {
            return "240";
        }
        if (n == 3) {
            return "224";
        }
        if (n == 2) {
            return "192";
        }
        if (n == 1) {
            return "128";
        }
        return "0";
    }

    private NalStruct getRoutingTableEntryOfStaticRoute(List list, NalStruct nalStruct) throws BemException {
        NalStruct nalStruct2 = null;
        try {
            String string = (String)nalStruct.getMemberValue("ipAddress");
            String string2 = (String)nalStruct.getMemberValue("networkMask");
            String string3 = (String)nalStruct.getMemberValue("nextHopIpAddr");
            for (int i = 0; i < list.size(); ++i) {
                NalStruct nalStruct3 = (NalStruct)list.get(i);
                String string4 = (String)nalStruct3.getMemberValue("destinationIpAddr");
                String string5 = (String)nalStruct3.getMemberValue("destinationNetworkMask");
                String string6 = (String)nalStruct3.getMemberValue("nextHopIpAddr");
                if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string5) || !string3.equalsIgnoreCase(string6)) continue;
                nalStruct2 = nalStruct3;
            }
            if (nalStruct2 == null) {
                BemLog.trace("Can not find this static route in routingTableEntry");
            }
            return nalStruct2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException("prepareDeleteEtm", "", "RoutingTableEntryMO", "trasnfer static routing to RoutingTableEntry format fails ", noSuchFieldException);
        }
    }
}

