/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionConstants;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractConfigurationItem
implements ConfigurationItem,
ExceptionConstants {
    private final Hashtable parameterHash = new Hashtable();
    protected final Rbs rbs;
    private HashMap sectorUninstall = new HashMap();

    public AbstractConfigurationItem(Rbs rbs) {
        this.rbs = rbs;
    }

    public abstract boolean open() throws BemException;

    public void afterOpen() throws BemException {
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        return false;
    }

    public String[] getAllCustomerParameterNames() {
        String[] stringArray = new String[]{};
        Set set = this.parameterHash.keySet();
        if (!set.isEmpty()) {
            stringArray = set.toArray(stringArray);
        }
        return stringArray;
    }

    public void addParameter(CustomerParameter customerParameter) {
        String string = customerParameter.getName();
        this.parameterHash.put(string, customerParameter);
        this.rbs.registerCustomerParameter(customerParameter);
    }

    public void addAllParametes(Collection collection) {
        for (Object e : collection) {
            this.addParameter((CustomerParameter)e);
        }
    }

    public void removeParameter(CustomerParameter customerParameter) {
        String string = customerParameter.getName();
        this.parameterHash.remove(string);
        this.rbs.unRegisterCustomerParameter(customerParameter);
    }

    public CustomerParameter getParameter(String string) {
        if (this.isParameterSupported(string)) {
            CustomerParameter customerParameter = (CustomerParameter)this.parameterHash.get(string);
            return customerParameter;
        }
        throw new Error("Not recognised parameter" + string);
    }

    public List getParameters() {
        Collection collection = this.parameterHash.values();
        ArrayList arrayList = new ArrayList(collection);
        return arrayList;
    }

    public TreeSet getParameterNames() {
        Set set = this.parameterHash.keySet();
        TreeSet treeSet = new TreeSet(set);
        return treeSet;
    }

    public boolean isParameterSupported(String string) {
        return this.parameterHash.containsKey(string);
    }

    public Rbs getRbs() {
        return this.rbs;
    }

    public List getRIsToUninstall() throws BemException {
        return new ArrayList();
    }

    public void checkConsistency() throws BemException {
        List list = this.getParameters();
        for (Object e : list) {
            CustomerParameter customerParameter;
            if (!(e instanceof CustomerParameter) || (customerParameter = (CustomerParameter)e).isValidValue() || !customerParameter.hasValueChanged()) continue;
            Nal.getFactory().getLog().nalTrace(7, this.getClass(), "Invalid CustomerParam: " + customerParameter.getName() + " (cont):" + "\n   RBS class=" + this.rbs.getClass().getName() + "\n       maxNoOfSectors=" + this.rbs.getMaxNumberOfSectors() + "\n   Checked ConfigurationItem=" + this.getName() + "\n   ParameterNames=" + this.getParameterNames() + "\n  ");
            throw new CustomerParameterException(customerParameter);
        }
    }

    protected void setCustomerParametersFromSV(String[] stringArray, ServiceValue serviceValue) throws BemException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = serviceValue.getValue(string);
            if (string2 == null) continue;
            this.setCustomerParameter(string, string2);
        }
    }

    protected void setCustomerParameter(String string, String string2) throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
        if (customerParameter == null) {
            throw new BemException("setCustomerParameter(): A customer parameter is not found with name=" + string);
        }
        customerParameter.setValue(string2);
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        for (String string : list) {
            CustomerParameter customerParameter;
            CustomerParameter customerParameter2;
            if (!this.isParameterSupported(string) || !((customerParameter2 = this.getParameter(string)) instanceof CustomerParameter) || (customerParameter = customerParameter2).isValidValue()) continue;
            throw new CustomerParameterException(customerParameter);
        }
    }

    protected void setSectorUninstall(int n, boolean bl) {
        this.sectorUninstall.put(new Integer(n), bl);
    }

    public boolean isSectorUninstalledBeforeAddCarrier(int n) {
        if (this.sectorUninstall.isEmpty()) {
            return false;
        }
        Boolean bl = (Boolean)this.sectorUninstall.get(new Integer(n));
        return bl;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        return new ConfigurationCheckReport();
    }

    public String toString() {
        String string = this.getName();
        return string;
    }

    public void throwCustomerParameterException(CustomerParameter customerParameter, String string) throws BemException {
        Nal.getFactory().getLog().nalTrace(7, this.getClass(), string);
        throw new CustomerParameterException(customerParameter);
    }
}

