/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.termination.TerminationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.EtmBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrack;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractEtmBoardManager
implements EtmBoardListener {
    public static final String PCR_MAX = "MAX_PCR";
    public static final String PCR_DEFAULT = "MAX_DEFAULT";
    public static final String MCR_MAX = "MAX_MCR";
    private static final double PCR_SLOT_IN_FRACTION = 150.93548;
    private static final double PCR_CONVERSION_RATE = 0.97234375;
    private Rbs rbs = null;
    private EtmBoardProvider etmBoardProvider = null;
    private Map slotMappings = new HashMap();
    private Map boardSlots = new HashMap();

    public AbstractEtmBoardManager(Rbs rbs, EtmBoardProvider etmBoardProvider) {
        this.rbs = rbs;
        this.etmBoardProvider = etmBoardProvider;
    }

    protected abstract void createSlotMappings(Map var1, EtmBoardProvider var2);

    public void loadAllEtmsFromNode() {
        this.etmBoardProvider.addEtmBoardListener(this);
        List list = this.etmBoardProvider.getEtmCapableBoards();
        this.boardSlots = this.createBoardSlots(list);
        this.slotMappings = new HashMap();
        this.createSlotMappings(this.slotMappings, this.etmBoardProvider);
    }

    protected abstract Map createBoardSlots(List var1);

    public boolean isEtmBoardsExistingOnNode() {
        boolean bl = false;
        Collection collection = this.boardSlots.values();
        for (Map map : collection) {
            if (map == null || map.size() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String[] getAllSupportedSlots() {
        return this.etmBoardProvider.getAllSupportedSlots();
    }

    public abstract String[] getAllSupportedStandards();

    public abstract String[] getAllSupportedTerminationTypes();

    public abstract String getStandard(String var1, String var2) throws BemException;

    public String getSubrackId(String string) {
        try {
            MoInstance moInstance = this.etmBoardProvider.getExchangeTerminalMoi(string);
            if (moInstance != null) {
                return BemUtil.extractRdnId(moInstance.getLdn(), MimSubrack.MOTYPENAME);
            }
        }
        catch (Exception exception) {
            BemLog.log(2, this.getClass() + " getSubrackId(" + string + ")", exception);
        }
        return null;
    }

    public String getEtmLdn(String string) {
        try {
            MoInstance moInstance = this.etmBoardProvider.getExchangeTerminalMoi(string);
            if (moInstance != null) {
                return moInstance.getLdn();
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + " getSubrackId(" + string + ")", bemException);
        }
        return null;
    }

    public String[] getSlotsForBoardType(String string) {
        String[] stringArray = null;
        Map map = (Map)this.boardSlots.get(string);
        if (map != null) {
            stringArray = AtmAndPtUtil.getSlotArray(map);
        }
        return stringArray;
    }

    protected abstract Mapping getEtmMapping(String var1, Map var2) throws BemException;

    public String[] getAvailableSlots(TerminationParameterList[] terminationParameterListArray, String string) throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.getAvailableSlots();
        if (stringArray == null) {
            return null;
        }
        if (terminationParameterListArray == null && string == null) {
            return stringArray;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isTerminationAddable(stringArray[i], terminationParameterListArray, string)) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean isTerminationAddable(String string, TerminationParameterList[] terminationParameterListArray, String string2) throws BemException {
        boolean bl = false;
        String[] stringArray = this.getAvailableLines(string, terminationParameterListArray, string2);
        if (stringArray != null && stringArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isCbu(String string) throws BemException {
        boolean bl = false;
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        if (mapping != null) {
            bl = mapping.isCbu();
        }
        return bl;
    }

    public boolean isFractional(String string, String string2) throws BemException {
        boolean bl = false;
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        if (mapping != null) {
            bl = mapping.isFractional(string2);
        }
        return bl;
    }

    public boolean isIma(String string, String string2) throws BemException {
        boolean bl = false;
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        if (mapping != null) {
            bl = mapping.isIma(string2);
        }
        return bl;
    }

    public abstract String[] getAvailableLines(String var1, TerminationParameterList[] var2, String var3) throws BemException;

    public abstract String[] getAvailableStandards(String var1) throws BemException;

    protected String[] getAvailableStandards(Mapping mapping) {
        String[] stringArray = null;
        stringArray = AbstractTerminationRI.getLoadedStandard() == null ? mapping.getSupportedStandards() : new String[]{AbstractTerminationRI.getLoadedStandard()};
        return stringArray;
    }

    public abstract String[] getAvailableTerminationTypes(String var1, String var2) throws BemException;

    public abstract String[] getAvailableTerminationTypes(String var1) throws BemException;

    public Integer getMaxNoOfLines(String string, String string2) throws BemException {
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        return mapping.getMaxNoOfLines(string2);
    }

    public Integer getMaxLineNumber(String string, String string2) throws BemException {
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        return mapping.getMaxLineNumberForTerminationType(string2);
    }

    public Integer getMaxNoOfTimeSlots(String string, String string2) throws BemException {
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        return mapping.getMaxNoOfTimeSlots(string2);
    }

    public String[] getAvailableSlots() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.etmBoardProvider.getEtmCapableBoards();
        for (EtmBoard etmBoard : list) {
            arrayList.add(String.valueOf(etmBoard.getSlotNo()));
        }
        return arrayList.toArray(new String[0]);
    }

    public Integer getPeakCellRate(TerminationData terminationData, String string, String string2) throws BemException {
        Integer n = null;
        if (terminationData == null) {
            return null;
        }
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
        String string3 = terminationData.getSlotNumber();
        String string4 = terminationData.getTerminationType();
        String string5 = terminationData.getRequiredNumberOfLinks();
        String[] stringArray = terminationData.getTimeSlotsInFraction();
        if (string3 != null) {
            Mapping mapping = this.getEtmMapping(string3, this.slotMappings);
            if (mapping != null) {
                n = string.equals(PCR_MAX) ? mapping.getMaxCellRate(string4) : mapping.getDefaultCellRate(string4);
            }
            boolean bl = this.isFractional(string3, string4);
            boolean bl2 = this.isIma(string3, string4);
            if (bl) {
                int n2 = stringArray.length;
                double d = (double)n2 * 150.93548;
                int n3 = (int)Math.floor(d);
                n = new Integer(n3);
            } else if (bl2) {
                int n4 = terminationData.getLineNumbers().length;
                int n5 = Integer.parseInt(string5);
                Integer n6 = (Integer)customerParameterServer.getValueMom();
                n = n6 == 3 ? new Integer((int)((double)(n4 * n) * 0.97234375)) : new Integer((int)((double)(n5 * n) * 0.97234375));
            }
        }
        return n;
    }

    public Integer getMinCellRate(TerminationData terminationData, String string) throws BemException {
        Integer n = null;
        if (terminationData == null) {
            return null;
        }
        String string2 = terminationData.getSlotNumber();
        String string3 = terminationData.getTerminationType();
        String string4 = terminationData.getRequiredNumberOfLinks();
        String[] stringArray = terminationData.getTimeSlotsInFraction();
        if (string2 != null) {
            Mapping mapping = this.getEtmMapping(string2, this.slotMappings);
            if (mapping != null) {
                n = string.equals(MCR_MAX) ? mapping.getMaxCellRate(string3) : mapping.getDefaultCellRate(string3);
            }
            boolean bl = this.isFractional(string2, string3);
            boolean bl2 = this.isIma(string2, string3);
            if (bl) {
                int n2 = stringArray.length;
                double d = (double)n2 * 150.93548;
                int n3 = (int)Math.floor(d);
                n = new Integer(n3);
            } else if (bl2) {
                int n4 = Integer.parseInt(string4);
                n = new Integer((int)((double)(n4 * n) * 0.97234375));
            }
        }
        return n;
    }

    public void update() {
        List list = this.etmBoardProvider.getEtmCapableBoards();
        this.boardSlots = this.createBoardSlots(list);
        this.slotMappings = new HashMap();
        this.createSlotMappings(this.slotMappings, this.etmBoardProvider);
    }

    public IntegerRange getLineRange(String string, String string2) throws BemException {
        Mapping mapping = this.getEtmMapping(string, this.slotMappings);
        Integer n = mapping.getMinLineNumberForTerminationType(string2);
        Integer n2 = mapping.getMaxLineNumberForTerminationType(string2);
        IntegerRange integerRange = new IntegerRange((int)n, (int)n2);
        return integerRange;
    }

    protected EtmBoardProvider getEtmBoardProvider() {
        return this.etmBoardProvider;
    }

    protected Rbs getRbs() {
        return this.rbs;
    }

    public String[] getAllowedTerminationTypesMatchingDefaultOamAtmLink() throws BemException {
        throw new BemException("getAllowedTerminationTypesMatchingDefaultOamAtmLink() is not supported for this RBS type");
    }

    public String[] getAllowedLinesMatchingDefaultOamAtmLink() throws BemException {
        throw new BemException("getAllowedLinesMatchingDefaultOamAtmLink() is not supported for this RBS type");
    }

    public void checkBoardCombinationConsistency() throws BemException {
    }

    protected Map getSlotMappings() {
        return this.slotMappings;
    }

    protected Set getAlreadyOccupiedLines(String string, TerminationParameterList[] terminationParameterListArray) {
        HashSet<String> hashSet = new HashSet<String>();
        if (terminationParameterListArray != null) {
            for (int i = 0; i < terminationParameterListArray.length; ++i) {
                EtbSlotParameter etbSlotParameter = terminationParameterListArray[i].getSlotParameter();
                String string2 = etbSlotParameter.getValue();
                if (!string2.equals(string)) continue;
                PhysicalLineParameter physicalLineParameter = terminationParameterListArray[i].getLineParameter();
                String[] stringArray = physicalLineParameter.getAllLines();
                for (int j = 0; j < stringArray.length; ++j) {
                    hashSet.add(stringArray[j]);
                }
            }
        }
        return hashSet;
    }
}

