/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.IpOverGigabitEthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpHostLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpHostLinkRI
extends AbstractResourceItem {
    public static final String name = "IpHostLinkRI";
    private static final String[] phases = new String[]{"IpHostCreationPhase"};
    private MoInstance ipInterfaceMoi = null;
    private MoInstance ipMoi;
    private MoInstance ipHostLinkMoi = null;
    private List pseudoList = new ArrayList();
    private static final String READ_ONLY_REASON = "Not possible to change attributes on IpHosts when IpInterface is shared";
    private boolean shouldBeDeleted = false;
    private MoInstance vpnInterfaceMoi = null;
    private IpOverGigabitEthernetProvider ipOverGigabitEthernetProvider;

    public IpHostLinkRI(Rbs rbs, IpOverGigabitEthernetProvider ipOverGigabitEthernetProvider) throws BemException {
        super(name, rbs, phases);
        this.ipOverGigabitEthernetProvider = ipOverGigabitEthernetProvider;
        this.initializeMois();
        List list = this.getCustomerParameterList();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        this.initiateCPWithNodeValues();
        this.setRestrictionsOnCustomerParameters();
    }

    public IpHostLinkRI(Rbs rbs, IpOverGigabitEthernetProvider ipOverGigabitEthernetProvider, MoInstance moInstance) throws BemException {
        super(name, rbs, phases);
        this.ipOverGigabitEthernetProvider = ipOverGigabitEthernetProvider;
        this.vpnInterfaceMoi = moInstance;
        this.initializeMois();
        List list = this.getCustomerParameterList();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        this.initiateCPWithNodeValues();
    }

    public void setShouldBeDeleted(boolean bl) {
        this.shouldBeDeleted = bl;
    }

    private void initializeMois() {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpOam.MOTYPENAME, "1");
        this.ipMoi = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        this.ipHostLinkMoi = new SingleChildMoi(this.ipMoi, MimIpHostLink.MOTYPENAME, "1");
    }

    private void setRestrictionsOnCustomerParameters() throws BemException {
        if (this.isIpInterfaceShared()) {
            ParameterRestriction parameterRestriction = new ParameterRestriction(READ_ONLY_REASON, 0);
            String[] stringArray = new String[]{"OamIpHost_oamIpAddress", "OamIpHost_oamSubnetMask", "OamIpHost_oamDefaultRouter0", "OamIpHost_oamVid", "IPoverGigabitEthernet_syncIpAddress", "IPoverGigabitEthernet_syncSubnetMask", "IPoverGigabitEthernet_defaultRouter0", "IPoverGigabitEthernet_syncVid"};
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.rbs.isParameterSupported(stringArray[i])) continue;
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(stringArray[i]);
                customerParameterServer.addRestriction(parameterRestriction);
            }
        }
    }

    private boolean isIpInterfaceShared() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            String string = this.ipHostLinkMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "ipInterfaceMoRef");
            BemMo[] bemMoArray = (BemMo[])this.getAttribute(bemMo2, "reservedBy");
            bl = bemMoArray.length > 1;
        }
        return bl;
    }

    public void setIpInterface(MoInstance moInstance) {
        this.ipInterfaceMoi = moInstance;
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.ipHostLinkMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        String string2 = "";
        boolean bl = this.isInstalled();
        if (bl) {
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                Object object = this.getAttribute(bemMo, string2);
                customerParameterServer.setLoadedValue(object);
            }
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        String string = this.ipHostLinkMoi.getLdn();
        bl = this.isExisting(string);
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            bl = true;
        }
        if (this.shouldBeDeleted) {
            bl = true;
        }
        if (!bl) {
            bl = this.isIpHostLinkCustparamsInGigabitEthernetCiChanged();
        }
        return bl;
    }

    public boolean getRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            bl = true;
        }
        if (this.shouldBeDeleted) {
            bl = true;
        }
        return bl;
    }

    private boolean isIpHostLinkCustparamsInGigabitEthernetCiChanged() throws BemException {
        boolean bl = false;
        CustomerParameter customerParameter = this.ipOverGigabitEthernetProvider.getOamSubnetMask();
        bl = this.isParamChanged(customerParameter);
        if (!bl) {
            CustomerParameter customerParameter2 = this.ipOverGigabitEthernetProvider.getIpHostLinkDefaultRouter();
            bl = this.isParamChanged(customerParameter2);
        }
        return bl;
    }

    private boolean isParamChanged(CustomerParameter customerParameter) {
        boolean bl = false;
        if (customerParameter != null) {
            bl = customerParameter.hasValueChanged();
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("IpHostCreationPhase")) {
            this.createIpHostLink();
        } else if (string.equals("IpSettingPhase") && this.ipInterfaceMoi != null) {
            boolean bl = false;
            this.setIpHostLink(bl);
        } else if (string.equals("IpResetPhase") && this.ipInterfaceMoi != null) {
            boolean bl = true;
            this.setIpHostLink(bl);
        } else if (string.equals("IpHostDeletePhase") && this.shouldBeDeleted) {
            this.deleteMoIfExisting(this.ipHostLinkMoi.getLdn());
        }
    }

    private void createIpHostLink() throws BemException {
        if (!this.isInstalled()) {
            Object object;
            BemMo bemMo = this.getMo(this.ipHostLinkMoi.getLdn());
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string = "ipInterfaceMoRef";
            if (this.ipInterfaceMoi != null) {
                object = this.getMo(this.ipInterfaceMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue(string, object));
            } else if (this.vpnInterfaceMoi != null) {
                object = this.getMo(this.vpnInterfaceMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue(string, object));
            }
            if (!this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP()) {
                string = "ipAddress";
                object = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
                String string2 = this.rbs.getCustomerParameterServerObject("ipAddress").getLoadedValue();
                Object object2 = null;
                object2 = !((String)object).equals(string2) ? object : "169.254.1.1";
                vector.add(Nal.getFactory().getNameValue(string, object2));
            }
            this.create(bemMo, vector);
            try {
                object = Nal.getFactory();
                object.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private void setIpHostLink(boolean bl) throws BemException {
        if (!this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP() && this.isInstalled() && bl == this.shouldBeDeleted) {
            BemMo bemMo = this.getMo(this.ipHostLinkMoi.getLdn());
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string = "ipAddress";
            Object object = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
            vector.add(Nal.getFactory().getNameValue(string, object));
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("OamIpHost_oamSubnetMask");
            string = "networkPrefixLength";
            object = customerParameterServer.getValueMom();
            vector.add(Nal.getFactory().getNameValue(string, object));
            customerParameterServer = this.rbs.getCustomerParameterServerObject("OamIpHost_oamDefaultRouter0");
            string = "defaultRouter0";
            object = customerParameterServer.getValueMom();
            vector.add(Nal.getFactory().getNameValue(string, object));
            string = "defaultRouter1";
            object = "0.0.0.0";
            vector.add(Nal.getFactory().getNameValue(string, object));
            string = "defaultRouter2";
            object = "0.0.0.0";
            vector.add(Nal.getFactory().getNameValue(string, object));
            string = "ownIpAddressActive";
            object = "0.0.0.0";
            vector.add(Nal.getFactory().getNameValue(string, object));
            NalNameValue[] nalNameValueArray = vector.toArray(new NalNameValue[0]);
            this.action(bemMo, "assignIpAddress", nalNameValueArray);
        }
    }

    public String getLdn() {
        return "";
    }

    public String getDisplayName() {
        return name;
    }

    public MoInstance getMoi() {
        return this.ipHostLinkMoi;
    }

    private List getCustomerParameterList() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>(0);
        CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject("OamIpHost_oamIpAddress");
        arrayList.add(customerParameter);
        return arrayList;
    }
}

