/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVpnInterface;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferencedMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferringMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpAccessHostEtRI
extends AbstractResourceItem {
    public static final String name = "IpAccessHostEtRI";
    private static String[] phases = new String[]{"LockPhase", "IpAccessHostEtCreationPhase", "IpAccessHostEtOuterCreationPhase", "UnlockPhase"};
    private MoInstance ipInterFaceMoi = null;
    private MoInstance ipAccesHostEtMoi = null;
    private final List pseudoList = new ArrayList();
    private static final String IP_ADDRESS_PSEUDO = "IPoverGigabitEthernet_syncIpAddress";
    private static final String INNER_IP_ADDRESS_PSEUDO = "Iub_ipAddressHostEt";
    private static final String OUTER_OAM_IP_ADDRESS_PSEUDO = "OamIpHost_outerOamIpAddressHostEt";
    public static final String INNER_IUB_IPACCESSHOSTET_RDN = "1";
    public static final String OUTER_IUB_IPACCESSHOSTET_RDN = "2";
    public static final String OUTER_OAM_IPACCESSHOSTET_RDN = "3";
    private MoInstance vpnInterFaceMoi = null;
    private String ipAccessHostEtMoRdn = "1";
    private String ipAdressPseudo = "IPoverGigabitEthernet_syncIpAddress";

    public IpAccessHostEtRI(Rbs rbs, MoInstance moInstance) throws BemException {
        super(name, rbs, phases);
        this.ipInterFaceMoi = moInstance;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null) {
            this.initializeMois();
            this.initiateCPWithNodeValues();
        }
    }

    public IpAccessHostEtRI(Rbs rbs, MoInstance moInstance, MoInstance moInstance2, String string) throws BemException {
        super(name, rbs, phases);
        this.ipAccessHostEtMoRdn = string;
        this.ipInterFaceMoi = moInstance;
        this.vpnInterFaceMoi = moInstance2;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null || moInstance2 != null) {
            this.initializeMois();
            this.initiateCPWithNodeValues();
        }
    }

    public void setIpInterfaceMoi(MoInstance moInstance) throws BemException {
        this.ipInterFaceMoi = moInstance;
        this.initializeMois();
    }

    private void initializeMois() throws BemException {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, INNER_IUB_IPACCESSHOSTET_RDN);
        BemMo bemMo = this.getMo(singleChildMoi.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimIpAccessHostEt.MOTYPENAME, "");
        if (bemMoArray.length <= 1 && this.vpnInterFaceMoi == null && this.ipAccessHostEtMoRdn.equals(INNER_IUB_IPACCESSHOSTET_RDN)) {
            this.ipAccesHostEtMoi = new ReferencedMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "ipInterfaceMoRef", this.ipInterFaceMoi, INNER_IUB_IPACCESSHOSTET_RDN);
        } else if (bemMoArray.length == 2 && !this.ipAccessHostEtMoRdn.equals(INNER_IUB_IPACCESSHOSTET_RDN)) {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, INNER_IUB_IPACCESSHOSTET_RDN);
            ReferringMoi referringMoi = new ReferringMoi(singleChildMoi, MimVpnInterface.MOTYPENAME, fixedRdnMoi, "ipInterfaceMoRef", INNER_IUB_IPACCESSHOSTET_RDN);
            this.ipAccesHostEtMoi = new ReferringMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, referringMoi, "ipAccessHostEtRef", INNER_IUB_IPACCESSHOSTET_RDN);
        } else {
            this.ipAccesHostEtMoi = new FixedRdnMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, this.ipAccessHostEtMoRdn);
        }
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        if (this.vpnInterFaceMoi == null && (this.ipAccessHostEtMoRdn.equals(INNER_IUB_IPACCESSHOSTET_RDN) || this.ipAccessHostEtMoRdn.equals(OUTER_IUB_IPACCESSHOSTET_RDN))) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(IP_ADDRESS_PSEUDO);
            arrayList.add(customerParameter);
            this.ipAdressPseudo = IP_ADDRESS_PSEUDO;
        } else if (this.vpnInterFaceMoi == null && this.ipAccessHostEtMoRdn.equals(OUTER_OAM_IPACCESSHOSTET_RDN)) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(OUTER_OAM_IP_ADDRESS_PSEUDO);
            arrayList.add(customerParameter);
            this.ipAdressPseudo = OUTER_OAM_IP_ADDRESS_PSEUDO;
        } else if (this.vpnInterFaceMoi != null && this.ipAccessHostEtMoRdn.equals(INNER_IUB_IPACCESSHOSTET_RDN)) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(INNER_IP_ADDRESS_PSEUDO);
            arrayList.add(customerParameter);
            this.ipAdressPseudo = INNER_IP_ADDRESS_PSEUDO;
        }
        return arrayList;
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.ipAccesHostEtMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        String string2 = "";
        boolean bl = this.isInstalled();
        if (bl) {
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                Object object = this.getAttribute(bemMo, string2);
                customerParameterServer.setLoadedValue(object);
            }
        }
    }

    public boolean isInstalled() throws BemException {
        String string = this.ipAccesHostEtMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                if (!customerParameter.isValidValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("LockPhase")) {
            this.lockIpAccessHostEt();
        } else if (string.equals("IpAccessHostEtCreationPhase") && this.ipAccessHostEtMoRdn.equals(INNER_IUB_IPACCESSHOSTET_RDN) || string.equals("IpAccessHostEtOuterCreationPhase") && !this.ipAccessHostEtMoRdn.equals(INNER_IUB_IPACCESSHOSTET_RDN)) {
            this.installIpAccessEt();
        } else if (string.equals("UnlockPhase")) {
            this.unlockIpAccessHostEt();
        }
    }

    private void installIpAccessEt() throws BemException {
        String string = this.ipAccesHostEtMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (!bl) {
            Object object;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string2 = "administrativeState";
            Object object2 = new Integer(1);
            vector.add(Nal.getFactory().getNameValue(string2, object2));
            string2 = "ipInterfaceMoRef";
            if (this.ipInterFaceMoi != null) {
                object = this.getMo(this.ipInterFaceMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue(string2, object));
            } else if (this.vpnInterFaceMoi != null) {
                object = this.getMo(this.vpnInterFaceMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue(string2, object));
            }
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                object2 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string2, object2));
            }
            this.create(bemMo, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string4 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                boolean bl2 = customerParameterServer.hasValueChanged();
                if (!bl2) continue;
                String string5 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string5, object));
            }
            if (vector.size() > 0) {
                this.lockIpAccessHostEt();
                this.setAttributes(bemMo, vector);
            }
        }
    }

    private void lockIpAccessHostEt() throws BemException {
        CustomerParameter customerParameter;
        boolean bl;
        String string = this.ipAccesHostEtMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl2 = this.isExisting(bemMo);
        if (bl2 && (bl = (customerParameter = this.rbs.getCustomerParameterObject(this.ipAdressPseudo)).hasValueChanged())) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
        }
    }

    private void unlockIpAccessHostEt() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(this.ipAdressPseudo);
        boolean bl = customerParameter.hasValueChanged();
        if (bl) {
            String string = this.ipAccesHostEtMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
        }
    }

    public String getLdn() {
        return "";
    }

    public String getDisplayName() {
        return name;
    }

    public MoInstance getMoi() {
        return this.ipAccesHostEtMoi;
    }
}

