/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.AccessLevel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSec;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSecTunnel;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpSecTunnelRI
extends AbstractResourceItem {
    public static final String name = "IpSecTunnelRI";
    private static String[] phases = new String[]{"IpSecTunnelCreationPhase"};
    private MoInstance ipSecTunnelMoi = null;
    private MoInstance ikePeerRefMoi = null;
    private MoInstance vpnInterfaceRefMoi = null;
    private int rdnId;
    private final List pseudoList = new ArrayList();

    public IpSecTunnelRI(Rbs rbs, MoInstance moInstance, MoInstance moInstance2, int n) throws BemException {
        super(name, rbs, phases);
        this.rdnId = n;
        this.ikePeerRefMoi = moInstance;
        this.vpnInterfaceRefMoi = moInstance2;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        this.initializeMois();
        this.initiateCPWithNodeValues();
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return "";
    }

    public MoInstance getMoi() {
        return this.ipSecTunnelMoi;
    }

    public void install(String string) throws BemException {
        if (string.equals(phases[0])) {
            this.createIpSecTunnelMO();
        }
    }

    public void uninstall(String string) throws BemException {
        if (this.isInstalled()) {
            this.deleteMoIfExisting(this.ipSecTunnelMoi.getLdn());
        }
    }

    private void createIpSecTunnelMO() throws BemException {
        BemMo bemMo = this.getMo(this.ipSecTunnelMoi.getLdn());
        String string = "";
        String string2 = "";
        Integer[] integerArray = new Integer[1];
        String string3 = "";
        Integer n = new Integer(32);
        String string4 = "";
        Integer n2 = new Integer(32);
        Boolean bl = false;
        Integer[] integerArray2 = new Integer[11];
        Integer[] integerArray3 = new Integer[11];
        int n3 = 0;
        string = this.rdnId == 1 ? "Iub_" : "OamIpHost_";
        if (!this.isExisting(bemMo)) {
            Object object;
            NalNameValue[] nalNameValueArray;
            Object object2;
            AccessLevel accessLevel;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            BemMo bemMo2 = this.getMo(this.vpnInterfaceRefMoi.getLdn());
            vector.add(Nal.getFactory().getNameValue("vpnInterfaceRef", bemMo2));
            BemMo bemMo3 = this.getMo(this.ikePeerRefMoi.getLdn());
            vector.add(Nal.getFactory().getNameValue("ikePeerRef", bemMo3));
            for (CustomerParameter customerParameter : this.getCustomerParameters()) {
                accessLevel = this.rbs.getCustomerParameterServerObject(customerParameter.getName());
                object2 = customerParameter.getValue();
                if (((String)object2).equals("##UNDEFINED") || ((String)object2).equals("")) continue;
                nalNameValueArray = accessLevel.getAttributeName();
                object = accessLevel.getValueMom();
                if (nalNameValueArray.equals("tsProtocols")) {
                    integerArray[0] = (Integer)object;
                    vector.add(Nal.getFactory().getNameValue((String)nalNameValueArray, integerArray));
                    continue;
                }
                if (nalNameValueArray.equals("IpSecTunnel_tsLocalIpAddress")) {
                    string3 = (String)object;
                    continue;
                }
                if (nalNameValueArray.equals("IpSecTunnel_tsLocalIpAddressMask")) {
                    n = (Integer)object;
                    continue;
                }
                if (nalNameValueArray.equals("IpSecTunnel_tsRemoteIpAddress")) {
                    string4 = (String)object;
                    continue;
                }
                if (nalNameValueArray.equals("IpSecTunnel_tsRemoteIpAddressMask")) {
                    n2 = (Integer)object;
                    continue;
                }
                if (nalNameValueArray.equals("IpSecTunnel_pfs")) {
                    bl = (Boolean)object;
                    continue;
                }
                if (nalNameValueArray.equals("encryptionAlgorithm") || nalNameValueArray.equals("integrityAlgorithm")) continue;
                vector.add(Nal.getFactory().getNameValue((String)nalNameValueArray, object));
            }
            for (int i = 0; i < 11; ++i) {
                string2 = MessageFormat.format(string + "IpSecTunnel_ChildSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
                accessLevel = this.rbs.getCustomerParameterObject(string2);
                object2 = accessLevel.getValue();
                nalNameValueArray = this.rbs.getCustomerParameterServerObject(string2);
                if (!object2.equals("##UNDEFINED") && !object2.equals("")) {
                    object = nalNameValueArray.getValueMom();
                    integerArray3[i] = (Integer)object;
                    ++n3;
                }
                string2 = MessageFormat.format(string + "IpSecTunnel_ChildSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
                accessLevel = this.rbs.getCustomerParameterObject(string2);
                nalNameValueArray = this.rbs.getCustomerParameterServerObject(string2);
                object2 = accessLevel.getValue();
                if (object2.equals("##UNDEFINED") || object2.equals("")) continue;
                object = nalNameValueArray.getValueMom();
                integerArray2[i] = (Integer)object;
            }
            NalStruct[] nalStructArray = new NalStruct[n3];
            for (int i = 0; i < n3; ++i) {
                object2 = new NalNameValue[]{Nal.getFactory().getNameValue("encryptionAlgorithm", integerArray2[i]), Nal.getFactory().getNameValue("integrityAlgorithm", integerArray3[i])};
                nalStructArray[i] = Nal.getFactory().getStruct((NalNameValue[])object2);
            }
            vector.add(Nal.getFactory().getNameValue("allowedTransforms", nalStructArray));
            NalNameValue[] nalNameValueArray2 = new NalNameValue[]{Nal.getFactory().getNameValue("ipAddress", string3), Nal.getFactory().getNameValue("mask", n)};
            object2 = new NalStruct[]{Nal.getFactory().getStruct(nalNameValueArray2)};
            vector.add(Nal.getFactory().getNameValue("tsLocalIpAddressRanges", object2));
            nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("ipAddress", string4), Nal.getFactory().getNameValue("mask", n2)};
            object = new NalStruct[]{Nal.getFactory().getStruct(nalNameValueArray)};
            vector.add(Nal.getFactory().getNameValue("tsRemoteIpAddressRanges", object));
            vector.add(Nal.getFactory().getNameValue("priority", MimIpSecTunnel.MIN_PRIORITY));
            vector.add(Nal.getFactory().getNameValue("pfs", bl));
            this.create(bemMo, vector);
        } else {
            BemLog.logWarning("Don't support modify attributes : ");
        }
    }

    private void initializeMois() {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIpSec.MOTYPENAME, "1");
        this.ipSecTunnelMoi = new FixedRdnMoi(singleChildMoi2, MimIpSecTunnel.MOTYPENAME, String.valueOf(this.rdnId));
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        String string = this.rdnId == 1 ? "Iub_" : "OamIpHost_";
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string + "IpSecTunnel_protocolType");
        arrayList.add(customerParameter);
        CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string + "IpSecTunnel_tsLocalIpAddress");
        arrayList.add(customerParameter2);
        CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject(string + "IpSecTunnel_tsLocalIpAddressMask");
        arrayList.add(customerParameter3);
        CustomerParameter customerParameter4 = this.rbs.getCustomerParameterObject(string + "IpSecTunnel_tsRemoteIpAddress");
        arrayList.add(customerParameter4);
        CustomerParameter customerParameter5 = this.rbs.getCustomerParameterObject(string + "IpSecTunnel_tsRemoteIpAddressMask");
        arrayList.add(customerParameter5);
        CustomerParameter customerParameter6 = this.rbs.getCustomerParameterObject(string + "IpSecTunnel_pfs");
        arrayList.add(customerParameter6);
        for (int i = 0; i < 11; ++i) {
            String string2 = MessageFormat.format(string + "IpSecTunnel_ChildSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
            CustomerParameter customerParameter7 = this.rbs.getCustomerParameterObject(string2);
            arrayList.add(customerParameter7);
            string2 = MessageFormat.format(string + "IpSecTunnel_ChildSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
            CustomerParameter customerParameter8 = this.rbs.getCustomerParameterObject(string2);
            arrayList.add(customerParameter8);
        }
        return arrayList;
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.ipSecTunnelMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = this.isInstalled();
        if (bl) {
            string3 = this.rdnId == 1 ? "Iub_" : "OamIpHost_";
            string2 = "tsLocalIpAddressRanges";
            Object object = this.getAttribute(bemMo, string2);
            NalStruct[] nalStructArray = (NalStruct[])object;
            NalNameValue nalNameValue = nalStructArray[0].getMember("ipAddress");
            string4 = string3 + "IpSecTunnel_tsLocalIpAddress";
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
            customerParameterServer.setLoadedValue(nalNameValue.getValue());
            NalNameValue nalNameValue2 = nalStructArray[0].getMember("mask");
            string4 = string3 + "IpSecTunnel_tsLocalIpAddressMask";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
            customerParameterServer.setLoadedValue(nalNameValue2.getValue());
            string2 = "tsRemoteIpAddressRanges";
            object = this.getAttribute(bemMo, string2);
            NalStruct[] nalStructArray2 = (NalStruct[])object;
            NalNameValue nalNameValue3 = nalStructArray2[0].getMember("ipAddress");
            string4 = string3 + "IpSecTunnel_tsRemoteIpAddress";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
            customerParameterServer.setLoadedValue(nalNameValue3.getValue());
            NalNameValue nalNameValue4 = nalStructArray2[0].getMember("mask");
            string4 = string3 + "IpSecTunnel_tsRemoteIpAddressMask";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
            customerParameterServer.setLoadedValue(nalNameValue4.getValue());
            string2 = "pfs";
            object = this.getAttribute(bemMo, string2);
            Boolean bl2 = (boolean)((Boolean)object);
            string4 = string3 + "IpSecTunnel_pfs";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
            customerParameterServer.setLoadedValue(bl2);
            string2 = "tsProtocols";
            object = this.getAttribute(bemMo, string2);
            int[] nArray = (int[])object;
            Integer n = new Integer(nArray[0]);
            string4 = string3 + "IpSecTunnel_protocolType";
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
            customerParameterServer.setLoadedValue(n);
            string2 = "allowedTransforms";
            object = this.getAttribute(bemMo, "allowedTransforms");
            NalStruct[] nalStructArray3 = (NalStruct[])object;
            for (int i = 0; i < nalStructArray3.length; ++i) {
                NalNameValue nalNameValue5 = nalStructArray3[i].getMember("encryptionAlgorithm");
                string4 = MessageFormat.format(string3 + "IpSecTunnel_ChildSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                customerParameterServer.setLoadedValue(nalNameValue5.getValue());
                NalNameValue nalNameValue6 = nalStructArray3[i].getMember("integrityAlgorithm");
                string4 = MessageFormat.format(string3 + "IpSecTunnel_ChildSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                customerParameterServer.setLoadedValue(nalNameValue6.getValue());
            }
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        String string = this.ipSecTunnelMoi.getLdn();
        bl = this.isExisting(string);
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                if (!customerParameter.isValidValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

