/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE1Ttp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE3PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimJ1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOs155SpiTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSts3CspeTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimT1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimT3PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVc4Ttp;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class PhysicalTransportLayerRI
extends AbstractResourceItem {
    public static final String TERM_TYPE_E1 = "E1";
    public static final String TERM_TYPE_J1 = "J1";
    public static final String TERM_TYPE_T1 = "T1";
    public static final String TERM_TYPE_FRAC_E1 = "FRAC-E1";
    public static final String TERM_TYPE_FRAC_J1 = "FRAC-J1";
    public static final String TERM_TYPE_FRAC_T1 = "FRAC-T1";
    public static final String TERM_TYPE_STM1_ETSI = "STM1_ETSI";
    public static final String TERM_TYPE_STM1_TTC = "STM1_TTC";
    public static final String TERM_TYPE_OC3 = "OC3";
    public static final String TERM_TYPE_E3 = "E3";
    public static final String TERM_TYPE_T3 = "T3";
    public static final String TERM_TYPE_CHAN_STM1_E1 = "Chan_STM1_E1";
    public static final String TERM_TYPE_CHAN_OC3_T1 = "Chan_OC3_T1";
    public static final String name = "PhysicalTransportLayer";
    private static final String[] myPhases = new String[]{"PhysicalTransportLayerCreationPhase"};
    private static final Integer VC4_MUX_MODE = new Integer(2);
    private static final Integer THE_PRIORITY = new Integer(1);
    private String etmLdn;
    private String etmType;
    private String atmId;
    private String physPathTermId = "pp1";
    private static final Integer LINE_NO = new Integer(1);
    private String etbSlot;
    private final EtmBoardProvider etmBoardProvider;

    public PhysicalTransportLayerRI(Rbs rbs, EtmBoardProvider etmBoardProvider) {
        super(name, rbs, myPhases);
        this.etmBoardProvider = etmBoardProvider;
    }

    private void initialiseMois() throws BemException {
        this.etbSlot = this.rbs.getCustomerParameter("IubNpcTestConfiguration_etbSlot");
        MoInstance moInstance = this.etmBoardProvider.getExchangeTerminalMoi(this.etbSlot);
        this.etmLdn = moInstance.getLdn();
        String string = this.etmBoardProvider.getTypeForExistingBoard(this.etbSlot);
        this.etmType = EtmBoardProvider.ETM_TYPE_MAPING.pseudo2type(string);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            this.initialiseMois();
            this.configureMos();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureMos() throws BemException, BemException {
        String string = this.rbs.getCustomerParameter("IubNpcTestConfiguration_terminationType");
        this.atmId = "1-" + this.etbSlot + "-1";
        this.physPathTermId = "pp1";
        if (this.etmType.equals("Etm1") || this.etmType.equals("Etmc1") || this.etmType.equals(MimCbu.MOTYPENAME) || this.etmType.equals(EtmBoardProvider.ETM_TYPE_MAPING.DUW.ETM_TYPE)) {
            if (string.equalsIgnoreCase(TERM_TYPE_E1)) {
                this.createPhysPathTermIfNotExisting(MimE1PhysPathTerm.MOTYPENAME, "administrativeState", "lineNo", this.etmLdn);
                return;
            } else if (string.equalsIgnoreCase(TERM_TYPE_J1)) {
                this.createPhysPathTermIfNotExisting(MimJ1PhysPathTerm.MOTYPENAME, "administrativeState", "lineNo", this.etmLdn);
                return;
            } else if (string.equalsIgnoreCase(TERM_TYPE_T1)) {
                this.createPhysPathTermIfNotExisting(MimT1PhysPathTerm.MOTYPENAME, "administrativeState", "lineNo", this.etmLdn);
                return;
            } else if (string.equalsIgnoreCase(TERM_TYPE_OC3)) {
                Integer n = new Integer(0);
                this.createOs155SpiTtpForEtmc4AnsiIfNotExisting(this.etmLdn, n, VC4_MUX_MODE);
                return;
            } else if (string.equalsIgnoreCase(TERM_TYPE_STM1_ETSI)) {
                Integer n = new Integer(1);
                this.createOs155SpiTtpForEtmc4EtsiOrTtcIfNotExisting(this.etmLdn, n, VC4_MUX_MODE);
                return;
            } else {
                if (!string.equalsIgnoreCase(TERM_TYPE_STM1_TTC)) throw new BemException("PhysicalTransportLayer.configureMos() has an unsupported terminationtype for the ET-M1 board. Termination type=" + string);
                Integer n = new Integer(2);
                this.createOs155SpiTtpForEtmc4EtsiOrTtcIfNotExisting(this.etmLdn, n, VC4_MUX_MODE);
            }
            return;
        } else if (this.etmType.equals("Etm3")) {
            if (string.equalsIgnoreCase(TERM_TYPE_E3)) {
                this.createPhysPathTermIfNotExisting(MimE3PhysPathTerm.MOTYPENAME, "administrativeState", "lineNo", this.etmLdn);
                return;
            } else {
                if (!string.equalsIgnoreCase(TERM_TYPE_T3)) throw new BemException("PhysicalTransportLayer.configureMos() has an unsupported terminationtype for the ET-M3 board. Termination type=" + string);
                this.createPhysPathTermIfNotExisting(MimT3PhysPathTerm.MOTYPENAME, "administrativeState", "lineNo", this.etmLdn);
            }
            return;
        } else if (this.etmType.equals("Etm4")) {
            if (string.equalsIgnoreCase(TERM_TYPE_OC3)) {
                Integer n = new Integer(0);
                this.createOs155SpiTtpForEtmc4AnsiIfNotExisting(this.etmLdn, n, VC4_MUX_MODE);
                return;
            } else if (string.equalsIgnoreCase(TERM_TYPE_STM1_ETSI)) {
                Integer n = new Integer(1);
                this.createOs155SpiTtpForEtmc4EtsiOrTtcIfNotExisting(this.etmLdn, n, VC4_MUX_MODE);
                return;
            } else {
                if (!string.equalsIgnoreCase(TERM_TYPE_STM1_TTC)) throw new BemException("PhysicalTransportLayer.configureMos() has an unsupported terminationtype for the ET-M4 board. Termination type=" + string);
                Integer n = new Integer(2);
                this.createOs155SpiTtpForEtmc4EtsiOrTtcIfNotExisting(this.etmLdn, n, VC4_MUX_MODE);
            }
            return;
        } else {
            if (!this.etmType.equals("Etmc41")) throw new BemException("PhysicalTransportLayer.configureMos() " + this.etmLdn + " is a not supported etm board");
            Integer n = null;
            if (string.equalsIgnoreCase(TERM_TYPE_CHAN_OC3_T1)) {
                n = new Integer(2);
            } else {
                if (!string.equalsIgnoreCase(TERM_TYPE_CHAN_STM1_E1)) throw new BemException("PhysicalTransportLayer.configureMos() has an unsupported terminationtype for the ET-MC41/ET-MC41S board. Termination type=" + string);
                n = new Integer(1);
            }
            Integer n2 = new Integer(1);
            this.createOs155SpiTtpForEtmc41IfNotExisting(this.etmLdn, n, n2);
        }
    }

    private void createPhysPathTermIfNotExisting(String string, String string2, String string3, String string4) throws BemException {
        String string5 = this.getPhysPathTermLdn(string4, string, this.physPathTermId);
        BemMo bemMo = this.getMo(string5);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue(string3, LINE_NO));
        this.createMoIfNotExisting(string5, vector);
        this.setAttribute(string5, string2, (Object)new Integer(1));
        this.createAtmPortIfNotExisting(bemMo);
        this.addSynchRef(bemMo);
    }

    private void createOs155SpiTtpForEtmc41IfNotExisting(String string, Integer n, Integer n2) throws BemException {
        String string2 = this.getPhysPathTermLdn(string, MimOs155SpiTtp.MOTYPENAME, this.physPathTermId);
        BemMo bemMo = this.getMo(string2);
        boolean bl = bemMo.isExisting();
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("lineNo", LINE_NO));
            vector.add(Nal.getFactory().getNameValue("standardMode", n));
            vector.add(Nal.getFactory().getNameValue("muxMode", n2));
            this.create(bemMo, vector);
            BemMo[] bemMoArray = this.getChildren(bemMo, 10, MimE1Ttp.MOTYPENAME, "");
            if (bemMoArray == null || bemMoArray.length < 1) {
                throw new BemException("Can not read the autocreated E1Ttp MO");
            }
            BemMo bemMo2 = bemMoArray[0];
            this.createAtmPortIfNotExisting(bemMo2);
            this.addSynchRef(bemMo);
        }
        this.unlockOs155SpiTtp(bemMo);
    }

    private void createOs155SpiTtpForEtmc4EtsiOrTtcIfNotExisting(String string, Integer n, Integer n2) throws BemException {
        BemMo bemMo = null;
        BemMo bemMo2 = null;
        String string2 = this.getPhysPathTermLdn(string, MimOs155SpiTtp.MOTYPENAME, this.physPathTermId);
        bemMo = this.getMo(string2);
        boolean bl = bemMo.isExisting();
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("lineNo", LINE_NO));
            vector.add(Nal.getFactory().getNameValue("standardMode", n));
            vector.add(Nal.getFactory().getNameValue("muxMode", n2));
            this.create(bemMo, vector);
            BemMo[] bemMoArray = this.getChildren(bemMo, 10, MimVc4Ttp.MOTYPENAME, "");
            if (bemMoArray == null || bemMoArray.length < 1) {
                throw new BemException("Can not read the autocreated Vc4Ttp MO");
            }
            bemMo2 = bemMoArray[0];
            this.createAtmPortIfNotExisting(bemMo2);
            this.addSynchRef(bemMo);
        }
        this.unlockOs155SpiTtp(bemMo);
    }

    private void createOs155SpiTtpForEtmc4AnsiIfNotExisting(String string, Integer n, Integer n2) throws BemException {
        BemMo bemMo = null;
        BemMo bemMo2 = null;
        String string2 = this.getPhysPathTermLdn(string, MimOs155SpiTtp.MOTYPENAME, this.physPathTermId);
        bemMo = this.getMo(string2);
        boolean bl = bemMo.isExisting();
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("lineNo", LINE_NO));
            vector.add(Nal.getFactory().getNameValue("standardMode", n));
            vector.add(Nal.getFactory().getNameValue("muxMode", n2));
            this.create(bemMo, vector);
            BemMo[] bemMoArray = this.getChildren(bemMo, 10, MimSts3CspeTtp.MOTYPENAME, "");
            if (bemMoArray == null || bemMoArray.length < 1) {
                throw new BemException("Can not read the autocreated Sts3CspeTtp MO");
            }
            bemMo2 = bemMoArray[0];
            this.createAtmPortIfNotExisting(bemMo2);
            this.addSynchRef(bemMo);
        }
        this.unlockOs155SpiTtp(bemMo);
    }

    private void createAtmPortIfNotExisting(BemMo bemMo) throws BemException {
        String string = this.getAtmPortLdn();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("uses", bemMo));
        this.createMoIfNotExisting(string, vector);
    }

    private void addSynchRef(BemMo bemMo) throws BemException {
        MoInstance moInstance = this.rbs.getMoiRefs().getSynchronizationMoi();
        BemMo bemMo2 = this.getMo(moInstance.getLdn());
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("syncReference", bemMo), Nal.getFactory().getNameValue("syncPriority", THE_PRIORITY)};
        this.action(bemMo2, "addSyncRefResource", nalNameValueArray);
    }

    private String getPhysPathTermLdn(String string, String string2, String string3) {
        String string4 = string + "," + string2 + "=" + string3;
        return string4;
    }

    private String getAtmPortLdn() throws BemException {
        MoInstance moInstance = this.rbs.getMoiRefs().getTransportNetworkMoi();
        String string = moInstance.getLdn();
        String string2 = string + "," + MimAtmPort.MOTYPENAME + "=" + this.atmId;
        return string2;
    }

    private void unlockOs155SpiTtp(BemMo bemMo) throws BemException {
        this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return name;
    }
}

