/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.IubOverAtmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2Ap;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2PathDistributionUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2PathVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2Sp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVclTp;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class TncpProtocolStackRI
extends AbstractResourceItem {
    public static final String name = "TncpProtocolStack";
    private static final String[] myPhases = new String[]{"TransportNetworkControlProtocolCreationPhase"};
    private String a2ea;
    private String atmId;
    private final String atmTrafficDescriptorId;
    private static final Integer ingressAtmPcr = new Integer(1000);
    private static final Integer egressAtmPcr = new Integer(1000);
    private static final Integer ingressAtmQos = new Integer(3);
    private static final Integer egressAtmQos = new Integer(3);
    private static final Integer ingressAtmMcr = new Integer(80);
    private static final Integer egressAtmMcr = new Integer(80);
    private static final Integer serviceCategory = new Integer(3);
    private static final String vpcTpId = "1";
    private static final String vplTpId = "vp1";
    private static final Integer externalVci1 = new Integer(38);
    private static final Integer externalVci2 = new Integer(45);
    private static final String externalVclTp1Id = "vc38";
    private static final String externalVclTp2Id = "vc45";
    private static final String aal5TpVccTp1Id = "bqa";
    private static final String aal5TpVccTp2Id = "bqb";
    private static final String aal2PathVccTpId = "ba1";
    private static final String uniSaalTp1Id = "bqa";
    private static final String uniSaalTp2Id = "bqb";
    private static final Integer maxSduSize = new Integer(128);
    private static final String uniSaalProfileId = "win30";
    private static final Integer initalCredit = new Integer(30);
    private static final Integer timerErq = new Integer(5000);
    private static final Integer timerRel = new Integer(2000);
    private static final String ANS_AAL2AP_11 = "ans_aal2ap_11";
    private static final String ANS_AAL2CPSRC_11 = "ans_aal2cpsrc_11";
    public static final String ANS_AAL2AP_15 = "ans_aal2ap_15";
    public static final String ANS_AAL2CPSRC_15 = "ans_aal2cpsrc_15";
    private List aal2PathsVccTpMois;

    public TncpProtocolStackRI(Rbs rbs, String string) {
        super(name, rbs, myPhases);
        this.atmTrafficDescriptorId = string;
    }

    private void initialiseMois() throws BemException {
        MoInstance moInstance = this.rbs.getMoiRefs().getTransportNetworkMoi();
        this.a2ea = this.rbs.getCustomerParameter("IubNpcTestConfiguration_a2ea");
        String string = this.rbs.getCustomerParameter("IubNpcTestConfiguration_etbSlot");
        this.atmId = "1-" + string + "-1";
        CustomerParameter[] customerParameterArray = this.rbs.getCustomerParameterObjectsWithPseudo("aal2PathId");
        this.aal2PathsVccTpMois = new ArrayList();
        for (int i = 0; i < customerParameterArray.length; ++i) {
            Integer n = Integer.valueOf(customerParameterArray[i].getValue());
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimAal2PathVccTp.MOTYPENAME, "ba" + n.toString());
            this.aal2PathsVccTpMois.add(fixedRdnMoi);
        }
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            this.initialiseMois();
            BemMo bemMo = this.configureAtmTrafficDescriptor();
            this.configureVclTpTree(bemMo);
        }
    }

    private BemMo configureAtmTrafficDescriptor() throws BemException {
        BemMo bemMo = null;
        String string = IubOverAtmManager.getAtmTrafficDescriptorLdn(this.atmTrafficDescriptorId);
        bemMo = this.getMo(string);
        boolean bl = bemMo.isExisting();
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("ingressAtmPcr", ingressAtmPcr));
            vector.add(Nal.getFactory().getNameValue("egressAtmPcr", egressAtmPcr));
            vector.add(Nal.getFactory().getNameValue("ingressAtmMcr", ingressAtmMcr));
            vector.add(Nal.getFactory().getNameValue("egressAtmMcr", egressAtmMcr));
            vector.add(Nal.getFactory().getNameValue("ingressAtmQos", ingressAtmQos));
            vector.add(Nal.getFactory().getNameValue("egressAtmQos", egressAtmQos));
            vector.add(Nal.getFactory().getNameValue("serviceCategory", serviceCategory));
            this.create(bemMo, vector);
        }
        return bemMo;
    }

    private void configureVclTpTree(BemMo bemMo) throws BemException {
        Object object;
        Object object2;
        BemMo bemMo2;
        Object object3;
        Object object4;
        String string = IubOverAtmManager.getVpcTpLdn(vplTpId, vpcTpId, this.atmId);
        String string2 = string + "," + MimVclTp.MOTYPENAME + "=" + externalVclTp1Id;
        Vector vector = IubOverAtmManager.getVclTpAttributes(externalVci1, bemMo);
        BemMo bemMo3 = this.getMo(string2);
        this.createMoIfNotExisting(string2, vector);
        String string3 = string + "," + MimVclTp.MOTYPENAME + "=" + externalVclTp2Id;
        String string4 = IubOverAtmManager.getAal5TpVccTpLdn("bqa");
        Vector vector2 = IubOverAtmManager.getAal5TpVccTpAttributes(this.rbs, bemMo3);
        this.createMoIfNotExisting(string4, vector2);
        BemMo bemMo4 = this.getMo(string4);
        String string5 = IubOverAtmManager.getAal5TpVccTpLdn("bqb");
        String string6 = IubOverAtmManager.getUniSaalProfileLdn(uniSaalProfileId);
        Vector vector3 = IubOverAtmManager.getUniSaalProfileAttributes(initalCredit);
        this.createMoIfNotExisting(string6, vector3);
        BemMo bemMo5 = this.getMo(string6);
        String string7 = IubOverAtmManager.getUniSaalTpLdn("bqa");
        Vector vector4 = IubOverAtmManager.getUniSaalTpAttributes(bemMo5, bemMo4, maxSduSize);
        this.createMoIfNotExisting(string7, vector4);
        BemMo bemMo6 = this.getMo(string7);
        BemMo bemMo7 = null;
        if (IubOverAtmManager.isIubRedunancyAllowed()) {
            object4 = IubOverAtmManager.getUniSaalTpLdn("bqb");
            object3 = IubOverAtmManager.getVclTpAttributes(externalVci2, bemMo);
            bemMo2 = this.getMo(string3);
            this.createMoIfNotExisting(string3, (Vector)object3);
            object2 = IubOverAtmManager.getAal5TpVccTpAttributes(this.rbs, bemMo2);
            this.createMoIfNotExisting(string5, (Vector)object2);
            object = this.getMo(string5);
            Vector vector5 = IubOverAtmManager.getUniSaalTpAttributes(bemMo5, (BemMo)object, maxSduSize);
            this.createMoIfNotExisting((String)object4, vector5);
            bemMo7 = this.getMo((String)object4);
        }
        object4 = this.rbs.getMoiRefs().getTransportNetworkMoi();
        object3 = ((MoInstance)object4).getLdn() + "," + MimAal2Sp.MOTYPENAME + "=1";
        this.createAal2SpIfNotExisting((String)object3);
        bemMo2 = DuwUtil.hasDuw() ? this.getRpuMo(ANS_AAL2AP_15) : this.getRpuMo(ANS_AAL2AP_11);
        object2 = (String)object3 + "," + MimAal2Ap.MOTYPENAME + "=1";
        this.createAal2ApIfNotExisting((String)object2, bemMo6, bemMo7, bemMo2);
        bemMo2 = DuwUtil.hasDuw() ? this.getRpuMo(ANS_AAL2CPSRC_15) : this.getRpuMo(ANS_AAL2CPSRC_11);
        object = (String)object2 + "," + MimAal2PathDistributionUnit.MOTYPENAME + "=1";
        this.createAal2PathDistributionUnitIfNotExisting((String)object, bemMo2);
    }

    private BemMo createAal2SpIfNotExisting(String string) throws BemException {
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("a2ea", this.a2ea));
            this.create(bemMo, vector);
        }
        return bemMo;
    }

    private BemMo createAal2ApIfNotExisting(String string, BemMo bemMo, BemMo bemMo2, BemMo bemMo3) throws BemException {
        BemMo bemMo4 = this.getMo(string);
        boolean bl = this.isExisting(bemMo4);
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("sigLinkId", bemMo));
            vector.add(Nal.getFactory().getNameValue("rpuId", bemMo3));
            vector.add(Nal.getFactory().getNameValue("timerErq", timerErq));
            vector.add(Nal.getFactory().getNameValue("timerRel", timerRel));
            this.create(bemMo4, vector);
        }
        return bemMo4;
    }

    private BemMo createAal2PathDistributionUnitIfNotExisting(String string, BemMo bemMo) throws BemException {
        BemMo bemMo2 = this.getMo(string);
        boolean bl = this.isExisting(bemMo2);
        if (!bl) {
            NalNameValue[] nalNameValueArray;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("rpuId", bemMo));
            this.create(bemMo2, vector);
            BemMo[] bemMoArray = null;
            if (this.aal2PathsVccTpMois.size() == 0) {
                nalNameValueArray = IubOverAtmManager.getAal2PathVccTpLdn(aal2PathVccTpId);
                BemMo bemMo3 = this.getMo((String)nalNameValueArray);
                bemMoArray = new BemMo[]{bemMo3};
            } else {
                bemMoArray = new BemMo[this.aal2PathsVccTpMois.size()];
                for (int i = 0; i < this.aal2PathsVccTpMois.size(); ++i) {
                    MoInstance moInstance = (MoInstance)this.aal2PathsVccTpMois.get(i);
                    bemMoArray[i] = this.getMo(moInstance.getLdn());
                }
            }
            nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aal2PathVccTpId", bemMoArray)};
            this.action(bemMo2, "addPath", nalNameValueArray);
        }
        return bemMo2;
    }

    private BemMo getRpuMo(String string) throws BemException, BemException {
        BemMo bemMo = null;
        MoInstance moInstance = this.rbs.getMoiRefs().getSwManagementMoi();
        String string2 = moInstance.getLdn();
        BemMo bemMo2 = this.getMo(string2);
        BemMo[] bemMoArray = this.getChildren(bemMo2, 1, MimReliableProgramUniter.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo3 = bemMoArray[i];
                String string3 = (String)bemMo3.getAttribute("reliableProgramLabel");
                if (!string3.equals(string)) continue;
                bemMo = bemMo3;
                break;
            }
        }
        if (bemMo == null) {
            throw new BemException("TncpProtocolStack It does not exist a RPU with reliableProgramLabel set to " + (DuwUtil.hasDuw() ? ANS_AAL2AP_15 : ANS_AAL2AP_11) + " Should have been installed in BASIC CV");
        }
        return bemMo;
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return name;
    }
}

