/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.BaseBandPoolBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.BaseBandPoolData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.HspaSettingsRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.NumEulResourcesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.NumHsCodeResourcesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RaxRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.TxDeviceInfoRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.TxRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDeviceBoardRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractRadioEquipmentCI
extends AbstractConfigurationItem
implements AtfProvider,
RadioEquipmentProvider,
HsdpaResourcesProvider {
    public static final String name = "RadioEquipmentCI";
    private static final String PREFIX_ENDING = "{0}_";
    private TxDeviceInfoRI txDeviceInfoRI;
    private HspaSettingsRI[] hspaSettingsRI;
    private RaxRI[] raxRI;
    private TxRI[] txRI;
    private NumHsCodeResourcesParameter[] numHsCodeResourcesParameter;
    private NumEulResourcesParameter[] numEulResourcesParameter;
    private ParameterRestriction rangeRestriction;
    private ParameterRestriction[] onlyOneTxBoardWithEulRestriction;
    private ParameterRestriction[] noEulWithoutHSmodulRestriction;
    private String notValidRangeRestrictionString = "not valid range for num of Hs code";
    private String onlyOneTxTxBoardWithEulRestrictionString = "Only one TX-board \ncan be configured for EUL";
    private String noEulWithoutHSmodulRestrictionString = "Only allowed to have EUL if\n there is at least one HS module in the baseband pool where EUL is activated.";
    private boolean isOpen;
    private List radioEquipmentListeners = new ArrayList();
    private List hsdpaResourcesListeners = new ArrayList();
    private String[] slotsForExistingTxDevices;
    private BaseBandPoolData bbpData = new BaseBandPoolData();
    private HubSubrackMoi hubSubrackMoi;
    private ArrayList raxSlotParameters = new ArrayList();
    private String[] parameterNames;
    private HashMap boardPositions = new HashMap();
    private List deletedRaxRis = null;
    private static final int DEFAULT_MAX_SUPPORTED_TX_BRANCHES_PER_CARRIER = 1;
    private static final int NO_OF_SECTORS_PER_BASE_BAND_POOL_FOR_RUIF_AND_OBIF = 6;

    public AbstractRadioEquipmentCI(Rbs rbs) {
        super(rbs);
    }

    public String getName() {
        return name;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return true;
        }
        this.isOpen = true;
        this.createTxRaxResources();
        this.createHspaResources();
        this.initRaxCustomerParameters();
        return true;
    }

    protected void createTxRaxResources() throws BemException {
        this.createTxResources();
        this.createRaxResources();
    }

    protected void createHspaResources() throws BemException {
        this.createHsdpaEulResources();
        this.createHsdpaCustomerParameters();
        this.createEulCustomerParameters();
        this.addHspaParameterListeners();
        this.updateHsdpaLoadedValues();
        this.updateEulLoadedValues();
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        this.setHspaCustomerParameters(serviceValue);
        this.checkValidSectors(serviceValue);
    }

    protected void setHspaCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int n;
        String[] stringArray = new String[this.numHsCodeResourcesParameter.length];
        String[] stringArray2 = new String[this.numEulResourcesParameter.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.numHsCodeResourcesParameter[n].getName();
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = this.numEulResourcesParameter[n].getName();
        }
        this.checkValidSlotsForHsdpa(stringArray, serviceValue);
        this.checkValidSlotsForEul(stringArray2, serviceValue);
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        super.setCustomerParametersFromSV(stringArray2, serviceValue);
        super.setCustomerParametersFromSV(this.parameterNames, serviceValue);
    }

    private void checkValidSectors(ServiceValue serviceValue) throws BemException {
        this.getRbs().getRbsType();
        LinkedList<String> linkedList = new LinkedList<String>();
        Serializable serializable = serviceValue.getAllAttributesWithSimpleName("sectorNumber");
        Object object = ((Vector)serializable).iterator();
        while (object.hasNext()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)object.next();
            int n = Integer.parseInt(serviceNameValue.getValueAsString());
            if (n <= this.getRbs().getMaxNumberOfSectors()) continue;
            linkedList.add("--------");
            linkedList.add("Found invalid SectorNumber=" + n + ".");
            String string = this.getRbs().getMaxNumberOfSectors() == 1 ? "1" : "1 to " + this.getRbs().getMaxNumberOfSectors();
            linkedList.add(this.getRbs().getRbsType() + " only supports SectorNumber=" + string + ".");
        }
        if (!linkedList.isEmpty()) {
            serializable = new StringBuffer();
            object = System.getProperty("line.separator");
            ((StringBuffer)serializable).append("The following ConfigurationParameters are not applicable for " + this.getRbs().getRbsType() + ":");
            ((StringBuffer)serializable).append((String)object);
            ((StringBuffer)serializable).append("--------");
            ((StringBuffer)serializable).append((String)object);
            while (!linkedList.isEmpty()) {
                ((StringBuffer)serializable).append(linkedList.removeLast().toString());
                ((StringBuffer)serializable).append((String)object);
            }
            throw new BemException(((StringBuffer)serializable).toString());
        }
    }

    private void checkValidSlotsForEul(String[] stringArray, ServiceValue serviceValue) throws BemException {
        int n;
        Object object;
        Vector vector = serviceValue.getAllAttributesWithSimpleName("numEulResources");
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            object = new StringTokenizer(string, "=");
            vector2.add(((StringTokenizer)object).nextToken());
        }
        vector2.removeElement("numEulResources");
        Vector<String> vector3 = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector3.add(stringArray[n]);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = (String)vector2.elementAt(n);
            if (vector3.contains(object)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "eulSlot_");
            String string = stringTokenizer.nextToken();
            throw new BemException("Slot: " + string + " is not valid for configuration of EUL! ");
        }
    }

    private void checkValidSlotsForHsdpa(String[] stringArray, ServiceValue serviceValue) throws BemException {
        int n;
        Object object;
        Vector vector = serviceValue.getAllAttributesWithSimpleName("numHsCodeResources");
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            object = new StringTokenizer(string, "=");
            vector2.add(((StringTokenizer)object).nextToken());
        }
        vector2.removeElement("numHsCodeResources");
        Vector<String> vector3 = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector3.add(stringArray[n]);
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = (String)vector2.elementAt(n);
            if (vector3.contains(object)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "hsSlot_");
            String string = stringTokenizer.nextToken();
            throw new BemException("Slot: " + string + " is not valid for configuration of HSDPA! ");
        }
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        this.updateEulRestrictions();
        super.checkConsistency();
    }

    protected void updateEulRestrictions() {
        this.updateOnlyOneTxBoardWithEulRestriction();
        this.updateNoEulWithoutHSmodulRestriction();
    }

    private void updateOnlyOneTxBoardWithEulRestriction() {
        this.resetOnlyOneTxBoardWithEulRestriction();
        if (this.eulSupportInTwoBaseBandPools()) {
            this.updateOnlyOneTxBoardPerBbpWithEulRestriction();
        } else {
            String[] stringArray;
            int n;
            String string = "eulSlot{0}_";
            boolean bl = false;
            int n2 = -1;
            for (n = 0; n < 2; ++n) {
                stringArray = this.getSlotArrayForTxDevices(n);
                for (int i = 0; i < this.numEulResourcesParameter.length; ++i) {
                    String string2 = this.numEulResourcesParameter[i].getName();
                    if (!this.inBbpArray(string, string2, stringArray) || this.numEulResourcesParameter[i].getValue().equals("0") || this.numEulResourcesParameter[i].getValue().equals("##UNDEFINED")) continue;
                    bl = true;
                    n2 = i;
                    break;
                }
                if (bl) break;
            }
            if (bl) {
                stringArray = this.getSlotArrayForTxDevices(n);
                EnumeratedRange enumeratedRange = this.getAllowedRange();
                for (int i = 0; i < this.numEulResourcesParameter.length; ++i) {
                    String string3 = this.numEulResourcesParameter[i].getName();
                    if (this.inBbpArray(string, string3, stringArray) && (!this.inBbpArray(string, string3, stringArray) || i == n2)) continue;
                    this.onlyOneTxBoardWithEulRestriction[i] = new ParameterRestriction(this.onlyOneTxTxBoardWithEulRestrictionString, enumeratedRange, true);
                    this.onlyOneTxBoardWithEulRestriction[i].setActive(true);
                    this.numEulResourcesParameter[i].addRestriction(this.onlyOneTxBoardWithEulRestriction[i]);
                }
            }
        }
    }

    private void updateOnlyOneTxBoardPerBbpWithEulRestriction() {
        this.resetOnlyOneTxBoardWithEulRestriction();
        String string = "eulSlot{0}_";
        int n = -1;
        for (int i = 0; i < 2; ++i) {
            boolean bl = false;
            String[] stringArray = this.getSlotArrayForTxDevices(i);
            for (int j = 0; j < this.numEulResourcesParameter.length; ++j) {
                String string2 = this.numEulResourcesParameter[j].getName();
                if (!this.inBbpArray(string, string2, stringArray) || this.numEulResourcesParameter[j].getValue().equals("0") || this.numEulResourcesParameter[j].getValue().equals("##UNDEFINED")) continue;
                bl = true;
                n = j;
                break;
            }
            if (!bl) continue;
            EnumeratedRange enumeratedRange = this.getAllowedRange();
            for (int j = 0; j < this.numEulResourcesParameter.length; ++j) {
                String string3 = this.numEulResourcesParameter[j].getName();
                if (!this.inBbpArray(string, string3, stringArray) || j == n) continue;
                this.onlyOneTxBoardWithEulRestriction[j] = new ParameterRestriction(this.onlyOneTxTxBoardWithEulRestrictionString, enumeratedRange, true);
                this.onlyOneTxBoardWithEulRestriction[j].setActive(true);
                this.numEulResourcesParameter[j].addRestriction(this.onlyOneTxBoardWithEulRestriction[j]);
            }
        }
    }

    private void updateNoEulWithoutHSmodulRestriction() {
        this.resetNoEulWithoutHSmoduleRestriction();
        String string = "eulSlot{0}_";
        for (int i = 0; i < 2; ++i) {
            String[] stringArray = this.getSlotArrayForTxDevices(i);
            if (this.hasHsModule(stringArray)) continue;
            EnumeratedRange enumeratedRange = this.getAllowedRange();
            for (int j = 0; j < this.numEulResourcesParameter.length; ++j) {
                String string2 = this.numEulResourcesParameter[j].getName();
                if (!this.inBbpArray(string, string2, stringArray)) continue;
                this.noEulWithoutHSmodulRestriction[j] = new ParameterRestriction(this.noEulWithoutHSmodulRestrictionString, enumeratedRange, true);
                this.noEulWithoutHSmodulRestriction[j].setActive(true);
                this.numEulResourcesParameter[j].addRestriction(this.noEulWithoutHSmodulRestriction[j]);
            }
        }
    }

    private boolean hasHsModule(String[] stringArray) {
        String string = "hsSlot{0}_";
        boolean bl = false;
        for (int i = 0; i < this.numHsCodeResourcesParameter.length; ++i) {
            String string2 = this.numHsCodeResourcesParameter[i].getName();
            if (!this.inBbpArray(string, string2, stringArray) || this.numHsCodeResourcesParameter[i].getValue().equals("0") || this.numHsCodeResourcesParameter[i].getValue().equals("##UNDEFINED")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean inBbpArray(String string, String string2, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = MessageFormat.format(string, stringArray[i]);
            if (!string2.startsWith(string3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private EnumeratedRange getAllowedRange() {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = MimTxDeviceGroup.MIN_NUMEULRESOURCES;
        treeSet.add(Integer.toString(n));
        String[] stringArray = treeSet.toArray(new String[0]);
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        return enumeratedRange;
    }

    private void resetOnlyOneTxBoardWithEulRestriction() {
        for (int i = 0; i < this.onlyOneTxBoardWithEulRestriction.length; ++i) {
            if (this.onlyOneTxBoardWithEulRestriction[i] == null) continue;
            this.numEulResourcesParameter[i].removeRestriction(this.onlyOneTxBoardWithEulRestriction[i]);
            this.onlyOneTxBoardWithEulRestriction[i] = null;
        }
    }

    private void resetNoEulWithoutHSmoduleRestriction() {
        for (int i = 0; i < this.noEulWithoutHSmodulRestriction.length; ++i) {
            if (this.noEulWithoutHSmodulRestriction[i] == null) continue;
            this.numEulResourcesParameter[i].removeRestriction(this.noEulWithoutHSmodulRestriction[i]);
            this.noEulWithoutHSmodulRestriction[i] = null;
        }
    }

    private void createHsdpaEulResources() throws BemException {
        try {
            this.txDeviceInfoRI = new TxDeviceInfoRI(this.getRbs(), this);
            this.slotsForExistingTxDevices = this.txDeviceInfoRI.getSlotsForExistingTxDevices();
            this.hspaSettingsRI = new HspaSettingsRI[this.slotsForExistingTxDevices.length];
            for (int i = 0; i < this.slotsForExistingTxDevices.length; ++i) {
                this.hspaSettingsRI[i] = new HspaSettingsRI(this.getRbs(), this.slotsForExistingTxDevices[i], this.txDeviceInfoRI);
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            String string2 = moHandlerException.getLdn();
            String string3 = moHandlerException.getAdditionalInfo();
            throw new BemException(string, "", string2, string3, moHandlerException);
        }
    }

    private void createRaxResources() throws BemException {
        this.hubSubrackMoi = new HubSubrackMoi(this.getRbs().getEquipmentMoi());
        String[] stringArray = this.getBoardPositions(MimRaxDeviceGroup.MOTYPENAME);
        this.raxRI = new RaxRI[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.valueOf(stringArray[i]);
            this.raxRI[i] = new RaxRI(this.getRbs(), n, this.hubSubrackMoi.getLdn());
        }
    }

    private void createTxResources() throws BemException {
        this.hubSubrackMoi = new HubSubrackMoi(this.getRbs().getEquipmentMoi());
        String[] stringArray = this.getBoardPositions(MimTxDeviceGroup.MOTYPENAME);
        this.txRI = new TxRI[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.valueOf(stringArray[i]);
            this.txRI[i] = new TxRI(this.getRbs(), n, this.hubSubrackMoi.getLdn());
        }
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = false;
        String string = serviceValue.getValue("numHsCodeResources");
        if (string != null) {
            bl = true;
        }
        return bl;
    }

    protected void createEulCustomerParameters() throws BemException {
        this.onlyOneTxBoardWithEulRestriction = new ParameterRestriction[this.slotsForExistingTxDevices.length];
        this.noEulWithoutHSmodulRestriction = new ParameterRestriction[this.slotsForExistingTxDevices.length];
        EnumeratedRange enumeratedRange = this.getNumEulCodeResourcesRange();
        this.numEulResourcesParameter = new NumEulResourcesParameter[this.slotsForExistingTxDevices.length];
        for (int i = 0; i < this.slotsForExistingTxDevices.length; ++i) {
            String string = this.slotsForExistingTxDevices[i];
            String string2 = MessageFormat.format("eulSlot{0}_numEulResources", string);
            this.numEulResourcesParameter[i] = new NumEulResourcesParameter(string2, enumeratedRange);
            this.numEulResourcesParameter[i].setTxSlot(Integer.parseInt(string));
            this.rangeRestriction = new ParameterRestriction(this.notValidRangeRestrictionString, enumeratedRange, true);
            this.rangeRestriction.setActive(true);
            this.numEulResourcesParameter[i].addRestriction(this.rangeRestriction);
            this.addParameter(this.numEulResourcesParameter[i]);
        }
    }

    protected void createHsdpaCustomerParameters() throws BemException {
        EnumeratedRange enumeratedRange = this.getNumHsCodeResourcesRange();
        this.numHsCodeResourcesParameter = new NumHsCodeResourcesParameter[this.slotsForExistingTxDevices.length];
        for (int i = 0; i < this.slotsForExistingTxDevices.length; ++i) {
            String string = this.slotsForExistingTxDevices[i];
            String string2 = MessageFormat.format("hsSlot{0}_numHsCodeResources", string);
            this.numHsCodeResourcesParameter[i] = new NumHsCodeResourcesParameter(string2, enumeratedRange);
            this.numHsCodeResourcesParameter[i].setTxSlot(Integer.parseInt(string));
            this.rangeRestriction = new ParameterRestriction(this.notValidRangeRestrictionString, enumeratedRange, true);
            this.rangeRestriction.setActive(true);
            this.numHsCodeResourcesParameter[i].addRestriction(this.rangeRestriction);
            this.addParameter(this.numHsCodeResourcesParameter[i]);
        }
    }

    private EnumeratedRange getNumEulCodeResourcesRange() {
        int n;
        TreeSet<String> treeSet = new TreeSet<String>();
        int n2 = MimTxDeviceGroup.MAX_NUMEULRESOURCES;
        for (int i = n = MimTxDeviceGroup.MIN_NUMEULRESOURCES.intValue(); i <= n2; ++i) {
            treeSet.add(Integer.toString(i));
        }
        String[] stringArray = treeSet.toArray(new String[0]);
        return new EnumeratedRange(stringArray);
    }

    private EnumeratedRange getNumHsCodeResourcesRange() {
        int n;
        TreeSet<String> treeSet = new TreeSet<String>();
        int n2 = MimTxDeviceGroup.MAX_NUMHSCODERESOURCES;
        for (int i = n = MimTxDeviceGroup.MIN_NUMHSCODERESOURCES.intValue(); i <= n2; ++i) {
            treeSet.add(Integer.toString(i));
        }
        String[] stringArray = treeSet.toArray(new String[0]);
        return new EnumeratedRange(stringArray);
    }

    protected void updateEulLoadedValues() throws BemException {
        for (int i = 0; i < this.slotsForExistingTxDevices.length; ++i) {
            int n = this.hspaSettingsRI[i].getNumEulResources();
            this.numEulResourcesParameter[i].setLoadedValue(new Integer(n));
        }
        this.updateOnlyOneTxBoardWithEulRestriction();
        this.updateNoEulWithoutHSmodulRestriction();
    }

    protected void updateHsdpaLoadedValues() throws BemException {
        for (int i = 0; i < this.slotsForExistingTxDevices.length; ++i) {
            int n = this.hspaSettingsRI[i].getNumHsCodeResources();
            this.numHsCodeResourcesParameter[i].setLoadedValue(new Integer(n));
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        this.checkConsistency();
        ArrayList arrayList = new ArrayList();
        if (!this.isOpen) {
            throw new BemException("RadioEquipmentCI is not open.");
        }
        arrayList.addAll(this.getNeededHspaRIs());
        arrayList.addAll(this.getNeededRaxTxRIs());
        return arrayList;
    }

    protected ArrayList getNeededHspaRIs() throws BemException {
        ArrayList<HspaSettingsRI> arrayList = new ArrayList<HspaSettingsRI>();
        for (int i = 0; i < this.hspaSettingsRI.length; ++i) {
            arrayList.add(this.hspaSettingsRI[i]);
        }
        return arrayList;
    }

    protected ArrayList getNeededRaxTxRIs() throws BemException {
        AbstractDeviceBoardRI abstractDeviceBoardRI;
        int n;
        ArrayList<AbstractDeviceBoardRI> arrayList = new ArrayList<AbstractDeviceBoardRI>();
        for (n = 0; this.txRI.length > n; ++n) {
            abstractDeviceBoardRI = this.txRI[n];
            if (((TxRI)abstractDeviceBoardRI).isDeleted()) continue;
            arrayList.add(abstractDeviceBoardRI);
        }
        for (n = 0; this.raxRI.length > n; ++n) {
            abstractDeviceBoardRI = this.raxRI[n];
            if (((RaxRI)abstractDeviceBoardRI).isDeleted()) continue;
            arrayList.add(abstractDeviceBoardRI);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        return this.getRaxRIsToUninstall();
    }

    protected List getRaxRIsToUninstall() throws BemException {
        Comparable comparable;
        int n;
        ArrayList<RaxRI> arrayList = new ArrayList<RaxRI>();
        Vector<String> vector = new Vector<String>();
        if (!this.isOpen) {
            throw new BemException("getRIsToUninstall : CI not open");
        }
        this.deletedRaxRis = new ArrayList();
        for (n = 0; n < this.raxSlotParameters.size(); ++n) {
            comparable = (Enumeration)this.raxSlotParameters.get(n);
            vector.add(((CustomerParameterImpl)comparable).getValue());
        }
        for (n = 0; vector.size() > n; ++n) {
            try {
                RaxRI raxRI;
                comparable = Integer.valueOf(vector.elementAt(n).toString());
                if ((Integer)comparable == -1 || !(raxRI = this.raxRI[n]).isInstalled()) continue;
                arrayList.add(raxRI);
                this.deletedRaxRis.add(raxRI);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    protected abstract AtfProvider getAtfProvider();

    public String getPrimaryAtfLdn(String string) throws BemException {
        AtfProvider atfProvider = this.getAtfProvider();
        return atfProvider.getPrimaryAtfLdn(string);
    }

    public String getPrimaryAtfLdn(String string, int n) throws BemException {
        AtfProvider atfProvider = this.getAtfProvider();
        return atfProvider.getPrimaryAtfLdn(string, n);
    }

    public String getSecondaryAtfLdn(String string) throws BemException {
        AtfProvider atfProvider = this.getAtfProvider();
        return atfProvider.getSecondaryAtfLdn(string);
    }

    public String getSecondaryAtfLdn(String string, int n) throws BemException {
        AtfProvider atfProvider = this.getAtfProvider();
        return atfProvider.getSecondaryAtfLdn(string, n);
    }

    public boolean isAtfRoleSupported(String string) {
        AtfProvider atfProvider = this.getAtfProvider();
        if (atfProvider == null) {
            return false;
        }
        return atfProvider.isAtfRoleSupported(string);
    }

    public boolean isAtfRoleSupported(String string, int n) {
        AtfProvider atfProvider = this.getAtfProvider();
        if (atfProvider == null) {
            return false;
        }
        return atfProvider.isAtfRoleSupported(string, n);
    }

    public String getAtfReport() {
        AtfProvider atfProvider = this.getAtfProvider();
        return atfProvider.getAtfReport();
    }

    public boolean isExternalOutputPowerUsed() {
        return false;
    }

    public void addListener(RadioEquipmentListener radioEquipmentListener) {
        this.radioEquipmentListeners.add(radioEquipmentListener);
    }

    public void addListener(HsdpaResourcesListener hsdpaResourcesListener) {
        this.hsdpaResourcesListeners.add(hsdpaResourcesListener);
    }

    protected void notifyRadioEquipmentListeners(int n) throws BemException {
        for (RadioEquipmentListener radioEquipmentListener : this.radioEquipmentListeners) {
            try {
                radioEquipmentListener.update(n);
            }
            catch (Exception exception) {
                throw new BemException("notifyRadioEquipmentListeners(): " + radioEquipmentListener.getClass().getName(), "", (Throwable)exception);
            }
        }
    }

    public int getSumOfHsCodeResources(int n) throws BemException {
        int n2 = 0;
        for (int i = 0; i < this.numHsCodeResourcesParameter.length; ++i) {
            if (this.numHsCodeResourcesParameter[i].getSlot() != n) continue;
            String string = this.numHsCodeResourcesParameter[i].getValue();
            n2 = Integer.parseInt(string);
            break;
        }
        return n2;
    }

    public int getMaxNumberOfSupportedCarrierTxBranches(int n) {
        return 1;
    }

    private void addHspaParameterListeners() {
        int n;
        for (n = 0; n < this.numHsCodeResourcesParameter.length; ++n) {
            this.numHsCodeResourcesParameter[n].addCustomerParameterListener(new NumOfHsCodeResourcesListener());
        }
        for (n = 0; n < this.numEulResourcesParameter.length; ++n) {
            this.numEulResourcesParameter[n].addCustomerParameterListener(new NumEulCodeResourcesListener());
        }
    }

    protected void notifyHsdpaEquipmentListeners(CustomerParameter customerParameter) throws BemException {
        for (HsdpaResourcesListener hsdpaResourcesListener : this.hsdpaResourcesListeners) {
            try {
                hsdpaResourcesListener.update();
            }
            catch (Exception exception) {
                throw new BemException("notifyHsdpaEquipmentListeners(): " + hsdpaResourcesListener.getClass().getName(), "", (Throwable)exception);
            }
        }
    }

    public String[] getSlotArrayForTxDevices(int n) {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Object[] objectArray2 = this.slotsForExistingTxDevices;
        Arrays.sort(objectArray2);
        int n2 = this.bbpData.getFirstSlotForSecondBBPool();
        if (n2 == -1) {
            objectArray = n == 0 ? objectArray2 : new String[]{};
        } else {
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray2[i];
                int n3 = Integer.parseInt((String)object);
                if (n3 < n2) {
                    arrayList.add(object);
                    continue;
                }
                arrayList2.add(object);
            }
            objectArray = n < 1 ? arrayList.toArray(new String[0]) : arrayList2.toArray(new String[0]);
        }
        return objectArray;
    }

    public void setBaseBandPoolData(BaseBandPoolData baseBandPoolData) {
        this.bbpData = baseBandPoolData;
    }

    public BaseBandPoolData getBaseBandPoolData() {
        return this.bbpData;
    }

    protected void initRaxCustomerParameters() throws BemException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-1");
        for (int i = 0; i < this.raxRI.length; ++i) {
            arrayList.add(String.valueOf(this.raxRI[i].getSlotNo()));
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; this.raxRI.length > n; ++n) {
            RaxRI raxRI = this.raxRI[n];
            Integer n2 = new Integer(raxRI.getSlotNo());
            String string = "DeleteRaxBoard_Slot" + this.getPrefix(n2) + "raxSlot";
            Enumeration enumeration = new Enumeration(string, new EnumeratedRange(arrayList));
            vector.add(string);
            enumeration.setDefaultValue("-1");
            enumeration.setLoadedValue("-1");
            super.addParameter(enumeration);
            ParameterRestriction parameterRestriction = new ParameterRestriction("Value not valid for Rax slot", 2);
            enumeration.addRestriction(parameterRestriction);
            if (!raxRI.exists()) {
                String[] stringArray = new String[]{n2.toString()};
                enumeration.addRestriction(new ParameterRestriction("The board is not installed", new EnumeratedRange(stringArray), false));
            }
            this.raxSlotParameters.add(enumeration);
        }
        if (vector.size() > 0) {
            this.parameterNames = new String[vector.size()];
        }
        for (n = 0; vector.size() > n; ++n) {
            this.parameterNames[n] = (String)vector.get(n);
        }
    }

    private String getPrefix(int n) {
        String string = MessageFormat.format(PREFIX_ENDING, new Integer(n));
        return string;
    }

    public int[] getEquippedSectors(int n) {
        int[] nArray = this.getEquippedSectors();
        int n2 = this.getNumberOfDuwSlots();
        if (n2 > 1) {
            int n3 = this.rbsWithRuifAndObif() ? 7 : this.bbpData.getFirstSectorNoForSecondBBPool();
            List[] listArray = new List[]{new ArrayList(), new ArrayList()};
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                if (this.isDualRadioInterfaceBoardNeeded(n4)) {
                    listArray[0].add(new Integer(n4));
                    listArray[1].add(new Integer(n4));
                    continue;
                }
                if (n4 < n3) {
                    listArray[0].add(new Integer(n4));
                    continue;
                }
                listArray[1].add(new Integer(n4));
            }
            Integer[] integerArray = listArray[n].toArray(new Integer[0]);
            nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        }
        return nArray;
    }

    protected void setBoardPositions(String string, String[] stringArray) {
        this.boardPositions.put(string, stringArray);
    }

    protected String[] getBoardPositions(String string) {
        Object v = this.boardPositions.get(string);
        if (v == null) {
            throw new Error("Error boardPosition must be set in RadioEquipment");
        }
        String[] stringArray = (String[])v;
        return stringArray;
    }

    public List getRaxAndTxRIsForBBpool(int n) throws BemException {
        int n2;
        AbstractDeviceBoardRI abstractDeviceBoardRI;
        int n3;
        ArrayList<AbstractDeviceBoardRI> arrayList = new ArrayList<AbstractDeviceBoardRI>();
        int n4 = this.bbpData.getFirstSlotForSecondBBPool();
        for (n3 = 0; n3 < this.txRI.length; ++n3) {
            abstractDeviceBoardRI = this.txRI[n3];
            n2 = abstractDeviceBoardRI.getSlotNo();
            if (n == 0) {
                if (n2 >= n4) continue;
                arrayList.add(abstractDeviceBoardRI);
                continue;
            }
            if (n2 < n4) continue;
            arrayList.add(abstractDeviceBoardRI);
        }
        for (n3 = 0; n3 < this.raxRI.length; ++n3) {
            abstractDeviceBoardRI = this.raxRI[n3];
            n2 = abstractDeviceBoardRI.getSlotNo();
            if (n == 0) {
                if (n2 >= n4) continue;
                arrayList.add(abstractDeviceBoardRI);
                continue;
            }
            if (n2 < n4) continue;
            arrayList.add(abstractDeviceBoardRI);
        }
        return arrayList;
    }

    protected void setRemoveSwallocation(List list) {
        for (BaseBandPoolBoard baseBandPoolBoard : list) {
            baseBandPoolBoard.setRemoveFromSwAllocation(true);
        }
    }

    public boolean mainRemoteRbs() {
        return false;
    }

    public List getRruwMois() {
        return new ArrayList();
    }

    public MoInstance[] getRruwMois(int n) {
        MoInstance[] moInstanceArray = new MoInstance[]{};
        return moInstanceArray;
    }

    protected void handleAddCarriersForMainRemote(ServiceValue serviceValue, int n, int n2) {
        String string = this.getRbs().getRbsStep();
        if (string.equals("STEP_EXPANSION")) {
            for (int i = 0; i < n; ++i) {
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    String string2;
                    String string3 = "S" + String.valueOf(i + 1) + "_";
                    String string4 = "C" + String.valueOf(j + 1) + "_";
                    String string5 = string3 + string4 + "cellCreated";
                    ServiceNameValue serviceNameValue = serviceValue.getAttribute(string5);
                    if (serviceNameValue == null || !"YES".equals(string2 = (String)serviceNameValue.getValue())) continue;
                    bl = true;
                    break;
                }
                this.setSectorUninstall(i, bl);
            }
        }
    }

    protected boolean useCreateSectorParameter() {
        return false;
    }

    public boolean eulSupportInTwoBaseBandPools() {
        return false;
    }

    public boolean rbsWithRuifAndObif() {
        return false;
    }

    public boolean isSectorRemote(int n) {
        return false;
    }

    public String getCarrierAllocationMode() {
        return "Basic";
    }

    public String getRbConnectorLdn(int n, int n2) {
        return "";
    }

    public int getNumberOfExistingSectors() {
        return 0;
    }

    public Integer[] getTerminationConnectors(int n, String string) throws BemException {
        Integer n2 = this.getTerminationConnector(n, string);
        return new Integer[]{n2};
    }

    public Integer[] getLoadedTerminationConnectors(int n, String string) throws BemException {
        return this.getTerminationConnectors(n, string);
    }

    public String getLoadedTerminationObject(int n, String string) throws BemException {
        return this.getTerminationObject(n, string);
    }

    public Integer getLoadedTerminationConnector(int n, String string) throws BemException {
        return this.getTerminationConnector(n, string);
    }

    public CustomerParameterListener getCarrierAllocationModeListener() {
        throw new RuntimeException("This function is only supported for DUW based RBS6000.");
    }

    public boolean isTxbStaticallyLoaded(int n) throws BemException {
        return false;
    }

    public int[] getSupportedConfiguration(int n) {
        return new int[0];
    }

    public int[] getEquippedSectorsWithoutBackup() {
        int[] nArray = new int[]{};
        return nArray;
    }

    public boolean isBackedUp(int n) {
        return false;
    }

    public boolean supportsCbuTxDiversity(int n) {
        return false;
    }

    public String getAuUnitType(int n) {
        return "";
    }

    public String getLoadedAuUnitType(int n) {
        return "";
    }

    public AbstractRuRI[] getSectorRadioUnits(int n) throws BemException {
        throw new BemException("getSectorRadioUnits(int sectorNumber) inherited from RadioEquipmentProvider not implemented in class AbstractRadioEquipmentCI");
    }

    public boolean isSectorEquipped(int n) {
        boolean bl = false;
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private class NumEulCodeResourcesListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                AbstractRadioEquipmentCI.this.updateOnlyOneTxBoardWithEulRestriction();
            }
        }
    }

    private class NumOfHsCodeResourcesListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                AbstractRadioEquipmentCI.this.updateNoEulWithoutHSmodulRestriction();
                try {
                    AbstractRadioEquipmentCI.this.notifyHsdpaEquipmentListeners(customerParameter);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }
}

