/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Precondition;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public abstract class AbstractReconfiguration
implements Reconfiguration {
    private List preconditions = new ArrayList();
    private String failReasons = "";
    private int sector;

    public AbstractReconfiguration(int n) {
        this.sector = n;
    }

    public boolean isPreconditionsMet() throws BemException {
        Precondition precondition2 = null;
        for (Precondition precondition2 : this.preconditions) {
            if (precondition2.isMet(this.sector)) continue;
            this.addReason(precondition2.getFailReason());
            return false;
        }
        this.clearReasons();
        return true;
    }

    public String getFailReasons() {
        return this.failReasons;
    }

    public void addPrecondition(Precondition precondition) {
        this.preconditions.add(precondition);
    }

    private void addReason(String string) {
        this.failReasons = string;
    }

    private void clearReasons() {
        this.failReasons = "";
    }

    protected int getSector() {
        return this.sector;
    }

    protected void requestUninitSector(Rbs rbs) throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = rbs.getCellAndCarrierProvider();
        cellAndCarrierProvider.requestUninitiateSector(this.getSector(), rbs.getConfigItem("RadioEquipmentCI"));
    }

    protected void requestInitSector(Rbs rbs) throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = rbs.getCellAndCarrierProvider();
        cellAndCarrierProvider.requestInitiateSector(this.getSector(), rbs.getConfigItem("RadioEquipmentCI"));
    }
}

