/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.OilRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RruwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.ObifRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RRB03
extends AbstractRadioBuildingBlock {
    public static final String name = "RRB03";
    private static final int NOT_USED = -1;
    private static final int NO_OF_CARRIERS = 2;
    private static final int NO_OF_RUS = 0;
    private static final int NO_OF_TX_BRANCHES = 2;
    MoHandler moHandler;
    private Rbs rbs;
    private List ris = new ArrayList();
    private Integer dlConnector;
    private Integer ulConnector;
    private RadioInterfaceBoard radioIfBoard;
    private OilRI oilDl = null;
    private OilRI oilUl = null;
    private OilRI oil2Dl = null;
    private OilRI oil2Ul = null;
    private RfCableRI rxARfCable = null;
    private RfCableRI rxBRfCable = null;
    private RruwRI rruw1 = null;
    private RruwRI rruw2 = null;
    Integer objectACon;
    Integer objectBCon;
    String objARefParam;
    String objBRefParam;
    private int rfElectricalUlDelay;
    private int rfUlAttenuation;
    List freeConnectors = new ArrayList();
    ReservedConnectorRI[] reservedConnectors;
    private ReservedConnectorRI a;
    private ReservedConnectorRI b;
    private ReservedConnectorRI c;
    private ReservedConnectorRI d;
    private ReservedConnectorRI e;
    private ReservedConnectorRI f;
    public String[] sectorRdn = new String[]{"1", "2", "3", "4", "5", "6"};
    private ObifRI obif;
    private String radioIfType;

    public RRB03(Rbs rbs, int n, RadioInterfaceBoard radioInterfaceBoard, RruwRI rruwRI, RruwRI rruwRI2, int n2, int n3, int n4, int n5) throws BemException {
        super(name, n, 2, 0, 2, new RadioInterfaceBoard[]{radioInterfaceBoard});
        this.rbs = rbs;
        this.moHandler = rbs.getMoHandler();
        this.radioIfBoard = radioInterfaceBoard;
        this.obif = (ObifRI)radioInterfaceBoard;
        this.radioIfType = radioInterfaceBoard.getType();
        this.rruw1 = rruwRI;
        this.rruw2 = rruwRI2;
        this.rfElectricalUlDelay = n2;
        this.rfUlAttenuation = n4;
        this.createTerminationConnector(n);
        this.createResourceItems(n);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        this.reservedConnectors = new ReservedConnectorRI[12];
        this.reservedConnectors[0] = reservedConnectorRI;
        this.reservedConnectors[1] = reservedConnectorRI2;
        this.reservedConnectors[2] = reservedConnectorRI3;
        this.reservedConnectors[3] = reservedConnectorRI4;
        this.reservedConnectors[4] = reservedConnectorRI5;
        this.reservedConnectors[5] = reservedConnectorRI6;
        this.reservedConnectors[6] = reservedConnectorRI;
        this.reservedConnectors[7] = reservedConnectorRI2;
        this.reservedConnectors[8] = reservedConnectorRI3;
        this.reservedConnectors[9] = reservedConnectorRI4;
        this.reservedConnectors[10] = reservedConnectorRI5;
        this.reservedConnectors[11] = reservedConnectorRI6;
    }

    public void setRadioIfConnectors(int n, ReservedConnectorRI[] reservedConnectorRIArray) {
        for (int i = 0; i < reservedConnectorRIArray.length; ++i) {
            if (reservedConnectorRIArray[i] == null) continue;
            this.reservedConnectors[n - 1] = reservedConnectorRIArray[i];
        }
    }

    public void createTerminationConnector(int n) throws BemException {
        Integer[] integerArray = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(5), new Integer(6), new Integer(7)};
        Integer[] integerArray2 = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(5), new Integer(6), new Integer(7)};
        if (n > 6) {
            n -= 6;
        }
        this.dlConnector = integerArray[n - 1];
        this.ulConnector = integerArray2[n - 1];
    }

    private void createResourceItems(int n) throws BemException {
        this.createReservedConnectors();
        this.ris.add(this.rruw1);
        this.ris.add(this.rruw2);
        String string = this.rruw1.getAuxPiuLdn();
        String string2 = this.rruw2.getAuxPiuLdn();
        String string3 = this.radioIfBoard.getPiuLdn();
        this.objectACon = this.ulConnector;
        this.objectBCon = new Integer(4);
        this.objARefParam = string3;
        this.objBRefParam = string;
        this.oilDl = new OilRI(this.rbs, n - 1, "Dl", this.objectACon, this.objectBCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oilDl);
        this.objectACon = new Integer(4);
        this.objectBCon = this.dlConnector;
        this.objARefParam = string;
        this.objBRefParam = string3;
        this.oilUl = new OilRI(this.rbs, n - 1, "Ul", this.objectACon, this.objectBCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oilUl);
        this.objectACon = new Integer(8);
        this.objectBCon = new Integer(4);
        this.objARefParam = string;
        this.objBRefParam = string2;
        this.oil2Dl = new OilRI(this.rbs, n - 1, "Dl", this.objectACon, this.objectBCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oil2Dl);
        this.objectACon = new Integer(4);
        this.objectBCon = new Integer(8);
        this.objARefParam = string2;
        this.objBRefParam = string;
        this.oil2Ul = new OilRI(this.rbs, n - 1, "Ul", this.objectACon, this.objectBCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oil2Ul);
        this.rxARfCable = new RfCableRI(this.rbs, this.rruw1.getLdn(), 12, this.rruw2.getLdn(), 22, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1, n, "A", 2);
        this.ris.add(this.rxARfCable);
        this.rxBRfCable = new RfCableRI(this.rbs, this.rruw2.getLdn(), 12, this.rruw1.getLdn(), 22, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1, n, "B", 2);
        this.ris.add(this.rxBRfCable);
    }

    public void updateOil(int n, String string, String string2, Integer n2, Integer n3) throws BemException {
        this.objectBCon = new Integer(4);
        this.objectACon = new Integer(4);
        this.oilDl.updateMoiResources(n, string, this.rruw1.getAuxPiuLdn(), n2, this.objectBCon, "Dl");
        this.oilUl.updateMoiResources(n, this.rruw1.getAuxPiuLdn(), string2, this.objectACon, n3, "Ul");
    }

    public void updatePrimaryConnector(int n, Integer n2) throws BemException {
        this.objectBCon = new Integer(4);
        this.objectACon = new Integer(4);
        this.oilDl.updateMoiResources(n, this.radioIfBoard.getPiuLdn(), this.rruw1.getAuxPiuLdn(), n2, this.objectBCon, "Dl");
        this.oilUl.updateMoiResources(n, this.rruw1.getAuxPiuLdn(), this.radioIfBoard.getPiuLdn(), this.objectACon, n2, "Ul");
    }

    public List getResourceItems() throws BemException {
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.rruw1);
        arrayList.add(this.rruw2);
        arrayList.add(this.oilDl);
        arrayList.add(this.oilUl);
        arrayList.add(this.oil2Dl);
        arrayList.add(this.oil2Ul);
        arrayList.add(this.rxARfCable);
        arrayList.add(this.rxBRfCable);
        return arrayList;
    }

    public int getReservedConnector() {
        return this.reservedConnectors[this.getSectorNo() - 1].getConnector();
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (!string.equalsIgnoreCase("A") && !string.equalsIgnoreCase("B")) {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        n = new Integer(1);
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        if (string.equalsIgnoreCase("A")) {
            return this.rruw1.getAuxPiuLdn();
        }
        if (string.equalsIgnoreCase("B")) {
            return this.rruw2.getAuxPiuLdn();
        }
        if (string.equalsIgnoreCase("UL") || string.equalsIgnoreCase("DL")) {
            return this.obif.getPiuLdn();
        }
        throw new BemException(this.getClass().getName() + " getTerminationObject(): Type " + string + " not supported");
    }

    public String getRadioInterfaceType() throws BemException {
        return this.radioIfType;
    }

    public String getPrevious() throws BemException {
        String string = "";
        String string2 = this.oilDl.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(string2);
            BemMo bemMo2 = (BemMo)moHandler.getAttribute(bemMo, "connectedToObjectARef");
            string = bemMo2.getDN();
        }
        catch (Exception exception) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
        }
        return string;
    }

    public Integer getPrimaryPortId() throws BemException {
        Integer n;
        String string = this.oilDl.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(string);
            n = (Integer)moHandler.getAttribute(bemMo, "objectAConnector");
        }
        catch (Exception exception) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
        }
        return n;
    }

    public String getObjARefForCascade() {
        return this.rruw2.getAuxPiuLdn();
    }

    public String getObjBRefForCascade() {
        return this.rruw2.getAuxPiuLdn();
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxARfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxBRfCable.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    private void createReservedConnectors() {
        String string = MimOpticalInterfaceLink.MOTYPENAME;
        String string2 = "objectAConnector";
        this.a = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 1, string, string2);
        this.b = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 2, string, string2);
        this.c = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 3, string, string2);
        this.d = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 5, string, string2);
        this.e = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 6, string, string2);
        this.f = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 7, string, string2);
        this.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    public int getNoOfRruAndRruwPerPort() {
        return 2;
    }

    public int getNoOfRrusAndRruws() {
        return 2;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        if (bl) {
            BemMo bemMo = this.moHandler.getMo(this.oil2Dl.getLdn());
            BemMo bemMo2 = (BemMo)bemMo.getAttribute("connectedToObjectARef");
            if (!bemMo2.getDN().equals(this.rruw1.getAuxPiuLdn())) {
                return false;
            }
            bemMo2 = (BemMo)bemMo.getAttribute("connectedToObjectBRef");
            if (!bemMo2.getDN().equals(this.rruw2.getAuxPiuLdn())) {
                return false;
            }
            bemMo = this.moHandler.getMo(this.oil2Ul.getLdn());
            bemMo2 = (BemMo)bemMo.getAttribute("connectedToObjectARef");
            if (!bemMo2.getDN().equals(this.rruw2.getAuxPiuLdn())) {
                return false;
            }
            bemMo2 = (BemMo)bemMo.getAttribute("connectedToObjectBRef");
            if (!bemMo2.getDN().equals(this.rruw1.getAuxPiuLdn())) {
                return false;
            }
        }
        return bl;
    }

    public MoInstance[] getRruwMois() {
        MoInstance[] moInstanceArray = new MoInstance[]{this.rruw1.boardMoi, this.rruw2.boardMoi};
        return moInstanceArray;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1, 2};
    }
}

