/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.api;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.NetworkSyncCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.Report;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class InformativeTextUtil {
    private final Rbs rbs;
    private final AtmAndPtCI atmAndPhysicalCI;
    private static final int DEFAULT = 0;
    private static final int REDUNDANT = 1;
    private static final String[] ipAtmHeading = new String[]{"IP over ATM (DEFAULT O&M Link)", "IP over ATM (REDUNDANT O&M Link)"};
    private static final String[] PSEUDO_PREFIX = new String[]{"firstOAMatm_", "secondOAMatm_"};
    private static final String[] PSEUDO_SLOT = new String[]{PSEUDO_PREFIX[0] + "etbSlot", PSEUDO_PREFIX[1] + "etbSlot"};
    private static final String[] PSEUDO_TERMINATION_TYPE = new String[]{PSEUDO_PREFIX[0] + "terminationType", PSEUDO_PREFIX[1] + "terminationType"};
    private static final String[] PSEUDO_LINE = new String[]{PSEUDO_PREFIX[0] + "physicalLine", PSEUDO_PREFIX[1] + "physicalLine"};
    private static final String[] PSEUDO_SLOTS_IN_FRACTION = new String[]{PSEUDO_PREFIX[0] + "timeSlotsInFraction", PSEUDO_PREFIX[1] + "timeSlotsInFraction"};
    private static final String[] PSEUDO_VPI = new String[]{PSEUDO_PREFIX[0] + "externalVpi", PSEUDO_PREFIX[1] + "externalVpi"};
    private static final String[] PSEUDO_VP_PCR = new String[]{PSEUDO_PREFIX[0] + "vpPeakCellRate", PSEUDO_PREFIX[1] + "vpPeakCellRate"};
    private static final String[] PSEUDO_VP_MCR = new String[]{PSEUDO_PREFIX[0] + "vpMinimumCellRate", PSEUDO_PREFIX[1] + "vpMinimumCellRate"};
    private static final String[] PSEUDO_VP_SC = new String[]{PSEUDO_PREFIX[0] + "vpServiceCategory", PSEUDO_PREFIX[1] + "vpServiceCategory"};
    private static final String[] PSEUDO_VCI = new String[]{PSEUDO_PREFIX[0] + "externalVci", PSEUDO_PREFIX[1] + "externalVci"};
    private static final String[] PSEUDO_VC_SC = new String[]{PSEUDO_PREFIX[0] + "vcServiceCategory", PSEUDO_PREFIX[1] + "vcServiceCategory"};
    private static final String[] PSEUDO_ADDRESS = new String[]{PSEUDO_PREFIX[0] + "atmIpAddress", PSEUDO_PREFIX[1] + "atmIpAddress"};
    private static final String[] PSEUDO_SUBNETMASK = new String[]{PSEUDO_PREFIX[0] + "atmSubnetMask", PSEUDO_PREFIX[1] + "atmSubnetMask"};
    private static final String[] PSEUDO_REQUIRED_NUMBER_OF_LINKS = new String[]{PSEUDO_PREFIX[0] + "requiredNumberOfLinks", PSEUDO_PREFIX[1] + "requiredNumberOfLinks"};

    public InformativeTextUtil(Rbs rbs) {
        this.rbs = rbs;
        this.atmAndPhysicalCI = new AtmAndPtCI(this.rbs);
    }

    public void getNetworkSyncInformativeText(Report report) throws BemException {
        Report.Table table = report.addTable("Network Synchronization");
        String[] stringArray = new String[]{"Priority", "Slot", "Board", "Port"};
        table.addColumnTitles(stringArray);
        for (int i = 0; i < NetworkSyncCI.getNumberOfSyncs(); ++i) {
            Integer n = new Integer(i + 1);
            String string = MessageFormat.format("Y_{0}_", n);
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String[] stringArray2 = string + "synchPriority";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject((String)stringArray2);
            string2 = customerParameter.getValue();
            stringArray2 = string + "synchSlot";
            customerParameter = this.rbs.getCustomerParameterObject((String)stringArray2);
            string3 = customerParameter.getValue();
            stringArray2 = string + "synchGuiBoard";
            customerParameter = this.rbs.getCustomerParameterObject((String)stringArray2);
            string4 = customerParameter.getValue();
            stringArray2 = string + "synchPort";
            customerParameter = this.rbs.getCustomerParameterObject((String)stringArray2);
            string5 = customerParameter.getValue();
            stringArray2 = new String[]{string2, string3, string4, string5};
            table.addRow(stringArray2);
        }
    }

    public void getTimeSettingInformativeText(Report report) throws BemException {
        Report.Table table = report.addTable("Time setting");
        String[][] stringArray = new String[][]{{"Local time zone:", "localTimeZone"}, {"Daylight saving time:", "daylightSavingTime"}, {"NTP primary server:", "primaryNtpServerIpAddress"}, {"NTP primary service active:", "primaryNtpServiceActive"}, {"NTP secondary server:", "secondaryNtpServerIpAddress"}, {"NTP secondary service active:", "secondaryNtpServiceActive"}};
        this.getValuesArray(table, stringArray);
    }

    public void getServerInformativeText(Report report) throws BemException {
        Report.Table table = report.addTable("Server Configuration");
        String[][] stringArray = new String[][]{{"Primary DHCP server:", "dhcpServerPrimaryIpAddress"}, {"Secondary DHCP server:", "dhcpServerSecondaryIpAddress"}, {"DNS server:", "dnsServerIpAddress"}, {"Use default domain name:", "isDefaultDomainName"}, {"Default domain name:", "defaultDomainName"}, {"Logon server (SLS):", "singleLogonServer"}, {"Document server (ALEX):", "documentServerWebAddress"}, {"OSS CORBA name server address:", "ossCorbaNameServer"}, {"OSS CORBA name server port:", "ossCorbaNameServerPort"}};
        this.getValuesArray(table, stringArray);
    }

    private void getValuesArray(Report.Table table, String[][] stringArray) throws BemException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][1];
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            table.addRow(stringArray[i][0], customerParameter.getValue());
        }
    }

    public void getIpRoutingInformativeText(Report report) throws BemException {
        Report.Table table = report.addTable("Routing Table");
        String[] stringArray = new String[]{"Dest IP address", "Dest subnet mask", "Next hop Ip address", "Route metric", "Redistribute"};
        table.addColumnTitles(stringArray);
        int n = 0;
        while (true) {
            Integer n2 = new Integer(++n);
            String string = MessageFormat.format("R_{0}_", n2);
            String string2 = string + "routeIpAddress";
            if (!this.rbs.isParameterSupported(string2)) break;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
            if (customerParameter.getAccessLevel() == 1) continue;
            String string3 = this.rbs.getCustomerParameter(string2);
            String string4 = this.rbs.getCustomerParameter(string + "routeSubnetMask");
            String string5 = this.rbs.getCustomerParameter(string + "hopIpAddress");
            String string6 = this.rbs.getCustomerParameter(string + "routeMetric");
            String string7 = this.rbs.getCustomerParameter(string + "redistribute");
            String[] stringArray2 = new String[]{string3, string4, string5, string6, string7};
            table.addRow(stringArray2);
        }
    }

    public void getIpOverEthernetInformativeText(Report report) throws BemException {
        Report.Table table = report.addTable("IP over Ethernet (site LAN)");
        if (this.rbs.isParameterSupported("ipAddress")) {
            String string = this.rbs.getCustomerParameter("ipAddress");
            String string2 = this.rbs.getCustomerParameter("subnetMask");
            table.addRow("IP address:", string);
            table.addRow("Subnet mask:", string2);
        }
    }

    public void getEthernetSwitchInformativeText(Report report) throws BemException {
        String string;
        if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption") && (string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption")).equals("ipV4")) {
            Report.Table table = null;
            table = report.addTable("Ethernet Switch");
            String[] stringArray = this.rbs.getCustomerParameter("EthernetSwitchvlan");
            table.addRow("Enable vlan:", (String)stringArray);
            table = report.addTable("Ethernet Switch Ports");
            stringArray = new String[]{"Port", "Adm State", "System Port", "Untagged VID"};
            table.addColumnTitles(stringArray);
            for (int i = 0; i < 7; ++i) {
                String string2 = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_administrativeState", new Integer(i + 1)));
                String string3 = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_systemPort", new Integer(i + 1)));
                String string4 = this.rbs.getCustomerParameter(MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressVid", new Integer(i + 1)));
                String[] stringArray2 = new String[]{String.valueOf(i), string2, string3, string4};
                table.addRow(stringArray2);
            }
        }
    }

    public void getIpOverGigabitEthernetInformativeText(Report report) throws BemException {
        String string;
        if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption") && (string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption")).equals("ipV4")) {
            String string2 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
            String string3 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncSubnetMask");
            String string4 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_defaultRouter0");
            String string5 = this.rbs.getCustomerParameter("IPoverGigabitEthernet_syncVid");
            Report.Table table = report.addTable("IP over Gigabit Ethernet");
            table.addRow("IP address:", string2);
            table.addRow("Network prefix length:", string3);
            table.addRow("Default router 0:", string4);
            table.addRow("Vid:", string5);
        }
    }

    public void getIpHostLinkInformativeText(Report report) throws BemException {
        String string;
        if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption") && (string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption")).equals("ipV4")) {
            String string2 = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
            String string3 = this.rbs.getCustomerParameter("OamIpHost_oamSubnetMask");
            String string4 = this.rbs.getCustomerParameter("OamIpHost_oamDefaultRouter0");
            String string5 = this.rbs.getCustomerParameter("OamIpHost_oamVid");
            Report.Table table = report.addTable("IP Host Link");
            table.addRow("IP address:", string2);
            table.addRow("Network prefix length:", string3);
            table.addRow("Default router 0:", string4);
            table.addRow("Vid:", string5);
        }
    }

    public void getAtmPortInformativeText(Report report) throws BemException {
        Report.Table table = Report.newTable("ATM ports");
        String[] stringArray = new String[]{"Etb slot", "Termination type", "Etb lines", "Slots in fraction"};
        table.addColumnTitles(stringArray);
        int n = 0;
        while (true) {
            String string = "";
            Integer n2 = new Integer(++n);
            String string2 = MessageFormat.format("ATM{0}_", n2);
            String string3 = string2 + "etbSlot";
            if (!this.rbs.isParameterSupported(string3)) break;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
            if (customerParameter.getAccessLevel() == 1) continue;
            String string4 = this.rbs.getCustomerParameter(string3);
            String string5 = this.rbs.getCustomerParameter(string2 + "physicalLine");
            String string6 = this.rbs.getCustomerParameter(string2 + "terminationType");
            String string7 = this.rbs.getCustomerParameter(string2 + "timeSlotsInFraction");
            AtmPortProvider atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
            boolean bl = atmPortProvider.isFractional(string4, string6);
            if (bl) {
                string = string7;
            }
            String[] stringArray2 = new String[]{string4, string6, string5, string};
            table.addRow(stringArray2);
        }
        if (table.hasData()) {
            report.addTable(table);
        }
    }

    public void getLinkInformativeText(Report report) throws BemException {
        String string;
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        AtmPortProvider atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        for (int i = 0; i < PSEUDO_SLOT.length && this.rbs.isParameterSupported(string = PSEUDO_SLOT[n]); ++i) {
            Object object;
            boolean bl;
            string2 = this.rbs.getCustomerParameter(PSEUDO_SLOT[n]);
            if (string2.equals("None")) break;
            String string5 = this.rbs.getCustomerParameter(PSEUDO_TERMINATION_TYPE[n]);
            String string6 = this.rbs.getCustomerParameter(PSEUDO_LINE[n]);
            String string7 = this.rbs.getCustomerParameter(PSEUDO_SLOTS_IN_FRACTION[n]);
            String string8 = this.rbs.getCustomerParameter(PSEUDO_VCI[n]);
            String string9 = this.rbs.getCustomerParameter(PSEUDO_VC_SC[n]);
            String string10 = this.rbs.getCustomerParameter(PSEUDO_VP_PCR[n]);
            String string11 = this.rbs.getCustomerParameter(PSEUDO_VP_MCR[n]);
            String string12 = this.rbs.getCustomerParameter(PSEUDO_VPI[n]);
            String string13 = this.rbs.getCustomerParameter(PSEUDO_VP_SC[n]);
            String string14 = this.rbs.getCustomerParameter(PSEUDO_ADDRESS[n]);
            String string15 = this.rbs.getCustomerParameter(PSEUDO_SUBNETMASK[n]);
            String string16 = "No";
            PhysicalLineParameter physicalLineParameter = (PhysicalLineParameter)this.rbs.getCustomerParameterObject(PSEUDO_LINE[n]);
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(PSEUDO_REQUIRED_NUMBER_OF_LINKS[n]);
            TimeSlotsInFractionParameter timeSlotsInFractionParameter = (TimeSlotsInFractionParameter)this.rbs.getCustomerParameterObject(PSEUDO_SLOTS_IN_FRACTION[n]);
            boolean bl2 = atmPortProvider.isFractional(string2, string5);
            String string17 = "N.A.";
            if (bl2) {
                string16 = "Yes";
                String[] stringArray = timeSlotsInFractionParameter.getAllTimeSlots();
                string17 = BemUtil.getCommaSeparatedValueString(stringArray);
                string17 = string7;
            }
            if (bl = atmPortProvider.isIma(string2, string5)) {
                object = physicalLineParameter.getAllLines();
                string3 = BemUtil.getCommaSeparatedValueString((String[])object);
                string4 = customerParameter.getValue();
            } else {
                string6 = physicalLineParameter.getValue();
            }
            object = report.addTable(ipAtmHeading[n]);
            ((Report.Table)object).addRow("ETB slot:", string2);
            ((Report.Table)object).addRow("Termination type:", string5);
            if (bl) {
                ((Report.Table)object).addRow("ETB physical lines (IMA):", string3);
                ((Report.Table)object).addRow("Required number of links:", string4);
            } else {
                ((Report.Table)object).addRow("ETB physical line:", string6);
            }
            ((Report.Table)object).addRow("Use fractional mode:", string16);
            ((Report.Table)object).addRow("Time slots in fraction:", string17);
            ((Report.Table)object).addRow("VPI:", string12);
            ((Report.Table)object).addRow("VP PCR:", string10);
            ((Report.Table)object).addRow("VP MCR:", string11);
            ((Report.Table)object).addRow("VP Service Category:", string13);
            ((Report.Table)object).addRow("VCI:", string8);
            ((Report.Table)object).addRow("VC Service Category:", string9);
            ((Report.Table)object).addRow("IP address:", string14);
            ((Report.Table)object).addRow("Subnet mask:", string15);
            ++n;
        }
    }
}

