/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3986.configitem;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RruRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RRB01;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RRB02;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RRB06;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.UninitSectorReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.ObifRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;

public class RadioEquipment3986CI
extends GenericRadioEquipmentCI {
    private static final int OBIF_SLOT_NO = 9;
    private static final int MAX_NO_OF_SECTORS = 6;
    private static final int MAX_NO_OF_RUS = 1;
    private static final int MAX_NO_OF_CARRIERS = 2;
    private static boolean cableSet = true;
    private RruRI rru1 = null;
    private RruRI rru2 = null;
    private EnumeratedRange radioIfTypeRange;

    public RadioEquipment3986CI(Rbs rbs) {
        super(rbs, 6, 1, 2, cableSet);
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"7", "8"});
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"2", "3", "4", "5", "6"});
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createRadioBuildingBlocks() throws BemException {
        int n = this.rbs.getMaxNumberOfSectors();
        this.radioBuildingBlocks = new RadioBuildingBlock[n];
        for (int i = 1; i <= n; ++i) {
            this.rru1 = new RruRI(this.rbs, "-1", AtfProvider.ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[i], i);
            this.rru2 = new RruRI(this.rbs, "-2", AtfProvider.ALL_CONTROLLERS_OF_RRU_INDEXED_BY_SECTOR[i], i);
            SectorCapability sectorCapability = new SectorCapability();
            RRB01 rRB01 = new RRB01(this.getRbs(), i, this.obif, this.rru1);
            RRB02 rRB02 = new RRB02(this.rbs, i, this.obif, this.rru1);
            Reconfiguration[] reconfigurationArray = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rRB01, rRB02, i)};
            Reconfiguration[] reconfigurationArray2 = new Reconfiguration[]{};
            if (i <= 3) {
                RRB06 rRB06 = new RRB06(this.rbs, i, this.obif, this.rru1, this.rru2);
                reconfigurationArray = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rRB01, rRB02, i), new UninitSectorReconfiguration(this.getRbs(), rRB01, rRB06, i)};
                reconfigurationArray2 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rRB02, rRB06, i)};
                sectorCapability.addConfiguration(rRB01, reconfigurationArray);
                sectorCapability.addConfiguration(rRB02, reconfigurationArray2);
                sectorCapability.addConfiguration(rRB06);
            } else {
                sectorCapability.addConfiguration(rRB01, reconfigurationArray);
                sectorCapability.addConfiguration(rRB02, reconfigurationArray2);
            }
            this.addSectorCapability(i, sectorCapability);
        }
    }

    protected void createSubracks() throws BemException {
        this.ruSubrack = null;
        this.fuSubrack = null;
        this.listOfRus = new ArrayList();
        this.listOfFus = new ArrayList();
    }

    protected void createRadioInterfaceBoard() {
        HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(this.rbs.getEquipmentMoi());
        this.obif = new ObifRI(this.rbs, 9, hubSubrackMoi);
    }

    protected List checkSectorConfigurationLeftRight() throws BemException {
        return new ArrayList();
    }

    public boolean useCreateSectorParameter() {
        return true;
    }

    protected RbsCableSets getRbsCableSets() {
        return null;
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OBIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    public EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

