/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;

public class CustomerParameterTableModel
extends AbstractTableModel
implements CustomerParameterListener {
    private Vector tableDataVector = new Vector();
    private Vector rowVector = new Vector();
    private Vector tableDataEditable = new Vector();
    private Vector tableDataEditableRow = new Vector();
    private Vector tableDataEditableColumn = new Vector();
    private String[] columnNames = null;
    private CustomerParameter customerParameter = null;
    private boolean areAllCellsNotEditable = false;

    public CustomerParameterTableModel(Object[][] objectArray, String[] stringArray) {
        this.tableDataVector = new Vector();
        this.columnNames = (String[])stringArray.clone();
        if (objectArray == null || objectArray.length == 0 || objectArray[0].length == 0) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.rowVector = new Vector();
            for (int j = 0; j < objectArray[0].length; ++j) {
                if (objectArray[i][j] instanceof CustomerParameter) {
                    CustomerParameter customerParameter = (CustomerParameter)objectArray[i][j];
                    customerParameter.addCustomerParameterListener(this);
                }
                this.rowVector.add(objectArray[i][j]);
            }
            this.tableDataVector.add(this.rowVector);
        }
        this.initTableDataEditableValues();
    }

    public CustomerParameterTableModel(Vector vector, String[] stringArray) {
        this(vector, stringArray, false);
    }

    public CustomerParameterTableModel(Vector vector, String[] stringArray, boolean bl) {
        this.tableDataVector = vector;
        this.columnNames = (String[])stringArray.clone();
        this.areAllCellsNotEditable = bl;
        this.initTableDataEditableValues();
    }

    public CustomerParameterTableModel(ListParameter listParameter, String[] stringArray) {
        this(listParameter, stringArray, false);
    }

    public CustomerParameterTableModel(ListParameter listParameter, String[] stringArray, boolean bl) {
        this.customerParameter = listParameter;
        this.columnNames = (String[])stringArray.clone();
        this.areAllCellsNotEditable = bl;
        this.createTableData(listParameter);
        this.customerParameter.addCustomerParameterListener(this);
    }

    private void initTableDataEditableValues() {
        this.updateEditableRowAndColumns();
        this.tableDataEditable = new Vector();
        int n = this.getRowCount();
        int n2 = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Boolean bl = (Boolean)this.tableDataEditableRow.get(i);
            this.rowVector = new Vector();
            for (int j = 0; j < n2; ++j) {
                Boolean bl2 = (Boolean)this.tableDataEditableColumn.get(j);
                boolean bl3 = bl != false && bl2 != false;
                this.rowVector.add(bl3);
            }
            this.tableDataEditable.add(this.rowVector);
        }
    }

    private void updateEditableRowAndColumns() {
        int n;
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        int n4 = this.tableDataEditableRow.size();
        int n5 = this.tableDataEditableColumn.size();
        if (n2 > n4) {
            for (n = n4; n < n2; ++n) {
                this.tableDataEditableRow.add(true);
                this.addEditableRow();
            }
        }
        if (n3 > n5) {
            for (n = n5; n < n3; ++n) {
                this.tableDataEditableColumn.add(true);
            }
        }
    }

    private void createTableData(ListParameter listParameter) {
        this.tableDataVector = new Vector();
        String[] stringArray = listParameter.getAllListValues();
        ListRange listRange = (ListRange)listParameter.getEnabledValueRange();
        ParameterRange parameterRange = listRange.getElementRange();
        if (parameterRange instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)parameterRange;
            Integer[] integerArray = integerRange.getMinValues();
            Integer[] integerArray2 = integerRange.getMaxValues();
            for (int i = 0; i < integerArray.length; ++i) {
                for (int j = integerArray[i].intValue(); j <= integerArray2[i]; ++j) {
                    Integer n = j;
                    Boolean bl = false;
                    String string = String.valueOf(j);
                    for (int k = 0; k < stringArray.length; ++k) {
                        if (!string.equals(stringArray[k])) continue;
                        bl = Boolean.TRUE;
                        break;
                    }
                    this.rowVector = new Vector();
                    this.rowVector.add(n);
                    this.rowVector.add(bl);
                    this.tableDataVector.add(this.rowVector);
                }
            }
            this.initTableDataEditableValues();
        }
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        return 0;
    }

    public int getRowCount() {
        return this.tableDataVector.size();
    }

    public String getColumnName(int n) {
        if (this.columnNames != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public Object getValueAt(int n, int n2) {
        this.rowVector = (Vector)this.tableDataVector.elementAt(n);
        return this.rowVector.elementAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.rowVector = (Vector)this.tableDataVector.elementAt(n);
        this.rowVector.setElementAt(object, n2);
        this.fireTableCellUpdated(n, n2);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.areAllCellsNotEditable || !this.isValidRowAndCol(n, n2)) {
            return false;
        }
        Vector vector = (Vector)this.tableDataEditable.get(n);
        Boolean bl = (Boolean)vector.get(n2);
        return bl;
    }

    private boolean isValidRowAndCol(int n, int n2) {
        return n >= 0 || n < this.getRowCount() || n2 >= 0 || n2 < this.getColumnCount();
    }

    public void setEditableColumn(int n, boolean bl) {
        this.tableDataEditableColumn.set(n, bl);
        this.setEditableColumn(n, 0, this.getRowCount(), bl);
    }

    public void setEditableColumn(int n, int n2, int n3, boolean bl) {
        int n4 = this.getRowCount();
        for (int i = n2; i < n4 && i < n3; ++i) {
            this.setValueForEditableAt(i, n, bl);
        }
    }

    public void setEditableRow(int n, boolean bl) {
        this.setEditableRow(n, 0, this.getColumnCount(), bl);
        this.tableDataEditableRow.set(n, bl);
    }

    public void setEditableRow(int n, int n2, int n3, boolean bl) {
        int n4 = this.getColumnCount();
        for (int i = n2; i < n4 && i < n3; ++i) {
            this.setValueForEditableAt(n, i, bl);
        }
    }

    public void setValueForEditableAt(int n, int n2, boolean bl) {
        Object e;
        if (this.isValidRowAndCol(n, n2) && (e = this.tableDataEditable.get(n)) != null) {
            Vector vector = (Vector)e;
            vector.set(n2, bl);
        }
    }

    private void addEditableRow() {
        int n = ((Vector)this.tableDataVector.get(0)).size();
        Vector<Boolean> vector = new Vector<Boolean>();
        for (int i = 0; i < n; ++i) {
            vector.add(true);
        }
        this.tableDataEditable.add(vector);
    }

    private void insertEditableRowAt(int n) {
        int n2 = ((Vector)this.tableDataVector.get(0)).size();
        Vector<Boolean> vector = new Vector<Boolean>();
        for (int i = 0; i < n2; ++i) {
            vector.add(true);
        }
        this.tableDataEditable.add(n, vector);
    }

    public void deleteEditableRowAt(int n) {
        this.tableDataEditable.removeElementAt(n);
    }

    public void deleteAllEditableRows() {
        this.tableDataEditable.removeAllElements();
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (customerParameter instanceof ListParameter && customerParameter.equals(this.customerParameter)) {
            if (parameterEvent.isRangeChanged()) {
                this.deleteAllRows();
                this.createTableData((ListParameter)customerParameter);
                this.fireTableStructureChanged();
            } else if (parameterEvent.isValueChanged()) {
                this.fireTableDataChanged();
            }
        } else {
            this.fireTableDataChanged();
        }
    }

    public String[] getSelectedItemsInRows() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.tableDataVector != null && (n = this.tableDataVector.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                this.rowVector = (Vector)this.tableDataVector.get(i);
                Integer n2 = null;
                Boolean bl = null;
                try {
                    n2 = (Integer)this.rowVector.firstElement();
                    bl = (Boolean)this.rowVector.lastElement();
                    if (!bl.booleanValue()) continue;
                    arrayList.add(n2.toString());
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private void addCustomerParameterListener(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                CustomerParameter customerParameter = (CustomerParameter)enumeration.nextElement();
                customerParameter.addCustomerParameterListener(this);
            }
            catch (Exception exception) {}
        }
    }

    private void removeCustomerParameterListener(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                CustomerParameter customerParameter = (CustomerParameter)enumeration.nextElement();
                customerParameter.removeCustomerParameterListener(this);
            }
            catch (Exception exception) {}
        }
    }

    public void addRow(Vector vector) {
        this.addCustomerParameterListener(vector);
        this.tableDataVector.add(vector);
        this.addEditableRow();
        int n = this.tableDataVector.size();
        this.fireTableRowsInserted(n, n);
    }

    public void insertRowAt(Vector vector, int n) {
        this.addCustomerParameterListener(vector);
        this.tableDataVector.insertElementAt(vector, n);
        this.insertEditableRowAt(n);
        this.fireTableRowsInserted(n, this.tableDataVector.size());
    }

    public void deleteRowAt(int n) {
        this.rowVector = (Vector)this.tableDataVector.get(n);
        this.removeCustomerParameterListener(this.rowVector);
        this.deleteEditableRowAt(n);
        this.tableDataVector.removeElementAt(n);
        this.fireTableRowsDeleted(n, this.tableDataVector.size());
    }

    public void deleteAllRows() {
        int n;
        if (this.tableDataVector != null && (n = this.tableDataVector.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                this.rowVector = (Vector)this.tableDataVector.get(i);
                this.removeCustomerParameterListener(this.rowVector);
            }
            this.tableDataVector.removeAllElements();
            this.deleteAllEditableRows();
            this.fireTableRowsDeleted(0, n);
        }
    }
}

