/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.IntegerDocument;

public class CustomerParameterTextField
extends JTextField
implements CustomerParameterListener,
CustomerParameterComponent {
    private KeyListener keyListener;
    private FocusListener focusListener;
    private CustomerParameter customerParameter;

    public CustomerParameterTextField(CustomerParameter customerParameter) {
        this.init(customerParameter);
    }

    public CustomerParameterTextField(IpAddressParameter ipAddressParameter) {
        this.setHorizontalAlignment(2);
        this.setColumns(12);
        this.init(ipAddressParameter);
    }

    public CustomerParameterTextField(SubnetParameter subnetParameter) {
        this.setHorizontalAlignment(2);
        this.setColumns(12);
        this.init(subnetParameter);
    }

    public CustomerParameterTextField(IntegerParameter integerParameter) {
        this.setHorizontalAlignment(4);
        this.setDocument(new IntegerDocument());
        IntegerRange integerRange = (IntegerRange)integerParameter.getSupportedValueRange();
        Integer n = integerRange.getMaxValue();
        int n2 = n.toString().length();
        this.setColumns(n2);
        this.init(integerParameter);
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    public void removeListeners() {
        this.removeFocusListener(this.focusListener);
        this.removeKeyListener(this.keyListener);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (customerParameter != this.customerParameter) {
            return;
        }
        this.updateValue();
    }

    private void init(CustomerParameter customerParameter) {
        this.customerParameter = customerParameter;
        if (customerParameter == null) {
            System.out.println("Error: Customer parameter not set for: " + this.getClass().getName());
            return;
        }
        this.updateValue();
        this.customerParameter.addCustomerParameterListener(this);
        this.focusListener = new FocusListener();
        this.addFocusListener(this.focusListener);
        this.keyListener = new KeyListener();
        this.addKeyListener(this.keyListener);
    }

    private void updateValue() {
        String string = this.customerParameter.getValue();
        String string2 = this.getText();
        if (string.equals("##UNDEFINED")) {
            this.setText("");
        } else if (!string.equals(string2)) {
            this.setText(string);
        }
        this.updateAccessLevel();
        this.checkValidity();
        this.updateToolTip();
    }

    private void updateToolTip() {
        ParameterRange parameterRange = this.customerParameter.getEnabledValueRange();
        this.setToolTipText(parameterRange.getDescription());
    }

    private void checkValidity() {
        if (this.getText().equals("")) {
            this.setForeground(null);
            return;
        }
        if (!this.customerParameter.isValidValue()) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(null);
        }
    }

    private void updateAccessLevel() {
        switch (this.customerParameter.getAccessLevel()) {
            case 1: {
                this.setEditable(false);
                this.setText("");
                break;
            }
            case 3: {
                this.setEditable(true);
                break;
            }
            case 2: {
                this.setEditable(true);
                break;
            }
            case 0: {
                this.setEditable(false);
                break;
            }
        }
    }

    private class FocusListener
    extends FocusAdapter {
        public void focusLost(FocusEvent focusEvent) {
            try {
                if (CustomerParameterTextField.this.customerParameter.getAccessLevel() != 1) {
                    CustomerParameterTextField.this.customerParameter.setValue(CustomerParameterTextField.this.getText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CustomerParameterTextField.this.checkValidity();
        }
    }

    private class KeyListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            try {
                CustomerParameterTextField.this.customerParameter.setValue(CustomerParameterTextField.this.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            CustomerParameterTextField.this.checkValidity();
        }
    }
}

