/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import se.ericsson.wcdma.rbs.bem.common.gui.components.AbstractGenLabelledField;
import se.ericsson.wcdma.support.gui.gengui.SyntaxException;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.GuilibResourceBundle;

class GenRadioButtonField
extends AbstractGenLabelledField {
    private String[] translatableTags = null;
    private JRadioButton[] jRadioButton = null;

    public GenRadioButtonField(String string, String string2, String[] stringArray) {
        super(string, string2);
        Log.trace("Constructor()");
        int n = stringArray.length;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioButton = new JRadioButton[n];
        for (int i = 0; i < n; ++i) {
            this.jRadioButton[i] = new JRadioButton(stringArray[i]);
            this.add(this.jRadioButton[i]);
            buttonGroup.add(this.jRadioButton[i]);
        }
        this.jRadioButton[0].setSelected(true);
        this.translatableTags = stringArray;
        this.layoutComponent();
    }

    public GenRadioButtonField(String string, String[] stringArray) {
        super(string);
        Log.trace("GenRadioButtonField()");
        int n = stringArray.length;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioButton = new JRadioButton[n];
        for (int i = 0; i < n; ++i) {
            this.jRadioButton[i] = new JRadioButton(stringArray[i]);
            this.add(this.jRadioButton[i]);
            buttonGroup.add(this.jRadioButton[i]);
        }
        this.jRadioButton[0].setSelected(true);
        this.translatableTags = stringArray;
    }

    public void setEditable(boolean bl) {
        Log.trace("setEditable()");
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            this.jRadioButton[i].setEnabled(bl);
        }
    }

    public void setEnabled(boolean bl) {
        Log.trace("setEnabled()");
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            this.jRadioButton[i].setEnabled(bl);
        }
        this.getLabel().setEnabled(bl);
    }

    public void setActionListener(ActionListener actionListener, String string) {
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            if (actionListener != null) {
                this.jRadioButton[i].addActionListener(actionListener);
            }
            this.jRadioButton[i].setActionCommand(string);
        }
    }

    public void setValue(String string) throws SyntaxException {
        Log.trace("setValue()");
        boolean bl = true;
        for (int i = 0; i < this.translatableTags.length; ++i) {
            if (!this.translatableTags[i].equals(string)) continue;
            bl = false;
            this.jRadioButton[i].setSelected(true);
        }
        if (bl) {
            throw new SyntaxException();
        }
    }

    public String getValue() {
        Log.trace("getValue()");
        for (int i = 0; i < this.translatableTags.length; ++i) {
            if (!this.jRadioButton[i].isSelected()) continue;
            return this.translatableTags[i];
        }
        return null;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.jRadioButton;
    }

    public void setToolTip(String string, String string2) {
        Log.trace("setToolTip(" + string2 + ")");
        this.toolTipBundle = string;
        this.toolTipTag = string2;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    public void setToolTip(String string, String string2, String string3) {
        Log.trace("setToolTip(" + string2 + ")");
        this.toolTipAddition = string3;
        if (null == string2) {
            for (int i = 0; i < this.jRadioButton.length; ++i) {
                this.jRadioButton[i].setToolTipText(this.toolTipAddition);
            }
        } else {
            this.setToolTip(string, string2);
        }
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle resourceBundle = GuilibResourceBundle.getBundle(this.toolTipBundle, locale, this.getClass().getClassLoader());
            if (this.toolTipTag != null) {
                for (int i = 0; i < this.jRadioButton.length; ++i) {
                    try {
                        this.jRadioButton[i].setToolTipText(resourceBundle.getString(this.toolTipTag) + this.toolTipAddition);
                        continue;
                    }
                    catch (MissingResourceException missingResourceException) {
                        this.jRadioButton[i].setToolTipText(this.toolTipTag + this.toolTipAddition);
                    }
                }
            }
        }
    }

    public void setToolTip(String string) {
        Log.trace("setToolTip(" + string + ")");
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            this.jRadioButton[i].setToolTipText(string);
        }
    }

    public void updateLocale(Locale locale) {
        Log.traceFlow();
        super.updateLocale(locale);
        for (int i = 0; i < this.translatableTags.length; ++i) {
            this.jRadioButton[i].setText(this.translateString(this.translatableTags[i]));
        }
        this.translateTooltip(locale);
    }
}

