/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.hook.application;

import java.io.File;
import java.io.IOException;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.model.ExportDeleteModel;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.CabinetXmlManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.SiteXmlManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;

public class ExportDeleteHook {
    public static final int VALUE_LEVEL_OF_RBSLOCALCELL = 3;
    public static final long VALUE_RBSLOCALCELL_OFFLINE = 8L;
    public static final Integer VALUE_INTEGER_RBSLOCALCELL_OFFLINE = 8;
    private ExportDeleteModel exportDeleteModel = null;
    private final MoHandler moHandler;

    public ExportDeleteHook() {
        ExportDeleteModel.initiate();
        this.exportDeleteModel = ExportDeleteModel.getTheInstance();
        this.moHandler = ExportDeleteModel.getMoHandler();
    }

    public MoHandler getMoHandlerFromHook() {
        return this.moHandler;
    }

    public String getRbsLocalCellsNotOffLine() {
        Object[] objectArray = null;
        try {
            objectArray = this.exportDeleteModel.getRbsLocalCellsNotOffLine();
        }
        catch (MoHandlerException moHandlerException) {
            System.out.println("Problems reading status for the Cells for this testcase. ");
            return null;
        }
        if (objectArray != null && objectArray.length > 0) {
            return "All Rbs Local Cells are NOT Off line.";
        }
        return null;
    }

    public String exportMOToXML(String string) {
        try {
            this.exportDeleteModel.exportMOToXML(string, null);
        }
        catch (IOException iOException) {
            System.out.println("IOException when creating file: " + string);
            iOException.printStackTrace();
            return iOException.toString();
        }
        catch (MoHandlerException moHandlerException) {
            System.out.println("MoHandlerException when exporting file: " + string);
            moHandlerException.printStackTrace();
            return moHandlerException.toString();
        }
        catch (Exception exception) {
            System.out.println("Unexpected Exception when exporting file: " + string);
            return exception.toString();
        }
        return null;
    }

    public String prepareDeleteMOAndCommit() {
        boolean bl;
        try {
            bl = this.exportDeleteModel.prepareDeleteMO();
            if (!bl) {
                return "Preparation of Deletion of MO Failed.";
            }
        }
        catch (BemException bemException) {
            System.out.println("Preparation of Deletion of MO Failed.");
            bemException.printStackTrace();
            return "Preparation of Deletion of MO Failed.\n" + bemException.toString();
        }
        try {
            bl = this.exportDeleteModel.commitDeleteMO();
            if (!bl) {
                return "Commit of Deletion of MO Failed.";
            }
        }
        catch (MoHandlerException moHandlerException) {
            System.out.println("Commit of Deletion of MO Failed.");
            moHandlerException.printStackTrace();
            return "Commit of Deletion of MO Failed. \n" + moHandlerException.toString();
        }
        return null;
    }

    public String prepareRemoveSecondaryDuwAndCommit() {
        boolean bl;
        try {
            bl = this.exportDeleteModel.prepareRemoveSecondaryDUW();
            if (!bl) {
                return "Preparation of Deletion of secondary DUW MO Failed.";
            }
        }
        catch (BemException bemException) {
            System.out.println("Preparation of Deletion of secondary DUW MO Failed.");
            bemException.printStackTrace();
            return "Preparation of Deletion of secondary DUW MO Failed.\n" + bemException.toString();
        }
        try {
            bl = this.exportDeleteModel.commitDeleteMO();
            if (!bl) {
                return "Commit of Deletion of MO Failed.";
            }
        }
        catch (MoHandlerException moHandlerException) {
            System.out.println("Commit of Deletion of MO Failed.");
            moHandlerException.printStackTrace();
            return "Commit of Deletion of MO Failed. \n" + moHandlerException.toString();
        }
        try {
            bl = this.exportDeleteModel.prepareDeleteInterPiuLink();
            if (!bl) {
                return "Commit of Deletion of InterPiuLink Failed.";
            }
        }
        catch (BemException bemException) {
            System.out.println("Commit of Deletion of InterPiuLink Failed.");
            bemException.printStackTrace();
            return "Commit of Deletion of InterPiuLink Failed. \n" + bemException.toString();
        }
        return null;
    }

    public String exportConfigDataCabinet(String string) {
        String string2 = null;
        String string3 = null;
        try {
            string3 = "Create rbs";
            Rbs rbs = RbsFactory.getRbs(this.moHandler, "STEP_SITE", DuwUtil.isPantherHybridRbs());
            string3 = "OpenCIs";
            OpenCIs.openExportXmlCIs(rbs);
            string3 = "remove existing file=" + string;
            File file = new File(string);
            file.delete();
            string3 = "Create cabinet XML file=" + string;
            CabinetXmlManager cabinetXmlManager = new CabinetXmlManager(rbs, string, null);
            cabinetXmlManager.createXmlFile();
        }
        catch (Exception exception) {
            string2 = string3 + " Exception=" + exception.toString();
        }
        return string2;
    }

    public String exportConfigDataSite(String string) {
        String string2 = null;
        String string3 = null;
        try {
            string3 = "Create rbs";
            Rbs rbs = RbsFactory.getRbs(this.moHandler, "STEP_SITE", DuwUtil.isPantherHybridRbs());
            string3 = "OpenCIs";
            OpenCIs.openExportXmlCIs(rbs);
            string3 = "remove existing file=" + string;
            File file = new File(string);
            file.delete();
            string3 = "Create site XML file=" + string;
            SiteXmlManager siteXmlManager = new SiteXmlManager(rbs, string, null);
            siteXmlManager.createXmlFile();
        }
        catch (Exception exception) {
            string2 = string3 + " Exception=" + exception.toString();
        }
        return string2;
    }
}

