/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.nex;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.ericsson.cello.neal.NealLogger;
import se.ericsson.cello.neal.NodeAccess;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalLogBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NealLoggerNex;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;

public class NalLogNex
extends NalLogBackend
implements NalLog {
    private static final String LOGGER_NAME_NEAL = "se.ericsson.cello.neal";
    private static final String LOGGER_NAME_CELLO = "se.ericsson.cello";
    private static final String LOGGER_NAME_WCDMA = "se.ericsson.wcdma";
    private static String jarFileVersions = null;
    private final Logger javaLogger;
    private static final Level[] LOGGER_LEVEL;
    private static final String NL = "\n";
    private static final String NL4 = "\n    ";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String[] interestingJars;

    public NalLogNex() {
        this("se.ericsson.wcdma.rbs.bem");
    }

    public NalLogNex(String string) {
        super(string);
        this.javaLogger = Logger.getLogger(string);
        System.out.println("nalLogger=" + this.javaLogger.getName() + ", Level=" + this.getLoggerLevel() + ", nalType=" + this.getNalType() + ", TraceLevel=" + this.getTraceLevel());
        if ("se.ericsson.wcdma.rbs.bem".equals(string) && jarFileVersions == null) {
            jarFileVersions = this.jarFileVersions();
            ExceptionProperties.getRevisionProperties().setProperty("Jar file revisions", jarFileVersions);
            this.nalTrace(3, this.getClass(), "Jar file revisions from found MANIFEST.MF files:\n\n" + this.indent("    ", jarFileVersions));
        }
        super.setTraceLevel(7);
    }

    public String getNalType() {
        return "nex";
    }

    private Level getLoggerLevel() {
        Logger logger = this.javaLogger;
        Level level = logger.getLevel();
        while (level == null) {
            logger = logger.getParent();
            level = logger.getLevel();
        }
        return level;
    }

    public int getTraceLevel() {
        Level level = this.getLoggerLevel();
        int n = NalLogNex.toNalLevel(level);
        return n;
    }

    public boolean isTraced(int n) {
        Level level = LOGGER_LEVEL[n];
        boolean bl = this.javaLogger.isLoggable(level);
        return bl;
    }

    public void setTraceLevel(int n) {
        if (n < 0) {
            return;
        }
        Level level = NalLogNex.toLoggerLevel(n);
        this.javaLogger.setLevel(level);
    }

    protected void log(int n, String string) {
        if (n < 0) {
            n = 0;
        }
        if (n > 7) {
            n = 7;
        }
        Level level = LOGGER_LEVEL[n];
        StackTraceElement stackTraceElement = NalLogNex.inferCaller();
        this.javaLogger.logp(level, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string);
    }

    public static Level toLoggerLevel(int n) {
        return LOGGER_LEVEL[n];
    }

    public static int toNalLevel(Level level) {
        if (level == null) {
            return 3;
        }
        int n = level.intValue();
        for (int i = 0; i < LOGGER_LEVEL.length; ++i) {
            if (n < LOGGER_LEVEL[i].intValue()) continue;
            return i;
        }
        throw new ArrayIndexOutOfBoundsException(level.getName());
    }

    Logger junit_getJavaLogger() {
        return this.javaLogger;
    }

    private synchronized String jarFileVersions() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources(MANIFEST);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                NalLogNex.appendJarFileVersion(stringBuilder, uRL);
            }
            stringBuilder.append('\n');
        }
        catch (Exception exception) {
            stringBuilder.append(NL4).append("Oops! ").append(exception.toString());
        }
        return stringBuilder.toString();
    }

    private static boolean isInteresting(URL uRL) {
        String string = uRL.toString();
        for (String string2 : interestingJars) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static void appendJarFileVersion(StringBuilder stringBuilder, URL uRL) {
        try {
            if (!NalLogNex.isInteresting(uRL)) {
                return;
            }
            String string = uRL.toString();
            int n = "jar:file:".length();
            int n2 = string.lastIndexOf(33);
            String string2 = string.substring(n, n2);
            n = string2.lastIndexOf(File.separatorChar) + 1;
            String string3 = string2.substring(n);
            stringBuilder.append(string3).append("  in  ").append(string2).append(" :");
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                stringBuilder.append(NL4).append("Failed to open META-INF/MANIFEST.MF as stream");
                return;
            }
            Manifest manifest = new Manifest(inputStream);
            inputStream.close();
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                stringBuilder.append(NL4).append("(Manifest has null attributes)");
                return;
            }
            String string4 = attributes.getValue("What-String1");
            String string5 = attributes.getValue("What-String2");
            String string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            String string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            String string9 = attributes.getValue(new Attributes.Name("Created-By"));
            if (string4 != null) {
                stringBuilder.append(NL4).append(string4);
                stringBuilder.append(NL4).append(string5);
            } else if (null != string6 && string6.startsWith("CXC")) {
                stringBuilder.append(NL4).append(string6).append(", ").append(string7);
                stringBuilder.append(", ").append(string8).append(", ").append(string3);
            } else if (null != string9) {
                stringBuilder.append(NL4).append("Created-By=").append(string9);
            } else {
                stringBuilder.append(NL4).append(attributes.entrySet().toString());
            }
            stringBuilder.append(NL);
        }
        catch (Exception exception) {
            stringBuilder.append("Oops! ").append(exception);
        }
    }

    private String indent(String string, String string2) {
        String string3 = string + string2.replace(NL, NL + string);
        return string3;
    }

    private static StackTraceElement inferCaller() {
        StackTraceElement stackTraceElement;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stackTraceElement = stackTraceElementArray[i];
            String string = stackTraceElement.getClassName();
            if (string.contains("Log")) continue;
            return stackTraceElement;
        }
        if (stackTraceElementArray.length > 2) {
            return stackTraceElementArray[2];
        }
        if (stackTraceElementArray.length > 0) {
            return stackTraceElementArray[stackTraceElementArray.length - 1];
        }
        stackTraceElement = new StackTraceElement("", "", "", 0);
        return stackTraceElement;
    }

    static {
        try {
            NealLogger nealLogger = NodeAccess.getLogger();
            if (nealLogger == null) {
                Logger logger = Logger.getLogger(LOGGER_NAME_NEAL);
                NealLoggerNex nealLoggerNex = new NealLoggerNex(logger);
                NodeAccess.setLogger((NealLogger)nealLoggerNex);
            }
        }
        catch (Throwable throwable) {
            System.err.println("\nERROR! Failed initiating the NealLogger!");
            throwable.printStackTrace();
        }
        Logger.getLogger(LOGGER_NAME_CELLO);
        Logger.getLogger(LOGGER_NAME_WCDMA);
        Log.assertion("se.ericsson.wcdma.support" != null, "Making sure the static initializion of class Log has been performed");
        LOGGER_LEVEL = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        interestingJars = new String[]{"bem.jar", "bemhlp.jar", "launcher.jar", "nex.jar", "neal.jar", "rt.jar", "foundation.jar"};
    }
}

