/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class BemUtil {
    public static String cabinetWithPDuw = BemUtil.generateCabinetKey(1);
    public static String cabinetWithSDuw = BemUtil.generateCabinetKey(2);

    public static String getCommaSeparatedValueString(String[] stringArray) {
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string.concat(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                string = string.concat(",");
            }
        }
        return string;
    }

    public static String getCommaSeparatedValueString(int[] nArray) {
        String string = "";
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = Integer.toString(nArray[i]);
                string = string.concat(string2);
                if (i == nArray.length - 1) continue;
                string = string.concat(",");
            }
        }
        return string;
    }

    public static String[] getStringArray(String string) {
        Vector<String> vector = new Vector<String>(0, 1);
        String[] stringArray = new String[]{};
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2.trim());
        }
        stringArray = vector.toArray(stringArray);
        return stringArray;
    }

    public static int[] convertStringArrayToIntArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static String[] convertIntArrayToStringArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = String.valueOf(nArray[i]);
        }
        return stringArray;
    }

    public static int[] convertIntegerArrayToIntArray(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        int n = integerArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static String[] createStringArrayFromInt(int n) {
        if (n < 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        return stringArray;
    }

    public static String[] createStringArrayFromInt(int n, int n2) {
        if (n > n2) {
            return null;
        }
        String[] stringArray = new String[n2 - n + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(i + n);
        }
        return stringArray;
    }

    public static String[] concat(String[] stringArray, String[] stringArray2) {
        return BemUtil.concat(new String[][]{stringArray, stringArray2});
    }

    public static String[] concat(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return BemUtil.concat(new String[][]{stringArray, stringArray2, stringArray3});
    }

    public static String[] concat(String[][] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            int n3 = 0;
            while (n3 < stringArray3.length) {
                stringArray2[n2++] = stringArray3[n3++];
            }
        }
        return stringArray2;
    }

    public static String extractRdnId(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = null;
        int n = string.indexOf(string2);
        if (n == -1) {
            return "";
        }
        int n2 = string.indexOf("=", n);
        int n3 = string.indexOf(",", n2);
        string3 = n3 != -1 ? string.substring(n2 + 1, n3) : string.substring(n2 + 1);
        return string3;
    }

    public static String extractLdn(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return "";
        }
        int n2 = string.indexOf(",", n);
        String string3 = n2 != -1 ? string.substring(0, n2) : string;
        return string3;
    }

    public static boolean isLdnOfType(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = 0;
        int n3 = string.lastIndexOf(",");
        if (n3 != -1) {
            n2 = n3 + 1;
        }
        if ((n = string.lastIndexOf("=")) == -1) {
            return false;
        }
        String string3 = string.substring(n2, n);
        boolean bl = string2.equals(string3);
        return bl;
    }

    public static String getRdn(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.lastIndexOf("=");
        string2 = n == -1 ? null : string.substring(n + 1);
        return string2;
    }

    public static String getTrimString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static boolean xor(boolean bl, boolean bl2) {
        return !(!bl && !bl2 || bl && bl2);
    }

    public static boolean isStringInArray(String string, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isIntInArray(int n, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getCustomerParameterName(String string, String string2, int n) {
        return string + string2 + (n == 1 ? "" : String.valueOf(n));
    }

    public static String getCustomerParameterNameWithBranchType(String string, String string2, String string3) {
        return string + string2 + string3;
    }

    public static String generateCabinetKey(int n) {
        return "Cabinet" + n;
    }

    public static String generateCabinetNumberFromKey(String string) {
        return string.substring("Cabinet".length());
    }

    public static String getCabinetType(String string) {
        if (RbsInfo.RBS_6201W.NAME.equals(string)) {
            return string;
        }
        int n = string.indexOf("V2W");
        if (n == -1) {
            n = string.indexOf("W");
        }
        if (string.startsWith("RBS6") && n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static boolean isDualBoxSupported(String string) {
        String[] stringArray = new String[]{RbsInfo.RBS_3018.NAME, RbsInfo.RBS_6601W.NAME, RbsInfo.RBS_6302W.NAME};
        List<String> list = Arrays.asList(stringArray);
        return list.contains(string);
    }

    public static String getInciConnectorPrefix(int n) {
        return MessageFormat.format("InciConnector{0}_", String.valueOf(n));
    }

    public static String getExNodeLoadedValue(Rbs rbs, BemMo bemMo, String string) throws BemException {
        String string2 = "##UNDEFINED";
        BemMo bemMo2 = (BemMo)bemMo.getAttribute("inciConnectorRef");
        if (bemMo2 == null) {
            return string2;
        }
        if (bemMo2.isExisting()) {
            String string3;
            String string4 = "##UNDEFINED";
            if (bemMo2.getType().equals(MimAuxPlugInUnit.MOTYPENAME)) {
                string3 = "Radio";
            } else if (bemMo2.getType().equals(MimEcBus.MOTYPENAME)) {
                string3 = "EcBus";
            } else {
                throw new BemException("Get loaded value of  " + string + " is failed. " + "The unitType of inciConnectorRef is strange, unitType: " + bemMo2.getType() + ".");
            }
            if (string3 == "Radio") {
                string4 = BemUtil.getLoadedValueSectorNumber(bemMo2);
            }
            if (string.equals("equipmentSupportFunctionId")) {
                BemMo bemMo3 = (BemMo)bemMo.getAttribute("equipmentSupportFunctionRef");
                if (bemMo3 == null) {
                    string2 = "##UNDEFINED";
                } else if (bemMo3.isExisting()) {
                    string2 = bemMo3.getId();
                }
            } else if (string.equals("unitType")) {
                string2 = string3;
            } else if (string.equals("sectorNumber")) {
                if (string3 == "Radio") {
                    string2 = string4;
                } else if (string3 == "EcBus") {
                    string2 = "##UNDEFINED";
                }
            } else if (string.equals("unitNumber")) {
                if (string3 == "EcBus") {
                    string2 = bemMo2.getId();
                } else if (string3 == "Radio") {
                    RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
                    AbstractRuRI[] abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(Integer.valueOf(string4));
                    if (null == abstractRuRIArray) {
                        throw new BemException("The sector " + string4 + "has no radio equipped.");
                    }
                    for (int i = 0; i < abstractRuRIArray.length; ++i) {
                        if (!abstractRuRIArray[i].getAuxPiuLdn().equals(bemMo2.getDN())) continue;
                        string2 = String.valueOf(abstractRuRIArray[i].getSequenceNumber());
                    }
                }
            } else {
                throw new BemException("Get loaded value of  " + string + " is failed");
            }
        }
        return string2;
    }

    public static String getLoadedValueSectorNumber(BemMo bemMo) throws BemException {
        BemMo bemMo2 = null;
        String string = "##UNDEFINED";
        Object[] objectArray = (Object[])bemMo.getAttribute("reservedBy");
        if (objectArray != null && objectArray.length > 0 && objectArray instanceof BemMo[]) {
            BemMo[] bemMoArray = (BemMo[])objectArray;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                BemMo bemMo3 = bemMoArray[i];
                if (!bemMo3.getType().equals(MimAntFeederCable.MOTYPENAME)) continue;
                bemMo2 = bemMo3;
                String string2 = bemMo2.getId();
                string = string2.substring(0, string2.length() - 1);
                break;
            }
        }
        return string;
    }

    public static boolean hasInciConnectorConfigChanged(Rbs rbs, String string) throws BemException {
        String string2 = MessageFormat.format("InciConnector{0}_", string);
        if (rbs.isParameterSupported(string2 + "unitNumber")) {
            CustomerParameter customerParameter = rbs.getCustomerParameterObject(string2 + "unitType");
            CustomerParameter customerParameter2 = rbs.getCustomerParameterObject(string2 + "sectorNumber");
            CustomerParameter customerParameter3 = rbs.getCustomerParameterObject(string2 + "equipmentSupportFunctionId");
            CustomerParameter customerParameter4 = rbs.getCustomerParameterObject(string2 + "unitNumber");
            if (customerParameter.hasValueChanged() && customerParameter4.getValue().equals("##UNDEFINED")) {
                return false;
            }
            if (customerParameter.hasValueChanged() || customerParameter4.hasValueChanged() || customerParameter2.hasValueChanged() || customerParameter3.hasValueChanged()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSecondaryESFReferred(Rbs rbs, int n) {
        boolean bl = false;
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
        try {
            String string2 = rbs.getCustomerParameter(string + "equipmentSupportFunctionId");
            if (string2.equals(String.valueOf(2))) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            // empty catch block
        }
        return bl;
    }

    public static BemMo getEquipmentSupportFunctionMo(Rbs rbs, String string) throws BemException {
        BemMo bemMo = rbs.getMoHandler().getMo(new LdnMoi(null).getLdn());
        if (string.equals(String.valueOf(1)) || string.equals(String.valueOf(2))) {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, string);
            String string2 = fixedRdnMoi.getLdn();
            bemMo = rbs.getMoHandler().getMo(string2);
        }
        return bemMo;
    }

    public static BemMo getInciConnectorMo(Rbs rbs, CustomerParameterServer customerParameterServer, CustomerParameterServer customerParameterServer2, CustomerParameterServer customerParameterServer3) throws BemException {
        BemMo bemMo = rbs.getMoHandler().getMo(new LdnMoi(null).getLdn());
        String string = customerParameterServer.getValueMom().toString();
        int n = Integer.parseInt(customerParameterServer2.getValueMom().toString());
        if (string.equals("Radio")) {
            int n2;
            RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
            if (!radioEquipmentProvider.isSectorEquipped(n2 = Integer.parseInt(customerParameterServer3.getValueMom().toString()))) {
                return bemMo;
            }
            AbstractRuRI[] abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(n2);
            if (null == abstractRuRIArray) {
                return bemMo;
            }
            bemMo = rbs.getMoHandler().getMo(abstractRuRIArray[n - 1].getAuxPiuLdn());
        } else if (string.equals("EcBus")) {
            MoInstance moInstance = rbs.getMoiRefs().getEquipmentMoi();
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, String.valueOf(n));
            String string2 = fixedRdnMoi.getLdn();
            bemMo = rbs.getMoHandler().getMo(string2);
        }
        return bemMo;
    }
}

