/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.view.actions;

import java.util.Properties;
import javax.swing.JOptionPane;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.view.util.BemViewCommon;

public class DisconnectBranchBAction
implements Launchable {
    private static final String NAME = "Disconnect Branch B";
    private static final String INFORMATION_TITLE = "Information";
    private static final String emString = " - RBS Element Manager - ";
    private BemMo deviceGroupMo;
    private String fuLdn;
    private String hostname;
    private StringBuffer title = new StringBuffer();
    private LauncherInterface launcher;
    private MoHandler moHandler = null;

    public void run(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        this.hostname = string;
        this.launcher = launcherInterface;
        this.fuLdn = properties.getProperty("LDNs");
        this.moHandler = new MoHandlerImpl();
        this.deviceGroupMo = this.moHandler.getMo(this.fuLdn);
        if (this.deviceGroupMo.getType().equals(MimFuDeviceGroup.MOTYPENAME)) {
            this.disConnectBranchB(true);
        } else {
            this.disConnectBranchB(false);
        }
        this.exit();
    }

    private void lockSecondAiDevice(String string) throws BemException {
        try {
            BemMo bemMo = this.moHandler.getMo(string);
            Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
            if (n != null && n == 1) {
                this.moHandler.setAttribute(bemMo, "administrativeState", 0);
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string2 = moHandlerException.getAction();
            throw new BemException(string2, string, (Throwable)moHandlerException);
        }
    }

    public boolean reconnect(String string, Properties properties) {
        return false;
    }

    public void exit() {
        this.launcher.onExit((Launchable)this);
    }

    public int getAntIndex(BemMo[] bemMoArray) throws MoHandlerException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        String string = this.deviceGroupMo.getParent().getDN();
        int n = -1;
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                int n2;
                Integer n3;
                String string2;
                BemMo bemMo = (BemMo)moHandlerImpl.getAttribute(bemMoArray[i], "connectedToObjectARef");
                if (bemMo == null || !(string2 = bemMo.getDN()).equals(string) || (n3 = (Integer)moHandlerImpl.getAttribute(bemMoArray[i], "objectAConnector")) == null || (n2 = n3.intValue()) != 2) continue;
                n = i;
                return n;
            }
        }
        return n;
    }

    public int getRfIndex(BemMo[] bemMoArray) throws MoHandlerException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        String string = this.deviceGroupMo.getParent().getDN();
        int n = -1;
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                int n2;
                Integer n3;
                String string2;
                BemMo bemMo = (BemMo)moHandlerImpl.getAttribute(bemMoArray[i], "connectedToObjectARef");
                if (bemMo == null || !(string2 = bemMo.getDN()).equals(string) || (n3 = (Integer)moHandlerImpl.getAttribute(bemMoArray[i], "objectAConnector")) == null || (n2 = n3.intValue()) != 9) continue;
                n = i;
                return n;
            }
        }
        return n;
    }

    public BemMo getAiMo(BemMo bemMo) throws NalCmException, MoHandlerException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        String string = this.deviceGroupMo.getDN();
        BemMo bemMo2 = moHandlerImpl.getMo(string);
        BemMo[] bemMoArray = moHandlerImpl.getChildren(bemMo2, 2, MimAiDevice.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length == 2) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string2 = bemMoArray[i].getId();
                if (!"2".equals(string2)) continue;
                return bemMoArray[i];
            }
        }
        return null;
    }

    public void disConnectBranchB(boolean bl) {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("Warning!");
        stringBuffer.append(string);
        stringBuffer.append("Disconnect Branch B results in loss of RX diversity until SW");
        stringBuffer.append(string);
        stringBuffer.append("configuration completed with Modify RBS Equipment Configuration");
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append("Do you want to continue?");
        stringBuffer.append(string);
        stringBuffer2.append("Disconnect Branch B completed. You may physically disconnect cables!");
        stringBuffer3.append("No cable connection on Branch B!");
        this.title.append(this.hostname + emString);
        this.title.append(NAME);
        try {
            BemMo bemMo = moHandlerImpl.getMo(BemViewCommon.VIEW_LDN_MANAGEDELEMENT);
            BemMo[] bemMoArray = bemMo.getChildren(2, MimAntFeederCable.MOTYPENAME, "");
            int n = this.getAntIndex(bemMoArray);
            int n2 = 1;
            BemMo[] bemMoArray2 = null;
            if (bl) {
                bemMoArray2 = bemMo.getChildren(2, MimRfCable.MOTYPENAME, "");
                n2 = this.getRfIndex(bemMoArray2);
            }
            BemMo bemMo2 = this.getAiMo(bemMo);
            int n3 = 0;
            if (n >= 0 && n2 >= 0 && bemMo2 != null && (n3 = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), this.title.toString(), 0, 2)) == 0) {
                if (bl) {
                    moHandlerImpl.setAttribute(bemMo2, "administrativeState", 0);
                } else {
                    this.lockSecondAiDevice(bemMo2.getDN());
                }
                moHandlerImpl.setAttribute(bemMoArray[n], "objectAConnector", 0);
                if (bl) {
                    moHandlerImpl.setAttribute(bemMoArray2[n2], "objectAConnector", 0);
                }
                JOptionPane.showMessageDialog(null, stringBuffer2.toString(), INFORMATION_TITLE, 1);
                bl2 = true;
            }
            if (n3 == 0 && !bl2) {
                JOptionPane.showMessageDialog(null, stringBuffer3.toString(), this.title.toString(), 0);
            }
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Failed to disconnect branch B", exception);
            JOptionPane.showMessageDialog(null, "DISCBRANCHB_FAILED\n" + exception.toString(), "BEM_ERROR_TITLE", 0);
        }
    }
}

