/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.view.views.equipment.embeddableappl.cableoverview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import se.ericsson.cello.nex.Embeddable;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ErrorDialog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalFactoryNexParameters;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.view.views.equipment.embeddableappl.cableoverview.CableConnectorNaming;

public class CablesEmbeddable
implements Embeddable {
    private static final Class THIS_CLASS = CablesEmbeddable.class;
    private static final int CELLGAP = 4;
    private static final String APPLICATION_NAME = "Cable Overview";
    private static final String CABLE_COLUMN_NAME = "Cable";
    private static final String FROM_CONNECTOR_COLUMN_NAME = "Connected from [Slot:Unit:Connector]";
    private static final String TO_CONNECTOR_COLUMN_NAME = "Connected to [Slot:Unit:Connector]";
    private static final String REFRESH_NAME = "Refresh";
    private static final String FAILURE_HEADING = "Failure when reading from node.";
    private static final String FAILURE_DESCRIPTION = "Trying to read cable information from node was not successful. The information can not be displayed in the Cable Overview tab.";
    private static final String HOST_NAME = "hostname";
    private JPanel myComponent = null;
    private JTable myTable = null;
    private CableTableModel myTableModel = null;
    private JButton myRefreshButton = null;
    private Properties myProps = null;
    private Launchable myLaunchableNex = null;
    private LauncherInterface myLauncher = null;
    private boolean neverCalled = true;
    private Vector allCables = null;

    public void init(Properties properties, Launchable launchable, LauncherInterface launcherInterface) {
        this.myProps = properties;
        this.myLaunchableNex = launchable;
        this.myLauncher = launcherInterface;
        Nal.getLog().nalTrace(6, this.getClass(), "Entered with nexProps=" + properties);
        try {
            String string = this.myProps.getProperty(HOST_NAME);
            NalFactoryNexParameters nalFactoryNexParameters = new NalFactoryNexParameters();
            nalFactoryNexParameters.launcher = this.myLauncher;
            nalFactoryNexParameters.parent = this.myLaunchableNex;
            nalFactoryNexParameters.properties = properties;
            Nal.connectToMib(string, -1, "nex", nalFactoryNexParameters);
        }
        catch (Exception exception) {
            this.reportException(FAILURE_HEADING, FAILURE_DESCRIPTION, exception);
        }
        this.initComponent();
        this.refresh();
    }

    public String getName() {
        return APPLICATION_NAME;
    }

    public void setLDNs(String[] stringArray) {
        if (this.neverCalled) {
            this.fillInTableValues(this.allCables);
            this.neverCalled = false;
        }
    }

    public JComponent getComponent() {
        if (null == this.myComponent) {
            this.initComponent();
        }
        return this.myComponent;
    }

    private void findCables() {
        BemMo bemMo = null;
        BemMo[] bemMoArray = null;
        BemMo bemMo2 = null;
        BemMo[] bemMoArray2 = null;
        Hashtable<String, BemMo> hashtable = new Hashtable<String, BemMo>();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            bemMo = BemMoImpl.getRoot();
            if (bemMo != null) {
                bemMoArray = bemMo.getChildren(1, "Equipment", "");
            }
            if (bemMoArray != null) {
                bemMo2 = bemMoArray[0];
            }
            if (bemMo2 != null) {
                bemMoArray2 = bemMo2.getChildren(1, "", "");
            }
            if (bemMoArray2 != null) {
                for (int i = 0; i < bemMoArray2.length; ++i) {
                    String string = bemMoArray2[i].getDN();
                    if (string == null || string.indexOf(CABLE_COLUMN_NAME) < 0) continue;
                    BemMo bemMo3 = bemMoArray2[i];
                    hashtable.put(string, bemMo3);
                    arrayList.add(string);
                }
            }
        }
        catch (Exception exception) {
            this.reportException(FAILURE_HEADING, FAILURE_DESCRIPTION, exception);
        }
        this.allCables = this.sortCables(hashtable, arrayList);
    }

    private Vector sortCables(Hashtable hashtable, ArrayList arrayList) {
        Vector<BemMo> vector = new Vector<BemMo>();
        try {
            Object[] objectArray = arrayList.toArray(new String[0]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                BemMo bemMo = (BemMo)hashtable.get(objectArray[i]);
                if (bemMo == null) continue;
                vector.add(bemMo);
            }
        }
        catch (Exception exception) {
            this.reportException(FAILURE_HEADING, FAILURE_DESCRIPTION, exception);
        }
        return vector;
    }

    private void initComponent() {
        this.myComponent = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        this.myComponent.setLayout(borderLayout);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.myRefreshButton = new JButton(REFRESH_NAME);
        this.myRefreshButton.setMnemonic('f');
        this.myRefreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CablesEmbeddable.this.refresh();
            }
        });
        jPanel.add(this.myRefreshButton);
        this.myComponent.add((Component)jPanel, "South");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.myTableModel = new CableTableModel();
        this.myTable = new JTable(this.myTableModel);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setCellSelectionEnabled(false);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setSelectionMode(0);
        int n = 4;
        this.myTable.setIntercellSpacing(new Dimension(4, n));
        this.myTable.setRowHeight(this.myTable.getRowHeight() + n);
        jScrollPane.setViewportView(this.myTable);
        this.myComponent.add(jScrollPane);
        this.myComponent.setVisible(true);
    }

    private void fillInTableValues(Vector vector) {
        this.myTableModel.clearTable();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                BemMo bemMo = (BemMo)vector.elementAt(i);
                Vector<String> vector2 = new Vector<String>();
                vector2.add(this.getCableName(bemMo));
                vector2.add(this.getConnectedFrom(bemMo));
                vector2.add(this.getConnectedTo(bemMo));
                this.myTableModel.addRow(vector2);
            }
        }
    }

    private String getCableName(BemMo bemMo) {
        if (bemMo == null) {
            return null;
        }
        String string = "";
        try {
            String string2 = bemMo.getDN();
            int n = string2.lastIndexOf(",") + 1;
            string = string2.substring(n);
        }
        catch (Exception exception) {
            this.reportException(FAILURE_HEADING, FAILURE_DESCRIPTION, exception);
        }
        return string;
    }

    private String getConnectedFrom(BemMo bemMo) {
        if (bemMo == null) {
            return null;
        }
        String string = "";
        try {
            string = CableConnectorNaming.getSlotIdFrom(bemMo) + CableConnectorNaming.getElementNameFrom(bemMo) + CableConnectorNaming.getTypeFrom(bemMo);
        }
        catch (Exception exception) {
            this.reportException(FAILURE_HEADING, FAILURE_DESCRIPTION, exception);
        }
        return string;
    }

    private String getConnectedTo(BemMo bemMo) {
        if (bemMo == null) {
            return null;
        }
        String string = "";
        try {
            string = CableConnectorNaming.getSlotIdTo(bemMo) + CableConnectorNaming.getElementNameTo(bemMo) + CableConnectorNaming.getTypeTo(bemMo);
        }
        catch (Exception exception) {
            this.reportException(FAILURE_HEADING, FAILURE_DESCRIPTION, exception);
        }
        return string;
    }

    private void refresh() {
        this.findCables();
        this.fillInTableValues(this.allCables);
        this.myTable.updateUI();
    }

    private void reportException(String string, String string2, Exception exception) {
        Nal.getLog().nalTraceError(THIS_CLASS, string + " " + string2, exception);
        BemException bemException = new BemException(exception);
        bemException.setUnlessEmpty("Problem", string + "\n" + string2);
        String string3 = bemException.getPopUpMessge();
        String string4 = bemException.getPopUpDetails();
        ErrorDialog errorDialog = ErrorDialog.create(this.myComponent.getTopLevelAncestor(), string3, string4);
        errorDialog.setModal(false);
        errorDialog.setVisible(true);
    }

    private static class CableTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Cable", "Connected from [Slot:Unit:Connector]", "Connected to [Slot:Unit:Connector]"};
        private Vector data = new Vector();

        private CableTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return ((Vector)this.data.get(n)).get(n2);
        }

        public void clearTable() {
            if (!this.data.isEmpty()) {
                this.data.clear();
            }
        }

        public void addRow(Vector vector) {
            this.data.add(vector);
        }
    }
}

