/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemWizardHeading;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractWizardView;

public abstract class BemWizardGuiView
extends AbstractWizardView {
    private final JPanel headingPanel = new JPanel();
    private BemWizardHeading headingComponent = null;
    private JComponent mainPanel;
    protected Dimension thePreferedDimension = new Dimension(700, 700);
    protected double headingWeightX = 1.0;
    protected double headingWeightY = 0.1;

    protected void init() {
        this.setupMainPanel();
        this.setupHeadingPanel();
    }

    protected void setupMainPanel() {
        this.setSize(this.thePreferedDimension);
        this.setPreferredSize(this.thePreferedDimension);
        this.setLayout(new GridBagLayout());
    }

    protected void setupHeadingPanel() {
        this.headingPanel.setLayout(new GridBagLayout());
        String string = this.getHeading();
        String string2 = this.getSubHeading();
        this.headingComponent = new BemWizardHeading(string, string2);
        this.addHeadingComponentToPanel();
        this.addHeadingPanel();
    }

    protected String getHeading() {
        return "";
    }

    protected String getSubHeading() {
        return "";
    }

    private void addHeadingComponentToPanel() {
        this.headingPanel.add((Component)this.headingComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addHeadingPanel() {
        this.setupHeadingWeight();
        this.add((Component)this.headingPanel, new GridBagConstraints(0, 0, 1, 1, this.headingWeightX, this.headingWeightY, 11, 2, new Insets(15, 10, 0, 10), 0, 0));
    }

    protected void addMainPanel(JComponent jComponent) {
        this.removeMainPanel();
        this.mainPanel = jComponent;
        this.add((Component)jComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 10, 4, 10), 0, 0));
    }

    protected void removeMainPanel() {
        if (this.mainPanel != null) {
            this.mainPanel.setVisible(false);
            this.remove(this.mainPanel);
            this.mainPanel = null;
        }
    }

    protected void setupHeadingWeight() {
    }

    public void setHeaderText(String string) {
        this.setEnabledHeadingLanguageHandling(false);
        this.headingComponent.setHeadingText(string);
    }

    public void setSubHeaderText(String string) {
        this.setEnabledSubHeadingLanguageHandling(false);
        this.headingComponent.setSubHeadingText(string);
    }

    public Dimension getPreferredSize() {
        return this.thePreferedDimension;
    }

    protected void setEnabledHeadingLanguageHandling(boolean bl) {
        JComponent jComponent = this.headingComponent.getHeadingComponent();
        this.setEnabledLanguageHandling(jComponent, bl);
    }

    protected void setEnabledSubHeadingLanguageHandling(boolean bl) {
        JComponent jComponent = this.headingComponent.getSubHeadingComponent();
        this.setEnabledLanguageHandling(jComponent, bl);
    }

    private void setEnabledLanguageHandling(JComponent jComponent, boolean bl) {
        String string = "NT";
        if (bl) {
            string = null;
        }
        jComponent.putClientProperty("LANGUAGE_CONTROLLED", string);
    }

    public void setComponent(String string, Object object) {
        throw new RuntimeException("BemWizardGuiView.setComponent() is called but not implemented");
    }
}

