/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConfigurationVersion;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.control.EmasWorkarounder;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.Preconditions;
import se.ericsson.wcdma.rbs.bem.wizard.util.PreconditionsCheck;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.rbs.bem.wizard.view.FileInputView;
import se.ericsson.wcdma.rbs.bem.wizard.view.NodeResultView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control.FileInputFlexCabinetController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control.NodeResultFlexController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.view.WelcomeViewer;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class WelcomeController
extends AbstractApplicationController
implements EmasWorkarounder {
    private WelcomeViewer myView = null;
    private WizardHelper wizardHelp = null;
    private Class nextController = FileInputFlexCabinetController.class;
    private Class nextView = FileInputView.class;
    private MoHandler theMoHandler;

    protected void init() {
        this.myView = (WelcomeViewer)((Object)this.getView());
        this.myView.getNextButton().addActionListener(new NextButtonListener());
        this.myView.getCancelButton().addActionListener(new CancelButtonListener());
        this.theMoHandler = new MoHandlerImpl();
    }

    protected boolean canStop() {
        return true;
    }

    protected void beforeVisible() {
        boolean bl = WizardLaunchChecker.wizardStarted();
        if (!bl) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    protected void afterVisible() {
        CabinetFlexModel.initiate("Cabinet Equipment Configuration");
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardHelp.destroyTheInstance();
        this.wizardHelp = WizardHelp.getTheInstance();
        try {
            DuwUtil.setup();
            if (DuwUtil.hasDuw()) {
                WizardHelp.getTheInstance().setDuwPageOrder();
            }
            this.setWindowSubTitle();
            this.checkInputFilePreconditions();
            this.checkEthernetLink();
            this.setProductData();
        }
        catch (Exception exception) {
            this.showError(exception.toString());
        }
    }

    private void setWindowSubTitle() {
        this.myView.setHeaderText("Cabinet Equipment Configuration");
    }

    public Class getNextControllerClass() {
        return this.nextController;
    }

    public Class getNextViewClass() {
        return this.nextView;
    }

    public void reportInstallerComplete(StringBuffer stringBuffer) {
        this.getApplication().stopApplication();
    }

    public void reportInstallerError(WizardException wizardException) {
    }

    public void reportInstallerCancelled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputFilePreconditions() {
        Preconditions preconditions = null;
        try {
            preconditions = WizardCommon.WIZARD_INPUTFILE_PRECONDITIONS_CABINET;
            preconditions = new PreconditionsCheck().checkPreconditions(preconditions);
            if (!preconditions.getPreconditionsFullfilled()) {
                this.nextController = NodeResultFlexController.class;
                this.nextView = NodeResultView.class;
                this.wizardHelp.excludeSlides("FileInputInitialController", "FileInputInitialController");
            }
        }
        catch (Exception exception) {
            this.showError(exception.getMessage());
        }
        finally {
            preconditions = null;
        }
    }

    private void checkEthernetLink() {
        try {
            String string = WizardCommon.WIZARD_LDN_ETHERNETLINK;
            BemMo bemMo = this.theMoHandler.getMo(string);
            boolean bl = bemMo.isExisting();
            if (bl) {
                this.wizardHelp.excludeSlides("IpController", "IpController");
            }
        }
        catch (Exception exception) {
            this.showError(exception.getMessage());
        }
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    protected void cancel() {
        WizardLaunchChecker.wizardStopped();
        this.getApplication().stopApplication();
    }

    protected void viewClosing() {
        this.cancel();
    }

    private boolean isWizardRun() {
        boolean bl = false;
        try {
            bl = DuwUtil.hasDuw() ? this.checkIfDuwWizardIsRun() : this.isNonDuwWizardRun();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Determining if wizard is run. Error=" + exception.toString(), "Error", 0);
        }
        return bl;
    }

    private boolean isNonDuwWizardRun() {
        return this.nextView == NodeResultView.class;
    }

    private boolean checkIfDuwWizardIsRun() throws Exception {
        boolean bl = false;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        RootMoi rootMoi = new RootMoi();
        String string = rootMoi.getLdn();
        BemMo bemMo = moHandlerImpl.getMo(string);
        Object object = null;
        object = moHandlerImpl.getAttribute(bemMo, "productName");
        String string2 = (String)object;
        if (string2 != null && !string2.equals("")) {
            bl = true;
        }
        return bl;
    }

    private void setProductData() throws NoSuchFieldException, IOException, MoHandlerException, BemException {
        Object object;
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimSwManagement.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimConfigurationVersion.MOTYPENAME, "1");
        BemMo bemMo = this.theMoHandler.getMo(singleChildMoi2.getLdn());
        BemMo bemMo2 = (BemMo)this.theMoHandler.getAttribute(bemMo, "currentUpgradePackage");
        NalStruct nalStruct = (NalStruct)this.theMoHandler.getAttribute(bemMo2, "administrativeData");
        String string = (String)nalStruct.getMemberValue("productNumber");
        String string2 = (String)nalStruct.getMemberValue("productRevision");
        String string3 = WizardHelp.getTheInstance().getDtdFilePath();
        InputStream inputStream = WelcomeController.class.getResourceAsStream(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = "";
        char[] cArray = new char[4096];
        int n = bufferedReader.read(cArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        while (n != -1) {
            n = bufferedReader.read(cArray);
            stringBuffer.append(cArray);
        }
        string4 = stringBuffer.toString();
        bufferedReader.close();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "<!");
        String string5 = "";
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n2 = ((String)object).indexOf("revision");
            if (n2 == -1) continue;
            int n3 = ((String)object).indexOf("(");
            int n4 = ((String)object).indexOf(")");
            if (n3 == -1 || n4 == -1) continue;
            string5 = ((String)object).substring(n3 + 1, n4);
            break;
        }
        object = ExceptionProperties.getRevisionProperties();
        ((ExceptionProperties)object).setProperty("Upgrade Package Revision", string + " rev " + string2);
        ((ExceptionProperties)object).setProperty("DTD version", "Cabinet : " + string5);
        String string6 = "* Software package\n  Product number: " + string + "\n" + "  Product revision: " + string2 + "\n" + "  DTD version: " + string5;
        this.myView.setProductData(string6);
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeController.this.cancel();
        }
    }

    class NextButtonListener
    implements ActionListener {
        NextButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[][] objectArray = new String[0][0];
            if (WelcomeController.this.isWizardRun()) {
                WelcomeController.this.showMessageDialog("NCONF_CABINET_WIZARD_ALREADY_RUN", null, "BEM_INFORMATION_TITLE", null, 1, null);
                WelcomeController.this.cancel();
                return;
            }
            WelcomeController.this.startWizard(false, "NCONF_WIZARD_WINDOW_TITLE", null, WelcomeController.this.getNextViewClass(), WelcomeController.this.getNextControllerClass(), objectArray);
            WelcomeController.this.myView.setTheViewToDummy();
        }
    }
}

