/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class EtmView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private static final String[] COLUMN_NAMES = new String[]{"Slot Position", "ETM Type"};
    private Map slots;
    private CustomerParameterTable table;

    public void setEtmSlots(Map map) {
        this.slots = map;
    }

    public void updateGui() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createEtmPanel(), "North");
        this.addMainPanel(jPanel);
    }

    private JPanel createEtmPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("ETM options"));
        String[] stringArray = this.getSlotPositions();
        Object[][] objectArray = new Object[stringArray.length][COLUMN_NAMES.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i][0] = stringArray[i];
            objectArray[i][1] = this.slots.get(stringArray[i]);
        }
        this.table = new CustomerParameterTable(objectArray, COLUMN_NAMES);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new JScrollPane(this.table), gridBagConstraints);
        return jPanel;
    }

    public String getGuiNameForCustomerParameter(String string) {
        if (this.table.isParameterInTable(string)) {
            return this.table.getRowAndColumnName(string);
        }
        return "";
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.table.isParameterInTable(string)) {
            this.table.setFocusOnCell(string);
        }
    }

    private String[] getSlotPositions() {
        String[] stringArray = this.slots.keySet().toArray(new String[0]);
        Arrays.sort(stringArray, new StringNumberComparator());
        return stringArray;
    }

    private static class StringNumberComparator
    implements Comparator {
        private StringNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(object.toString());
                n2 = Integer.parseInt(object2.toString());
            }
            catch (Exception exception) {
                throw new Error(exception.toString());
            }
            return n - n2;
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

