/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterList;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemCheckBoxSingle;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlFileHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.ExternalConfigurator;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.rbs.bem.wizard.view.NodeResultView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.control.NodeResultController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.model.ModifyModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.view.WelcomeView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.view.WelcomeViewer;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class WelcomeController
extends AbstractApplicationController {
    private static RbsEmPropertiesFileHandler rbsEmProp = RbsEmPropertiesFileHandler.getInstance();
    private static String NCONF_INFO_DIALOG = "Information";
    private WelcomeViewer myView = null;
    private WizardHelper wizardHelp = null;
    private final Class nextController = NodeResultController.class;
    private final Class nextView = NodeResultView.class;
    private final String configurationVersion = WizardCommon.WIZARD_LDN_CONFIGURATIONVERSION;
    private ModifyModel expandModel = null;
    private MoHandler theMoHandler;
    private JButton browseButton = null;
    private ExternalConfigurator theConfigurator = null;
    private static final String ERR_MSG_PARSE = "Error: XML Parsing error. \nProbable cause: \n";
    private static final String tmfFileNameError = "TMF data files have to use the naming convention\nTmfData_S<sectorNumber>_V<versionNumber>.bin";
    private BemCheckBoxSingle checkBoxAddTmdFile;
    private JButton addTmfFilesButton;
    private JButton removeTmfFilesButton;
    private static int maxTmfFileNumber = 3;
    private static int maxNumberOfSectors = 12;

    protected void init() {
        DuwUtil.unSetup();
        ModifyModel.initiate();
        this.expandModel = ModifyModel.getInstance();
        this.theMoHandler = new MoHandlerImpl();
        this.theConfigurator = this.expandModel;
        this.myView = (WelcomeViewer)((Object)this.getView());
        this.myView.getNextButton().addActionListener(new NextButtonListener());
        this.myView.getCancelButton().addActionListener(new CancelButtonListener());
        this.browseButton = (JButton)this.myView.getBrowseButtonComponent();
        this.browseButton.addActionListener(new BrowseButtonListener());
        this.checkBoxAddTmdFile = this.myView.getCheckBoxAddTmfFilesComponent();
        this.checkBoxAddTmdFile.setActionListener(new CheckBoxAddTmfFilesListener(), null);
        this.addTmfFilesButton = this.myView.getButtonAddTmfFilesComponent();
        this.addTmfFilesButton.addActionListener(new AddTmfFilesButtonListener());
        this.removeTmfFilesButton = this.myView.getButtonRemoveTmfFilesComponent();
        this.removeTmfFilesButton.addActionListener(new RemoveTmfFilesButtonListener());
        this.wizardHelp = WizardHelp.getTheInstance();
    }

    protected boolean canStop() {
        return true;
    }

    protected void beforeVisible() {
        boolean bl = WizardLaunchChecker.wizardStarted();
        if (!bl) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    protected void afterVisible() {
        this.setWindowSubTitle();
        try {
            this.setProductData();
            String string = rbsEmProp.getProperty("XML_PATH");
            if (string != null) {
                this.myView.setFilePath(string);
            } else {
                this.myView.setFilePath("");
            }
        }
        catch (Exception exception) {
            this.showError(exception.toString());
        }
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    protected void displayDetailedWarningOkDialog(String string, String string2) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        JTextArea jTextArea = new JTextArea(string2, 10, 50);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jOptionPane.add(jScrollPane);
        String string3 = this.wizardHelp.getPageSubTitle("Modify");
        String string4 = string3 == "" ? NCONF_INFO_DIALOG : string3 + ": " + NCONF_INFO_DIALOG;
        JDialog jDialog = jOptionPane.createDialog(this.getView(), string4);
        jDialog.setVisible(true);
    }

    protected void cancel() {
        WizardLaunchChecker.wizardStopped();
        this.getApplication().stopApplication();
    }

    protected void viewClosing() {
        this.cancel();
    }

    private void setWindowSubTitle() {
        this.myView.setHeaderText("Modify RBS Equipment Configuration");
    }

    public Class getNextControllerClass() {
        return this.nextController;
    }

    public Class getNextViewClass() {
        return this.nextView;
    }

    public String getHelpId() {
        return this.wizardHelp.getHelpId();
    }

    private void setProductData() throws NoSuchFieldException, IOException, WizardException {
        Object object;
        Object object2;
        BemMo bemMo = this.theMoHandler.getMo(this.configurationVersion);
        String string = null;
        String string2 = null;
        try {
            object2 = (BemMo)this.theMoHandler.getAttribute(bemMo, "currentUpgradePackage");
            NalStruct nalStruct = (NalStruct)this.theMoHandler.getAttribute((BemMo)object2, "administrativeData");
            string = (String)nalStruct.getMemberValue("productNumber");
            string2 = (String)nalStruct.getMemberValue("productRevision");
        }
        catch (MoHandlerException moHandlerException) {
            throw new WizardException(moHandlerException.toString());
        }
        object2 = WizardHelp.getTheInstance().getDtdFilePath();
        int n = ((String)object2).lastIndexOf("/");
        int n2 = ((String)object2).lastIndexOf(".");
        String string3 = ((String)object2).substring(n + 1, n2);
        InputStream inputStream = WelcomeController.class.getResourceAsStream((String)object2);
        if (inputStream == null) {
            throw new WizardException("Can not open dtd file=" + (String)object2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = "";
        char[] cArray = new char[4096];
        int n3 = bufferedReader.read(cArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray);
        while (n3 != -1) {
            n3 = bufferedReader.read(cArray);
            stringBuffer.append(cArray);
        }
        string4 = stringBuffer.toString();
        bufferedReader.close();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "<!");
        String string5 = "";
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n4 = ((String)object).indexOf("revision");
            if (n4 == -1) continue;
            int n5 = ((String)object).indexOf("(");
            int n6 = ((String)object).indexOf(")");
            if (n5 == -1 || n6 == -1) continue;
            string5 = ((String)object).substring(n5 + 1, n6);
            break;
        }
        object = ExceptionProperties.getRevisionProperties();
        ((ExceptionProperties)object).setProperty("Upgrade Package Revision", string + " rev " + string2);
        ((ExceptionProperties)object).setProperty("DTD version", "Modify : " + string5);
        String string6 = "Software package\nProduct number: " + string + "\n" + "Product revision: " + string2 + "\n" + "Supported DTD: " + string3 + "\n" + "DTD version: " + string5;
        this.myView.setProductData(string6);
    }

    protected boolean isXmlMadatory() {
        File file;
        boolean bl = true;
        ServiceValue serviceValue = null;
        CustomerParameterList customerParameterList = this.myView.getListTmfFilesComponent();
        if (!(customerParameterList.getNumberOfValues() <= 0 || (file = new File(this.myView.getFilePath())).isFile() && file.canRead())) {
            this.expandModel.setUseFileInput(false);
            bl = false;
            serviceValue = new ServiceValue("NO_XML");
            this.theConfigurator.setServiceValue(serviceValue);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean parseXML() {
        boolean bl = false;
        XmlFileHandler xmlFileHandler = null;
        ServiceValue serviceValue = null;
        ServiceCommon.initate();
        try {
            xmlFileHandler = XmlFileHandler.getInstance();
            serviceValue = xmlFileHandler.startParsing(this.myView.getFilePath(), this.wizardHelp.getDtdFilePath());
            this.theConfigurator.setServiceValue(serviceValue);
            if (serviceValue.hasDeprecationWarnings()) {
                String string = serviceValue.getDeprecationReport();
                this.displayDetailedWarningOkDialog("Deprecation warning\n\nSome of the parameters in input file relate to an old format.\nThese parameters have been successfully converted to the latest format.", string);
            }
            bl = true;
        }
        catch (BemXmlException bemXmlException) {
            this.reportException(bemXmlException, ERR_MSG_PARSE);
            bl = false;
        }
        catch (Exception exception) {
            this.reportException(exception, ERR_MSG_PARSE);
            bl = false;
        }
        finally {
            xmlFileHandler = null;
            serviceValue = null;
        }
        return bl;
    }

    public void reportException(Exception exception, String string) {
        ExceptionProperties exceptionProperties = ExceptionProperties.getProperties(exception);
        exceptionProperties.prependProperty("Problem", string, " - ");
        this.getEasyPopUp().displayError(exception);
    }

    private void updateRbsEmProperties() {
        String string = this.myView.getFilePath();
        JFileChooser jFileChooser = new JFileChooser(string);
        File file = jFileChooser.getCurrentDirectory();
        rbsEmProp.setProperty("XML_PATH", file.getPath());
        rbsEmProp.storeBemPropInFile();
    }

    private boolean checkTmfInputConsistency(String string) {
        boolean bl = true;
        String string2 = System.getProperty("file.separator");
        String string3 = string.substring(string.lastIndexOf(string2) + 1);
        String[] stringArray = string3.split("_");
        if (stringArray.length != 3) {
            bl = false;
            this.displayError(tmfFileNameError);
            return bl;
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        String string6 = stringArray[2];
        if (!(string4.equals("TmfData") && string5.startsWith("S") && string6.startsWith("V"))) {
            this.displayError(tmfFileNameError);
            bl = false;
        }
        return bl;
    }

    private int getSectorNumberFromTmfFileName(String string) {
        int n = 0;
        String string2 = System.getProperty("file.separator");
        String string3 = string.substring(string.lastIndexOf(string2) + 1);
        String[] stringArray = string3.split("_");
        String string4 = stringArray[1];
        n = Integer.valueOf(string4.substring(string4.indexOf("S") + 1));
        if (n < 0 || n > maxNumberOfSectors) {
            n = 0;
        }
        return n;
    }

    public void displayWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "Warning", 2);
    }

    public void displayError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    class RemoveTmfFilesButtonListener
    implements ActionListener {
        RemoveTmfFilesButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeViewer welcomeViewer = (WelcomeViewer)((Object)WelcomeController.this.getView());
            CustomerParameterList customerParameterList = welcomeViewer.getListTmfFilesComponent();
            customerParameterList.removeElement(customerParameterList.getSelectedValue());
            if (customerParameterList.getNumberOfValues() == 0) {
                welcomeViewer.getButtonRemoveTmfFilesComponent().setEnabled(false);
            }
            welcomeViewer.getButtonAddTmfFilesComponent().setEnabled(true);
        }
    }

    class AddTmfFilesButtonListener
    implements ActionListener {
        AddTmfFilesButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = System.getProperties();
            String string = (String)properties.get(BemLanguageHelp.getTranslation("USER_HOME"));
            JFileChooser jFileChooser = new JFileChooser(string);
            BemFileFilter bemFileFilter = new BemFileFilter("bin", "BIN files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Open Configuration File");
            int n = jFileChooser.showDialog((JButton)actionEvent.getSource(), "Open");
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                WelcomeViewer welcomeViewer = (WelcomeViewer)((Object)WelcomeController.this.getView());
                CustomerParameterList customerParameterList = welcomeViewer.getListTmfFilesComponent();
                if (!customerParameterList.checkObjectContains(string2)) {
                    if (WelcomeController.this.checkTmfInputConsistency(string2) && customerParameterList.getNumberOfValues() < maxTmfFileNumber) {
                        customerParameterList.addElement(string2);
                        welcomeViewer.getButtonRemoveTmfFilesComponent().setEnabled(true);
                        if (customerParameterList.getNumberOfValues() == maxTmfFileNumber) {
                            welcomeViewer.getButtonAddTmfFilesComponent().setEnabled(false);
                        }
                    }
                } else {
                    WelcomeController.this.displayWarningMessage("This TMF file is already in TMF file List!");
                }
            }
        }
    }

    class CheckBoxAddTmfFilesListener
    implements ActionListener {
        CheckBoxAddTmfFilesListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeView welcomeView = (WelcomeView)WelcomeController.this.myView;
            boolean bl = welcomeView.isTmfFileToAdd();
            WelcomeController.this.expandModel.setTmfFilesToAdd(bl);
            if (!bl) {
                CustomerParameterList customerParameterList = WelcomeController.this.myView.getListTmfFilesComponent();
                customerParameterList.cleanList();
            }
            welcomeView.setTmfFilesPanel(bl);
        }
    }

    class BrowseButtonListener
    implements ActionListener {
        BrowseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = WelcomeController.this.myView.getFilePath();
            JFileChooser jFileChooser = new JFileChooser(string);
            BemFileFilter bemFileFilter = new BemFileFilter("xml", "XML files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Open Configuration File");
            int n = jFileChooser.showOpenDialog(WelcomeController.this.browseButton);
            if (n == 0) {
                String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                WelcomeController.this.myView.setFilePath(string2);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeController.this.cancel();
        }
    }

    class NextButtonListener
    implements ActionListener {
        NextButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object[][] objectArray = new String[0][0];
            WelcomeController.this.updateRbsEmProperties();
            WelcomeController.this.expandModel.setUseFileInput(true);
            WelcomeController.this.expandModel.setUseWizard(false);
            CustomerParameterList customerParameterList = WelcomeController.this.myView.getListTmfFilesComponent();
            StringBuffer stringBuffer = new StringBuffer();
            int[] nArray = new int[maxTmfFileNumber];
            for (n = 0; n < customerParameterList.getNumberOfValues(); ++n) {
                String string = customerParameterList.getELementAt(n).toString();
                nArray[n] = WelcomeController.this.getSectorNumberFromTmfFileName(string);
                stringBuffer.append(customerParameterList.getELementAt(n).toString()).append("\n");
            }
            WelcomeController.this.expandModel.setTmfFiles(stringBuffer.toString());
            WelcomeController.this.expandModel.setUninitAndInitSectorNumberList(nArray);
            n = 0;
            n = !WelcomeController.this.isXmlMadatory() ? 1 : (int)(WelcomeController.this.parseXML() ? 1 : 0);
            if (n != 0) {
                WelcomeController.this.startWizard(false, "MODIFY_RBS_CONFIGURATION_HEADING", null, WelcomeController.this.getNextViewClass(), WelcomeController.this.getNextControllerClass(), objectArray);
                WelcomeController.this.myView.setTheViewToDummy();
            }
        }
    }
}

