/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemGuiComponents;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemIntegerField;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemTimeField;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.TimeSelector;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.BemCalendar;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.OamCustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.OamGuiComponentErrorManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.TimeSettingViewer;
import se.ericsson.wcdma.support.gui.gengui.SyntaxException;

public class TimeSettingController
extends BemWizardGuiController
implements CustomerParameterListener,
OamGuiComponentErrorManager {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private static final String[] monthLiteralsEnglish = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private TimeSettingViewer view = null;
    private boolean isListenerEnabled = true;
    private UtcTimeSetListener utcTimeSetListener = null;
    private TimeSelector theTimeSelector = null;
    private WizardCIModel oamCIModel;
    private Rbs rbs;
    private MoHandler theMoHandler = null;
    private BemGuiComponents oldGuiComponents = null;
    private BemTimeField utcTimeStringField = null;
    private final String[] dayLiterals = new String[31];
    private BemComboBox dayComboBox = null;
    private BemComboBox monthComboBox = null;
    private BemIntegerField yearIntegerField = null;
    private BemCalendar timeNode = new BemCalendar();
    private boolean timeSet = false;
    private final String[] allCPNames = new String[]{"primaryNtpServerIpAddress", "primaryNtpServiceActive", "secondaryNtpServerIpAddress", "secondaryNtpServiceActive", "daylightSavingTime", "localTimeZone"};
    private CustomerParameterPanel[] newGuiComponents = null;
    private Hashtable allCPs = null;
    private CustomerParameter ntpServerPrimaryIpActiveCP = null;
    private CustomerParameter ntpServerSecondaryIpActiveCP = null;
    private boolean alreadyRun = false;
    OamCustomerParameterComboBox localTimeZoneField = null;

    protected void init() {
        try {
            this.view = (TimeSettingViewer)((Object)super.getView());
            this.wizardHelp = WizardHelp.getTheInstance();
            this.setWindowTitle();
            this.oamCIModel = OamCIModel.getInstance();
            this.rbs = this.oamCIModel.getRbs();
            this.theMoHandler = this.rbs.getMoHandler();
            this.theTimeSelector = (TimeSelector)((Object)this.oamCIModel);
            this.oldGuiComponents = new BemGuiComponents();
            this.createOldComponents();
            this.updateOldComponentsFromModel();
            this.view.setBemComponents(this.oldGuiComponents);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "init()", null, "Setting up window for input", exception);
            super.displayError(wizardException);
        }
    }

    protected void afterVisible() {
        this.isListenerEnabled = false;
        try {
            boolean bl;
            if (!this.alreadyRun) {
                this.getAllCPs(this.allCPNames);
                this.newGuiComponents = this.createNewGuiComponents();
                this.view.setBemComponents(this.newGuiComponents);
                this.alreadyRun = true;
            }
            this.view.enableUtcTime(!(bl = this.isPrimaryOrSecondaryNtpActiveSet()));
            this.localTimeZoneField.addListener();
            this.ntpServerPrimaryIpActiveCP.addCustomerParameterListener(this);
            this.ntpServerSecondaryIpActiveCP.addCustomerParameterListener(this);
            this.utcTimeSetListener = new UtcTimeSetListener();
            JButton jButton = this.view.getUtcTimeSetButton();
            jButton.addActionListener(this.utcTimeSetListener);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            super.displayError(wizardException);
        }
        this.isListenerEnabled = true;
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected boolean cancel() {
        this.removeListeners();
        return super.cancel();
    }

    private void removeListeners() {
        JButton jButton = this.view.getUtcTimeSetButton();
        jButton.removeActionListener(this.utcTimeSetListener);
        this.utcTimeSetListener = null;
        this.ntpServerPrimaryIpActiveCP.removeCustomerParameterListener(this);
        this.ntpServerSecondaryIpActiveCP.removeCustomerParameterListener(this);
        this.localTimeZoneField.removeListener();
    }

    private List createAllCpNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.allCPNames) {
            arrayList.add(string);
        }
        return arrayList;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.removeListeners();
            List list = this.createAllCpNamesList();
            this.rbs.checkConsistency("ServerConfigCI", list);
            if (this.timeSet) {
                this.theTimeSelector.setNodeTimeStamp(this.timeNode);
            }
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            this.displayError(customerParameterException);
            this.setFocusOnNewComponent(string);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        this.removeListeners();
        return true;
    }

    private void setFocusOnNewComponent(String string) {
        for (CustomerParameterPanel customerParameterPanel : this.newGuiComponents) {
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            customerParameterPanel.requestFocus();
        }
    }

    private void createOldComponents() {
        this.utcTimeStringField = new BemTimeField(WizardLanguageHelp.getTranslation("NCONF_TIM_UTC_TIME_LABEL"), false, 8, "time", "nodeUTCTime");
        this.utcTimeStringField.setToolTip(WizardLanguageHelp.getTranslation("NCONF_SITE_TIME_TIME"));
        this.addOldGuiComponent(this.utcTimeStringField);
        for (int i = 0; i < 31; ++i) {
            this.dayLiterals[i] = Integer.valueOf(i + 1).toString();
        }
        this.dayComboBox = new BemComboBox(WizardLanguageHelp.getTranslation("NCONF_TIM_DAY"), this.dayLiterals, false, false, "day", "");
        this.addOldGuiComponent(this.dayComboBox);
        this.yearIntegerField = new BemIntegerField(WizardLanguageHelp.getTranslation("NCONF_TIM_YEAR"), 1970, 9999, false, 4, "year", "");
        this.yearIntegerField.setToolTip(WizardLanguageHelp.getTranslation("NCONF_SITE_TIME_YEAR"));
        this.addOldGuiComponent(this.yearIntegerField);
        this.monthComboBox = new BemComboBox(WizardLanguageHelp.getTranslation("NCONF_TIM_MONTH"), monthLiteralsEnglish, false, false, "month", "");
        this.addOldGuiComponent(this.monthComboBox);
    }

    private void updateOldComponentsFromModel() throws MoHandlerException {
        if (this.theTimeSelector.hasUserEnteredTime()) {
            this.timeNode = this.theTimeSelector.getNodeTimeStamp();
        } else {
            Long l = null;
            BemMo bemMo = this.theMoHandler.getMo(BemLdn.LDN_MANAGEDELEMENTDATA);
            l = (Long)this.theMoHandler.getAttribute(bemMo, "nodeUTCTime");
            if (l != null) {
                this.setUtcTimeFromNode(l);
            }
        }
    }

    protected void addOldGuiComponent(Object object) {
        this.oldGuiComponents.addComponent(object);
    }

    private void setUtcTimeFromNode(long l) {
        this.timeNode.setUtcTime(l);
        int n = this.timeNode.get(1);
        int n2 = this.timeNode.get(2);
        int n3 = this.timeNode.get(5);
        try {
            this.yearIntegerField.setValue(n);
            this.monthComboBox.setValue(monthLiteralsEnglish[n2]);
            this.dayComboBox.setValue(String.valueOf(n3));
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }

    public void utcTimeSetListenerLogic() {
        boolean bl = this.checkTimeSettingSyntax();
        if (bl) {
            this.setUtcTime();
        }
    }

    public void setUtcTime() {
        Integer n = this.yearIntegerField.getValue();
        int n2 = this.monthComboBox.getSelectedIndex();
        String string = this.dayComboBox.getValue();
        String string2 = this.utcTimeStringField.getHour();
        String string3 = this.utcTimeStringField.getMinute();
        String string4 = this.utcTimeStringField.getSecond();
        if (n != null && string != null && string2 != null && string3 != null && string4 != null) {
            this.timeNode.setLocalTime(n, n2, Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4));
            this.timeSet = true;
        }
    }

    private boolean checkTimeSettingSyntax() {
        boolean bl = true;
        JPanel jPanel = null;
        Integer n = this.yearIntegerField.getValue();
        if (n == null) {
            jPanel = this.yearIntegerField;
            bl = false;
        } else {
            jPanel = this.utcTimeStringField;
            bl = jPanel.isCorrectSyntax("GUI");
        }
        if (!bl) {
            jPanel.setFocus();
            this.displayErrorMessage("Incorrect input, the field must be filled in for correct time setting\nPlease fill in a valid value!");
        }
        return bl;
    }

    private CustomerParameterPanel[] createNewGuiComponents() {
        CustomerParameterPanel customerParameterPanel;
        CustomerParameterPanel[] customerParameterPanelArray = new CustomerParameterPanel[6];
        Object object = (CustomerParameter)this.allCPs.get("primaryNtpServerIpAddress");
        JComponent jComponent = new CustomerParameterTextField((CustomerParameter)object);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[0] = customerParameterPanel = new CustomerParameterPanel("Server address:", (CustomerParameterComponent)((Object)jComponent), false);
        this.ntpServerPrimaryIpActiveCP = (CustomerParameter)this.allCPs.get("primaryNtpServiceActive");
        object = new CustomerParameterCheckbox("", (YesNoCustomerParameter)this.ntpServerPrimaryIpActiveCP);
        jComponent = new CustomerParameterPanel("Service active:", (CustomerParameterComponent)object, false);
        customerParameterPanelArray[1] = jComponent;
        object = (CustomerParameter)this.allCPs.get("secondaryNtpServerIpAddress");
        jComponent = new CustomerParameterTextField((CustomerParameter)object);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[2] = customerParameterPanel = new CustomerParameterPanel("Server address:", (CustomerParameterComponent)((Object)jComponent), false);
        this.ntpServerSecondaryIpActiveCP = (CustomerParameter)this.allCPs.get("secondaryNtpServiceActive");
        object = new CustomerParameterCheckbox("", (YesNoCustomerParameter)this.ntpServerSecondaryIpActiveCP);
        jComponent = new CustomerParameterPanel("Service active:", (CustomerParameterComponent)object, false);
        customerParameterPanelArray[3] = jComponent;
        object = (CustomerParameter)this.allCPs.get("daylightSavingTime");
        jComponent = new CustomerParameterCheckbox("", (YesNoCustomerParameter)object);
        customerParameterPanelArray[4] = customerParameterPanel = new CustomerParameterPanel("Daylight saving time:", (CustomerParameterComponent)((Object)jComponent), false);
        object = (CustomerParameter)this.allCPs.get("localTimeZone");
        this.localTimeZoneField = new OamCustomerParameterComboBox((Enumeration)object, this);
        jComponent = new CustomerParameterPanel("Local time zone:", this.localTimeZoneField, false);
        customerParameterPanelArray[5] = jComponent;
        return customerParameterPanelArray;
    }

    private void getAllCPs(String[] stringArray) throws BemException {
        this.allCPs = new Hashtable();
        for (String string : stringArray) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            this.allCPs.put(string, customerParameter);
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        String string;
        if (parameterEvent.isValueChanged() && ((string = customerParameter.getName()).equalsIgnoreCase(this.ntpServerPrimaryIpActiveCP.getName()) || string.equalsIgnoreCase(this.ntpServerSecondaryIpActiveCP.getName()))) {
            boolean bl = this.isPrimaryOrSecondaryNtpActiveSet();
            this.view.enableUtcTime(!bl);
        }
    }

    private boolean isPrimaryOrSecondaryNtpActiveSet() {
        boolean bl = false;
        String string = this.ntpServerPrimaryIpActiveCP.getValue();
        boolean bl2 = string.equalsIgnoreCase("YES");
        String string2 = this.ntpServerSecondaryIpActiveCP.getValue();
        boolean bl3 = string2.equalsIgnoreCase("YES");
        bl = bl2 | bl3;
        return bl;
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    public void handleSetError(Exception exception) {
        this.showError("Problem to set component. Reason=" + exception.toString());
    }

    class UtcTimeSetListener
    implements ActionListener {
        private Timer utcTimer = new Timer(500, this);

        public UtcTimeSetListener() {
            this.utcTimer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TimeSettingController.this.isListenerEnabled) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("utcTimeSet")) {
                    TimeSettingController.this.utcTimeSetListenerLogic();
                } else {
                    String string = TimeSettingController.this.timeNode.toString();
                    TimeSettingController.this.view.setUtcTimeNow(string);
                }
            }
        }
    }
}

