/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemGuiComponents;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemIntegerField;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemTimeField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.TimeSettingViewer;
import se.ericsson.wcdma.support.gui.gengui.GenLeftRightPanel;

public class TimeSettingView
extends BemWizardGuiView
implements TimeSettingViewer {
    private final JPanel mainPanel = new JPanel();
    private final JPanel utcTimePanel = new JPanel();
    private final GenLeftRightPanel timeComponentPanel = new GenLeftRightPanel();
    private final JPanel ntpPrimaryServerPanel = new JPanel();
    private final JPanel ntpSecondaryServerPanel = new JPanel();
    private final JLabel utcDateLabel = new JLabel();
    private final GridBagLayout utcTimePanelGridBagLayout = new GridBagLayout();
    private BemTimeField utcTimeStringField = null;
    private BemIntegerField yearIntegerField = null;
    private BemComboBox dayComboBox = null;
    private BemComboBox monthComboBox = null;
    private final JButton utcTimeSetButton = new JButton();
    private CustomerParameterPanel[] newGuiComponents = null;

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.mainPanel);
        this.utcTimePanel.setLayout(this.utcTimePanelGridBagLayout);
        this.arrangeTimePanel();
        this.arrangeNtpServerPanels();
        this.utcTimePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), WizardLanguageHelp.getTranslation("NCONF_TIM_UTC_TIME")));
        this.mainPanel.add((Component)this.ntpPrimaryServerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.mainPanel.add((Component)this.ntpSecondaryServerPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.mainPanel.add((Component)this.utcTimePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
    }

    private void arrangeTimePanel() {
        this.utcTimeSetButton.setText(WizardLanguageHelp.getTranslation("NCONF_TIM_UTC_TIME_SET_BUTTON"));
        this.utcTimeSetButton.setActionCommand("utcTimeSet");
        this.utcDateLabel.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.utcTimePanel.add((Component)this.utcDateLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.utcTimePanel.add((Component)this.utcTimeSetButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 50), 0, 0));
        this.utcTimePanel.add((Component)this.timeComponentPanel, new GridBagConstraints(0, 1, 2, 4, 1.0, 1.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void arrangeNtpServerPanels() {
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_TIM_PRIMARY_SERVER");
        this.ntpPrimaryServerPanel.setBorder(titledBorder);
        this.ntpPrimaryServerPanel.setLayout(new GridBagLayout());
        this.ntpPrimaryServerPanel.setToolTipText("BEM_OAM_NTP_PRIMARY_SERVER");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_TIM_SECONDARY_SERVER");
        this.ntpSecondaryServerPanel.setBorder(titledBorder2);
        this.ntpSecondaryServerPanel.setLayout(new GridBagLayout());
    }

    protected void setupHeadingWeight() {
        this.headingWeightX = 0.0;
        this.headingWeightY = 0.0;
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_TIM_SERVER_CONFIGURATION");
    }

    public JButton getUtcTimeSetButton() {
        return this.utcTimeSetButton;
    }

    public void setUtcTimeNow(String string) {
        this.utcDateLabel.setText(string);
    }

    public void enableUtcTime(boolean bl) {
        this.utcTimeSetButton.setEnabled(bl);
        this.utcTimeStringField.setEnabled(bl);
        this.dayComboBox.setEnabled(bl);
        this.monthComboBox.setEnabled(bl);
        this.yearIntegerField.setEnabled(bl);
    }

    public void addOldComponentsToPanels() {
        this.timeComponentPanel.addLeft(this.utcTimeStringField);
        this.timeComponentPanel.addLeft(this.dayComboBox);
        this.timeComponentPanel.addLeft(this.monthComboBox);
        this.timeComponentPanel.addLeft(this.yearIntegerField);
    }

    public void addNewComponentsToPanels() {
        JPanel jPanel = this.getTimeRightPanel();
        this.timeComponentPanel.addRight(jPanel);
        JPanel jPanel2 = this.getNtpServerPanel(0);
        this.ntpPrimaryServerPanel.add(jPanel2);
        JPanel jPanel3 = this.getNtpServerPanel(1);
        this.ntpSecondaryServerPanel.add(jPanel3);
    }

    public void setBemComponents(BemGuiComponents bemGuiComponents) throws BemException {
        this.utcTimeStringField = (BemTimeField)bemGuiComponents.getComponent("time");
        this.yearIntegerField = (BemIntegerField)bemGuiComponents.getComponent("year");
        this.dayComboBox = (BemComboBox)bemGuiComponents.getComponent("day");
        this.monthComboBox = (BemComboBox)bemGuiComponents.getComponent("month");
        this.addOldComponentsToPanels();
    }

    public void setBemComponents(CustomerParameterPanel[] customerParameterPanelArray) {
        this.newGuiComponents = customerParameterPanelArray;
        this.addNewComponentsToPanels();
    }

    private JPanel getNtpServerPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        String string = null;
        String string2 = null;
        if (n == 0) {
            string = "primaryNtpServerIpAddress";
            string2 = "primaryNtpServiceActive";
        } else {
            string = "secondaryNtpServerIpAddress";
            string2 = "secondaryNtpServiceActive";
        }
        CustomerParameterPanel customerParameterPanel = this.getCustomerParameterPanel(string);
        CustomerParameterPanel customerParameterPanel2 = this.getCustomerParameterPanel(string2);
        customerParameterPanel.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        customerParameterPanel2.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)customerParameterPanel2.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)customerParameterPanel2, gridBagConstraints);
        return jPanel;
    }

    private CustomerParameterPanel getCustomerParameterPanel(String string) {
        CustomerParameterPanel customerParameterPanel = null;
        for (CustomerParameterPanel customerParameterPanel2 : this.newGuiComponents) {
            if (!customerParameterPanel2.containCustomerParameter(string)) continue;
            customerParameterPanel = customerParameterPanel2;
            break;
        }
        return customerParameterPanel;
    }

    private JPanel getTimeRightPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        CustomerParameterPanel customerParameterPanel = this.getCustomerParameterPanel("daylightSavingTime");
        CustomerParameterPanel customerParameterPanel2 = this.getCustomerParameterPanel("localTimeZone");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)customerParameterPanel2.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)customerParameterPanel2, gridBagConstraints);
        return jPanel;
    }
}

