/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.BatteryChargingViewer;

public class BatteryChargingController
extends BemWizardGuiController {
    private BatteryChargingViewer myView = null;
    private WizardCIModel wizardCiModel = null;
    private final List batteryBackUpParameterNames = new ArrayList();
    boolean isCommonRbs = false;

    protected void init() {
        this.myView = (BatteryChargingViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected void afterVisible() {
        try {
            Rbs rbs = this.wizardCiModel.getRbs();
            PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)((Object)rbs.getConfigItem("PowerSystemCI"));
            this.isCommonRbs = false;
            if (powerSupplyProvider != null) {
                this.isCommonRbs = powerSupplyProvider.isSupportSystemAvailable();
            }
            if (this.isCommonRbs) {
                this.handleBatteryBackUp(rbs);
            }
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Error has occured", exception);
            this.displayError(exception);
        }
    }

    protected boolean next() {
        boolean bl = true;
        try {
            Rbs rbs = this.wizardCiModel.getRbs();
            rbs.checkConsistency("PowerSystemCI", this.batteryBackUpParameterNames);
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }

    private void handleBatteryBackUp(Rbs rbs) throws Exception {
        IntegerParameter integerParameter = null;
        IntegerParameter integerParameter2 = null;
        IntegerParameter integerParameter3 = null;
        IntegerParameter integerParameter4 = null;
        IntegerParameter integerParameter5 = null;
        IntegerParameter integerParameter6 = null;
        IntegerParameter integerParameter7 = null;
        IntegerParameter integerParameter8 = null;
        IntegerParameter integerParameter9 = null;
        IntegerParameter integerParameter10 = null;
        IntegerParameter integerParameter11 = null;
        IntegerParameter integerParameter12 = null;
        IntegerParameter integerParameter13 = null;
        integerParameter = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "chargingVoltage");
        this.batteryBackUpParameterNames.add(integerParameter.getName());
        integerParameter2 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "tempCompVoltageSlope");
        this.batteryBackUpParameterNames.add(integerParameter2.getName());
        integerParameter3 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "nominalTemp");
        this.batteryBackUpParameterNames.add(integerParameter3.getName());
        integerParameter4 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "tempCompMinVoltage");
        this.batteryBackUpParameterNames.add(integerParameter4.getName());
        integerParameter5 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "tempCompMaxVoltage");
        this.batteryBackUpParameterNames.add(integerParameter5.getName());
        integerParameter6 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "increasedChargeVoltage");
        this.batteryBackUpParameterNames.add(integerParameter6.getName());
        integerParameter7 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "boostChargeTime");
        this.batteryBackUpParameterNames.add(integerParameter7.getName());
        integerParameter8 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "boostChargeTriggerVoltage");
        this.batteryBackUpParameterNames.add(integerParameter8.getName());
        integerParameter9 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "equalizeChargeTime");
        this.batteryBackUpParameterNames.add(integerParameter9.getName());
        integerParameter10 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "equalizeChargeCyclicInterval");
        this.batteryBackUpParameterNames.add(integerParameter10.getName());
        integerParameter11 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "intermittentChargeConnectVoltage");
        this.batteryBackUpParameterNames.add(integerParameter11.getName());
        integerParameter12 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "intermittentChargeConnectTime");
        this.batteryBackUpParameterNames.add(integerParameter12.getName());
        integerParameter13 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "intermittentChargeDisconnectTime");
        this.batteryBackUpParameterNames.add(integerParameter13.getName());
        this.myView.setBatteryBackUpParameters(integerParameter, integerParameter2, integerParameter3, integerParameter4, integerParameter5, integerParameter6, integerParameter7, integerParameter8, integerParameter9, integerParameter10, integerParameter11, integerParameter12, integerParameter13);
    }
}

