/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.UseCellParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.control.GuiCheckAndShowWarning;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.AntennaBranchController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.AntennaCablesController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.RetCascadingController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SectorAntennaView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SectorAntennaViewer;

public class SectorAntennaController
extends BemWizardGuiController {
    private SectorAntennaViewer myView;
    private final List<String> customerParameterNames = new ArrayList<String>();
    private final HashMap<String, String> sectorAntennaNames = new HashMap();
    private WizardCIModel wizardCiModel;
    private Rbs rbs;
    private boolean[] canHaveTma = new boolean[]{false, false};
    private JTable sectorAntennaOverviewTable;
    private int selectedRow = 0;
    private int selectedColumn = 0;
    private Vector activeSectors;
    public static final int MANDATORY_INPUT = 0;
    public static final int OPTIONAL_INPUT = 1;
    public static final int CONFIGUTED_INPUT = 2;
    public static final int NA_INPUT = 3;
    public static final int INCORRECT_INPUT = 4;
    public int[][] sectorAntennaState;
    private String tmaType = "NONE";
    private RadioEquipmentProvider[] radioEquipmentProvider = new RadioEquipmentProvider[2];
    private static final int maxSectorAntenna = 3;
    private static final String NONE_STRING = "NONE";
    private static final String ASC_STRING = "ASC";
    private static final String TMA_STRING = "TMA";
    private static final String ATMA_STRING = "ATMA";
    private static final String ATMA_AND_TMA_STRING = "ATMA_AND_TMA";
    private static final String TMF_STRING = "TMF";
    private static final String ARETU_STRING = "ARETU";
    private static final String ARETU_CASCADE_STRING = "ARETU_CASCADE";
    private static final int ascParamNum = 1;
    private static final int atmaParamNum = 5;
    private static final int atmaAndTmaParamNum = 11;
    private static final int tmaParamNum = 15;
    private static final int ANTENNA_TYPE_VALUE_CFG = 50;
    private int[] equipedSectors = null;
    private TmaTypeListener tmaTypeListener = null;
    private AtmaTypeListener atmaTypeListener = null;
    private TypeOfRetListener typeOfRetListener = null;
    private TypeOfAntennaListener typeOfAntennaListener = null;
    private SectorAntennaConfigurationTableListener sectorAntennaConfigurationTableListener = null;
    private static Map<String, String> tmaTypeSeq = new HashMap<String, String>();
    private static Map<String, String> bandsOfAtmaValueSeq = new HashMap<String, String>();
    private static String bandsOfAtmaValue = "0";
    private static final String TMA_TYPE_EQUALS_ATMA = "1";
    private static final String TMA_TYPE_NOT_EQUALS_ATMA = "0";
    private static final String BANDS_OF_ATMA_DEFAULT_VALUE = "0";
    private static final String BANDS_OF_ATMA_NOT_DEFAULT_VALUE = "1";
    private static final String BANDS_OF_ATMA_INVALID_VALUE = "2";

    protected void init() {
        this.myView = (SectorAntennaViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
        ((SectorAntennaView)this.getView()).setController(this);
        this.rbs = this.wizardCiModel.getRbs();
        this.initEquipedSectors();
        this.atmaTypeListener = new AtmaTypeListener(this);
        this.tmaTypeListener = new TmaTypeListener(this);
        this.typeOfRetListener = new TypeOfRetListener(this);
        this.typeOfAntennaListener = new TypeOfAntennaListener(this);
        this.sectorAntennaConfigurationTableListener = new SectorAntennaConfigurationTableListener(this);
    }

    private void initEquipedSectors() {
        if (this.rbs == null) {
            this.rbs = this.wizardCiModel.getRbs();
        }
        this.radioEquipmentProvider[0] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class);
        int[] nArray = this.radioEquipmentProvider[0].getEquippedSectors();
        if (this.rbs.isPantherHybridRbs()) {
            this.radioEquipmentProvider[1] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, 1);
            int[] nArray2 = this.radioEquipmentProvider[1].getEquippedSectors();
            this.equipedSectors = WizardHelp.mergeIntArray(nArray, nArray2);
        } else {
            this.equipedSectors = nArray;
        }
        this.sectorAntennaState = new int[this.equipedSectors.length][3];
        block0: for (int i = 0; i < this.equipedSectors.length; ++i) {
            int n = 0;
            while (true) {
                if (n >= 3) continue block0;
                if (this.sectorAntennaState[i][n] != 2) {
                    this.sectorAntennaState[i][n] = 1;
                }
                ++n;
            }
        }
    }

    private void addTmaAndRetTypeListener() throws BemException {
        block0: for (int i = 0; i < this.equipedSectors.length; ++i) {
            int n = this.equipedSectors[i];
            String string = MessageFormat.format("S{0}_", String.valueOf(n));
            int n2 = 1;
            while (true) {
                CustomerParameter customerParameter;
                if (n2 > 3) continue block0;
                String string2 = n2 > 1 ? String.valueOf(n2) : "";
                String string3 = null;
                if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
                    string3 = string + "tmaType" + string2;
                    if (this.rbs.isParameterSupported(string3)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.addCustomerParameterListener(this.tmaTypeListener);
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    }
                    if (this.rbs.isParameterSupported(string3 = string + "bandsOfAtma" + string2)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.addCustomerParameterListener(this.atmaTypeListener);
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    }
                    if (this.rbs.isParameterSupported(string3 = string + "antennaType" + string2)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.addCustomerParameterListener(this.typeOfAntennaListener);
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string + "typeOfRet" + string2)) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    customerParameter.addCustomerParameterListener(this.typeOfRetListener);
                    customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                    this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                }
                ++n2;
            }
        }
    }

    private void removeTmaAndRetTypeListener() throws BemException {
        block0: for (int i = 0; i < this.equipedSectors.length; ++i) {
            int n = this.equipedSectors[i];
            String string = MessageFormat.format("S{0}_", String.valueOf(n));
            int n2 = 1;
            while (true) {
                if (n2 > 3) continue block0;
                String string2 = n2 > 1 ? String.valueOf(n2) : "";
                String string3 = null;
                if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
                    CustomerParameter customerParameter;
                    string3 = string + "tmaType" + string2;
                    if (this.rbs.isParameterSupported(string3)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.removeCustomerParameterListener(this.tmaTypeListener);
                        customerParameter.removeCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                    }
                    if (this.rbs.isParameterSupported(string3 = string + "bandsOfAtma" + string2)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.removeCustomerParameterListener(this.atmaTypeListener);
                        customerParameter.removeCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                    }
                    if (this.rbs.isParameterSupported(string3 = string + "antennaType" + string2)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.removeAllCustomerParameterListeners();
                    }
                    if (this.rbs.isParameterSupported(string3 = string + "typeOfRet" + string2)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        customerParameter.removeCustomerParameterListener(this.typeOfRetListener);
                        customerParameter.removeCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                    }
                }
                ++n2;
            }
        }
    }

    protected void beforeVisible() {
        try {
            this.initEquipedSectors();
            AntennaSystemProvider[] antennaSystemProviderArray = new AntennaSystemProvider[2];
            antennaSystemProviderArray[0] = (AntennaSystemProvider)this.rbs.getProvider(AntennaSystemProvider.class);
            this.canHaveTma[0] = antennaSystemProviderArray[0].canHaveTma();
            if (this.rbs.isPantherHybridRbs()) {
                antennaSystemProviderArray[1] = (AntennaSystemProvider)this.rbs.getProvider(AntennaSystemProvider.class, 1);
                this.canHaveTma[1] = antennaSystemProviderArray[1].canHaveTma();
            }
            this.arrangeSectorAntennaOverviewTable(this.equipedSectors);
            this.sectorAntennaConfigurationTableListener.clearCustomerParameterCheckList();
            if (!this.rbs.isPantherHybridRbs() && this.canHaveTma[0] || this.rbs.isPantherHybridRbs() && this.canHaveTma[0] || this.rbs.isPantherHybridRbs() && this.canHaveTma[1]) {
                this.addTmaAndRetTypeListener();
            }
            this.checkInputValidation();
            this.changeTableCellStatus();
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised("Error has occured", bemException);
            this.displayErrorMessage(bemException.toString());
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Error has occured", exception);
            this.displayErrorMessage(exception.toString());
        }
    }

    private void arrangeSectorAntennaOverviewTable(int[] nArray) throws BemException {
        int n;
        Vector<String> vector = new Vector<String>();
        this.activeSectors = new Vector();
        vector.add("Sector Antenna");
        for (int i = 0; i < nArray.length; ++i) {
            String string = String.valueOf(nArray[i]);
            vector.add("Sector " + string);
            this.activeSectors.add(string);
        }
        String[] stringArray = vector.toArray(new String[vector.size()]);
        Object[][] objectArray = new Object[3][stringArray.length];
        for (n = 0; n < 3; ++n) {
            objectArray[n][0] = Integer.valueOf(n + 1).toString();
        }
        block2: for (n = 1; n < stringArray.length; ++n) {
            int n2 = 0;
            while (true) {
                if (n2 >= 3) continue block2;
                objectArray[n2][n] = "";
                ++n2;
            }
        }
        this.sectorAntennaOverviewTable = this.myView.setSectorAntennaOverviewTableParameters(objectArray, stringArray);
        ListSelectionModel listSelectionModel = this.sectorAntennaOverviewTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = SectorAntennaController.this.sectorAntennaOverviewTable.getSelectedRows();
                int[] nArray2 = SectorAntennaController.this.sectorAntennaOverviewTable.getSelectedColumns();
                if (nArray.length > 0 && nArray2.length > 0) {
                    SectorAntennaController.this.selectedRow = nArray[0];
                    SectorAntennaController.this.selectedColumn = nArray2[0];
                } else {
                    SectorAntennaController.this.selectedRow = 0;
                    SectorAntennaController.this.selectedColumn = 0;
                }
                try {
                    SectorAntennaController.this.arrangeSectorAntennaTable();
                    if (SectorAntennaController.this.selectedColumn == 0) {
                        SectorAntennaController.this.myView.setInVisible();
                    }
                }
                catch (BemException bemException) {
                    BemLog.exceptionRaised("Error has occured", bemException);
                    SectorAntennaController.this.displayErrorMessage(bemException.toString());
                }
            }
        };
        listSelectionModel.addListSelectionListener(listSelectionListener);
        this.sectorAntennaOverviewTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void arrangeSectorAntennaTable() throws BemException {
        int n = 0;
        int n2 = 0;
        if (this.selectedColumn != 0) {
            if (this.sectorAntennaState[this.selectedColumn - 1][this.selectedRow] != 3) {
                Object[][] objectArray;
                Object object;
                n = this.equipedSectors[this.selectedColumn - 1];
                n2 = this.selectedRow + 1;
                String string = n2 > 1 ? String.valueOf(n2) : "";
                boolean bl = AIRUtil.getInstance(this.rbs).isAir4SectorAntenna(n, false);
                ArrayList<String> arrayList = new ArrayList<String>();
                String[] stringArray = new String[]{"Sector antenna:", n + "-" + n2};
                ArrayList<CustomerParameter> arrayList2 = new ArrayList<CustomerParameter>();
                String string2 = String.valueOf(n);
                String string3 = "";
                String string4 = MessageFormat.format("S{0}_", string2);
                CustomerParameter customerParameter = null;
                string3 = string4 + "antennaType" + string;
                if (bl) {
                    object = new IntegerRange(MimSectorAntenna.MIN_ANTENNATYPE, MimSectorAntenna.MAX_ANTENNATYPE);
                    customerParameter = new IntegerParameter(string3, (IntegerRange)object);
                    customerParameter.setDefaultValue(MimSectorAntenna.MIN_ANTENNATYPE.toString());
                    ((CustomerParameterImpl)customerParameter).addRestriction(new ParameterRestriction("set antenna type to read only for air situation", 0));
                } else {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                }
                arrayList2.add(customerParameter);
                this.customerParameterNames.add(string3);
                this.sectorAntennaNames.put(string3, null);
                String string5 = "Antenna type:";
                if (!arrayList.contains(string5)) {
                    arrayList.add(string5);
                }
                if (!bl && !this.rbs.isPantherHybridRbs() && this.canHaveTma[0] || this.rbs.isPantherHybridRbs() && this.canHaveTma[0] && Integer.valueOf(string2) < 7 || this.rbs.isPantherHybridRbs() && this.canHaveTma[1] && Integer.valueOf(string2) >= 7) {
                    string3 = string4 + "tmaType" + string;
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    arrayList2.add(customerParameter);
                    this.customerParameterNames.add(string3);
                    this.sectorAntennaNames.put(string3, null);
                    string5 = "TMA type:";
                    if (!arrayList.contains(string5)) {
                        arrayList.add(string5);
                    }
                }
                if ((object = tmaTypeSeq.get(string4 + "tmaType" + string)) == null) {
                    object = "0";
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "bandsOfAtma" + string) && (((String)object).equals("1") || customerParameter.getValue().equals(ATMA_STRING))) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    arrayList2.add(customerParameter);
                    this.customerParameterNames.add(string3);
                    this.sectorAntennaNames.put(string3, null);
                    string5 = "Bands Of Atma:";
                    if (!arrayList.contains(string5)) {
                        arrayList.add(string5);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "typeOfRet" + string)) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    arrayList2.add(customerParameter);
                    this.customerParameterNames.add(string3);
                    this.sectorAntennaNames.put(string3, null);
                    string5 = "RET type:";
                    if (!arrayList.contains(string5)) {
                        arrayList.add(string5);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "riuInstalled" + string) && !bl) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    arrayList2.add(customerParameter);
                    this.customerParameterNames.add(string3);
                    this.sectorAntennaNames.put(string3, null);
                    string5 = "RIU installed:";
                    if (!arrayList.contains(string5)) {
                        arrayList.add(string5);
                    }
                }
                customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                string3 = string4 + "uniqueHwId" + string;
                String string6 = string4 + "typeOfRet" + string;
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string6);
                String string7 = customerParameter2.getValue();
                if (this.rbs.isParameterSupported(string3)) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    string5 = "Unique hardware id:";
                    if (ARETU_CASCADE_STRING.equals(string7)) {
                        arrayList2.remove(customerParameter);
                        this.customerParameterNames.remove(string3);
                        this.sectorAntennaNames.remove(string3);
                        arrayList.remove(string5);
                        customerParameter.removeCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    } else if (customerParameter.getAccessLevel() != 1 || bl) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                string3 = string4 + "mechanicalTilt" + string;
                customerParameter = this.rbs.getCustomerParameterObject(string3);
                arrayList2.add(customerParameter);
                this.customerParameterNames.add(string3);
                this.sectorAntennaNames.put(string3, null);
                string5 = "Mechanical tilt (deg):";
                if (!arrayList.contains(string5)) {
                    arrayList.add(string5);
                }
                customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                string3 = string4 + "electricalTilt" + string;
                if (this.rbs.isParameterSupported(string3) || bl) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1 || AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Electrical tilt (deg):";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "typeOfRet" + string) && !bl && (customerParameter = this.rbs.getCustomerParameterObject(string3)).getValue().equals(ARETU_STRING) && this.rbs.isParameterSupported(string3 = string4 + "verticalBeamWidthMode" + string)) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Vertical beam width mode:";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "typeOfRet" + string) && (customerParameter = this.rbs.getCustomerParameterObject(string3)).getValue().equals(ARETU_STRING)) {
                    string3 = string4 + "antennaType" + string;
                    CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject(string3);
                    objectArray = Integer.valueOf(customerParameter3.getValue());
                    string3 = string4 + "maxTilt" + string;
                    if (this.rbs.isParameterSupported(string3)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        if (customerParameter.getAccessLevel() != 1 && objectArray.intValue() > 50) {
                            arrayList2.add(customerParameter);
                            this.customerParameterNames.add(string3);
                            this.sectorAntennaNames.put(string3, null);
                            string5 = "Max tilt (deg):";
                            if (!arrayList.contains(string5)) {
                                arrayList.add(string5);
                            }
                            customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                            this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                        } else {
                            customerParameter.setValue("##UNDEFINED");
                            this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                        }
                    }
                    if (this.rbs.isParameterSupported(string3 = string4 + "minTilt" + string)) {
                        customerParameter = this.rbs.getCustomerParameterObject(string3);
                        if (customerParameter.getAccessLevel() != 1 && objectArray.intValue() > 50) {
                            arrayList2.add(customerParameter);
                            this.customerParameterNames.add(string3);
                            this.sectorAntennaNames.put(string3, null);
                            string5 = "Min tilt (deg):";
                            if (!arrayList.contains(string5)) {
                                arrayList.add(string5);
                            }
                            customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                            this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                        } else {
                            customerParameter.setValue("##UNDEFINED");
                            this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                        }
                    }
                }
                if (!this.rbs.isPantherHybridRbs() && this.canHaveTma[0] || this.rbs.isPantherHybridRbs() && this.canHaveTma[0] && Integer.valueOf(string2) < 7 || this.rbs.isPantherHybridRbs() && this.canHaveTma[1] && Integer.valueOf(string2) >= 7 && !bl) {
                    string3 = string4 + "tmaType" + string;
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getValue().equals(TMF_STRING)) {
                        string3 = string4 + "beamDirection" + string;
                        if (this.rbs.isParameterSupported(string3)) {
                            customerParameter = this.rbs.getCustomerParameterObject(string3);
                            if (customerParameter.getAccessLevel() != 1) {
                                arrayList2.add(customerParameter);
                                this.customerParameterNames.add(string3);
                                this.sectorAntennaNames.put(string3, null);
                                string5 = "Beam Direction (Deg):";
                                if (!arrayList.contains(string5)) {
                                    arrayList.add(string5);
                                }
                                customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                                this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                            } else {
                                this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                            }
                        }
                    } else {
                        string3 = string4 + "beamDirection" + string;
                        if (this.rbs.isParameterSupported(string3)) {
                            customerParameter = this.rbs.getCustomerParameterObject(string3);
                            this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                        }
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "rfCablesSet") && !bl) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Rf cable set:";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "digitalCablesSet")) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Digital cable set:";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "sectorOutputPower")) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Sector output power (W):";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "sectorOutputPowerLow")) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Low sector output power (mW):";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                if (this.rbs.isParameterSupported(string3 = string4 + "lockSectorOutputPowerLow")) {
                    customerParameter = this.rbs.getCustomerParameterObject(string3);
                    if (customerParameter.getAccessLevel() != 1) {
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string3);
                        this.sectorAntennaNames.put(string3, null);
                        string5 = "Lock sector output power low:";
                        if (!arrayList.contains(string5)) {
                            arrayList.add(string5);
                        }
                        customerParameter.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                        this.sectorAntennaConfigurationTableListener.addToCustomerParameterCheckList(customerParameter);
                    } else {
                        this.sectorAntennaConfigurationTableListener.removeFromCustomerParameterCheckList(customerParameter);
                    }
                }
                int n3 = arrayList2.size();
                objectArray = new Object[n3][1];
                for (int i = 0; i < n3; ++i) {
                    Object object2;
                    String string8 = ((CustomerParameter)arrayList2.get(i)).getName();
                    if (!(string8.endsWith("tmaType" + string) || string8.endsWith("typeOfRet" + string) || string8.endsWith("sectorOutputPower") || string8.endsWith("sectorOutputPowerLow"))) {
                        object2 = (CustomerParameter)arrayList2.get(i);
                        object2.addCustomerParameterListener(this.sectorAntennaConfigurationTableListener);
                    }
                    objectArray[i][0] = object2 = arrayList2.get(i);
                }
                String[] stringArray2 = arrayList.toArray(new String[0]);
                this.myView.setSectorAntennaTableParameters(objectArray, stringArray2, stringArray);
                string3 = string4 + "tmaType" + string;
                customerParameter = this.rbs.getCustomerParameterObject(string3);
                this.tmaType = customerParameter.getValue();
                if (!customerParameter.getValue().equals(NONE_STRING)) {
                    if (!customerParameter.getValue().equals(TMF_STRING)) {
                        this.arrangeTmaTable();
                    }
                }
            } else {
                this.myView.setInVisible();
            }
        }
    }

    public void arrangeTmaTable() throws BemException {
        if (!this.rbs.isPantherHybridRbs() && !this.canHaveTma[0] || this.rbs.isPantherHybridRbs() && !this.canHaveTma[0] && !this.canHaveTma[1]) {
            return;
        }
        int n = this.selectedRow;
        if (this.selectedColumn != 0) {
            int n2;
            Object object;
            Object object2;
            String string = ServiceCommon.BRANCH_NAMES[n * 2];
            String string2 = ServiceCommon.BRANCH_NAMES[n * 2 + 1];
            String[] stringArray = new String[]{"currentLowSupervision_" + string2};
            String[] stringArray2 = new String[]{"Low current supervision, branch B"};
            String[] stringArray3 = new String[]{"currentLowSupervision_" + string, BemUtil.getCustomerParameterName("", "dlAttenuation_ATMA", n + 1), BemUtil.getCustomerParameterName("", "dlTrafficDelay", n + 1), BemUtil.getCustomerParameterName("", "ulTrafficDelay", n + 1)};
            String[] stringArray4 = new String[]{"Low current supervision, branch A", "DL attenuation (0.1 dB)", "DL traffic delay (0.1 ns)", "UL traffic delay (0.1 ns)"};
            String[] stringArray5 = new String[]{"currentLowSupervision_" + string, BemUtil.getCustomerParameterName("", "dlAttenuationPerBand", n + 1), BemUtil.getCustomerParameterName("", "dlTrafficDelayPerBand", n + 1), BemUtil.getCustomerParameterName("", "ulTrafficDelayPerBand", n + 1)};
            String[] stringArray6 = new String[]{"Low current supervision, branch A", "DL attenuation Per Band (0.1 dB)", "DL traffic delay Per Band (0.1 ns)", "UL traffic delay Per Band (0.1 ns)"};
            String[] stringArray7 = new String[]{"dlTrafficDelay" + string, "dlTrafficDelay" + string2, BemUtil.getCustomerParameterName("", "dlAttenuation", n + 1), BemUtil.getCustomerParameterName("", "ulGain", n + 1), "ulTrafficDelay" + string, "ulTrafficDelay" + string2, "currentLowLim" + string2, "currentHighLim" + string2, BemUtil.getCustomerParameterName("", "internalPower", n + 1), BemUtil.getCustomerParameterName("", "dcVoltage", n + 1)};
            String[] stringArray8 = new String[]{"DL traffic delay A (0.1 ns):", "DL traffic delay B (0.1 ns):", "DL attenuation (0.1 dB):", "UL gain (0.1 dB):", "UL traffic delay A (0.1 ns):", "UL traffic delay B (0.1 ns):", "Current low lim B (mA):", "Current high lim B (mA):", " Internal power:", "DC Voltage:"};
            String[] stringArray9 = new String[]{"currentLowLim" + string, "currentHighLim" + string, BemUtil.getCustomerParameterName("", "tmaDegradedSupported", n + 1)};
            String[] stringArray10 = new String[]{"Current low lim A (mA):", "Current high lim A (mA):", "TMA degraded supported:"};
            String[][] stringArray11 = new String[2][15];
            for (int i = 0; i < 15; ++i) {
                if (i < stringArray.length) {
                    stringArray11[0][i] = stringArray[i];
                    stringArray11[1][i] = stringArray2[i];
                    continue;
                }
                if (i == stringArray.length) {
                    stringArray11[0][i] = stringArray3[i - stringArray.length];
                    stringArray11[1][i] = stringArray4[i - stringArray.length];
                    continue;
                }
                if (i - stringArray.length - 1 < stringArray9.length) {
                    stringArray11[0][i] = stringArray9[i - stringArray.length - 1];
                    stringArray11[1][i] = stringArray10[i - stringArray.length - 1];
                    continue;
                }
                if (i - stringArray9.length - stringArray.length - 1 >= stringArray7.length) continue;
                stringArray11[0][i] = stringArray7[i - stringArray9.length - stringArray.length - 1];
                stringArray11[1][i] = stringArray8[i - stringArray9.length - stringArray.length - 1];
            }
            String[][] stringArray12 = new String[2][1];
            for (int i = 0; i < 1; ++i) {
                stringArray12[0][i] = stringArray[i];
                stringArray12[1][i] = stringArray2[i];
            }
            String[][] stringArray13 = new String[2][5];
            for (int i = 0; i < 5; ++i) {
                if (i < stringArray3.length) {
                    stringArray13[0][i] = stringArray3[i];
                    stringArray13[1][i] = stringArray4[i];
                    continue;
                }
                if (i - stringArray3.length >= stringArray.length) continue;
                stringArray13[0][i] = stringArray[i - stringArray3.length];
                stringArray13[1][i] = stringArray2[i - stringArray3.length];
            }
            String[][] stringArray14 = new String[2][5];
            for (int i = 0; i < 5; ++i) {
                if (i < stringArray5.length) {
                    stringArray14[0][i] = stringArray5[i];
                    stringArray14[1][i] = stringArray6[i];
                    continue;
                }
                if (i - stringArray5.length >= stringArray.length) continue;
                stringArray14[0][i] = stringArray[i - stringArray5.length];
                stringArray14[1][i] = stringArray2[i - stringArray5.length];
            }
            String[][] stringArray15 = new String[2][11];
            for (int i = 0; i < 11; ++i) {
                if (i < stringArray7.length) {
                    stringArray15[0][i] = stringArray7[i];
                    stringArray15[1][i] = stringArray8[i];
                    continue;
                }
                if (i - stringArray7.length >= stringArray.length) continue;
                stringArray15[0][i] = stringArray[i - stringArray7.length];
                stringArray15[1][i] = stringArray2[i - stringArray7.length];
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String[] stringArray16 = new String[2];
            stringArray16[0] = "Sector Antenna: ";
            String string3 = String.valueOf(this.equipedSectors[this.selectedColumn - 1]);
            String string4 = String.valueOf(n + 1);
            String string5 = "";
            stringArray16[1] = string3 + "-" + string4;
            String string6 = MessageFormat.format("S{0}_", string3);
            String string7 = Integer.valueOf(string4) > 1 ? string4 : "";
            if (this.tmaType.equals(TMA_STRING)) {
                for (int i = 0; i < stringArray11[0].length; ++i) {
                    string5 = string6 + stringArray11[0][i];
                    String string8 = "";
                    object2 = this.rbs.getCustomerParameterObject(string5);
                    string8 = stringArray11[1][i];
                    if (!arrayList.contains(string8)) {
                        arrayList.add(string8);
                    }
                    arrayList2.add(object2);
                    this.customerParameterNames.add(string5);
                }
            } else if (this.tmaType.equals(ASC_STRING)) {
                for (int i = 0; i < stringArray12[0].length; ++i) {
                    string5 = string6 + stringArray12[0][i];
                    String string9 = "";
                    object2 = this.rbs.getCustomerParameterObject(string5);
                    string9 = stringArray12[1][i];
                    if (!arrayList.contains(string9)) {
                        arrayList.add(string9);
                    }
                    arrayList2.add(object2);
                    this.customerParameterNames.add(string5);
                }
            } else if (this.tmaType.equals(ATMA_STRING)) {
                CustomerParameter customerParameter;
                String string10;
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string6 + "bandsOfAtma" + string7);
                boolean bl = false;
                object2 = BemUtil.getStringArray(customerParameter2.getValue());
                int[] nArray = new int[((Object[])object2).length];
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    nArray[i] = Integer.valueOf((String)object2[i]);
                    if (nArray[i] != 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                }
                object = "0";
                object = bandsOfAtmaValueSeq.get(string6 + "bandsOfAtma" + string7);
                if (object == null) {
                    object = BANDS_OF_ATMA_INVALID_VALUE;
                }
                if (((String)object).equals("0") || !bl) {
                    for (n2 = 0; n2 < stringArray13[0].length; ++n2) {
                        string5 = string6 + stringArray13[0][n2];
                        string10 = "";
                        customerParameter = this.rbs.getCustomerParameterObject(string5);
                        string10 = stringArray13[1][n2];
                        if (!arrayList.contains(string10)) {
                            arrayList.add(string10);
                        }
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string5);
                    }
                } else if (((String)object).equals("1") || bl) {
                    for (n2 = 0; n2 < stringArray14[0].length; ++n2) {
                        string5 = string6 + stringArray14[0][n2];
                        string10 = "";
                        customerParameter = this.rbs.getCustomerParameterObject(string5);
                        string10 = stringArray14[1][n2];
                        if (!arrayList.contains(string10)) {
                            arrayList.add(string10);
                        }
                        arrayList2.add(customerParameter);
                        this.customerParameterNames.add(string5);
                    }
                }
            } else if (this.tmaType.equals(ATMA_AND_TMA_STRING)) {
                for (int i = 0; i < stringArray15[0].length; ++i) {
                    string5 = string6 + stringArray15[0][i];
                    String string11 = "";
                    object2 = this.rbs.getCustomerParameterObject(string5);
                    string11 = stringArray15[1][i];
                    if (!arrayList.contains(string11)) {
                        arrayList.add(string11);
                    }
                    arrayList2.add(object2);
                    this.customerParameterNames.add(string5);
                }
            }
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                ((CustomerParameter)arrayList2.get(i)).addCustomerParameterListener(new TmaTableListener(this));
            }
            String[] stringArray17 = arrayList.toArray(new String[0]);
            object2 = arrayList2.toArray();
            int n4 = ((Object[])object2).length;
            object = new Object[n4][1];
            for (n2 = 0; n2 < n4; ++n2) {
                object[n2][0] = object2[n2];
            }
            this.myView.setTmaTableParameters((Object[][])object, stringArray17, stringArray16);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        if (!GuiCheckAndShowWarning.checkDcVoltageAndShowWarning(this.rbs, this)) {
            bl = false;
            return bl;
        }
        try {
            this.myView.editingStopped();
            this.checkInputValidation();
            this.changeTableCellStatus();
            this.rbs.checkConsistency("AntennaSystemCI", this.customerParameterNames);
            this.checkTableCellStatus();
            int n = 1;
            if (this.rbs.isPantherHybridRbs()) {
                n = 2;
            }
            boolean bl2 = false;
            for (int i = 0; i < n; ++i) {
                AntennaSystemProvider antennaSystemProvider = (AntennaSystemProvider)this.rbs.getProvider(AntennaSystemProvider.class, i);
                if (!antennaSystemProvider.canHaveRetCascading()) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.wizardHelp.excludeSlides(RetCascadingController.class.getSimpleName(), RetCascadingController.class.getSimpleName());
            } else {
                this.wizardHelp.addSlides(SectorAntennaController.class.getSimpleName(), RetCascadingController.class.getSimpleName());
            }
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            this.displayError(customerParameterException);
            boolean bl3 = this.sectorAntennaNames.containsKey(string);
            if (bl3) {
                this.myView.setFocusOnSectorAntennaParameterComponent(string);
            } else {
                this.myView.setFocusOnTmaParameterComponent(string);
            }
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        this.wizardHelp.addSlides(AntennaBranchController.class.getSimpleName(), AntennaCablesController.class.getSimpleName());
        try {
            this.removeTmaAndRetTypeListener();
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised("Error has occured", bemException);
            this.displayErrorMessage(bemException.toString());
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Error has occured", exception);
            this.displayErrorMessage(exception.toString());
        }
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void checkInputValidation() {
        for (var1_1 = 0; var1_1 < this.equipedSectors.length; ++var1_1) {
            var2_2 = this.equipedSectors[var1_1];
            try {
                var3_3 = 0;
                if (this.rbs.isPantherHybridRbs() && var2_2 >= 7) {
                    var3_3 = 1;
                }
                var5_5 = 0;
                for (var6_6 = 0; var6_6 < this.rbs.getMaxNumberOfCarriers(); ++var6_6) {
                    var7_7 = MessageFormat.format("S{0}_C{1}_", new Object[]{var2_2, String.valueOf(var6_6 + 1)});
                    var8_8 = var7_7 + "cellCreated";
                    if (!this.rbs.isParameterSupported(var8_8) || !((UseCellParameter)(var9_9 = this.rbs.getCustomerParameterObject(var8_8))).getBooleanObject().booleanValue()) continue;
                    var5_5 = this.rbs.getAntennaSystemProvider(var3_3).getNumOfSectorAntennas(var2_2);
                    break;
                }
                for (var6_6 = 0; var6_6 < this.sectorAntennaState[var1_1].length; ++var6_6) {
                    if (var6_6 < var5_5) {
                        if (this.sectorAntennaState[var1_1][var6_6] != 3) continue;
                        this.sectorAntennaState[var1_1][var6_6] = 1;
                        continue;
                    }
                    this.sectorAntennaState[var1_1][var6_6] = 3;
                }
                for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
                    block16: {
                        block15: {
                            var7_7 = (String)this.activeSectors.get(var1_1);
                            var8_8 = MessageFormat.format("S{0}_", new Object[]{var7_7});
                            var9_9 = ServiceCommon.BRANCH_NAMES[var6_6 * 2];
                            var10_10 = ServiceCommon.BRANCH_NAMES[var6_6 * 2 + 1];
                            var11_11 = var6_6 > 0 ? String.valueOf(var6_6 + 1) : "";
                            var12_12 = new Vector<String>();
                            var13_13 = "";
                            var14_14 = null;
                            if (!AIRUtil.getInstance(this.rbs).isAir4SectorAntenna(var2_2, false)) break block15;
                            var12_12.add(var8_8 + "uniqueHwId");
                            var12_12.add(var8_8 + "typeOfRet" + var11_11);
                            var12_12.add(var8_8 + "mechanicalTilt" + var11_11);
                            var12_12.add(var8_8 + "electricalTilt" + var11_11);
                            var12_12.add(var8_8 + "sectorOutputPower");
                            var12_12.add(var8_8 + "sectorOutputPowerLow");
                            var12_12.add(var8_8 + "lockSectorOutputPowerLow");
                            break block16;
                        }
                        var13_13 = var8_8 + "tmaType" + var11_11;
                        var14_14 = this.rbs.getCustomerParameterObject(var13_13);
                        if (var14_14.getValue().equals("NONE")) ** GOTO lbl-1000
                        if (var14_14.getValue().equals("TMF")) lbl-1000:
                        // 2 sources

                        {
                            var12_12.add(var8_8 + "antennaType" + var11_11);
                            var12_12.add(var8_8 + "tmaType" + var11_11);
                            var12_12.add(var8_8 + "typeOfRet" + var11_11);
                            var12_12.add(var8_8 + "riuInstalled" + var11_11);
                            var12_12.add(var8_8 + "mechanicalTilt" + var11_11);
                            var12_12.add(var8_8 + "electricalTilt" + var11_11);
                            var12_12.add(var8_8 + "verticalBeamWidthMode" + var11_11);
                            var12_12.add(var8_8 + "sectorOutputPower");
                            var12_12.add(var8_8 + "sectorOutputPowerLow");
                            var12_12.add(var8_8 + "lockSectorOutputPowerLow");
                        } else {
                            var12_12.add(var8_8 + "antennaType" + var11_11);
                            var12_12.add(var8_8 + "tmaType" + var11_11);
                            var12_12.add(var8_8 + "typeOfRet" + var11_11);
                            var12_12.add(var8_8 + "riuInstalled" + var11_11);
                            var12_12.add(var8_8 + "mechanicalTilt" + var11_11);
                            var12_12.add(var8_8 + "electricalTilt" + var11_11);
                            var12_12.add(var8_8 + "verticalBeamWidthMode" + var11_11);
                            var12_12.add(var8_8 + "sectorOutputPower");
                            var12_12.add(var8_8 + "sectorOutputPowerLow");
                            var12_12.add(var8_8 + "lockSectorOutputPowerLow");
                            var12_12.add(var8_8 + "internalPower" + var11_11);
                            var12_12.add(var8_8 + "dcVoltage" + var11_11);
                            var12_12.add(var8_8 + "dlTrafficDelay" + (String)var9_9);
                            var12_12.add(var8_8 + "dlTrafficDelay" + var10_10);
                            var12_12.add(var8_8 + "dlAttenuation" + var11_11);
                            var12_12.add(var8_8 + "ulGain" + var11_11);
                            var12_12.add(var8_8 + "ulTrafficDelay" + (String)var9_9);
                            var12_12.add(var8_8 + "ulTrafficDelay" + var10_10);
                            var12_12.add(var8_8 + "tmaDegradedSupported" + var11_11);
                            var12_12.add(var8_8 + "currentLowSupervision_" + (String)var9_9);
                            var12_12.add(var8_8 + "currentLowSupervision_" + var10_10);
                            var12_12.add(var8_8 + "currentLowLim" + (String)var9_9);
                            var12_12.add(var8_8 + "currentLowLim" + var10_10);
                            var12_12.add(var8_8 + "currentHighLim" + (String)var9_9);
                            var12_12.add(var8_8 + "currentHighLim" + var10_10);
                            var12_12.add(var8_8 + "dlAttenuation_ATMA" + var11_11);
                            var12_12.add(var8_8 + "dlTrafficDelay" + var11_11);
                            var12_12.add(var8_8 + "ulTrafficDelay" + var11_11);
                        }
                    }
                    var15_15 = false;
                    var16_16 = false;
                    var17_17 = false;
                    for (E var19_19 : var12_12) {
                        var20_20 = this.rbs.getCustomerParameterObject(var19_19.toString());
                        if (var14_14 != null && var14_14.getValue() != null) {
                            if (!var14_14.getValue().equals("NONE") && !this.sectorAntennaNames.containsKey(var20_20) && var20_20.getAccessLevel() != 1 && var20_20.getValue().equals("")) {
                                var17_17 = true;
                                break;
                            }
                        }
                        if (var20_20.isDefault() || var20_20.getValue().equals("") || var20_20.getValue().equals("##UNDEFINED")) continue;
                        if (!var20_20.isValidValue()) {
                            var15_15 = true;
                            break;
                        }
                        if (var20_20.getName().endsWith("sectorOutputPower") || var20_20.getName().endsWith("sectorOutputPowerLow")) continue;
                        var16_16 = true;
                    }
                    if (var17_17 || var15_15) {
                        this.sectorAntennaState[var1_1][var6_6] = 4;
                        continue;
                    }
                    if (!var16_16) continue;
                    this.sectorAntennaState[var1_1][var6_6] = 2;
                }
                continue;
            }
            catch (BemException var3_4) {
                BemLog.exceptionRaised(var3_4);
            }
        }
    }

    public void changeTableCellStatus() {
        int n = this.equipedSectors.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            try {
                int n3 = 0;
                if (this.rbs.isPantherHybridRbs() && this.equipedSectors[i] >= 7) {
                    n3 = 1;
                }
                int n4 = this.rbs.getAntennaSystemProvider(n3).getNumOfSectorAntennas(this.equipedSectors[i]);
                block8: for (int j = 0; j < n4; ++j) {
                    switch (this.sectorAntennaState[i][j]) {
                        case 1: {
                            this.sectorAntennaOverviewTable.setValueAt("", j, n2);
                            continue block8;
                        }
                        case 4: {
                            this.sectorAntennaOverviewTable.setValueAt("InCorrect", j, n2);
                            continue block8;
                        }
                        case 2: {
                            String string = this.equipedSectors[i] + "-" + String.valueOf(j + 1);
                            this.sectorAntennaOverviewTable.setValueAt(string, j, n2);
                            continue block8;
                        }
                    }
                }
                continue;
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised(bemException);
            }
        }
    }

    private void checkTableCellStatus() throws BemException {
        for (int i = 0; i < this.equipedSectors.length; ++i) {
            int n = this.equipedSectors[i];
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n2 = 1;
            }
            for (int j = 0; j < this.rbs.getAntennaSystemProvider(n2).getNumOfSectorAntennas(n); ++j) {
                if (this.sectorAntennaState[i][j] != 4) continue;
                throw new BemException("The configuration of Sector" + n + " is incorrect,please check your configure! ");
            }
        }
    }

    private class TmaTableListener
    implements CustomerParameterListener {
        private SectorAntennaController controller;

        public TmaTableListener(SectorAntennaController sectorAntennaController2) {
            this.controller = sectorAntennaController2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged() && !customerParameter.isDefault()) {
                for (int i = 0; i < SectorAntennaController.this.equipedSectors.length; ++i) {
                    String string = MessageFormat.format("S{0}_", SectorAntennaController.this.equipedSectors[i]);
                    if (!customerParameter.getName().startsWith(string)) continue;
                    if (customerParameter.getName().endsWith(SectorAntennaController.BANDS_OF_ATMA_INVALID_VALUE) || customerParameter.getName().endsWith("C") || customerParameter.getName().endsWith("D")) {
                        this.controller.sectorAntennaState[i][1] = 2;
                        continue;
                    }
                    this.controller.sectorAntennaState[i][0] = 2;
                }
                this.controller.changeTableCellStatus();
            }
        }
    }

    private class SectorAntennaConfigurationTableListener
    implements CustomerParameterListener {
        private SectorAntennaController controller;
        final List<CustomerParameter> parametersCheckList;

        public SectorAntennaConfigurationTableListener(SectorAntennaController sectorAntennaController2) {
            this.controller = sectorAntennaController2;
            this.parametersCheckList = new ArrayList<CustomerParameter>();
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            block14: {
                if (!customerParameter.getName().endsWith("sectorOutputPower") && !customerParameter.getName().endsWith("sectorOutputPowerLow") && parameterEvent.isValueChanged()) {
                    for (int i = 0; i < SectorAntennaController.this.equipedSectors.length; ++i) {
                        String string = MessageFormat.format("S{0}_", SectorAntennaController.this.equipedSectors[i]);
                        if (!customerParameter.getName().startsWith(string)) continue;
                        for (int j = 0; j < SectorAntennaController.this.sectorAntennaState[i].length; ++j) {
                            if (customerParameter.getName().endsWith(String.valueOf(j + 1))) {
                                if (customerParameter.isDefault()) {
                                    if (!this.checkAllCustomerParameterBackToDefault(SectorAntennaController.this.equipedSectors[i], j + 1)) break block14;
                                    this.controller.sectorAntennaState[i][j] = 1;
                                    break block14;
                                }
                                this.controller.sectorAntennaState[i][j] = 2;
                                break block14;
                            }
                            if (!WizardHelp.isFirstSectorAntenna(customerParameter.getName(), 3)) continue;
                            if (customerParameter.isDefault()) {
                                if (!this.checkAllCustomerParameterBackToDefault(SectorAntennaController.this.equipedSectors[i], j + 1)) break block14;
                                this.controller.sectorAntennaState[i][j] = 1;
                                break block14;
                            }
                            this.controller.sectorAntennaState[i][j] = 2;
                            break block14;
                        }
                        break;
                    }
                } else if ((customerParameter.getName().endsWith("sectorOutputPower") || customerParameter.getName().endsWith("sectorOutputPowerLow")) && parameterEvent.isValueChanged()) {
                    for (int i = 0; i < SectorAntennaController.this.equipedSectors.length; ++i) {
                        String string = MessageFormat.format("S{0}_", SectorAntennaController.this.equipedSectors[i]);
                        if (!customerParameter.getName().startsWith(string)) continue;
                        int n = 0;
                        if (SectorAntennaController.this.rbs.isPantherHybridRbs() && SectorAntennaController.this.equipedSectors[i] >= 7) {
                            n = 1;
                        }
                        int n2 = 1;
                        try {
                            n2 = SectorAntennaController.this.rbs.getAntennaSystemProvider(n).getNumOfSectorAntennas(SectorAntennaController.this.equipedSectors[i]);
                            for (int j = 0; j < n2; ++j) {
                                if (customerParameter.isDefault()) {
                                    if (!this.checkAllCustomerParameterBackToDefault(SectorAntennaController.this.equipedSectors[i], j + 1)) continue;
                                    this.controller.sectorAntennaState[i][j] = 1;
                                    continue;
                                }
                                this.controller.sectorAntennaState[i][j] = 2;
                            }
                            continue;
                        }
                        catch (BemException bemException) {
                            BemLog.exceptionRaised(bemException);
                        }
                    }
                }
            }
            this.controller.changeTableCellStatus();
        }

        public boolean isCustomerParameterInCheckList(CustomerParameter customerParameter) {
            return this.parametersCheckList.contains(customerParameter);
        }

        public void addToCustomerParameterCheckList(CustomerParameter customerParameter) {
            if (!this.isCustomerParameterInCheckList(customerParameter)) {
                this.parametersCheckList.add(customerParameter);
            }
        }

        public void removeFromCustomerParameterCheckList(CustomerParameter customerParameter) {
            if (this.isCustomerParameterInCheckList(customerParameter)) {
                this.parametersCheckList.remove(customerParameter);
            }
        }

        public void clearCustomerParameterCheckList() {
            if (!this.parametersCheckList.isEmpty()) {
                this.parametersCheckList.clear();
            }
        }

        private boolean checkAllCustomerParameterBackToDefault(int n, int n2) {
            boolean bl = true;
            String string = MessageFormat.format("S{0}_", String.valueOf(n));
            String string2 = n2 == 1 ? "" : String.valueOf(n2);
            for (CustomerParameter customerParameter : this.parametersCheckList) {
                if (!customerParameter.getName().startsWith(string)) continue;
                if (n2 == 1 && WizardHelp.isFirstSectorAntenna(customerParameter.getName(), 3)) {
                    bl = bl && customerParameter.isDefault();
                    continue;
                }
                if (n2 <= 1 || !customerParameter.getName().endsWith(string2)) continue;
                bl = bl && customerParameter.isDefault();
            }
            return bl;
        }
    }

    private static class TypeOfAntennaListener
    implements CustomerParameterListener {
        private SectorAntennaController controller;

        public TypeOfAntennaListener(SectorAntennaController sectorAntennaController) {
            this.controller = sectorAntennaController;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            try {
                this.controller.arrangeSectorAntennaTable();
                this.controller.changeTableCellStatus();
                this.controller.myView.setFocusOnSectorAntennaParameterComponent(customerParameter.getName());
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised("Error has occured", bemException);
            }
        }
    }

    private static class TypeOfRetListener
    implements CustomerParameterListener {
        private SectorAntennaController controller;

        public TypeOfRetListener(SectorAntennaController sectorAntennaController) {
            this.controller = sectorAntennaController;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            try {
                this.controller.arrangeSectorAntennaTable();
                this.controller.changeTableCellStatus();
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised("Error has occured", bemException);
            }
        }
    }

    private static class AtmaTypeListener
    implements CustomerParameterListener {
        private SectorAntennaController controller;

        public AtmaTypeListener(SectorAntennaController sectorAntennaController) {
            this.controller = sectorAntennaController;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                try {
                    if (customerParameter.getName().contains("bandsOfAtma")) {
                        String string = customerParameter.getValue();
                        String string2 = bandsOfAtmaValue;
                        if (customerParameter.getValue().equals(SectorAntennaController.NONE_STRING) || customerParameter.getValue().equals(SectorAntennaController.TMF_STRING)) {
                            return;
                        }
                        String[] stringArray = BemUtil.getStringArray(string);
                        int[] nArray = new int[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            nArray[i] = Integer.valueOf(stringArray[i]);
                            if (nArray[i] != 0) {
                                bandsOfAtmaValue = "1";
                                break;
                            }
                            bandsOfAtmaValue = "0";
                        }
                        bandsOfAtmaValueSeq.put(customerParameter.getName(), bandsOfAtmaValue);
                        if (!string2.equals(bandsOfAtmaValue)) {
                            this.controller.arrangeTmaTable();
                        }
                    }
                }
                catch (BemException bemException) {
                    BemLog.exceptionRaised("Error has occured", bemException);
                }
            }
        }
    }

    private class TmaTypeListener
    implements CustomerParameterListener {
        private SectorAntennaController controller;

        public TmaTypeListener(SectorAntennaController sectorAntennaController2) {
            this.controller = sectorAntennaController2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                try {
                    String string = "0";
                    string = customerParameter.getValue().equals(SectorAntennaController.ATMA_STRING) ? "1" : "0";
                    tmaTypeSeq.put(customerParameter.getName(), string);
                    this.controller.tmaType = customerParameter.getValue();
                    this.controller.arrangeSectorAntennaTable();
                    if (!customerParameter.getValue().equals(SectorAntennaController.NONE_STRING) && !customerParameter.getValue().equals(SectorAntennaController.TMF_STRING)) {
                        this.controller.arrangeTmaTable();
                    } else {
                        SectorAntennaController.this.myView.removeTmaPanel();
                    }
                    this.controller.changeTableCellStatus();
                }
                catch (BemException bemException) {
                    BemLog.exceptionRaised("Error has occured", bemException);
                }
            }
        }
    }
}

