/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.IsSharedWithExternalMeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SectorDataViewer;

public class SectorDataController
extends BemWizardGuiController {
    private SectorDataViewer myView;
    private JTable sectorDataTable;
    private final List customerParameterNames = new ArrayList();
    private WizardCIModel wizardCiModel;
    private int selectedRow = 0;
    private int selectedColumn = 0;
    private int[] bothBBPSector;
    private Rbs rbs;
    private AbstractRuRI[][] auxRi = new AbstractRuRI[12][3];
    private SectorAuxTableListener sectorAuxTableListener = null;
    private String[][] mixedModeRadioNumber = new String[12][3];
    private String[] mixedModeCellName = new String[12];
    private RadioEquipmentProvider[] radioEquipmentProvider = new RadioEquipmentProvider[2];
    public static final String MIXED_MODE_NOT_CONFIGUERED = "F";
    public static final String MIXED_MODE_CONFIGUERED = "T";
    protected static final int MIXED_MODE_CONFIGUERED_ROW_NUMBER = 7;
    public static final String SPACE = " ";
    private JTable auxSharedTable;

    protected void init() {
        this.myView = (SectorDataViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
        this.sectorAuxTableListener = new SectorAuxTableListener(this);
    }

    protected void afterVisible() {
        try {
            int n;
            this.rbs = this.wizardCiModel.getRbs();
            int[][] nArrayArray = new int[2][];
            int n2 = 0;
            for (n = 0; n < this.radioEquipmentProvider.length && (this.rbs.isPantherHybridRbs() || n != 1); ++n) {
                if (n == 1) {
                    n2 = 1;
                }
                this.radioEquipmentProvider[n] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, n2);
                nArrayArray[n] = this.radioEquipmentProvider[n].getEquippedSectors();
                for (int i = 0; i < nArrayArray[n].length; ++i) {
                    if (!(this.radioEquipmentProvider[n] instanceof RadioEquipmentProviderWithRbb)) continue;
                    this.auxRi[nArrayArray[n][i] - 1] = this.radioEquipmentProvider[n].getSectorRadioUnits(nArrayArray[n][i]);
                }
            }
            this.bothBBPSector = WizardHelp.mergeIntArray(nArrayArray[0], nArrayArray[1]);
            if (this.radioEquipmentProvider[0] instanceof RadioEquipmentProviderWithRbb || this.radioEquipmentProvider[1] != null && this.radioEquipmentProvider[1] instanceof RadioEquipmentProviderWithRbb) {
                this.myView.initiateMainPanel();
            }
            if ((n = this.bothBBPSector.length) > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("Latitude:");
                arrayList.add("Lat hemisphere:");
                arrayList.add("Longitude:");
                arrayList.add("Geo datum:");
                arrayList.add("Height");
                arrayList.add("Noise figure");
                arrayList.add("Sector group");
                if (this.rbs.getRbsData().isRbs6000() && DuwUtil.hasDuw()) {
                    arrayList.add("Mixed Mode configuration");
                }
                String[] stringArray = arrayList.toArray(new String[0]);
                Object[][] objectArray = new Object[stringArray.length][n];
                String[] stringArray2 = new String[n + 1];
                stringArray2[0] = SPACE;
                for (int i = 0; i < n; ++i) {
                    int n3 = this.bothBBPSector[i];
                    String string = String.valueOf(n3);
                    String string2 = "";
                    stringArray2[i + 1] = MessageFormat.format("Sector={0}", string);
                    String string3 = MessageFormat.format("S{0}_", string);
                    string2 = string3 + "latitude";
                    CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                    TrueFalseCustomerParameter trueFalseCustomerParameter = null;
                    objectArray[0][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "latHemisphere";
                    customerParameter = this.rbs.getCustomerParameterObject(string2);
                    objectArray[1][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "longitude";
                    customerParameter = this.rbs.getCustomerParameterObject(string2);
                    objectArray[2][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "geoDatum";
                    customerParameter = this.rbs.getCustomerParameterObject(string2);
                    objectArray[3][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "height";
                    customerParameter = this.rbs.getCustomerParameterObject(string2);
                    objectArray[4][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "noiseFigure";
                    customerParameter = this.rbs.getCustomerParameterObject(string2);
                    objectArray[5][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    string2 = string3 + "sectorGroup";
                    customerParameter = this.rbs.getCustomerParameterObject(string2);
                    objectArray[6][i] = customerParameter;
                    this.customerParameterNames.add(string2);
                    if (!this.rbs.getRbsData().isRbs6000() || !DuwUtil.hasDuw()) continue;
                    for (int j = 0; j < this.auxRi[n3 - 1].length; ++j) {
                        string2 = this.auxRi[n3 - 1][j].getSectorAuxPrefix() + "isSharedWithExternalMe";
                        trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject(string2);
                        this.mixedModeRadioNumber[i][j] = trueFalseCustomerParameter.isDefault() ? MIXED_MODE_NOT_CONFIGUERED : MIXED_MODE_CONFIGUERED;
                        this.customerParameterNames.add(string2);
                    }
                    this.generateMixedModeCellName();
                    objectArray[7][i] = this.mixedModeCellName[i];
                }
                this.sectorDataTable = this.myView.setSectorTableParameters(objectArray, stringArray, stringArray2);
                ListSelectionModel listSelectionModel = this.sectorDataTable.getSelectionModel();
                listSelectionModel.setSelectionMode(0);
                listSelectionModel.setSelectionMode(0);
                ListSelectionListener listSelectionListener = new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int[] nArray = SectorDataController.this.sectorDataTable.getSelectedRows();
                        int[] nArray2 = SectorDataController.this.sectorDataTable.getSelectedColumns();
                        if (nArray.length > 0 && nArray2.length > 0) {
                            SectorDataController.this.selectedRow = nArray[0];
                            SectorDataController.this.selectedColumn = nArray2[0];
                        } else {
                            SectorDataController.this.selectedRow = 0;
                            SectorDataController.this.selectedColumn = 0;
                        }
                        try {
                            if (SectorDataController.this.rbs.getRbsData().isRbs6000() && DuwUtil.hasDuw() && 7 == SectorDataController.this.selectedRow && 0 != SectorDataController.this.selectedColumn) {
                                SectorDataController.this.arrangeSectorAuxTable(SectorDataController.this.selectedColumn);
                            }
                        }
                        catch (BemException bemException) {
                            String string = "Failed to create Aux configration table!";
                            Nal.getLog().nalTraceError(this.getClass(), string, bemException);
                        }
                    }
                };
                listSelectionModel.addListSelectionListener(listSelectionListener);
                this.sectorDataTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
            }
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
    }

    public void arrangeSectorAuxTable(int n) throws BemException {
        String[] stringArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = this.bothBBPSector[n - 1];
        Object[][] objectArray = new Object[this.auxRi[n2 - 1].length][1];
        String string = MessageFormat.format("S{0}_", n2);
        for (int i = 0; i < this.auxRi[n2 - 1].length; ++i) {
            stringArray = this.auxRi[n2 - 1][i].getAuxPiuLdn().substring(this.auxRi[n2 - 1][i].getAuxPiuLdn().lastIndexOf("=") + 1);
            if (this.isSharedWithExternalMeSupported(this.auxRi[n2 - 1][i].getAuType())) {
                arrayList.add(stringArray);
            }
            String string2 = MessageFormat.format("AUX{0}_", new Integer(i + 1));
            String string3 = string + string2 + "isSharedWithExternalMe";
            IsSharedWithExternalMeParameter isSharedWithExternalMeParameter = null;
            try {
                isSharedWithExternalMeParameter = (IsSharedWithExternalMeParameter)this.rbs.getCustomerParameterObject(string3);
            }
            catch (Exception exception) {
                this.displayError(exception);
            }
            isSharedWithExternalMeParameter.addCustomerParameterListener(this.sectorAuxTableListener);
            objectArray[i][0] = isSharedWithExternalMeParameter;
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        stringArray = new String[]{"Radio Unit", "Sector " + n2};
        this.auxSharedTable = this.myView.setAuxSharedTableParameters(objectArray, stringArray2, stringArray);
        if (this.isNotFirstSectorRadioSharedBy(n2)) {
            this.auxSharedTable.setEnabled(false);
        } else {
            this.auxSharedTable.setEnabled(true);
        }
    }

    private boolean isSharedWithExternalMeSupported(int n) {
        int[] nArray = new int[]{11, 10, 19, 20, 27, 26};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.myView.editingStopped();
            Rbs rbs = this.wizardCiModel.getRbs();
            rbs.checkConsistency("AntennaSystemCI", this.customerParameterNames);
            rbs.checkConsistency("RadioEquipmentCI");
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }

    private void changeTableCellStatus() {
        for (int i = 0; i < this.bothBBPSector.length; ++i) {
            this.sectorDataTable.setValueAt(this.mixedModeCellName[i], 7, i + 1);
        }
    }

    private void generateMixedModeCellName() {
        for (int i = 0; i < this.bothBBPSector.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < 3; ++j) {
                if (null == this.mixedModeRadioNumber[i][j]) continue;
                stringBuffer.append(SPACE);
                stringBuffer.append(this.mixedModeRadioNumber[i][j]);
            }
            this.mixedModeCellName[i] = stringBuffer.toString();
        }
    }

    private int getRadioSharedSector(int n) throws BemException {
        String string = MessageFormat.format("S{0}_", n);
        String string2 = string + "radioSharedBySector";
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
        String string3 = customerParameter.getValue();
        if (string3 == null || string3.equals("") || string3.equals("##UNDEFINED")) {
            return 0;
        }
        return Integer.valueOf(string3);
    }

    boolean isNotFirstSectorRadioSharedBy(int n) throws BemException {
        int n2 = this.getRadioSharedSector(n);
        return n2 != 0 && n2 < n;
    }

    private class SectorAuxTableListener
    implements CustomerParameterListener {
        private SectorDataController controller;

        public SectorAuxTableListener(SectorDataController sectorDataController2) {
            this.controller = sectorDataController2;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (customerParameter.getName().endsWith("isSharedWithExternalMe") && parameterEvent.isValueChanged()) {
                for (int i = 0; i < SectorDataController.this.bothBBPSector.length; ++i) {
                    String string = MessageFormat.format("S{0}_", SectorDataController.this.bothBBPSector[i]);
                    int n = SectorDataController.this.bothBBPSector[i];
                    for (int j = 0; j < SectorDataController.this.auxRi[n - 1].length; ++j) {
                        String string2 = MessageFormat.format("AUX{0}_", j + 1);
                        String string3 = string + string2;
                        if (!customerParameter.getName().startsWith(string3)) continue;
                        ((SectorDataController)this.controller).mixedModeRadioNumber[i][j] = customerParameter.isDefault() ? SectorDataController.MIXED_MODE_NOT_CONFIGUERED : SectorDataController.MIXED_MODE_CONFIGUERED;
                    }
                }
            }
            this.controller.generateMixedModeCellName();
            this.controller.changeTableCellStatus();
        }
    }
}

