/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperty;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.BrowserHelpMessageDialogController;
import se.ericsson.wcdma.support.gui.guilib.infra.BrowserHelpMessageDialogView;
import se.ericsson.wcdma.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.wcdma.support.gui.guilib.infra.ResourceBundleDelegator;

public class BrowserHelp
extends AbstractHelp {
    private static String DOCUMENT_ROOT_KEY = "gsl.help.docserver.documentroot";
    private static String HELP_DOCUMENT_BUNDLE_KEY = "gsl.help.documentmapping";
    private static String HELP_TRACKING_ICON = "gsl.icon.helptracking";
    private static String ALEX_SEARCH_EXPRESSION = "ALEX_SEARCH_EXPRESSION";
    private ResourceBundleDelegator helpBundle;
    private Vector components = new Vector();
    private KeyPressedListener keyListener = new KeyPressedListener();
    private ButtonAction buttonListener = new ButtonAction();
    private TrackingListener trackingListener = new TrackingListener();
    private ResourceBundle documentMapping;

    public BrowserHelp() {
        Log.traceFlow();
    }

    public void handleComponent(JComponent jComponent) {
        Log.trace("BrowserHelp.handleComponent(" + jComponent.getClass().getName() + ")");
        if (jComponent instanceof AbstractButton && jComponent.getClientProperty("HELP_ENABLE") != null) {
            ((AbstractButton)jComponent).addActionListener(this.buttonListener);
            Log.trace("ButtonListener added to help-enabling button");
            this.addF1Lister(jComponent);
        }
        if (jComponent.getClientProperty("HELP_TRACKING") != null) {
            Log.trace("TrackingListener added to help-tracker component");
            ((AbstractButton)jComponent).addActionListener(this.trackingListener);
        }
        jComponent.addKeyListener(this.keyListener);
        this.components.addElement(jComponent);
    }

    public void dispose() {
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent jComponent = (JComponent)this.components.elementAt(i);
            jComponent.removeKeyListener(this.keyListener);
            if (jComponent.getClientProperty("HELP_ENABLE") == null) continue;
            ((AbstractButton)jComponent).removeActionListener(this.buttonListener);
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, false));
        }
        this.components.clear();
    }

    private String getEndOfString(String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public void updateHelp(Locale locale) {
        Object object;
        Object object2;
        Object object3;
        String string;
        Log.traceFlow();
        Log.log(4, "locale = " + locale);
        this.helpBundle = new ResourceBundleDelegator();
        String string2 = this.getApplication().getEnvironment().getProperty("gsl.help.default.bundle.name");
        Log.log(4, "Default help-bundle name : " + string2);
        this.helpBundle.add(GuilibResourceBundle.getBundle(string2, locale, this.getClass().getClassLoader()));
        String string3 = "se.ericsson.wcdma.support.gui.guilib.infra.resources.help.BrowserHelpMapping";
        Log.log(4, "Default helpmapping-bundle name : " + string3);
        this.helpBundle.add(GuilibResourceBundle.getBundle(string3, locale, this.getClass().getClassLoader()));
        try {
            string = "resources.help." + this.getEndOfString(string3) + "_ext";
            object3 = GuilibResourceBundle.getBundle(string, locale, this.getClass().getClassLoader());
            this.helpBundle.add((ResourceBundle)object3);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        string = this.getApplication().getApplicationManager().getFirstInitialApplication().getHelpBundleName();
        Log.log(4, "help-bundle name of initial application : " + string);
        if (string != null && !string.equals("")) {
            object3 = GuilibResourceBundle.getBundle(string, locale, this.getClass().getClassLoader());
            this.helpBundle.add((ResourceBundle)object3);
            try {
                object2 = "resources.help." + this.getEndOfString(string) + "_ext";
                object = GuilibResourceBundle.getBundle((String)object2, locale, this.getClass().getClassLoader());
                this.helpBundle.add((ResourceBundle)object);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            object2 = this.getString((ResourceBundle)object3, HELP_DOCUMENT_BUNDLE_KEY);
            Log.log(4, "helpmapping-bundle of initial application : " + (String)object2);
            if (object2 != null && !((String)object2).equals("")) {
                object = this.getClass().getClassLoader();
                ResourceBundle resourceBundle = GuilibResourceBundle.getBundle((String)object2, locale, (ClassLoader)object);
                this.helpBundle.add(resourceBundle);
            } else {
                Log.trace("No or empty helpmapping-bundle specified for initial app");
            }
        } else {
            Log.trace("No or empty help-bundle specified for initial app");
        }
        string = this.getHelpBundleName();
        Log.log(4, "help-bundle name of current application=" + string);
        if (string != null && !string.equals("")) {
            object3 = GuilibResourceBundle.getBundle(string, locale, this.getClass().getClassLoader());
            this.helpBundle.add((ResourceBundle)object3);
            try {
                object2 = "resources.help." + this.getEndOfString(string) + "_ext";
                object = GuilibResourceBundle.getBundle((String)object2, locale, this.getClass().getClassLoader());
                this.helpBundle.add((ResourceBundle)object);
            }
            catch (MissingResourceException missingResourceException) {}
        } else {
            Log.logNotify("No or empty help-bundle specified for current app :" + this.getApplication());
        }
        object3 = this.getString(this.helpBundle, HELP_DOCUMENT_BUNDLE_KEY);
        Log.log(4, "helpmapping-bundle of current application : " + (String)object3);
        if (object3 != null && !((String)object3).equals("")) {
            object2 = this.getClass().getClassLoader();
            this.documentMapping = GuilibResourceBundle.getBundle((String)object3, locale, (ClassLoader)object2);
            this.helpBundle.add(this.documentMapping);
        } else {
            Log.trace("No or empty helpmapping-bundle for current app : " + this.getApplication());
        }
    }

    private String getString(ResourceBundle resourceBundle, String string) {
        try {
            Log.trace("getString() bundle = " + resourceBundle);
            Log.trace("getString() key    = " + string);
            if (resourceBundle != null && string != null) {
                String string2 = resourceBundle.getString(string);
                return string2;
            }
            Log.logWarning("Empty bundle or key! key=" + string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.logWarning("Missing resource : " + string);
        }
        return null;
    }

    private void showDocument(String string) {
        Log.traceFlow();
        Log.logNotify("helpmapping-key = " + string);
        if (string == null || string.equals("")) {
            Log.logError("empty key passed! key=" + string);
            this.showMessageDialog("GSL_ERROR", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
            return;
        }
        String string2 = this.getString(this.helpBundle, string);
        Log.logNotify("help-document file = " + string2);
        if (string2 == null || string2.equals("")) {
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIGURATION_MSG", null);
            return;
        }
        if (string2.startsWith(DOCUMENT_ROOT_KEY)) {
            int n = DOCUMENT_ROOT_KEY.length();
            this.callHelpServiceWithHalfUrl(string2.substring(n));
        } else {
            Log.logWarning("Malformed URL to document server. ");
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", null);
        }
    }

    private void showMessageDialog(String string, String string2, Object[] objectArray) {
        Log.traceFlow();
        Object[][] objectArray2 = new Object[][]{{"MESSAGEHEADING_TAG", string}, {"MESSAGE_TAG", string2}, {"MESSAGE_ARGUMENTS", objectArray}};
        this.startDialog(false, "BROWSERHELP_MESSAGEDIALOG_TITLE", null, BrowserHelpMessageDialogView.class, BrowserHelpMessageDialogController.class, objectArray2);
    }

    private AbstractView getView() {
        return this.getPresenter().getView();
    }

    private void addF1Lister(JComponent jComponent) {
        jComponent.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AbstractView abstractView = BrowserHelp.this.getView();
                    String string = (String)abstractView.getClientProperty("HELP_KEY");
                    Log.logNotify("F1 pressed. helptag = " + string + " , " + "window : " + abstractView);
                    if (string != null) {
                        String string2 = (String)abstractView.getClientProperty("TITLE");
                        if (string2 != null && string2.equals("YES")) {
                            BrowserHelp.this.showDocumentWithTitle(string);
                        } else {
                            BrowserHelp.this.showDocument(BrowserHelp.this.getString(BrowserHelp.this.helpBundle, string));
                        }
                    }
                }
                catch (Exception exception) {
                    Log.trace("BrowserHelp exception when invoking help on F1");
                    exception.printStackTrace();
                }
            }
        }, "", KeyStroke.getKeyStroke(112, 0, false), 2);
    }

    public String convertTitle(String string) {
        return string;
    }

    private void showDocumentWithTitle(String string) {
        Properties properties = new Properties();
        properties.setProperty("DOC_TITLE", string);
        this.launchEmToolboxHelp(properties);
    }

    public void startBrowser(URL uRL) {
        Properties properties = new Properties();
        properties.setProperty("URL", uRL.toString());
        this.launchEmToolboxHelp(properties);
    }

    private void callHelpServiceWithHalfUrl(String string) {
        boolean bl;
        string = string.trim();
        string = string.replace(' ', '+');
        boolean bl2 = bl = System.getProperties().getProperty("os.name").indexOf("Windows") > -1;
        if (bl) {
            string = "\"" + string + "\"";
        }
        Properties properties = new Properties();
        properties.setProperty(ALEX_SEARCH_EXPRESSION, string);
        this.launchEmToolboxHelp(properties);
    }

    private void launchEmToolboxHelp(Properties properties) {
        final BemLaunchable bemLaunchable = this.getApplication().getBemLaunchable();
        final Properties properties2 = bemLaunchable.getArguments().getSupersedingProperties();
        properties2.putAll((Map<?, ?>)properties);
        final String string = bemLaunchable.getArguments().getProperty(LaunchProperty.HELPSERVICE_CONFIG);
        if (0 == string.length()) {
            Log.logWarning("BrowserHelp found no path to HelpService configuration file.");
            Object[] objectArray = new String[]{"The configuration file for Help Service was not available."};
            this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", objectArray);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    bemLaunchable.getLauncher().runResource(string, bemLaunchable.getHostname(), properties2, (Launchable)bemLaunchable);
                }
                catch (Exception exception) {
                    Log.logError("Exception in runResource", exception);
                    String string2 = "Problem displaying help. " + exception.getMessage();
                    Object[] objectArray = new String[]{string2};
                    BrowserHelp.this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", objectArray);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private class TrackingListener
    implements ActionListener {
        private Toolkit tk = Toolkit.getDefaultToolkit();
        private EventQueue eventQueue = null;
        private boolean firstClick = true;

        private TrackingListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Log.logNotify("help-tracking activated: " + object);
            if (((JComponent)actionEvent.getSource()).getClientProperty("HELP_TRACKING") != null) {
                String string = null;
                string = BrowserHelp.this.getApplication().getApplicationManager().getFirstInitialApplication().getEnvironment().getProperty(HELP_TRACKING_ICON);
                Log.logNotify("Image loaded..: " + string);
                ClassLoader classLoader = this.getClass().getClassLoader();
                Image image = this.tk.createImage(classLoader.getResource(string));
                Cursor cursor = this.tk.createCustomCursor(image, new Point(0, 0), "HelpTracker");
                Log.trace("The cursor: " + cursor.toString());
                BrowserHelp.this.getApplication().setCursor(cursor);
                try {
                    this.eventQueue = this.tk.getSystemEventQueue();
                }
                catch (Exception exception) {
                    Log.logWarning("Exception TrackingListener");
                    this.restoreCursor();
                    return;
                }
                while (true) {
                    try {
                        MouseEvent mouseEvent;
                        Object object2;
                        AWTEvent aWTEvent;
                        while (true) {
                            int n;
                            aWTEvent = this.eventQueue.getNextEvent();
                            object2 = aWTEvent.getSource();
                            if (!(aWTEvent instanceof MouseEvent) || (n = (mouseEvent = (MouseEvent)aWTEvent).getID()) != 501 && n != 502 && n != 500) continue;
                            if (!this.firstClick) break;
                            this.firstClick = false;
                            mouseEvent.consume();
                        }
                        Object object3 = this.getDeepestObjectAt(object2, mouseEvent.getX(), mouseEvent.getY());
                        this.eventFired(object3, aWTEvent);
                        this.firstClick = true;
                        mouseEvent.consume();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        Log.logWarning("InterruptedException");
                        continue;
                    }
                    break;
                }
            }
        }

        private void restoreCursor() {
            BrowserHelp.this.getApplication().setCursor(Cursor.getDefaultCursor());
        }

        public void eventFired(Object object, AWTEvent aWTEvent) {
            this.restoreCursor();
            JComponent jComponent = null;
            if (object instanceof JComponent) {
                jComponent = (JComponent)object;
            }
            String string = null;
            String string2 = null;
            if (jComponent != null) {
                string = (String)jComponent.getClientProperty("HELP_KEY");
                string2 = (String)jComponent.getClientProperty("TITLE");
            }
            if (string != null) {
                Log.logNotify("helptag on component = " + string);
                if (string2 != null && string2.equals("YES")) {
                    BrowserHelp.this.showDocumentWithTitle(string2);
                } else {
                    BrowserHelp.this.showDocument(BrowserHelp.this.getString(BrowserHelp.this.helpBundle, string));
                }
            }
            int n = 0;
            do {
                try {
                    AWTEvent aWTEvent2 = this.eventQueue.getNextEvent();
                    Object object2 = aWTEvent2.getSource();
                    if (object == object2 && aWTEvent2 instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)aWTEvent2;
                        int n2 = aWTEvent2.getID();
                        if (n2 == 501 || n2 == 502 || n2 == 500) {
                            Log.trace("ActionEvent consumed: " + aWTEvent2.getClass().getName());
                            mouseEvent.consume();
                            return;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    Log.logWarning("InterruptedException in TrackingListener");
                }
            } while (++n <= 5);
        }

        private Object getDeepestObjectAt(Object object, int n, int n2) {
            Component component;
            if (object != null && object instanceof Container && (component = this.findComponentAt((Container)object, n, n2)) != null && component != object) {
                if (component instanceof JRootPane) {
                    JLayeredPane jLayeredPane = ((JRootPane)component).getLayeredPane();
                    Rectangle rectangle = jLayeredPane.getBounds();
                    component = (Component)this.getDeepestObjectAt(jLayeredPane, n - rectangle.x, n2 - rectangle.y);
                    if (component != null) {
                        return component;
                    }
                } else {
                    return component;
                }
            }
            return object;
        }

        private Component findComponentAt(Container container, int n, int n2) {
            if (!container.contains(n, n2)) {
                return null;
            }
            int n3 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < n3; ++i) {
                Component component = componentArray[i];
                if (component == null) continue;
                Point point = component.getLocation();
                if ((component = component instanceof Container ? this.findComponentAt((Container)component, n - point.x, n2 - point.y) : component.getComponentAt(n - point.x, n2 - point.y)) == null || !component.isVisible()) continue;
                return component;
            }
            return container;
        }
    }

    private class KeyPressedListener
    implements KeyListener {
        private KeyPressedListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            Log.traceFlow();
            if (keyEvent.getKeyCode() == 112) {
                String string = null;
                String string2 = null;
                if (keyEvent.getModifiers() == 1) {
                    JComponent jComponent = (JComponent)keyEvent.getSource();
                    string = (String)jComponent.getClientProperty("HELP_KEY");
                    string2 = (String)jComponent.getClientProperty("TITLE");
                    Log.logNotify("Shift-F1 pressed. helptag = " + string + " , " + " component : " + jComponent);
                    keyEvent.consume();
                    if (string != null) {
                        if (string2 != null && string2.equals("YES")) {
                            BrowserHelp.this.showDocumentWithTitle(string);
                        } else {
                            BrowserHelp.this.showDocument(string);
                        }
                    }
                }
            }
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Log.log(4, "Button pressed. button = " + object);
            String string = (String)((JComponent)object).getClientProperty("HELP_KEY");
            String string2 = (String)((JComponent)object).getClientProperty("TITLE");
            if (string2 != null && string2.equals("YES")) {
                BrowserHelp.this.showDocumentWithTitle(string);
                return;
            }
            Log.logNotify("Button pressed. helptag = " + string);
            String string3 = BrowserHelp.this.getString(BrowserHelp.this.helpBundle, string);
            if (null == string3 || 0 == string3.trim().length()) {
                Object[] objectArray = new String[]{"The key for the document was: " + string};
                BrowserHelp.this.showMessageDialog("INFORMATION", "BROWSERHELP_INCORRECT_CONFIG_MSG", objectArray);
                return;
            }
            BrowserHelp.this.showDocument(BrowserHelp.this.getString(BrowserHelp.this.helpBundle, string));
        }
    }
}

