/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.wcdma.support.gui.guilib.infra.ViewContainer;

class DialogViewContainer
extends JDialog
implements ViewContainer {
    private AbstractPresenter presenter;
    private boolean visible;
    private boolean beenVisible;
    private WinAdapter winAdapter = new WinAdapter();
    private JPanel viewPane;

    public DialogViewContainer(Frame frame, boolean bl) {
        super(frame, bl);
    }

    public DialogViewContainer(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public void init(AbstractPresenter abstractPresenter) {
        this.presenter = abstractPresenter;
        this.getContentPane().setLayout(new BorderLayout());
        this.viewPane = new JPanel();
        this.viewPane.setLayout(new BoxLayout(this.viewPane, 1));
        this.getContentPane().add((Component)this.viewPane, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.winAdapter);
    }

    public void setView(AbstractView abstractView) {
        this.viewPane.removeAll();
        this.viewPane.add(abstractView);
        this.setResizable(abstractView.isResizable());
    }

    public void setViewResizable(boolean bl) {
        this.setResizable(bl);
    }

    public void setToolBar(ApplicationToolBar applicationToolBar) {
    }

    public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
    }

    public Window getWindow() {
        return this;
    }

    public Component getComponent() {
        return this;
    }

    public void setStatus(String string) {
    }

    public void setVisible(boolean bl) {
        if (this.isModal()) {
            if (!bl) {
                this.visible = bl;
            } else {
                if (this.isVisible() != this.visible) {
                    Log.logWarning("Modal dialog visibility out of sync Dialog: " + this.isVisible() + " Container: " + this.visible);
                }
                if (!this.isVisible()) {
                    this.setVisibleImpl(bl);
                }
            }
        } else {
            this.setVisibleImpl(bl);
        }
    }

    private void setVisibleImpl(boolean bl) {
        if (bl && !this.beenVisible) {
            this.pack();
            if (this.isModal()) {
                this.centerOnScreen();
            } else {
                this.centerOnOwner();
            }
        }
        this.visible = bl;
        if (bl) {
            SwingUtilities.invokeLater(new DoSetVisible());
        } else {
            this.setVisibleSuper(bl);
        }
    }

    private void setVisibleSuper(boolean bl) {
        super.setVisible(bl);
    }

    public void setEnabled(boolean bl) {
        if (this.presenter.isDefaultEnabling()) {
            super.setEnabled(bl);
        }
    }

    public void bringToFront() {
        this.toFront();
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
    }

    public void setMaximized() {
    }

    public void setMinimized() {
    }

    public void setRestored() {
    }

    public void doValidate() {
        this.validate();
        this.repaint();
    }

    public void dispose() {
        if (this.presenter != null) {
            this.getContentPane().removeAll();
            this.removeWindowListener(this.winAdapter);
            this.winAdapter = null;
        }
        super.dispose();
    }

    private void centerOnOwner() {
        Window window = this.getOwner();
        Rectangle rectangle = window.getBounds();
        if (rectangle.x <= 0 || rectangle.y <= 0) {
            this.centerOnScreen();
        } else {
            this.setLocation((rectangle.width - this.getSize().width) / 2 + rectangle.x, (rectangle.height - this.getSize().height) / 2 + rectangle.y);
        }
    }

    private void centerOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
    }

    public void addStatusBar() {
    }

    public void setHorizontalScrollBarPolicy(int n) {
    }

    public void setVerticalScrollBarPolicy(int n) {
    }

    private class DoSetVisible
    implements Runnable {
        private DoSetVisible() {
        }

        public void run() {
            if (DialogViewContainer.this.visible) {
                DialogViewContainer.this.setVisibleSuper(true);
            }
        }
    }

    private class WinAdapter
    extends WindowAdapter {
        private WinAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (!DialogViewContainer.this.beenVisible) {
                DialogViewContainer.this.beenVisible = true;
                if (DialogViewContainer.this.isModal()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DialogViewContainer.this.presenter.getController().afterVisible();
                        }
                    });
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (DialogViewContainer.this.presenter.isEnabled()) {
                DialogViewContainer.this.presenter.getController().viewClosing();
            }
        }
    }
}

