/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import sun.misc.SoftCache;

public abstract class GuilibResourceBundle {
    private static final ResourceCacheKey cachedKey = new ResourceCacheKey();
    private static final int INIT_CACHE_SIZE = 25;
    private static final float CACHE_FACTOR = 1.0f;
    private static final int MAX_BUNDLE_SEARCHED = 3;
    private static final Hashtable inConstruction = new Hashtable(3, 1.0f);
    private static final Integer DEF_NOT_FOUND = -1;
    private static SoftCache cachedList = new SoftCache(25, 1.0f);
    protected ResourceBundle parents = null;

    protected void setParent(ResourceBundle resourceBundle) {
        this.parents = resourceBundle;
    }

    public static ResourceBundle getBundle(String string, ClassLoader classLoader) throws MissingResourceException {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return GuilibResourceBundle.getBundleImpl(string, Locale.getDefault(), classLoader);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return GuilibResourceBundle.getBundleImpl(string, locale, classLoader);
    }

    private static ResourceBundle getBundleImpl(String string, Locale locale, ClassLoader classLoader) {
        if (string == null) {
            throw new NullPointerException();
        }
        Object object = classLoader != null ? classLoader : DEF_NOT_FOUND;
        String string2 = string;
        String string3 = locale.toString();
        if (string3.length() > 0) {
            string2 = string2 + "_" + string3;
        } else if (locale.getVariant().length() > 0) {
            string2 = string2 + "___" + locale.getVariant();
        }
        Object object2 = GuilibResourceBundle.findBundleInCache(classLoader, string2);
        if (object2 == object) {
            GuilibResourceBundle.throwMissingResourceException(string, locale);
        } else if (object2 != null) {
            return (ResourceBundle)object2;
        }
        Object object3 = object;
        try {
            boolean bl;
            Object object4 = GuilibResourceBundle.findBundle(classLoader, string, string, null, object);
            if (object4 == null) {
                GuilibResourceBundle.putBundleInCache(classLoader, string, object);
                object4 = object;
            }
            Vector vector = GuilibResourceBundle.calculateBundleNames(string, locale);
            boolean bl2 = bl = object4 != object && vector.size() == 0;
            if (!bl) {
                object3 = object4;
                for (int i = vector.size(); i > 0; --i) {
                    string2 = (String)vector.elementAt(i - 1);
                    object2 = GuilibResourceBundle.findBundle(classLoader, string2, string, object3, object);
                    if (object2 == null) continue;
                    object3 = object2;
                    bl = true;
                    break;
                }
            }
            object3 = object4;
            if (!bl) {
                Vector vector2 = GuilibResourceBundle.calculateBundleNames(string, Locale.getDefault());
                for (int i = 0; i < vector2.size() && !vector.contains(string2 = (String)vector2.elementAt(i)); ++i) {
                    object2 = GuilibResourceBundle.findBundle(classLoader, string2, string, object3, object);
                    if (object2 != null) {
                        object3 = object2;
                        continue;
                    }
                    GuilibResourceBundle.putBundleInCache(classLoader, string2, object3);
                }
            }
            object3 = GuilibResourceBundle.propagate(classLoader, vector, object3);
        }
        catch (Exception exception) {
            GuilibResourceBundle.cleanUpConstructionList();
            GuilibResourceBundle.throwMissingResourceException(string, locale);
        }
        catch (Error error) {
            GuilibResourceBundle.cleanUpConstructionList();
            throw error;
        }
        if (object3 == object) {
            GuilibResourceBundle.throwMissingResourceException(string, locale);
        }
        Log.logNotify(string2 + " has been loaded");
        return (ResourceBundle)object3;
    }

    private static Object propagate(ClassLoader classLoader, Vector vector, Object object) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            Object object2 = GuilibResourceBundle.findBundleInCache(classLoader, string);
            if (object2 == null) {
                GuilibResourceBundle.putBundleInCache(classLoader, string, object);
                continue;
            }
            object = object2;
        }
        return object;
    }

    private static void throwMissingResourceException(String string, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            Collection collection = inConstruction.values();
            Thread thread = Thread.currentThread();
            while (collection.remove(thread)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader classLoader, String string, String string2, Object object, Object object2) {
        Thread thread;
        Object object3;
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            boolean bl;
            cachedKey.setKeyValues(classLoader, string);
            object3 = cachedList.get((Object)cachedKey);
            if (object3 != null) {
                cachedKey.clear();
                return object3;
            }
            thread = (Thread)inConstruction.get(cachedKey);
            boolean bl2 = bl = thread != null && thread != Thread.currentThread();
            if (bl) {
                while (bl) {
                    cachedKey.clear();
                    try {
                        cachedList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cachedKey.setKeyValues(classLoader, string);
                    bl = inConstruction.containsKey(cachedKey);
                }
                object3 = cachedList.get((Object)cachedKey);
                if (object3 != null) {
                    cachedKey.clear();
                    return object3;
                }
            }
            Object object4 = cachedKey.clone();
            inConstruction.put(object4, Thread.currentThread());
            cachedKey.clear();
        }
        object3 = GuilibResourceBundle.loadBundle(classLoader, string);
        if (object3 != null) {
            boolean bl;
            thread = cachedList;
            synchronized (thread) {
                cachedKey.setKeyValues(classLoader, string);
                bl = inConstruction.get(cachedKey) == Thread.currentThread();
                cachedKey.clear();
            }
            if (bl) {
                GuilibResourceBundle.putBundleInCache(classLoader, string, object3);
            }
        }
        return object3;
    }

    private static Vector calculateBundleNames(String string, Locale locale) {
        String string2;
        int n;
        String string3;
        int n2;
        Vector<String> vector = new Vector<String>(3);
        String string4 = locale.getLanguage();
        int n3 = string4.length();
        if (n3 + (n2 = (string3 = locale.getCountry()).length()) + (n = (string2 = locale.getVariant()).length()) == 0) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(string4);
        vector.addElement(stringBuffer.toString());
        if (n2 + n == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string3);
        vector.addElement(stringBuffer.toString());
        if (n == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string2);
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader classLoader, String string) {
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            cachedKey.setKeyValues(classLoader, string);
            Object object = cachedList.get((Object)cachedKey);
            cachedKey.clear();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader classLoader, String string, Object object) {
        SoftCache softCache = cachedList;
        synchronized (softCache) {
            cachedKey.setKeyValues(classLoader, string);
            cachedList.put(cachedKey.clone(), object);
            inConstruction.remove(cachedKey);
            cachedKey.clear();
            cachedList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadBundle(final ClassLoader classLoader, String string) {
        final String string2 = string.replace('.', '/') + ".properties";
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(string2);
                }
                return ClassLoader.getSystemResourceAsStream(string2);
            }
        });
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream);
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(inputStream);
                return propertyResourceBundle;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            if (ResourceBundle.class.isAssignableFrom(clazz)) {
                Object obj = clazz.newInstance();
                Object object = GuilibResourceBundle.findBundleInCache(classLoader, string);
                if (object != null) {
                    return object;
                }
                return obj;
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderReference;
        private String searchNames;
        private int hashCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            try {
                ResourceCacheKey resourceCacheKey = (ResourceCacheKey)object;
                if (this.hashCache != resourceCacheKey.hashCache) {
                    return false;
                }
                if (!this.searchNames.equals(resourceCacheKey.searchNames)) {
                    return false;
                }
                if (this.loaderReference == null) {
                    return resourceCacheKey.loaderReference == null;
                }
                return resourceCacheKey.loaderReference != null && this.loaderReference.get() == resourceCacheKey.loaderReference.get();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader classLoader, String string) {
            this.searchNames = string;
            this.hashCache = string.hashCode();
            if (classLoader == null) {
                this.loaderReference = null;
            } else {
                this.loaderReference = new SoftReference<ClassLoader>(classLoader);
                this.hashCache ^= classLoader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "");
        }
    }
}

