/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.wcdma.support.gui.guilib.infra.EditListeners;
import se.ericsson.wcdma.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.wcdma.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.wcdma.support.gui.guilib.infra.MenuToolbarHandler;
import se.ericsson.wcdma.support.gui.guilib.infra.ResourceBundleDelegator;
import se.ericsson.wcdma.support.gui.guilib.infra.Resources;
import se.ericsson.wcdma.support.gui.guilib.infra.Translatable;

class LanguageManager
extends AbstractHandler {
    static final char MNEMONIC_INDICATOR = '&';
    static final char SHORTCUT_INDICATOR = '|';
    static final String SUPPORTED_LOCALES = "gsl.language.supportedlocales";
    static final Locale EMPTY_LOCALE = new Locale("", "");
    static final String DEFAULT_LANGUAGE_BUNDLE_NAME_KEY = "gsl.language.default.bundle.name";
    static final String DEFAULT_TOOLTIP_BUNDLE_NAME_KEY = "gsl.tooltip.default.bundle.name";
    static final String SYSTEM_LANGUAGE_BUNDLE_NAME_KEY = "gsl.language.system.bundle.name";
    static final String SYSTEM_TOOLTIP_BUNDLE_NAME_KEY = "gsl.tooltip.system.bundle.name";
    static final String UI_STRINGS_BUNDLE_NAME_KEY = "gsl.ui.strings.bundle.name";
    static final String UI_MNEMONICS_BUNDLE_NAME_KEY = "gsl.ui.mnemonics.bundle.name";
    static final String KEY = "gsl.lanaguage.key";
    static final String TOOLTIPKEY = "gsl.tooltip.key";
    private Vector languageComponents = new Vector();
    private ResourceBundleDelegator languageBundle;
    private ResourceBundleDelegator toolTipBundle;
    private boolean stripShortcut = false;
    private Locale locale;

    LanguageManager() {
    }

    private void addBundle(String string, ResourceBundleDelegator resourceBundleDelegator) {
        Log.log(4, "Trying to load bundle:" + string);
        ResourceBundle resourceBundle = this.getBundle(string);
        if (resourceBundle != null) {
            resourceBundleDelegator.add(resourceBundle);
        } else {
            Log.trace("Not able to load bundle:" + string);
        }
    }

    public void dispose() {
        Enumeration enumeration = this.languageComponents.elements();
        while (enumeration.hasMoreElements()) {
            ((AbstractLanguageHandler)enumeration.nextElement()).dispose();
        }
        this.languageComponents.clear();
    }

    public boolean handleComponent(JComponent jComponent) {
        return this.handleComponent_Impl(jComponent);
    }

    private boolean handleComponent_Impl(JComponent jComponent) {
        String string = (String)jComponent.getClientProperty("LANGUAGE_CONTROLLED");
        if (string != null) {
            if (jComponent instanceof LocaleChangeListener) {
                this.presenter.addLocaleChangeListener((LocaleChangeListener)((Object)jComponent));
            }
            if (string.equals("NT")) {
                return true;
            }
            if (string.equals("NA")) {
                return false;
            }
        } else if (jComponent instanceof Translatable) {
            new TranslatableLanguageHandler(jComponent);
        } else if (jComponent instanceof JButton) {
            new AbstractButtonLanguageHandler(jComponent);
        } else if (jComponent instanceof JColorChooser) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JComboBox) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JFileChooser) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JLabel) {
            new JLabelLanguageHandler(jComponent);
        } else if (jComponent instanceof JList) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JMenuBar) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JMenuItem) {
            new JMenuItemLanguageHandler(jComponent);
        } else if (jComponent instanceof JOptionPane) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JPanel) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JPopupMenu) {
            new JPopupMenuLanguageHandler(jComponent);
        } else if (jComponent instanceof JPopupMenu.Separator) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JProgressBar) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JScrollBar) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JScrollPane) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JSeparator) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JSlider) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JSplitPane) {
            new JComponentLanguageHandler(jComponent);
        } else if (jComponent instanceof JTabbedPane) {
            new JTabbedPaneLanguageHandler(jComponent);
        } else {
            if (jComponent instanceof JTable) {
                new JTableLanguageHandler(jComponent);
                return false;
            }
            if (jComponent instanceof JTextComponent) {
                new JTextComponentLanguageHandler(jComponent);
            } else if (jComponent instanceof JToggleButton) {
                new AbstractButtonLanguageHandler(jComponent);
            } else if (jComponent instanceof JToolBar) {
                new JComponentLanguageHandler(jComponent);
            } else if (jComponent instanceof JToolBar.Separator) {
                new JComponentLanguageHandler(jComponent);
            } else if (jComponent instanceof JToolTip) {
                new JComponentLanguageHandler(jComponent);
            } else if (jComponent instanceof JViewport) {
                new JComponentLanguageHandler(jComponent);
            } else if (jComponent instanceof AbstractButton) {
                new AbstractButtonLanguageHandler(jComponent);
            } else if (!(jComponent instanceof JRootPane)) {
                if (jComponent instanceof JLayeredPane) {
                    new JComponentLanguageHandler(jComponent);
                } else if (jComponent instanceof JSplitPane) {
                    new JComponentLanguageHandler(jComponent);
                } else {
                    if (jComponent instanceof JTree) {
                        new JComponentLanguageHandler(jComponent);
                        return false;
                    }
                    if (jComponent instanceof JTableHeader) {
                        new JTableHeaderLanguageHandler(jComponent);
                        return false;
                    }
                    if (jComponent instanceof JComponent) {
                        new JComponentLanguageHandler(jComponent);
                        return false;
                    }
                    new JComponentLanguageHandler(jComponent);
                    Log.logWarning("Unknown component " + jComponent.getClass());
                }
            }
        }
        return true;
    }

    private ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (string != null) {
            Log.assertion(!string.equals(""), "Not allowed to specify empty string as bundle name");
            try {
                resourceBundle = GuilibResourceBundle.getBundle(string, this.locale, this.getClass().getClassLoader());
            }
            catch (Throwable throwable) {
                String string2 = "Could not load bundle named: " + string;
                Log.logError(string2, throwable);
                Log.assertion(false, string2);
            }
        }
        return resourceBundle;
    }

    ResourceBundle getLanguageBundle() {
        return this.languageBundle;
    }

    private Character getMnemonic(String string) {
        Character c = null;
        int n = string.indexOf(38);
        if (n != -1) {
            c = new Character(string.charAt(n + 1));
        }
        return c;
    }

    String getString(String string, boolean bl) {
        Log.trace("LanguageManager.getString(): key    = " + string);
        String string2 = this.lookupString(this.languageBundle, string);
        if (string2 == null) {
            string2 = "UNRESOLVED MESSAGE: " + string;
        }
        if (bl) {
            string2 = this.stripString(string2);
        }
        Log.trace("LanguageManager.getString(): string = " + string2);
        return string2;
    }

    ResourceBundle getToolTipBundle() {
        return this.toolTipBundle;
    }

    private String getToolTipString(String string) {
        if (string.startsWith("[")) {
            return string;
        }
        String string2 = this.lookupString(this.toolTipBundle, string);
        if (string2 == null) {
            string2 = "UNRESOLVED MESSAGE: " + string;
        }
        return string2;
    }

    public void init() {
        this.locale = this.getApplication().getLocale();
        Properties properties = this.getApplication().getEnvironment();
        Resources resources = this.getResources();
        Log.measure("getBundles", true, "LanguageManager.getBundles in init()");
        this.languageBundle = new ResourceBundleDelegator();
        this.addBundle(properties.getProperty(DEFAULT_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
        this.addBundle(properties.getProperty(SYSTEM_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
        this.addBundle(resources.getLanguageBundleName(), this.languageBundle);
        this.toolTipBundle = new ResourceBundleDelegator();
        this.addBundle(properties.getProperty(DEFAULT_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
        this.addBundle(properties.getProperty(SYSTEM_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
        this.addBundle(resources.getToolTipBundleName(), this.toolTipBundle);
        Log.measure("getBundles", false);
    }

    private String lookupString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    private String stripString(String string) {
        int n = string.lastIndexOf(124);
        String string2 = string;
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        String string3 = string2;
        int n2 = string2.indexOf(38);
        string3 = "";
        if (n2 > 0) {
            string3 = string2.substring(0, n2);
        }
        if (string2.length() > n2 + 1) {
            string3 = string3 + string2.substring(n2 + 1);
        }
        return string3;
    }

    void stripShortCut(boolean bl) {
        this.stripShortcut = bl;
    }

    public void updateLocale(Locale locale) {
        Log.measure("updateLocale", true, "LanguageManager.updateLocale");
        if (!this.locale.equals(locale)) {
            Log.trace("LanguageManager: Locale changed: " + locale);
            this.locale = locale;
            Properties properties = this.getApplication().getEnvironment();
            Resources resources = this.getResources();
            this.languageBundle = new ResourceBundleDelegator();
            this.addBundle(properties.getProperty(DEFAULT_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
            this.addBundle(properties.getProperty(SYSTEM_LANGUAGE_BUNDLE_NAME_KEY), this.languageBundle);
            this.addBundle(resources.getLanguageBundleName(), this.languageBundle);
            this.toolTipBundle = new ResourceBundleDelegator();
            this.addBundle(properties.getProperty(DEFAULT_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
            this.addBundle(properties.getProperty(SYSTEM_TOOLTIP_BUNDLE_NAME_KEY), this.toolTipBundle);
            this.addBundle(resources.getToolTipBundleName(), this.toolTipBundle);
        }
        Log.trace("LanguageManager: Updating language on components");
        for (int i = 0; i < this.languageComponents.size(); ++i) {
            ((AbstractLanguageHandler)this.languageComponents.elementAt(i)).updateLanguage();
        }
        Log.measure("updateLocale", false);
    }

    private class JMenuItemLanguageHandler
    extends AbstractButtonLanguageHandler {
        public JMenuItemLanguageHandler(JComponent jComponent) {
            super(jComponent);
        }

        public void updateLanguage() {
            String string;
            int n;
            if (this.labelKey != null && this.labelKey != "" && !(this.myComponent instanceof JMenu) && (n = (string = LanguageManager.this.getString(this.labelKey, false)).lastIndexOf(124)) != -1) {
                String string2 = string.substring(n + 1);
                if (!LanguageManager.this.stripShortcut) {
                    ((JMenuItem)this.myComponent).setAccelerator(KeyStroke.getKeyStroke(string2));
                }
            }
            super.updateLanguage();
        }
    }

    private class JLabelLanguageHandler
    extends JComponentLanguageHandler {
        private String labelKey;

        public JLabelLanguageHandler(JComponent jComponent) {
            super(jComponent);
            this.labelKey = ((JLabel)this.myComponent).getText();
            if (this.labelKey == null) {
                Log.logWarning("JLabelLanguageHandler Text is missing!");
            }
        }

        public void updateLanguage() {
            if (this.labelKey != null && this.labelKey != "") {
                String string = LanguageManager.this.getString(this.labelKey, false);
                Character c = LanguageManager.this.getMnemonic(string);
                if (c != null) {
                    ((JLabel)this.myComponent).setDisplayedMnemonic(c.charValue());
                }
                ((JLabel)this.myComponent).setText(LanguageManager.this.stripString(string));
            }
            super.updateLanguage();
        }
    }

    private class JPopupMenuLanguageHandler
    extends JComponentLanguageHandler {
        private String labelKey;

        public JPopupMenuLanguageHandler(JComponent jComponent) {
            super(jComponent);
            this.labelKey = ((JPopupMenu)this.myComponent).getLabel();
        }

        public void updateLanguage() {
            if (this.labelKey != null) {
                ((JPopupMenu)this.myComponent).setLabel(LanguageManager.this.getString(this.labelKey, true));
            }
            super.updateLanguage();
        }
    }

    private class JTableHeaderLanguageHandler
    extends JComponentLanguageHandler {
        private Object[][] headerToolTipKeys;

        public JTableHeaderLanguageHandler(JComponent jComponent) {
            super(jComponent);
            this.init();
            LanguageManager.this.languageComponents.addElement(this);
            this.updateLanguage();
        }

        private void init() {
            JTableHeader jTableHeader = (JTableHeader)this.myComponent;
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            this.headerToolTipKeys = new Object[tableColumnModel.getColumnCount()][2];
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer instanceof JComponent) {
                    this.headerToolTipKeys[i][0] = tableCellRenderer;
                    this.headerToolTipKeys[i][1] = ((JComponent)((Object)tableCellRenderer)).getToolTipText();
                    continue;
                }
                this.headerToolTipKeys[i][0] = null;
                this.headerToolTipKeys[i][1] = null;
            }
        }

        public void updateLanguage() {
            if (this.headerToolTipKeys != null) {
                for (int i = 0; i < this.headerToolTipKeys.length; ++i) {
                    if (this.headerToolTipKeys[i][1] == null) continue;
                    ((JComponent)this.headerToolTipKeys[i][0]).setToolTipText(LanguageManager.this.getToolTipString((String)this.headerToolTipKeys[i][1]));
                }
            }
            super.updateLanguage();
        }
    }

    private class JTableLanguageHandler
    extends JComponentLanguageHandler
    implements PropertyChangeListener {
        private Object[][] labelKeys;
        private Object[][] headerToolTipKeys;
        private Object[][] columnToolTipKeys;

        public JTableLanguageHandler(JComponent jComponent) {
            super(jComponent);
            this.init();
            jComponent.addPropertyChangeListener(this);
            LanguageManager.this.languageComponents.addElement(this);
        }

        private void init() {
            JTableHeader jTableHeader = ((JTable)this.myComponent).getTableHeader();
            if (jTableHeader != null) {
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                this.labelKeys = new Object[tableColumnModel.getColumnCount()][2];
                this.headerToolTipKeys = new Object[tableColumnModel.getColumnCount()][2];
                this.columnToolTipKeys = new Object[tableColumnModel.getColumnCount()][2];
                for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    this.labelKeys[i][0] = tableColumn;
                    this.labelKeys[i][1] = tableColumn.getHeaderValue().toString();
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    if (tableCellRenderer instanceof JComponent) {
                        this.headerToolTipKeys[i][0] = tableCellRenderer;
                        this.headerToolTipKeys[i][1] = ((JComponent)((Object)tableCellRenderer)).getToolTipText();
                    } else {
                        this.headerToolTipKeys[i][0] = null;
                        this.headerToolTipKeys[i][1] = null;
                    }
                    TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
                    if (tableCellRenderer2 instanceof JComponent) {
                        this.columnToolTipKeys[i][0] = tableCellRenderer2;
                        this.columnToolTipKeys[i][1] = ((JComponent)((Object)tableCellRenderer2)).getToolTipText();
                        continue;
                    }
                    this.columnToolTipKeys[i][0] = null;
                    this.columnToolTipKeys[i][1] = null;
                }
            }
        }

        public void updateLanguage() {
            if (this.labelKeys != null) {
                for (int i = 0; i < this.labelKeys.length; ++i) {
                    ((TableColumn)this.labelKeys[i][0]).setHeaderValue(LanguageManager.this.getString((String)this.labelKeys[i][1], true));
                    if (this.headerToolTipKeys[i][1] != null) {
                        ((JComponent)this.headerToolTipKeys[i][0]).setToolTipText(LanguageManager.this.getToolTipString((String)this.headerToolTipKeys[i][1]));
                    }
                    if (this.columnToolTipKeys[i][1] == null) continue;
                    ((JComponent)this.columnToolTipKeys[i][0]).setToolTipText(LanguageManager.this.getToolTipString((String)this.columnToolTipKeys[i][1]));
                }
            }
            super.updateLanguage();
        }

        public void dispose() {
            this.myComponent.removePropertyChangeListener(this);
            super.dispose();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                this.init();
                this.updateLanguage();
                this.myComponent.revalidate();
                this.myComponent.repaint();
            }
        }
    }

    private class JTextComponentLanguageHandler
    extends JComponentLanguageHandler {
        public JTextComponentLanguageHandler(JComponent jComponent) {
            super(jComponent);
            MenuToolbarHandler menuToolbarHandler = LanguageManager.this.getApplication().getApplicationPresenter().getMenuToolBarHandler();
            if (menuToolbarHandler != null) {
                Action[] actionArray = menuToolbarHandler.getApplicationDefaultView().getEditActions();
                new EditListeners(actionArray, (JTextComponent)this.myComponent);
            }
        }
    }

    private class JTabbedPaneLanguageHandler
    extends JComponentLanguageHandler {
        private String[] labelKeys;

        public JTabbedPaneLanguageHandler(JComponent jComponent) {
            super(jComponent);
            JTabbedPane jTabbedPane = (JTabbedPane)jComponent;
            this.labelKeys = new String[jTabbedPane.getTabCount()];
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                this.labelKeys[i] = jTabbedPane.getTitleAt(i);
            }
            LanguageManager.this.languageComponents.addElement(this);
        }

        public void updateLanguage() {
            for (int i = 0; i < this.labelKeys.length; ++i) {
                ((JTabbedPane)this.myComponent).setTitleAt(i, LanguageManager.this.getString(this.labelKeys[i], true));
            }
            super.updateLanguage();
        }
    }

    private class AbstractButtonLanguageHandler
    extends JComponentLanguageHandler {
        protected String labelKey;

        public AbstractButtonLanguageHandler(JComponent jComponent) {
            super(jComponent);
            AbstractButton abstractButton = (AbstractButton)this.myComponent;
            this.labelKey = abstractButton.getText();
            String string = (String)abstractButton.getClientProperty(LanguageManager.KEY);
            if (string == null) {
                abstractButton.putClientProperty(LanguageManager.KEY, this.labelKey);
            } else {
                this.labelKey = string;
            }
        }

        public void updateLanguage() {
            if (this.labelKey != null && this.labelKey != "") {
                String string = LanguageManager.this.getString(this.labelKey, false);
                Character c = LanguageManager.this.getMnemonic(string);
                if (c != null) {
                    ((AbstractButton)this.myComponent).setMnemonic(c.charValue());
                }
                ((AbstractButton)this.myComponent).setText(LanguageManager.this.stripString(string));
            }
            super.updateLanguage();
        }
    }

    private class TranslatableLanguageHandler
    extends JComponentLanguageHandler {
        public TranslatableLanguageHandler(JComponent jComponent) {
            super(jComponent);
        }

        public void updateLanguage() {
            ((Translatable)((Object)this.myComponent)).translate(LanguageManager.this.languageBundle, LanguageManager.this.locale);
            super.updateLanguage();
        }
    }

    private class JComponentLanguageHandler
    extends AbstractLanguageHandler {
        private String toolTipKey;
        private String borderTitleKey;
        protected JComponent myComponent;

        public JComponentLanguageHandler(JComponent jComponent) {
            this.myComponent = jComponent;
            this.toolTipKey = this.myComponent.getToolTipText();
            TitledBorder titledBorder = this.findTitledBorder(this.myComponent.getBorder());
            if (titledBorder != null) {
                this.borderTitleKey = titledBorder.getTitle();
            }
            LanguageManager.this.languageComponents.addElement(this);
        }

        private TitledBorder findTitledBorder(Border border) {
            TitledBorder titledBorder = null;
            if (border != null) {
                if (border instanceof TitledBorder) {
                    titledBorder = (TitledBorder)border;
                } else if (border instanceof CompoundBorder && (titledBorder = this.findTitledBorder(((CompoundBorder)border).getOutsideBorder())) == null) {
                    titledBorder = this.findTitledBorder(((CompoundBorder)border).getInsideBorder());
                }
            }
            return titledBorder;
        }

        public void updateLanguage() {
            Serializable serializable;
            if (this.toolTipKey != null) {
                if (this.myComponent instanceof JMenuItem) {
                    serializable = (AbstractButton)this.myComponent;
                    String string = (String)((JComponent)serializable).getClientProperty(LanguageManager.TOOLTIPKEY);
                    if (string == null) {
                        ((JComponent)serializable).putClientProperty(LanguageManager.TOOLTIPKEY, this.toolTipKey);
                    } else {
                        this.toolTipKey = string;
                    }
                }
                this.myComponent.setToolTipText(LanguageManager.this.getToolTipString(this.toolTipKey));
            }
            if (this.borderTitleKey != null && (serializable = this.findTitledBorder(this.myComponent.getBorder())) != null) {
                if (serializable instanceof Translatable) {
                    ((Translatable)((Object)serializable)).translate(LanguageManager.this.languageBundle, LanguageManager.this.locale);
                } else {
                    ((TitledBorder)serializable).setTitle(LanguageManager.this.getString(this.borderTitleKey, true));
                }
            }
            this.myComponent.revalidate();
            this.myComponent.repaint();
        }
    }

    private abstract class AbstractLanguageHandler {
        private AbstractLanguageHandler() {
        }

        public abstract void updateLanguage();

        public void dispose() {
        }
    }
}

