/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.KeyStroke;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractWizardController;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardDefaultView;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardSlidePresenter;

class WizardDefaultController
extends AbstractController {
    private WizardDefaultView view;
    private PrevAction prevAction = new PrevAction();
    private NextAction nextAction = new NextAction();
    private CancelAction cancelAction = new CancelAction();
    private CloseAction closeAction = new CloseAction();
    private CancelActionAction cancelActionAction = new CancelActionAction();

    WizardDefaultController() {
    }

    private WizardPresenter getWizardPresenter() {
        return (WizardPresenter)this.getPresenter().getParentPresenter();
    }

    protected void init() {
        this.view = ((WizardSlidePresenter)this.getPresenter()).getWizardDefaultView();
        AbstractWizardController abstractWizardController = (AbstractWizardController)this.getPresenter().getController();
        this.view.prevButton.addActionListener(this.prevAction);
        this.view.nextButton.addActionListener(this.nextAction);
        this.view.cancelButton.addActionListener(this.cancelAction);
        this.view.closeButton.addActionListener(this.closeAction);
        this.view.cancelActionButton.addActionListener(this.cancelActionAction);
        this.view.cancelButton.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WizardDefaultController.this.getWizardPresenter().cancel();
                }
                catch (Exception exception) {
                    Log.trace("WizardDefaultController exception while doing cancel");
                }
            }
        }, "", KeyStroke.getKeyStroke(27, 0, false), 2);
        if (abstractWizardController.getHelpId() != null) {
            this.view.helpButton.putClientProperty("HELP_KEY", abstractWizardController.getHelpId());
            this.view.helpButton.putClientProperty("HELP_ENABLE", "");
        } else {
            this.view.helpButton.setEnabled(false);
        }
        abstractWizardController.setPreviousEnabled(!((WizardSlidePresenter)this.getPresenter()).isFirst());
        if (((WizardSlidePresenter)this.getPresenter()).isLast()) {
            this.view.nextButton.setText("GSL_FINISH");
        }
    }

    protected void stop() {
        this.view.prevButton.removeActionListener(this.prevAction);
        this.view.nextButton.removeActionListener(this.nextAction);
        this.view.cancelButton.removeActionListener(this.cancelAction);
        this.view.closeButton.removeActionListener(this.closeAction);
        this.view.cancelActionButton.removeActionListener(this.cancelActionAction);
        this.view.cancelButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.view = null;
    }

    private class CancelActionAction
    implements ActionListener {
        private CancelActionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WizardDefaultController.this.getWizardPresenter().cancelAction();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WizardDefaultController.this.getWizardPresenter().close();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WizardDefaultController.this.getWizardPresenter().cancel();
        }
    }

    private class NextAction
    implements ActionListener {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((WizardSlidePresenter)WizardDefaultController.this.getPresenter()).isLast()) {
                if (((AbstractWizardController)WizardDefaultController.this.getPresenter().getController()).finish()) {
                    WizardDefaultController.this.getPresenter().getParentPresenter().stopNoCheck();
                }
            } else {
                Thread thread = new Thread("BEM WizardDefaultController NextAction"){

                    public void run() {
                        WizardDefaultController.this.getWizardPresenter().showNext();
                    }
                };
                thread.start();
            }
        }
    }

    private class PrevAction
    implements ActionListener {
        private PrevAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WizardDefaultController.this.getWizardPresenter().showPrevious();
        }
    }
}

