/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBitString;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERInteger;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.pkcs.PKCSObjectIdentifiers;
import com.maverick.crypto.asn1.x509.AlgorithmIdentifier;
import com.maverick.crypto.asn1.x509.SubjectPublicKeyInfo;
import com.maverick.crypto.asn1.x509.TBSCertificateStructure;
import com.maverick.crypto.asn1.x509.Time;
import com.maverick.crypto.asn1.x509.X509Name;
import com.maverick.crypto.asn1.x509.X509ObjectIdentifiers;

public class X509CertificateStructure
implements DEREncodable,
X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    ASN1Sequence p;
    TBSCertificateStructure s;
    AlgorithmIdentifier q;
    DERBitString r;

    public static X509CertificateStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509CertificateStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static X509CertificateStructure getInstance(Object object) {
        if (object instanceof X509CertificateStructure) {
            return (X509CertificateStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509CertificateStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public X509CertificateStructure(ASN1Sequence aSN1Sequence) {
        this.p = aSN1Sequence;
        if (aSN1Sequence.size() == 3) {
            this.s = TBSCertificateStructure.getInstance(aSN1Sequence.getObjectAt(0));
            this.q = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            this.r = (DERBitString)aSN1Sequence.getObjectAt(2);
        }
    }

    public TBSCertificateStructure getTBSCertificate() {
        return this.s;
    }

    public int getVersion() {
        return this.s.getVersion();
    }

    public DERInteger getSerialNumber() {
        return this.s.getSerialNumber();
    }

    public X509Name getIssuer() {
        return this.s.getIssuer();
    }

    public Time getStartDate() {
        return this.s.getStartDate();
    }

    public Time getEndDate() {
        return this.s.getEndDate();
    }

    public X509Name getSubject() {
        return this.s.getSubject();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.s.getSubjectPublicKeyInfo();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.q;
    }

    public DERBitString getSignature() {
        return this.r;
    }

    public DERObject getDERObject() {
        return this.p;
    }
}

