/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.scp;

import com.maverick.sftp.FileTransferProgress;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshSession;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ScpClientIO {
    protected SshClient ssh;
    boolean k = true;

    public ScpClientIO(SshClient sshClient) {
        this.ssh = sshClient;
    }

    public void put(InputStream inputStream, long l, String string, String string2) throws SshException, ChannelOpenException {
        this.put(inputStream, l, string, string2, null);
    }

    public void put(InputStream inputStream, long l, String string, String string2, FileTransferProgress fileTransferProgress) throws SshException, ChannelOpenException {
        ScpEngineIO scpEngineIO = new ScpEngineIO("scp -t " + string2, this.ssh.openSessionChannel());
        try {
            scpEngineIO.waitForResponse();
            if (fileTransferProgress != null) {
                fileTransferProgress.started(l, string2);
            }
            scpEngineIO.writeStreamToRemote(inputStream, l, string, fileTransferProgress);
            if (fileTransferProgress != null) {
                fileTransferProgress.completed();
            }
            scpEngineIO.close();
        }
        catch (IOException iOException) {
            scpEngineIO.close();
            throw new SshException(iOException, 6);
        }
    }

    public InputStream get(String string) throws SshException, ChannelOpenException {
        return this.get(string, null);
    }

    public InputStream get(String string, FileTransferProgress fileTransferProgress) throws SshException, ChannelOpenException {
        ScpEngineIO scpEngineIO = new ScpEngineIO("scp -f " + string, this.ssh.openSessionChannel());
        try {
            return scpEngineIO.readStreamFromRemote(string, fileTransferProgress);
        }
        catch (IOException iOException) {
            scpEngineIO.close();
            throw new SshException(iOException, 6);
        }
    }

    static class _b
    extends InputStream {
        long f;
        InputStream b;
        long e;
        ScpEngineIO d;
        FileTransferProgress c;
        String g;

        _b(long l, InputStream inputStream, ScpEngineIO scpEngineIO, FileTransferProgress fileTransferProgress, String string) {
            this.f = l;
            this.b = inputStream;
            this.d = scpEngineIO;
            this.c = fileTransferProgress;
            this.g = string;
        }

        public int read() throws IOException {
            if (this.e == this.f) {
                return -1;
            }
            if (this.e >= this.f) {
                throw new EOFException("End of file.");
            }
            int n = this.b.read();
            if (n == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            ++this.e;
            if (this.e == this.f) {
                this.d.waitForResponse();
                this.d.writeOk();
                if (this.c != null) {
                    this.c.completed();
                }
            }
            if (this.c != null) {
                if (this.c.isCancelled()) {
                    throw new SshIOException(new SshException("SCP transfer was cancelled by user", 18));
                }
                this.c.progressed(this.e);
            }
            return n;
        }

        public int available() throws IOException {
            if (this.e == this.f) {
                return -1;
            }
            return (int)(this.f - this.e);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.e >= this.f) {
                return -1;
            }
            int n3 = this.b.read(byArray, n, (int)(this.f - this.e > (long)n2 ? (long)n2 : this.f - this.e));
            if (n3 == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            this.e += (long)n3;
            if (this.e >= this.f) {
                this.d.waitForResponse();
                this.d.writeOk();
                if (this.c != null) {
                    this.c.completed();
                }
            }
            if (this.c != null) {
                if (this.c.isCancelled()) {
                    throw new SshIOException(new SshException("SCP transfer was cancelled by user", 18));
                }
                this.c.progressed(this.e);
            }
            return n3;
        }

        public void close() throws IOException {
            try {
                this.d.close();
            }
            catch (SshException sshException) {
                throw new SshIOException(sshException);
            }
        }
    }

    public class ScpEngineIO {
        protected byte[] buffer = new byte[16384];
        protected String cmd;
        protected SshSession session;
        protected OutputStream out;
        protected InputStream in;

        protected ScpEngineIO(String string, SshSession sshSession) throws SshException {
            try {
                this.session = sshSession;
                this.cmd = string;
                this.in = sshSession.getInputStream();
                this.out = sshSession.getOutputStream();
                if (!sshSession.executeCommand(string)) {
                    sshSession.close();
                    throw new SshException("Failed to execute the command " + string, 6);
                }
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
        }

        public void close() throws SshException {
            try {
                this.session.getOutputStream().close();
            }
            catch (IOException iOException) {
                throw new SshException(iOException);
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.session.close();
        }

        protected void writeStreamToRemote(InputStream inputStream, long l, String string, FileTransferProgress fileTransferProgress) throws IOException {
            String string2 = "C0644 " + l + " " + string + "\n";
            this.out.write(string2.getBytes());
            this.waitForResponse();
            this.writeCompleteFile(inputStream, l, fileTransferProgress);
            this.writeOk();
            this.waitForResponse();
        }

        protected InputStream readStreamFromRemote(String string, FileTransferProgress fileTransferProgress) throws IOException {
            String string2;
            String[] stringArray = new String[3];
            this.writeOk();
            block9: while (true) {
                try {
                    string2 = this.readString();
                }
                catch (EOFException eOFException) {
                    return null;
                }
                catch (SshIOException sshIOException) {
                    return null;
                }
                char c2 = string2.charAt(0);
                switch (c2) {
                    case 'E': {
                        this.writeOk();
                        return null;
                    }
                    case 'T': {
                        continue block9;
                    }
                    case 'D': {
                        throw new IOException("Directories cannot be copied to a stream");
                    }
                    case 'C': {
                        this.parseCommand(string2, stringArray);
                        this.writeOk();
                        long l = Long.parseLong(stringArray[1]);
                        if (fileTransferProgress != null) {
                            fileTransferProgress.started(l, string);
                        }
                        return new _b(l, this.in, this, fileTransferProgress, string);
                    }
                }
                break;
            }
            this.writeError("Unexpected cmd: " + string2);
            throw new IOException("SCP unexpected cmd: " + string2);
        }

        protected void parseCommand(String string, String[] stringArray) throws IOException {
            int n = string.indexOf(32);
            int n2 = string.indexOf(32, n + 1);
            if (n == -1 || n2 == -1) {
                this.writeError("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            stringArray[0] = string.substring(1, n);
            stringArray[1] = string.substring(n + 1, n2);
            stringArray[2] = string.substring(n2 + 1);
        }

        protected String readString() throws IOException {
            int n;
            int n2 = 0;
            while ((n = this.in.read()) != 10 && n >= 0) {
                this.buffer[n2++] = (byte)n;
            }
            if (n == -1) {
                throw new EOFException("Unexpected EOF");
            }
            if (this.buffer[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.buffer[0] == 2 || this.buffer[0] == 1) {
                String string = new String(this.buffer, 1, n2 - 1);
                if (this.buffer[0] == 2) {
                    throw new IOException(string);
                }
                throw new IOException("SCP returned an unexpected error: " + string);
            }
            return new String(this.buffer, 0, n2);
        }

        public void waitForResponse() throws IOException {
            int n = this.in.read();
            if (ScpClientIO.this.k) {
                while (n > 0 && n != 2) {
                    n = this.in.read();
                }
                ScpClientIO.this.k = false;
            }
            if (n == 0) {
                return;
            }
            if (n == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String string = this.readString();
            if (n == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }

        protected void writeOk() throws IOException {
            this.out.write(0);
        }

        protected void writeError(String string) throws IOException {
            this.out.write(1);
            this.out.write(string.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeCompleteFile(InputStream inputStream, long l, FileTransferProgress fileTransferProgress) throws IOException {
            try {
                int n;
                for (long k = 0L; k < l; k += (long)n) {
                    n = inputStream.read(this.buffer, 0, (int)(l - k < (long)this.buffer.length ? l - k : (long)this.buffer.length));
                    if (n == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    this.out.write(this.buffer, 0, n);
                    if (fileTransferProgress == null) continue;
                    if (fileTransferProgress.isCancelled()) {
                        throw new SshIOException(new SshException("SCP transfer was cancelled by user", 18));
                    }
                    fileTransferProgress.progressed(k);
                }
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readCompleteFile(OutputStream outputStream, long l, FileTransferProgress fileTransferProgress) throws IOException {
            try {
                int n;
                for (long k = 0L; k < l; k += (long)n) {
                    n = this.in.read(this.buffer, 0, (int)(l - k < (long)this.buffer.length ? l - k : (long)this.buffer.length));
                    if (n == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    outputStream.write(this.buffer, 0, n);
                    if (fileTransferProgress == null) continue;
                    if (fileTransferProgress.isCancelled()) {
                        throw new SshIOException(new SshException("SCP transfer was cancelled by user", 18));
                    }
                    fileTransferProgress.progressed(k);
                }
            }
            finally {
                outputStream.close();
            }
        }
    }
}

