/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.util.ByteArrayWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AbstractDigest
implements Digest {
    MessageDigest c;

    public AbstractDigest(String string) throws NoSuchAlgorithmException {
        this.c = JCEProvider.getProviderForAlgorithm(string) == null ? MessageDigest.getInstance(string) : MessageDigest.getInstance(string, JCEProvider.getProviderForAlgorithm(string));
    }

    public byte[] doFinal() {
        return this.c.digest();
    }

    public void putBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        this.putInt(byArray.length);
        this.putBytes(byArray);
    }

    public void putByte(byte by) {
        this.c.update(by);
    }

    public void putBytes(byte[] byArray) {
        this.c.update(byArray, 0, byArray.length);
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        this.c.update(byArray, n, n2);
    }

    public void putInt(int n) {
        this.putBytes(ByteArrayWriter.encodeInt(n));
    }

    public void putString(String string) {
        this.putInt(string.length());
        this.putBytes(string.getBytes());
    }

    public void reset() {
        this.c.reset();
    }

    public String getProvider() {
        return this.c.getProvider().getName();
    }
}

