/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;

public class Ssh2RsaPublicKey
extends RsaPublicKey
implements SshRsaPublicKey {
    public Ssh2RsaPublicKey() {
    }

    public Ssh2RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public byte[] getEncoded() throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithm());
            byteArrayWriter.writeBigInteger(this.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.getModulus());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithm())) {
                throw new SshException("Invalid ssh-rsa key", 4);
            }
            this.setPublicExponent(byteArrayReader.readBigInteger());
            this.setModulus(byteArrayReader.readBigInteger());
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 0, byArray.length);
            byte[] byArray3 = byteArrayReader.readBinaryString();
            String string = new String(byArray3);
            if (!string.equals(this.getAlgorithm())) {
                return false;
            }
            byArray = byteArrayReader.readBinaryString();
            return super.verifySignature(byArray, byArray2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshRsaPublicKey) {
            try {
                return ((SshPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException sshException) {
            return 0;
        }
    }

    public int getVersion() {
        return 2;
    }

    public BigInteger doPublic(BigInteger bigInteger) {
        bigInteger = Rsa.padPKCS1(bigInteger, 2, (this.getModulus().bitLength() + 7) / 8);
        return Rsa.doPublic(bigInteger, this.getModulus(), this.getPublicExponent());
    }
}

