/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.publickey.Dsa;
import com.maverick.crypto.publickey.DsaPrivateKey;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentFactory;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.SshDsaPrivateKey;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.ssh.components.SshKeyPair;
import com.maverick.ssh.components.SshRsaPrivateCrtKey;
import com.maverick.ssh.components.SshRsaPrivateKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.ssh.components.SshSecureRandomGenerator;
import com.maverick.ssh.components.standalone.SecureRND;
import com.maverick.ssh.components.standalone.Ssh1RsaPublicKey;
import com.maverick.ssh.components.standalone.Ssh2DsaPrivateKey;
import com.maverick.ssh.components.standalone.Ssh2DsaPublicKey;
import com.maverick.ssh.components.standalone.Ssh2RsaPrivateCrtKey;
import com.maverick.ssh.components.standalone.Ssh2RsaPrivateKey;
import com.maverick.ssh.components.standalone.Ssh2RsaPublicKey;
import java.math.BigInteger;

public class StandaloneComponentManager
extends ComponentManager {
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$TripleDesCbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$BlowfishCbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$AES128Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$AES128Ctr;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$AES192Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$AES192Ctr;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$AES256Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$AES256Ctr;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Twofish128Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Twofish192Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Twofish256Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$CAST128Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$MD5HMac;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$MD5HMac96;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$SHA1HMac;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$SHA1HMac96;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Ssh2DsaPublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Ssh2RsaPublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Ssh1Des;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$Ssh1Des3;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$MD5Digest;
    static /* synthetic */ Class class$com$maverick$ssh$components$standalone$SHA1Digest;

    public SshSecureRandomGenerator getRND() {
        return SecureRND.getInstance();
    }

    public SshDsaPublicKey createDsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return new Ssh2DsaPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public SshDsaPublicKey createDsaPublicKey() {
        return new Ssh2DsaPublicKey();
    }

    public SshRsaPublicKey createRsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        switch (n) {
            case 1: {
                return new Ssh1RsaPublicKey(bigInteger, bigInteger2);
            }
            case 2: {
                return new Ssh2RsaPublicKey(bigInteger, bigInteger2);
            }
        }
        throw new RuntimeException("Unsupported SSH version for RSA public keys " + n);
    }

    public SshRsaPublicKey createSsh2RsaPublicKey() throws SshException {
        return new Ssh2RsaPublicKey();
    }

    public void initializeSsh2CipherFactory(ComponentFactory componentFactory) {
        componentFactory.add("3des-cbc", class$com$maverick$ssh$components$standalone$TripleDesCbc == null ? (class$com$maverick$ssh$components$standalone$TripleDesCbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.TripleDesCbc")) : class$com$maverick$ssh$components$standalone$TripleDesCbc);
        componentFactory.add("blowfish-cbc", class$com$maverick$ssh$components$standalone$BlowfishCbc == null ? (class$com$maverick$ssh$components$standalone$BlowfishCbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.BlowfishCbc")) : class$com$maverick$ssh$components$standalone$BlowfishCbc);
        componentFactory.add("aes128-cbc", class$com$maverick$ssh$components$standalone$AES128Cbc == null ? (class$com$maverick$ssh$components$standalone$AES128Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.AES128Cbc")) : class$com$maverick$ssh$components$standalone$AES128Cbc);
        componentFactory.add("aes128-ctr", class$com$maverick$ssh$components$standalone$AES128Ctr == null ? (class$com$maverick$ssh$components$standalone$AES128Ctr = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.AES128Ctr")) : class$com$maverick$ssh$components$standalone$AES128Ctr);
        componentFactory.add("aes192-cbc", class$com$maverick$ssh$components$standalone$AES192Cbc == null ? (class$com$maverick$ssh$components$standalone$AES192Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.AES192Cbc")) : class$com$maverick$ssh$components$standalone$AES192Cbc);
        componentFactory.add("aes192-ctr", class$com$maverick$ssh$components$standalone$AES192Ctr == null ? (class$com$maverick$ssh$components$standalone$AES192Ctr = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.AES192Ctr")) : class$com$maverick$ssh$components$standalone$AES192Ctr);
        componentFactory.add("aes256-cbc", class$com$maverick$ssh$components$standalone$AES256Cbc == null ? (class$com$maverick$ssh$components$standalone$AES256Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.AES256Cbc")) : class$com$maverick$ssh$components$standalone$AES256Cbc);
        componentFactory.add("aes256-ctr", class$com$maverick$ssh$components$standalone$AES256Ctr == null ? (class$com$maverick$ssh$components$standalone$AES256Ctr = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.AES256Ctr")) : class$com$maverick$ssh$components$standalone$AES256Ctr);
        componentFactory.add("twofish128-cbc", class$com$maverick$ssh$components$standalone$Twofish128Cbc == null ? (class$com$maverick$ssh$components$standalone$Twofish128Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Twofish128Cbc")) : class$com$maverick$ssh$components$standalone$Twofish128Cbc);
        componentFactory.add("twofish192-cbc", class$com$maverick$ssh$components$standalone$Twofish192Cbc == null ? (class$com$maverick$ssh$components$standalone$Twofish192Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Twofish192Cbc")) : class$com$maverick$ssh$components$standalone$Twofish192Cbc);
        componentFactory.add("twofish256-cbc", class$com$maverick$ssh$components$standalone$Twofish256Cbc == null ? (class$com$maverick$ssh$components$standalone$Twofish256Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Twofish256Cbc")) : class$com$maverick$ssh$components$standalone$Twofish256Cbc);
        componentFactory.add("cast128-cbc", class$com$maverick$ssh$components$standalone$CAST128Cbc == null ? (class$com$maverick$ssh$components$standalone$CAST128Cbc = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.CAST128Cbc")) : class$com$maverick$ssh$components$standalone$CAST128Cbc);
    }

    public void initializeHmacFactory(ComponentFactory componentFactory) {
        componentFactory.add("hmac-md5", class$com$maverick$ssh$components$standalone$MD5HMac == null ? (class$com$maverick$ssh$components$standalone$MD5HMac = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.MD5HMac")) : class$com$maverick$ssh$components$standalone$MD5HMac);
        componentFactory.add("hmac-md5-96", class$com$maverick$ssh$components$standalone$MD5HMac96 == null ? (class$com$maverick$ssh$components$standalone$MD5HMac96 = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.MD5HMac96")) : class$com$maverick$ssh$components$standalone$MD5HMac96);
        componentFactory.add("hmac-sha1", class$com$maverick$ssh$components$standalone$SHA1HMac == null ? (class$com$maverick$ssh$components$standalone$SHA1HMac = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.SHA1HMac")) : class$com$maverick$ssh$components$standalone$SHA1HMac);
        componentFactory.add("hmac-sha1-96", class$com$maverick$ssh$components$standalone$SHA1HMac96 == null ? (class$com$maverick$ssh$components$standalone$SHA1HMac96 = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.SHA1HMac96")) : class$com$maverick$ssh$components$standalone$SHA1HMac96);
    }

    public void initializePublicKeyFactory(ComponentFactory componentFactory) {
        componentFactory.add("ssh-dss", class$com$maverick$ssh$components$standalone$Ssh2DsaPublicKey == null ? (class$com$maverick$ssh$components$standalone$Ssh2DsaPublicKey = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Ssh2DsaPublicKey")) : class$com$maverick$ssh$components$standalone$Ssh2DsaPublicKey);
        componentFactory.add("ssh-rsa", class$com$maverick$ssh$components$standalone$Ssh2RsaPublicKey == null ? (class$com$maverick$ssh$components$standalone$Ssh2RsaPublicKey = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Ssh2RsaPublicKey")) : class$com$maverick$ssh$components$standalone$Ssh2RsaPublicKey);
    }

    protected void initializeKeyExchangeFactory(ComponentFactory componentFactory) {
        try {
            componentFactory.add("diffie-hellman-group14-sha1", Class.forName("com.maverick.ssh.components.standalone.DiffieHellmanGroup14Sha1"));
            componentFactory.add("diffie-hellman-group1-sha1", Class.forName("com.maverick.ssh.components.standalone.DiffieHellmanGroup1Sha1"));
            componentFactory.add("diffie-hellman-group-exchange-sha1", Class.forName("com.maverick.ssh.components.standalone.DiffieHellmanGroupExchangeSha1"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void initializeSsh1CipherFactory(ComponentFactory componentFactory) {
        componentFactory.add("2", class$com$maverick$ssh$components$standalone$Ssh1Des == null ? (class$com$maverick$ssh$components$standalone$Ssh1Des = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Ssh1Des")) : class$com$maverick$ssh$components$standalone$Ssh1Des);
        componentFactory.add("3", class$com$maverick$ssh$components$standalone$Ssh1Des3 == null ? (class$com$maverick$ssh$components$standalone$Ssh1Des3 = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.Ssh1Des3")) : class$com$maverick$ssh$components$standalone$Ssh1Des3);
    }

    public SshDsaPrivateKey createDsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        return new Ssh2DsaPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        return new Ssh2RsaPrivateCrtKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6);
    }

    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        return new Ssh2RsaPrivateCrtKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
    }

    public SshRsaPrivateKey createRsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        return new Ssh2RsaPrivateKey(bigInteger, bigInteger2);
    }

    public SshKeyPair generateDsaKeyPair(int n) {
        DsaPrivateKey dsaPrivateKey = Dsa.generateKey(n, SecureRandom.getInstance());
        SshKeyPair sshKeyPair = new SshKeyPair();
        sshKeyPair.setPublicKey(new Ssh2DsaPublicKey(dsaPrivateKey.getP(), dsaPrivateKey.getQ(), dsaPrivateKey.getG(), Dsa.generatePublicKey(dsaPrivateKey.getG(), dsaPrivateKey.getP(), dsaPrivateKey.getX())));
        sshKeyPair.setPrivateKey(new Ssh2DsaPrivateKey(dsaPrivateKey));
        return sshKeyPair;
    }

    public SshKeyPair generateRsaKeyPair(int n, int n2) {
        SshKeyPair sshKeyPair = new SshKeyPair();
        RsaPrivateCrtKey rsaPrivateCrtKey = Rsa.generateKey(n, SecureRandom.getInstance());
        sshKeyPair.setPrivateKey(new Ssh2RsaPrivateCrtKey(rsaPrivateCrtKey));
        switch (n2) {
            case 1: {
                sshKeyPair.setPublicKey(new Ssh1RsaPublicKey(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent()));
                break;
            }
            case 2: {
                sshKeyPair.setPublicKey(new Ssh2RsaPublicKey(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Version parameter must be either 1 or 2");
            }
        }
        return sshKeyPair;
    }

    protected void initializeDigestFactory(ComponentFactory componentFactory) {
        componentFactory.add("MD5", class$com$maverick$ssh$components$standalone$MD5Digest == null ? (class$com$maverick$ssh$components$standalone$MD5Digest = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.MD5Digest")) : class$com$maverick$ssh$components$standalone$MD5Digest);
        componentFactory.add("SHA-1", class$com$maverick$ssh$components$standalone$SHA1Digest == null ? (class$com$maverick$ssh$components$standalone$SHA1Digest = StandaloneComponentManager.class$("com.maverick.ssh.components.standalone.SHA1Digest")) : class$com$maverick$ssh$components$standalone$SHA1Digest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

