/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.util;

import com.maverick.util.UnsignedInteger32;
import com.maverick.util.UnsignedInteger64;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class ByteArrayReader
extends ByteArrayInputStream {
    private static String b = "UTF8";
    public static boolean encode;

    public ByteArrayReader(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public ByteArrayReader(byte[] byArray) {
        super(byArray, 0, byArray.length);
    }

    public byte[] array() {
        return this.buf;
    }

    public static void setCharsetEncoding(String string) {
        try {
            String string2 = "123456890";
            string2.getBytes(string);
            b = string;
            encode = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            b = "";
            encode = false;
        }
    }

    public static String getCharsetEncoding() {
        return b;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int k = 0; k < n2; k += n3) {
            n3 = this.read(byArray, n + k, n2 - k);
            if (n3 >= 0) continue;
            throw new EOFException("Could not read number of bytes requested: " + n2 + ", got " + k + " into buffer size " + byArray.length + " at offset " + n);
        }
    }

    public boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public BigInteger readBigInteger() throws IOException {
        int n = (int)this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return new BigInteger(byArray);
    }

    public UnsignedInteger64 readUINT64() throws IOException {
        byte[] byArray = new byte[9];
        this.readFully(byArray, 1, 8);
        return new UnsignedInteger64(byArray);
    }

    public UnsignedInteger32 readUINT32() throws IOException {
        return new UnsignedInteger32(this.readInt());
    }

    public static long readInt(byte[] byArray, int n) {
        long l = (long)(byArray[n] & 0xFF) << 24 & 0xFFFFFFFFL | (long)((byArray[n + 1] & 0xFF) << 16) | (long)((byArray[n + 2] & 0xFF) << 8) | (long)((byArray[n + 3] & 0xFF) << 0);
        return l;
    }

    public static short readShort(byte[] byArray, int n) {
        short s = (short)((byArray[n] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 0);
        return s;
    }

    public byte[] readBinaryString() throws IOException {
        int n = (int)this.readInt();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public long readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (long)((n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0)) & 0xFFFFFFFFL;
    }

    public String readString() throws IOException {
        return this.readString(b);
    }

    public String readString(String string) throws IOException {
        long l = this.readInt();
        if (l > (long)this.available()) {
            throw new IOException("Cannot read string of length " + l + " bytes when only " + this.available() + " bytes are available");
        }
        byte[] byArray = new byte[(int)l];
        this.readFully(byArray);
        if (encode) {
            return new String(byArray, string);
        }
        return new String(byArray);
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public BigInteger readMPINT32() throws IOException {
        int n = (int)this.readInt();
        byte[] byArray = new byte[(n + 7) / 8 + 1];
        byArray[0] = 0;
        this.readFully(byArray, 1, byArray.length - 1);
        return new BigInteger(byArray);
    }

    public BigInteger readMPINT() throws IOException {
        short s = this.readShort();
        byte[] byArray = new byte[(s + 7) / 8 + 1];
        byArray[0] = 0;
        this.readFully(byArray, 1, byArray.length - 1);
        return new BigInteger(byArray);
    }

    public int getPosition() {
        return this.pos;
    }

    static {
        ByteArrayReader.setCharsetEncoding(b);
    }
}

