/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.SshHmac;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.util.Base64;
import com.sshtools.publickey.SshPublicKeyFileFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private Hashtable g = new Hashtable();
    private Hashtable f = new Hashtable();
    private String e;
    private boolean b;
    private boolean d = true;
    private File c;

    public AbstractKnownHostsKeyVerification() throws SshException {
        this(null);
    }

    public File getKnownHostsFile() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractKnownHostsKeyVerification(String string) throws SshException {
        Object object;
        InputStream inputStream = null;
        if (string == null) {
            object = "";
            try {
                object = System.getProperty("user.home");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.c = new File((String)object, ".ssh" + File.separator + "known_hosts");
            string = this.c.getAbsolutePath();
        } else {
            this.c = new File(string);
        }
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(string);
            }
            if (this.c.exists()) {
                String string2;
                inputStream = new FileInputStream(this.c);
                object = new BufferedReader(new InputStreamReader(inputStream));
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    Object object2;
                    String string3;
                    if ((string2 = string2.trim()).equals("")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.onInvalidHostEntry(string2);
                        continue;
                    }
                    String string4 = (String)stringTokenizer.nextElement();
                    String string5 = null;
                    try {
                        if (!stringTokenizer.hasMoreTokens()) {
                            this.onInvalidHostEntry(string2);
                            continue;
                        }
                        string5 = (String)stringTokenizer.nextElement();
                        Integer.parseInt(string5);
                        if (!stringTokenizer.hasMoreTokens()) {
                            this.onInvalidHostEntry(string2);
                            continue;
                        }
                        String string6 = (String)stringTokenizer.nextElement();
                        if (!stringTokenizer.hasMoreTokens()) {
                            this.onInvalidHostEntry(string2);
                            continue;
                        }
                        string3 = (String)stringTokenizer.nextElement();
                        object2 = new BigInteger(string6);
                        BigInteger bigInteger = new BigInteger(string3);
                        this.c(string4, ComponentManager.getInstance().createRsaPublicKey(bigInteger, (BigInteger)object2, 1), true);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new SshException("Error parsing known_hosts file, is your file corrupt? " + this.c.getAbsolutePath(), 17);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!stringTokenizer.hasMoreTokens()) {
                            this.onInvalidHostEntry(string2);
                            continue;
                        }
                        string3 = (String)stringTokenizer.nextElement();
                        try {
                            object2 = string5 != null ? SshPublicKeyFileFactory.decodeSSH2PublicKey(string5, Base64.decode(string3)) : SshPublicKeyFileFactory.decodeSSH2PublicKey(Base64.decode(string3));
                            this.c(string4, (SshPublicKey)object2, true);
                        }
                        catch (IOException iOException) {
                            this.onInvalidHostEntry(string2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new SshException("Error parsing known_hosts file, is your file corrupt? " + this.c.getAbsolutePath(), 17);
                        }
                    }
                }
                ((BufferedReader)object).close();
                inputStream.close();
                this.b = this.c.canWrite();
            } else {
                object = new File(this.c.getParent());
                ((File)object).mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(this.c);
                fileOutputStream.write(this.toString().getBytes());
                fileOutputStream.close();
                this.b = true;
            }
            this.e = string;
        }
        catch (IOException iOException) {
            this.b = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setHashHosts(boolean bl) {
        this.d = bl;
    }

    protected void onInvalidHostEntry(String string) throws SshException {
    }

    public boolean isHostFileWriteable() {
        return this.b;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws SshException;

    public abstract void onUnknownHost(String var1, SshPublicKey var2) throws SshException;

    public void allowHost(String string, SshPublicKey sshPublicKey, boolean bl) throws SshException {
        if (this.d) {
            SshHmac sshHmac = (SshHmac)ComponentManager.getInstance().supportedHMacsCS().getInstance("hmac-sha1");
            byte[] byArray = new byte[sshHmac.getMacLength()];
            ComponentManager.getInstance().getRND().nextBytes(byArray);
            sshHmac.init(byArray);
            sshHmac.update(string.getBytes());
            byte[] byArray2 = sshHmac.doFinal();
            String string2 = "|1|" + Base64.encodeBytes(byArray, false) + "|" + Base64.encodeBytes(byArray2, false);
            this.c(string2, sshPublicKey, bl);
        } else {
            this.c(string, sshPublicKey, bl);
        }
        if (bl) {
            try {
                this.saveHostFile();
            }
            catch (IOException iOException) {
                throw new SshException("knownhosts file could not be saved! " + iOException.getMessage(), 5);
            }
        }
    }

    public Hashtable allowedHosts() {
        return this.g;
    }

    public synchronized void removeAllowedHost(String string) {
        if (this.g.containsKey(string)) {
            this.g.remove(string);
        }
    }

    public boolean verifyHost(String string, SshPublicKey sshPublicKey) throws SshException {
        return this.b(string, sshPublicKey, true);
    }

    private synchronized boolean b(String string, SshPublicKey sshPublicKey, boolean bl) throws SshException {
        String string2;
        StringTokenizer stringTokenizer;
        String string3;
        Enumeration enumeration;
        String string4 = null;
        String string5 = null;
        if (System.getProperty("maverick.knownHosts.enableReverseDNS", "true").equalsIgnoreCase("true")) {
            try {
                enumeration = InetAddress.getByName(string);
                string4 = ((InetAddress)((Object)enumeration)).getHostName();
                string5 = ((InetAddress)((Object)enumeration)).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        enumeration = this.g.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (string3.startsWith("|1|")) {
                if (this.c(string3, string)) {
                    return this.b(string3, sshPublicKey);
                }
                if (string5 != null && this.c(string3, string5)) {
                    return this.b(string3, sshPublicKey);
                }
            } else if (string3.equals(string)) {
                return this.b(string3, sshPublicKey);
            }
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                string2 = (String)stringTokenizer.nextElement();
                if ((string4 == null || !string2.equals(string4)) && (string5 == null || !string2.equals(string5))) continue;
                return this.b(string2, sshPublicKey);
            }
        }
        enumeration = this.f.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (string3.startsWith("|1|")) {
                if (this.c(string3, string)) {
                    return this.b(string3, sshPublicKey);
                }
                if (string5 != null && this.c(string3, string5)) {
                    return this.b(string3, sshPublicKey);
                }
            } else if (string3.equals(string)) {
                return this.b(string3, sshPublicKey);
            }
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                string2 = (String)stringTokenizer.nextElement();
                if ((string4 == null || !string2.equals(string4)) && (string5 == null || !string2.equals(string5))) continue;
                return this.b(string2, sshPublicKey);
            }
        }
        if (!bl) {
            return false;
        }
        this.onUnknownHost(string, sshPublicKey);
        return this.b(string, sshPublicKey, false);
    }

    private boolean c(String string, String string2) throws SshException {
        SshHmac sshHmac = (SshHmac)ComponentManager.getInstance().supportedHMacsCS().getInstance("hmac-sha1");
        String string3 = string.substring("|1|".length());
        String string4 = string3.substring(0, string3.indexOf("|"));
        String string5 = string3.substring(string3.indexOf("|") + 1);
        byte[] byArray = Base64.decode(string5);
        sshHmac.init(Base64.decode(string4));
        sshHmac.update(string2.getBytes());
        byte[] byArray2 = sshHmac.doFinal();
        return Arrays.equals(byArray, byArray2);
    }

    private boolean b(String string, SshPublicKey sshPublicKey) throws SshException {
        SshPublicKey sshPublicKey2 = this.b(string, sshPublicKey.getAlgorithm());
        if (sshPublicKey2 != null && sshPublicKey.equals(sshPublicKey2)) {
            return true;
        }
        if (sshPublicKey2 == null) {
            this.onUnknownHost(string, sshPublicKey);
        } else {
            this.onHostKeyMismatch(string, sshPublicKey2, sshPublicKey);
        }
        return this.c(string, sshPublicKey);
    }

    private boolean c(String string, SshPublicKey sshPublicKey) {
        SshPublicKey sshPublicKey2 = this.b(string, sshPublicKey.getAlgorithm());
        return sshPublicKey2 != null && sshPublicKey2.equals(sshPublicKey);
    }

    private synchronized SshPublicKey b(String string, String string2) {
        String string3;
        Object object;
        try {
            object = this.f.keySet().iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                if (!string3.startsWith("|") || !this.c(string3, string)) continue;
                Hashtable hashtable = (Hashtable)this.f.get(string3);
                return (SshPublicKey)hashtable.get(string2);
            }
        }
        catch (SshException sshException) {
            // empty catch block
        }
        if (this.f.containsKey(string)) {
            object = (Hashtable)this.f.get(string);
            return (SshPublicKey)((Hashtable)object).get(string2);
        }
        try {
            object = this.g.keySet().iterator();
            while (object.hasNext()) {
                string3 = (String)object.next();
                if (!string3.startsWith("|") || !this.c(string3, string)) continue;
                Hashtable hashtable = (Hashtable)this.g.get(string3);
                return (SshPublicKey)hashtable.get(string2);
            }
        }
        catch (SshException sshException) {
            // empty catch block
        }
        if (this.g.containsKey(string)) {
            object = (Hashtable)this.g.get(string);
            return (SshPublicKey)((Hashtable)object).get(string2);
        }
        return null;
    }

    private synchronized void c(String string, SshPublicKey sshPublicKey, boolean bl) {
        if (bl) {
            if (!this.g.containsKey(string)) {
                this.g.put(string, new Hashtable());
            }
            Hashtable hashtable = (Hashtable)this.g.get(string);
            hashtable.put(sshPublicKey.getAlgorithm(), sshPublicKey);
        } else {
            if (!this.f.containsKey(string)) {
                this.f.put(string, new Hashtable());
            }
            Hashtable hashtable = (Hashtable)this.f.get(string);
            hashtable.put(sshPublicKey.getAlgorithm(), sshPublicKey);
        }
    }

    public synchronized void saveHostFile() throws IOException {
        if (!this.b) {
            throw new IOException("Host file is not writeable.");
        }
        try {
            File file = new File(this.e);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException("Could not write to " + this.e);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = System.getProperty("line.separator");
        Enumeration enumeration = this.g.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.g.get(string2);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                SshPublicKey sshPublicKey = (SshPublicKey)hashtable.get(string3);
                if (sshPublicKey instanceof SshRsaPublicKey && ((SshRsaPublicKey)sshPublicKey).getVersion() == 1) {
                    SshRsaPublicKey sshRsaPublicKey = (SshRsaPublicKey)sshPublicKey;
                    stringBuffer.append(string2 + " " + String.valueOf(sshRsaPublicKey.getModulus().bitLength()) + " " + sshRsaPublicKey.getPublicExponent() + " " + sshRsaPublicKey.getModulus() + string);
                    continue;
                }
                try {
                    stringBuffer.append(string2 + " " + sshPublicKey.getAlgorithm() + " " + Base64.encodeBytes(sshPublicKey.getEncoded(), true) + string);
                }
                catch (SshException sshException) {}
            }
        }
        return stringBuffer.toString();
    }
}

