/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.components.SshPublicKey;
import com.sshtools.publickey.AbstractKnownHostsKeyVerification;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    public ConsoleKnownHostsKeyVerification() throws SshException {
    }

    public ConsoleKnownHostsKeyVerification(String string) throws SshException {
        super(string);
    }

    public void onHostKeyMismatch(String string, SshPublicKey sshPublicKey, SshPublicKey sshPublicKey2) {
        try {
            System.out.println("The host key supplied by " + string + "(" + sshPublicKey.getAlgorithm() + ")" + " is: " + sshPublicKey2.getFingerprint());
            System.out.println("The current allowed key for " + string + " is: " + sshPublicKey.getFingerprint());
            this.d(string, sshPublicKey2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onUnknownHost(String string, SshPublicKey sshPublicKey) {
        try {
            System.out.println("The host " + string + " is currently unknown to the system");
            System.out.println("The MD5 host key (" + sshPublicKey.getAlgorithm() + ") fingerprint is: " + sshPublicKey.getFingerprint());
            System.out.println("The SHA1 host key (" + sshPublicKey.getAlgorithm() + ") fingerprint is: " + SshKeyFingerprint.getFingerprint(sshPublicKey.getEncoded(), "SHA-1"));
            try {
                System.out.println("The SHA256 host key (" + sshPublicKey.getAlgorithm() + ") fingerprint is: " + SshKeyFingerprint.getFingerprint(sshPublicKey.getEncoded(), "SHA-256"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.d(string, sshPublicKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void onInvalidHostEntry(String string) throws SshException {
        System.out.println("Invalid host entry in " + this.getKnownHostsFile().getAbsolutePath());
        System.out.println(string);
    }

    private void d(String string, SshPublicKey sshPublicKey) throws SshException {
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (!(string2.equalsIgnoreCase("YES") || string2.equalsIgnoreCase("NO") || string2.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable())) {
            String string3;
            String string4 = string3 = this.isHostFileWriteable() ? "Yes|No|Always" : "Yes|No";
            if (!this.isHostFileWriteable()) {
                System.out.println("Always option disabled, host file is not writeable");
            }
            System.out.print("Do you want to allow this host key? [" + string3 + "]: ");
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new SshException("Failed to read response", 5);
            }
        }
        if (string2.equalsIgnoreCase("YES")) {
            this.allowHost(string, sshPublicKey, false);
        }
        if (string2.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable()) {
            this.allowHost(string, sshPublicKey, true);
        }
    }
}

