/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.util.ByteArrayReader;
import com.sshtools.publickey.OpenSSHPublicKeyFile;
import com.sshtools.publickey.SECSHPublicKeyFile;
import com.sshtools.publickey.SshPublicKeyFile;
import com.sshtools.publickey.f;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPublicKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SECSH_FORMAT = 1;
    public static final int SSH1_FORMAT = 2;

    public static SshPublicKey decodeSSH2PublicKey(byte[] byArray) throws IOException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            try {
                SshPublicKey sshPublicKey = (SshPublicKey)ComponentManager.getInstance().supportedPublicKeys().getInstance(string);
                sshPublicKey.init(byArray, 0, byArray.length);
                return sshPublicKey;
            }
            catch (SshException sshException) {
                throw new SshIOException(sshException);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("An error occurred parsing a public key file! Is the file corrupt?");
        }
    }

    public static SshPublicKey decodeSSH2PublicKey(String string, byte[] byArray) throws IOException {
        try {
            SshPublicKey sshPublicKey = (SshPublicKey)ComponentManager.getInstance().supportedPublicKeys().getInstance(string);
            sshPublicKey.init(byArray, 0, byArray.length);
            return sshPublicKey;
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
    }

    public static SshPublicKeyFile parse(byte[] byArray) throws IOException {
        try {
            try {
                return new OpenSSHPublicKeyFile(byArray);
            }
            catch (IOException iOException) {
                try {
                    return new SECSHPublicKeyFile(byArray);
                }
                catch (IOException iOException2) {
                    try {
                        return new f(byArray);
                    }
                    catch (Exception exception) {
                        throw new IOException("Unable to parse key, format could not be identified");
                    }
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("An error occurred parsing a public key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPublicKeyFile parse(InputStream inputStream) throws IOException {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) > -1) {
                byteArrayOutputStream.write(n);
            }
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFileFactory.parse(byteArrayOutputStream.toByteArray());
            return sshPublicKeyFile;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPublicKeyFile create(SshPublicKey sshPublicKey, String string, int n) throws IOException {
        switch (n) {
            case 0: {
                return new OpenSSHPublicKeyFile(sshPublicKey, string);
            }
            case 1: {
                return new SECSHPublicKeyFile(sshPublicKey, string);
            }
            case 2: {
                return new f(sshPublicKey);
            }
        }
        throw new IOException("Invalid format type specified!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(SshPublicKey sshPublicKey, String string, int n, File file) throws IOException {
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFileFactory.create(sshPublicKey, string, n);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(sshPublicKeyFile.getFormattedKey());
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static void convertFile(File file, int n, File file2) throws IOException {
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFileFactory.parse(new FileInputStream(file));
        SshPublicKeyFileFactory.createFile(sshPublicKeyFile.toPublicKey(), sshPublicKeyFile.getComment(), n, file2);
    }
}

