/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport.fropxy;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import java.util.Vector;
import se.ericsson.cello.internaltransport.fropxy.ReliableGroupLink;

public class SpasLinkGroupGetAttrRsp
extends UnlinkedSignal {
    public static final int SIGNO = 231431;
    public static final int SPAS_PHYSICALLINKSTATUS_WORKING = 1;
    public static final int SPAS_PHYSICALLINKSTATUS_UNDEFINED = 3;
    private int result;
    private int linkGroupSmn1;
    private int linkGroupSmn2;
    Vector valuesSmnStatus = new Vector(8);
    private Vector relGroup0;
    private Vector relGroup1;
    private Vector relGroup2;
    private Vector relGroup3;
    private Vector relGroup4;
    private Vector relGroup5;
    private Vector relGroup6;
    private Vector relGroup7;
    private int admStateLinkGroup;
    private int opStateLinkGroup;
    private int availStateLinkGroup;
    private static final int MAX_NUMBER_OF_LINKS = 8;

    public int getSignalNumber() {
        return 231431;
    }

    public SpasLinkGroupGetAttrRsp() {
        super(231431);
    }

    public int getResult() {
        return this.result;
    }

    public int getLinkGroupSmn1() {
        return this.linkGroupSmn1;
    }

    public int getLinkGroupSmn2() {
        return this.linkGroupSmn2;
    }

    public Vector getRelGroup0() {
        return this.relGroup0;
    }

    public Vector getRelGroup1() {
        return this.relGroup1;
    }

    public Vector getRelGroup2() {
        return this.relGroup2;
    }

    public Vector getRelGroup3() {
        return this.relGroup3;
    }

    public Vector getRelGroup4() {
        return this.relGroup4;
    }

    public Vector getRelGroup5() {
        return this.relGroup5;
    }

    public Vector getRelGroup6() {
        return this.relGroup6;
    }

    public Vector getRelGroup7() {
        return this.relGroup7;
    }

    public int getAdmStateLinkGroup() {
        return this.admStateLinkGroup;
    }

    public int getOpStateLinkGroup() {
        return this.opStateLinkGroup;
    }

    public int getAvailStateLinkGroup() {
        return this.availStateLinkGroup;
    }

    public long[] getRlgLinks(int n) {
        long[] lArray = new long[]{};
        switch (n) {
            case 0: {
                Vector vector = this.getRelGroup0();
                lArray = this.findRLG(vector);
                break;
            }
            case 1: {
                Vector vector = this.getRelGroup1();
                lArray = this.findRLG(vector);
                break;
            }
            case 2: {
                Vector vector = this.getRelGroup2();
                lArray = this.findRLG(vector);
                break;
            }
            case 3: {
                Vector vector = this.getRelGroup3();
                lArray = this.findRLG(vector);
                break;
            }
            case 4: {
                Vector vector = this.getRelGroup4();
                lArray = this.findRLG(vector);
                break;
            }
            case 5: {
                Vector vector = this.getRelGroup5();
                lArray = this.findRLG(vector);
                break;
            }
            case 6: {
                Vector vector = this.getRelGroup6();
                lArray = this.findRLG(vector);
                break;
            }
            case 7: {
                Vector vector = this.getRelGroup7();
                lArray = this.findRLG(vector);
            }
        }
        return lArray;
    }

    private long[] findRLG(Vector vector) {
        long[] lArray = new long[4];
        for (int i = 0; i < 4; ++i) {
            ReliableGroupLink reliableGroupLink = (ReliableGroupLink)vector.elementAt(i);
            lArray[i] = reliableGroupLink.getFroId();
        }
        return lArray;
    }

    public int[] getRlgroups() {
        int[] nArray = new int[this.valuesSmnStatus.size()];
        for (int i = 0; i < this.valuesSmnStatus.size(); ++i) {
            Object e = this.valuesSmnStatus.elementAt(i);
            nArray[i] = (Integer)e;
        }
        return nArray;
    }

    public int getLinkStatus(int n, int n2) {
        int n3 = 3;
        switch (n2) {
            case 0: {
                Vector vector = this.getRelGroup0();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 1: {
                Vector vector = this.getRelGroup1();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 2: {
                Vector vector = this.getRelGroup2();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 3: {
                Vector vector = this.getRelGroup3();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 4: {
                Vector vector = this.getRelGroup4();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 5: {
                Vector vector = this.getRelGroup5();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 6: {
                Vector vector = this.getRelGroup6();
                n3 = this.findStatus(vector, n);
                break;
            }
            case 7: {
                Vector vector = this.getRelGroup7();
                n3 = this.findStatus(vector, n);
            }
        }
        return n3;
    }

    private int findStatus(Vector vector, int n) {
        int n2 = 3;
        for (int i = 0; i < 4; ++i) {
            ReliableGroupLink reliableGroupLink = (ReliableGroupLink)vector.elementAt(i);
            long l = reliableGroupLink.getFroId();
            if (l != (long)n) continue;
            n2 = reliableGroupLink.getLinkStatus();
        }
        return n2;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.result = signalInputStream.readU16();
            this.linkGroupSmn1 = signalInputStream.readU16();
            this.linkGroupSmn2 = signalInputStream.readU16();
            this.relGroup0 = this.constructReliableGroup(signalInputStream, 0);
            this.relGroup1 = this.constructReliableGroup(signalInputStream, 1);
            this.relGroup2 = this.constructReliableGroup(signalInputStream, 2);
            this.relGroup3 = this.constructReliableGroup(signalInputStream, 3);
            this.relGroup4 = this.constructReliableGroup(signalInputStream, 4);
            this.relGroup5 = this.constructReliableGroup(signalInputStream, 5);
            this.relGroup6 = this.constructReliableGroup(signalInputStream, 6);
            this.relGroup7 = this.constructReliableGroup(signalInputStream, 7);
            this.admStateLinkGroup = signalInputStream.readU16();
            this.opStateLinkGroup = signalInputStream.readU16();
            this.availStateLinkGroup = signalInputStream.readU16();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initSend() {
    }

    private Vector constructReliableGroup(SignalInputStream signalInputStream, int n) {
        boolean bl = false;
        Vector<ReliableGroupLink> vector = new Vector<ReliableGroupLink>(4);
        try {
            for (int i = 0; i < 4; ++i) {
                long l = signalInputStream.readU32();
                int n2 = signalInputStream.readU16();
                int n3 = signalInputStream.readU16();
                ReliableGroupLink reliableGroupLink = new ReliableGroupLink(l, n2);
                vector.addElement(reliableGroupLink);
                if (n2 != 1) continue;
                Integer n4 = new Integer(n);
                this.valuesSmnStatus.addElement(n4);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vector;
    }
}

