/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.StringTokenizer;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class IpSecCertSpec {
    private String fileName = null;
    private String serialNumber = null;
    private String fingerprint = null;

    public IpSecCertSpec(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 3) {
            throw new ValueOutOfRangeException("Missing member in certSpec", "IpSec");
        }
        if (!(struct.getValue("fileName") instanceof String)) {
            throw new WrongAttributeTypeException("fileName", "IpSec");
        }
        this.fileName = (String)struct.getValue("fileName");
        if (!(struct.getValue("fingerprint") instanceof String)) {
            throw new WrongAttributeTypeException("fingerprint", "IpSec");
        }
        this.fingerprint = (String)struct.getValue("fingerprint");
        if (!(struct.getValue("serialNumber") instanceof String)) {
            throw new WrongAttributeTypeException("serialNumber", "IpSec");
        }
        this.serialNumber = (String)struct.getValue("serialNumber");
        this.check();
    }

    protected String getSerialNumber() {
        return this.serialNumber;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getFingerprint() {
        return this.fingerprint;
    }

    private void check() throws MoAccessException {
        if (this.serialNumber == null || this.serialNumber.length() < 1 || this.serialNumber.length() > 64) {
            throw new ValueOutOfRangeException("serialNumber String too long/empty", "IpSec");
        }
        if (!IpSecCertSpec.containsOnlyNumbers(this.serialNumber)) {
            throw new ValueOutOfRangeException("serialNumber should contain only digits", "IpSec");
        }
        if (this.fileName == null || this.fileName.length() > 255) {
            throw new ValueOutOfRangeException("fileName String too long", "IpSec");
        }
        if (this.fingerprint == null || this.fingerprint.length() > 127) {
            throw new ValueOutOfRangeException("fingerprint String too long", "IpSec");
        }
        if (!this.checkFingerprint(this.fingerprint)) {
            throw new IllegalAttributeValueException("fingerprint String format invalid", "IpSec");
        }
    }

    private boolean checkFingerprint(String string) {
        if (string.equals("")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() == 2) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("MD5") == 0) {
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":");
                return stringTokenizer2.countTokens() == 16;
            }
            if (string2.indexOf("SHA-1") == 0 || string2.indexOf("SHA1") == 0) {
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ":");
                return stringTokenizer3.countTokens() == 20;
            }
            if (string2.indexOf("SHA256") == 0) {
                String string5 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer4 = new StringTokenizer(string5, ":");
                return stringTokenizer4.countTokens() == 32;
            }
            return false;
        }
        return false;
    }

    static boolean containsOnlyNumbers(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

