/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandlerFactoryImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostLinkIpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipsec.IpSecTunnelMo;
import se.ericsson.cello.ipsec.PeerIpSecTunnelMoFactoryImpl;
import se.ericsson.cello.ipsec.PeerIpSecTunnelMoImpl;
import se.ericsson.cello.ipsec.VpnInterfaceMoGen;
import se.ericsson.cello.ipsec.ipcp_vpni_mi;
import se.ericsson.cello.ipsec.ipi_peeripsectunnel_mi;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class VpnInterfaceMoImpl
extends VpnInterfaceMoGen
implements VpnInterfaceBuildIF,
IpHostLinkIpInterfaceBuildIF {
    private static TagNameDictionary peerIpSecTunnelTagNameDictionary = TagNameDictionaries.create((ResourceBundle)ResourceBundle.getBundle(ipi_peeripsectunnel_mi.class.getName()));
    private PeerIpSecTunnelMoFactoryImpl peerIpSecTunnelFactoryImpl = null;
    private MaoFroIndicationHandler indicationHandler = MaoFroIndicationHandlerFactoryImpl.instance().create(ipcp_vpni_mi.class);
    private static final int PEERIPSECTUNNEL_EVENT_CREATE = 1;
    private static final int PEERIPSECTUNNEL_EVENT_DELETE_ALL = 2;
    private HashMap tunnelFroIds = null;

    public VpnInterfaceMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, this.getFroId(coordinator));
    }

    public VpnInterfaceMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = ((IpAccessHostEtMo)setRequestContext.getAttributeFromRequest("ipAccessHostEtRef")).getIpInterfaceMoRef(coordinator);
        int n2 = 0;
        if (managedObject instanceof IpInterfaceMo) {
            ManagedObject managedObject2 = managedObject;
            n = ((IpInterfaceMo)managedObject).getFroId(coordinator);
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject2);
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            n = ((Ipv6InterfaceMo)managedObject).getFroId(coordinator);
            ManagedObject managedObject3 = (ManagedObject)managedObject.getAttribute("ethernetRef", coordinator);
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject3);
        } else {
            throw new InvalidReferenceException("VpnInterface", "The referenced instance of IpAccessHostEt MO must refer to IpInterface MO or Ipv6Interface Mo");
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("autoDetectIpVersion", 0));
        setRequestContext.addParameter(this.froProxy, (Parameter)new UnsignedIntParameter("ipInterfaceFroId", (long)n));
        setRequestContext.addParameter(this.froProxy, (Parameter)new UnsignedIntParameter("piuFroId", (long)n2));
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("vpnInterfaceMoRdn", this.getRelativeDistinguishedName()));
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("networkPrefixLength") || setRequestContext.isIncludedInRequest("subnet")) {
            throw new AttrNotSettableException("networkPrefixLength/subnet", "VpnInterface");
        }
    }

    protected Object onGetAttributes(GetRequestContext getRequestContext, String string, Object object) throws MoAccessException {
        if (string.equalsIgnoreCase("AutoDetectIpVersion")) {
            throw new NoSuchAttributeException(string, "VpnInterface");
        }
        return object;
    }

    protected void validateSubnet(String string, SetRequestContext setRequestContext) throws MoAccessException {
        if (!string.equals("")) {
            new IpAddress(string);
        }
    }

    public int getAutoDetectIpVersion(Coordinator coordinator) throws MoAccessException {
        SignedIntParameter signedIntParameter = (SignedIntParameter)this.froProxy.getAttribute(coordinator, this.getFroId(coordinator), "autoDetectIpVersion");
        return signedIntParameter.getValue();
    }

    public void setAutoDetectIpVersion(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkEnumAttribute((String)"autoDetectIpVersion", (int)n, (int[])AUTO_DETECT_IP_VERSION_VALUES, (String)"VpnInterface");
        SignedIntParameter signedIntParameter = new SignedIntParameter("autoDetectIpVersion", n);
        this.froProxy.setAttribute(coordinator, this.getFroId(coordinator), (Parameter)signedIntParameter);
    }

    public int getConnectedPiuFroId(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = ((IpAccessHostEtMo)this.getIpAccessHostEtRef(coordinator)).getIpInterfaceMoRef(coordinator);
        if (managedObject instanceof Ipv6InterfaceMo) {
            managedObject = ((Ipv6InterfaceMo)managedObject).getEthernetRef(coordinator);
        }
        return PiuUtils.findPiuParentFroId((ManagedObject)managedObject);
    }

    public int getFroType(Coordinator coordinator) throws MoAccessException {
        return Integer.parseInt("A0B", 16);
    }

    public NetworkAddress getNetworkAddress(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{"subnet", "networkPrefixLength"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return new NetworkAddress((String)objectArray[0], ((Integer)objectArray[1]).intValue());
    }

    public void helpAssignVpnAddress(int n, IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        if (n < 1 || n > 32) {
            throw new ValueOutOfRangeException("networkPrefixLength", "VpnInterface");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("networkPrefixLength", new SignedIntParameter("networkPrefixLength", n));
        hashMap.put("subnet", new StringParameter("subnet", ipAddress.getSubnetAddress(n).toString()));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashMap.values());
        this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        ManagedObject[] managedObjectArray;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("VpnInterface", "Cannot be reserved by 'null' reference");
        }
        if (this.getConfigurationMode(coordinator) == 1) {
            int n2;
            managedObjectArray = this.getReservedBy(coordinator);
            n = managedObjectArray.length;
            if (managedObject.getType().equalsIgnoreCase("IpAccessHostEt")) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (!managedObjectArray[n2].getType().equalsIgnoreCase("IpHostLink")) continue;
                    throw new MoNotPossibleToReserveException("This MO already reserved by IpHostLink MO.", "VpnInterface");
                }
            } else if (managedObject.getType().equalsIgnoreCase("IpHostLink")) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (managedObjectArray[n2].getType().equalsIgnoreCase("IpAccessHostEt")) {
                        throw new MoNotPossibleToReserveException("This MO already reserved by IpAccessHostEt MO.", "VpnInterface");
                    }
                    if (!managedObjectArray[n2].getType().equalsIgnoreCase("IpHostLink")) continue;
                    throw new MoNotPossibleToReserveException("This MO already reserved by another IpHostLink MO.", "VpnInterface");
                }
            }
        }
        managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObject instanceof IpHostLinkMo && managedObjectArray[n] instanceof IpHostLinkMo) {
                throw new MoNotPossibleToReserveException("Only one IpHostLink instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
            }
            if (managedObject instanceof IpAccessHostEtMo && managedObjectArray[n] instanceof IpAccessHostEtMo) {
                throw new MoNotPossibleToReserveException("Only one IpAccessHostEt instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
            }
            if (this.getConfigurationMode(coordinator) != 1 || !(managedObject instanceof IpSecTunnelMo) || !(managedObjectArray[n] instanceof IpSecTunnelMo)) continue;
            throw new MoNotPossibleToReserveException("Only one IpSecTunnelMo instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    protected Map getTunnelFroIdMap() throws Exception {
        if (this.tunnelFroIds == null) {
            return new HashMap();
        }
        return this.tunnelFroIds;
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        block26: {
            Map map = null;
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = null;
            String string = null;
            try {
                map = maoFroGenericEventInd.getParameters(peerIpSecTunnelTagNameDictionary);
                if (maoFroGenericEventInd.getSpecificEvent() == 1) {
                    this.tunnelFroIds = new HashMap();
                    AttrListImpl attrListImpl = new AttrListImpl();
                    if (map.containsKey("innerIpAddress")) {
                        string = ((StringParameter)map.get("innerIpAddress")).getValue();
                    } else {
                        MessageLog.traceError(this.getClass(), (String)"Inner Ip address is not received in the create indication ");
                    }
                    if (map.containsKey("froIdInternal")) {
                        this.tunnelFroIds.put(string, map.get("froIdInternal"));
                    } else {
                        MessageLog.traceError(this.getClass(), (String)"Fro id is not received");
                    }
                    if (this.peerIpSecTunnelFactoryImpl == null) {
                        this.peerIpSecTunnelFactoryImpl = (PeerIpSecTunnelMoFactoryImpl)MoFactoryMgr.instance().lookup("PeerIpSecTunnel");
                    }
                    if (this.peerIpSecTunnelFactoryImpl != null) {
                        try {
                            control = transactionFactory.create(3600);
                            Coordinator coordinator = control.getCoordinator();
                            this.peerIpSecTunnelFactoryImpl.autoCreate(this, (AttrList)attrListImpl, string, coordinator);
                            control.getTerminator().commit();
                        }
                        catch (TransactionRolledBackException transactionRolledBackException) {
                            MessageLog.traceError(this.getClass(), (String)"start of PeerIpSecTunnel failed", (Throwable)transactionRolledBackException);
                        }
                        catch (MoAccessException moAccessException) {
                            try {
                                control.getTerminator().rollback();
                                MessageLog.traceError(this.getClass(), (String)("MO with id " + string + "creation failed"));
                                break block26;
                            }
                            catch (InactiveTransactionException inactiveTransactionException) {
                                MessageLog.traceError(this.getClass(), (String)"start of PeerIpSecTunnel failed", (Throwable)inactiveTransactionException);
                            }
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            MessageLog.traceError(this.getClass(), (String)"start of PeerIpSecTunnel failed", (Throwable)inactiveTransactionException);
                        }
                        break block26;
                    }
                    MessageLog.traceError(this.getClass(), (String)" Mo factory not found! PeerIpSecTunnel", null);
                    break block26;
                }
                if (maoFroGenericEventInd.getSpecificEvent() == 2) {
                    MoIterator moIterator = this.getChildren();
                    ManagedObject managedObject = null;
                    while (moIterator.hasMoreElements()) {
                        managedObject = moIterator.nextMo();
                        if (!managedObject.getType().equals("PeerIpSecTunnel")) continue;
                        try {
                            control = transactionFactory.create(3600);
                            Coordinator coordinator = control.getCoordinator();
                            ((PeerIpSecTunnelMoImpl)managedObject).autoDelete(coordinator);
                            control.getTerminator().commit();
                        }
                        catch (TransactionRolledBackException transactionRolledBackException) {
                            MessageLog.traceError(this.getClass(), (String)"start of PeerIpSecTunnel failed", (Throwable)transactionRolledBackException);
                        }
                        catch (MoAccessException moAccessException) {
                            try {
                                control.getTerminator().rollback();
                                MessageLog.traceError(this.getClass(), (String)"MOs cannot be deleted");
                            }
                            catch (InactiveTransactionException inactiveTransactionException) {
                                MessageLog.traceError(this.getClass(), (String)"Delete of PeerIpSecTunnel failed", (Throwable)inactiveTransactionException);
                            }
                        }
                        catch (InactiveTransactionException inactiveTransactionException) {
                            MessageLog.traceError(this.getClass(), (String)"Delete of PeerIpSecTunnel failed", (Throwable)inactiveTransactionException);
                        }
                    }
                } else {
                    MessageLog.traceError(this.getClass(), (String)("ERROR - Unknown specificEvent: " + maoFroGenericEventInd.getSpecificEvent() + " sent in signal MaoFroGenericEventInd"));
                }
            }
            catch (RuntimeException runtimeException) {
                MessageLog.traceError(this.getClass(), (String)"Runtime Exception: ", (Throwable)runtimeException);
            }
            catch (TagNameDictionaryException tagNameDictionaryException) {
                MessageLog.traceError(this.getClass(), (String)"TagName Dictionary Exception: ", (Throwable)tagNameDictionaryException);
            }
            catch (IllegalParameterValueException illegalParameterValueException) {
                MessageLog.traceError(this.getClass(), (String)("Exception in creating the additionalText, " + illegalParameterValueException.getMessage()));
            }
        }
    }

    public void checkIfIpAddressInSubnet(IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        NetworkAddress networkAddress = this.getNetworkAddress(coordinator);
        ipAddress.validateIpAddrWithinSubnet(networkAddress.getNetworkPrefix(), new IpAddress(networkAddress.getSubnet()), "VpnInterface");
    }
}

