/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.cvhelper;

import java.util.TimerTask;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CvTimer {
    private static final Class THIS_CLASS = CvTimer.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private volatile boolean isCanceled;
    private Thread timerThread;

    public void scheduleTask(final long delayms, final TimerTask task) {
        Runnable taskDelay = new Runnable(){

            public void run() {
                long startTime = CvTimer.this.getCurrentTimeMs();
                while (CvTimer.this.getCurrentTimeMs() - startTime <= delayms) {
                    if (CvTimer.this.isCanceled) {
                        logger.info(THIS_CLASS, "EXIT from timer thread");
                        return;
                    }
                    CvTimer.this.wait10ms();
                }
                task.run();
            }
        };
        this.isCanceled = false;
        this.timerThread = new Thread(taskDelay, "timerThreadDelay");
        this.timerThread.start();
    }

    private void wait10ms() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long getCurrentTimeMs() {
        return System.currentTimeMillis();
    }

    public void cancelIfActive() {
        logger.info(THIS_CLASS, "Enter cancelIfActive()");
        if (this.timerThread == null) {
            return;
        }
        this.isCanceled = true;
        try {
            this.timerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info(THIS_CLASS, "Return cancelIfActive()");
    }
}

